/* 1150, Tue 23 Nov 93

   PKTSNAP.H:  Declarations for AU packet monitoring
		  extensions to Waterloo TCP/IP

   Copyright (C) 1992-1994 by Nevil Brownlee,
   Computer Centre,  The University of Auckland */

#define noFULL_IPX  /* Net+Host => 10-byte IPX peer addresses */
#define noCLNS      /* CLNS peer addresses are 20-byte NSAPs */

#if defined(FULL_IPX) || defined(CLNS)
#define BIG_PEER_ADDR  /* 20-byte peer addresses */
#endif

#ifdef PKTSNAP
#define EXTERN
#else
#define EXTERN extern
#endif

#define MXPKTHDRLEN  70  /* CLNS = 26-byte header + 2x 21-byte NSAPs */

#define MAC_ADDR_LEN     6  /* Address lengths */

#define IP_ADDR_LEN      4
#define DN_ADDR_LEN      3
#define ET_ADDR_LEN      3
#ifdef FULL_IPX
#define IPX_ADDR_LEN    10
#else
#define IPX_ADDR_LEN     4
#endif
#define NSAP_ADDR_LEN   20

#define DETAIL_ADDR_LEN  2

#ifdef BIG_PEER_ADDR
#define PEER_ADDR_LEN   20  /* Default */
#else
#define PEER_ADDR_LEN    4  /* Default */
#endif

#ifdef BIG_PEER_ADDR
#define RULE_ADDR_LEN   20  /* Max of above */
#else
#define RULE_ADDR_LEN    6  /* Max of above */
#endif

struct pkt_key {
   unsigned char AdjAddress[MAC_ADDR_LEN];
   unsigned char PeerAddress[PEER_ADDR_LEN];
   unsigned char DetailAddress[DETAIL_ADDR_LEN];
   };

struct pkt {
   unsigned int p_len;
   unsigned char PeerAddrType;
   unsigned char DetailAddrType;
   struct pkt_key Low, High;
   };

#ifdef AU_MSDOS
/* Declared in wattcp\src\pcpkt.c .. */

void pkt_rcv_call2(unsigned int handle, unsigned int len,
   unsigned char far *buff);

extern char au_monitor;  /* 1 to enable monitoring */

extern unsigned char eth_addr[6];
extern unsigned long npackets,nbytes;
#else
EXTERN unsigned long npackets;  /* Declared in meter_ux.c */
#endif

/* Declared in wattcp\acct\meter_pc.c .. */

EXTERN unsigned int bkgi;  /* Seconds before next run of backgound process */

EXTERN unsigned int  /* Statistics variables */
   max_pkt_rate, pkt_backlog,max_pkt_backlog,
   dummypackets, mdpacketrate;
EXTERN unsigned long
   stats_time, t_backlog,
   spackets,sbytes,
   kilodummypackets, dummypacketrate, mindummyrate,
   badpackets,nobufpackets;
EXTERN unsigned char
   clear_pkt_stats;  /* 1 to clear stats variables */

/* Declared in wattcp\elib\q*.asm .. */

#ifdef AU_MSDOS
void qmove(unsigned char far *s, unsigned char far *d, unsigned int n);
int qcmp(unsigned char far *s, unsigned char far *d, unsigned int n);

#else 

#define qmove(s,d,n) memcpy((char *)d,(char *)s,n)
#define qcmp(s,d,n) memcmp((char *)s,(char *)d,n)

#define w_roll(x1,y1, x2,y2, up)
#define scpos(x,y)
#define w_clear(x1,y1, x2,y2)
#endif

/* Monitor variables .. */

EXTERN long lostpackets;

#define MAXPKTLEN  1526

#ifdef AU_MSDOS
EXTERN struct pkt far *pkts;

EXTERN int
   maxpkt,  /* Must be a power of 2 */
   pktmask,   /* maxpkt-1 */
   maxpkthi,  /* maxpkt/256 */
   prcv,   /* Index of next pkt to be received (i.e. next empty pkt) */
   pproc;  /* Index of next pkt to be processed (i.e. next full pkt) */
#endif

EXTERN long l_tod;  /* Time of day */
EXTERN char tod_h,tod_m,tod_s,
   s_tod_h,s_tod_m,s_tod_s;  /* Time when counters last saved */

EXTERN int midnight_crossings;
EXTERN long boot_time;

EXTERN long elapsed_sec;  /* Seconds since counters last saved */

unsigned long uptime();  /* Since startup, in centiseconds */

#ifdef AU_MSDOS
void chart(int tx, int ty,  /* Declared in chart.c */
   int bx, int by,
   int x1, int x2, int x3);

long biosticks(void);  /* PC clock ticks */

/* 12 bytes interframe space + 8 bytes preamble + 4 byte FCS */
#define util_pc(p,b)  (((24l*p + b)/1250l + 5l)/10l)  /* % utilisation */
#endif

#ifndef NULL
#define NULL  0
#endif


