#include <stdlib.h>  // prototype for qsort
#include "arrayob.h"

inline Object** REALLOC(Object** ptr, unsigned size)
{
    return (Object**)realloc((char*)ptr,sizeof(Object*)*size);
}

inline void DELETE(Object** ptr) { free((char*)ptr); }


#define THIS    ArrayOb
#define BASE    Collection
//DEFINE_CLASS(THIS, BASE);
DEFINE_CLASS(ArrayOb,Collection);

#define NEW(type,size)  ((type*)malloc(sizeof(type)*(size)))

ArrayOb::ArrayOb(unsigned size)
{
    sz = size;
    if (sz==0) allocSizeErr();
    v = NEW(Object*,sz);
    register i = sz;
    register Object** vp = &v[0];
    while (i--) *vp++ = (Object*)nil;
}
    
ArrayOb::ArrayOb(const ArrayOb& a)
{
    register i = a.sz;
    sz = i;
    v = NEW(Object*,i);
    register Object** vp = &v[0];
    register Object** av = &a.v[0];
    while (i--) *vp++ = *av++;
}

ArrayOb::~ArrayOb() { DELETE(v); }

void ArrayOb::operator=(const ArrayOb& a)
{
    if (v != a.v) {
        DELETE(v);
        v = NEW(Object*,sz=a.sz);
        register i = a.sz;
        register Object** vp = &v[0];
        register Object** av = &a.v[0];
        while (i--) *vp++ = *av++;
    }
}

bool ArrayOb::operator==(const ArrayOb& a) const
{
    if (sz != a.sz) return NO;
    register unsigned i = sz;
    register Object** vp = &v[0];
    register Object** av = &a.v[0];
    while (i--) { if (!((*vp++)->isEqual(**av++))) return NO; }
    return YES;
}

Object*& ArrayOb::at(int i) const { return (*this)[i]; }

unsigned ArrayOb::capacity() const    { return sz; }
    
bool ArrayOb::isEqual(const Object& a) const
{
    return a.isSpecies(class_ArrayOb) && *this==*(ArrayOb*)&a;
}

const Class* ArrayOb::species() const { return &class_ArrayOb; }

void ArrayOb::reSize(unsigned newsize)
{
    if (newsize<=0) allocSizeErr();
    v = REALLOC(v,newsize);
    sz = newsize;
}

Collection& ArrayOb::addContentsTo(Collection& cltn) const
{
    register Object** vp = &v[0];
    register unsigned i = sz;
    while (i--) cltn.add(**vp++);
    return cltn;
}

Object* ArrayOb::doNext(Iterator& pos) const
{
    if (pos.index < size()) return v[pos.index++];
    return 0;
}

void ArrayOb::deepenShallowCopy()
{
    BASE::deepenShallowCopy();
    register Object** av = &v[0];
    register i = sz;
    v = NEW(Object*,i);
    register Object** vp = &v[0];
    while (i--) *vp++ = (*av++)->deepCopy();
}

unsigned ArrayOb::hash() const
{
    register unsigned h = sz;
    register unsigned i = sz;
    register Object** vp = &v[0];
    while (i--) h^=(*vp++)->hash();
    return h;
}

void ArrayOb::printOn(ostream& strm) const
{
    strm << className() << "[\n";
    for (register unsigned i=0; i<sz; i++) {
        if (i>0) strm << "\n";
        v[i]->printOn(strm);
    }
    strm << "]\n";
}


unsigned ArrayOb::size() const    { return sz; }

static int
compare_ob(Object** a, Object** b) // const
{
    return (*a)->compare(**b);
}

void ArrayOb::sort() const
{
    //qsort(&v[0],sz,sizeof(Object*),compare_ob);
    // -gmv 2/14/90 added cast
    qsort(&v[0],sz,sizeof(Object*),
    (int (*)(const void*, const void*))compare_ob);
}

void ArrayOb::allocSizeErr() const
{
    //DTerror("OOPS_ALLOCSIZE,DEFAULT,this",className());
    DTerror("Negative or zero object allocation size requested: ",className());
}

void ArrayOb::indexRangeErr() const
{
    //DTerror("OOPS_INDEXRANGE,DEFAULT,this",className());
    DTerror("Index out of range: ",className());
}


