(*--------------------------------------------------------------------------*)
(*                       Power -- raise real to real power                  *)
(*--------------------------------------------------------------------------*)

FUNCTION Power( x: REAL; y: REAL ) : REAL;

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*      Function:  Power                                                    *)
(*                                                                          *)
(*      Purpose:   Performs exponentiation of real to real power.           *)
(*                                                                          *)
(*      Calling Sequence:                                                   *)
(*                                                                          *)
(*         Powval := Power( x , y: REAL ) : REAL;                           *)
(*                                                                          *)
(*            x      --- base (must be positive)                            *)
(*            y      --- power to raise base to                             *)
(*                                                                          *)
(*      Calls:     None                                                     *)
(*                                                                          *)
(*      Remarks:                                                            *)
(*                                                                          *)
(*         If x < 0 and y < 0, 0 is returned.  Likewise, Power(0,0) returns *)
(*         zero.                                                            *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

BEGIN (* Power *)

   IF x > 0 THEN
      Power := EXP( y * LN( x ) )
   ELSE
      Power := 0.0;

END   (* Power *);