/*
	rtfwc - read rtf input, write word count (actually, char, word
		and paragraph counts).

	This installs callbacks for the ascii and control token classes.
	The control class is necessary so that special characters such as
	\par, \tab, \sect, etc.  can be counted.

	Counts paragraphs instead of lines, since the concept of "line"
	is relatively meaningless.

	It's problematic how to count text in headers and footers, and
	what to do about tables.

	04 Feb 91	Paul DuBois	dubois@primate.wisc.edu

	04 Feb 91 V1.0. Created.
	27 Feb 91 V1.01. Updated for distribution 1.05.
	16 Mar 91 V1.02. Updated for distribution 1.06.  Multiple files
		allowed.
*/

# include	<stdio.h>
# include	"rtf.h"


static long	chars, tchars = 0;
static long	words, twords = 0;
static long	paras, tparas = 0;
static long	wchars = 0;	/* chars in current word */

static void	Count ();
static void	Text ();
static void	Control ();

int main (argc, argv)
int	argc;
char	**argv;
{
int	i;

	--argc;
	++argv;

	if (argc == 0)
	{
		Count ();
		printf ("\n");
	}
	else
	{
		for (i = 0; i < argc; i++)
		{
			if (freopen (argv[i], "r", stdin) == NULL)
			{
				fprintf (stderr, "Can't open \"%s\"\n",
								argv[i]);
				exit (1);
			}
			Count ();
			printf ("\t%s\n", argv[i]);
		}
		if (argc > 1)	/* multiple files, print totals */
			printf ("%ld chars\t%ld words\t%ld paragraphs\ttotal\n",
						tchars, twords, tparas);
	}

	exit (0);
}


static void Count ()
{
	chars = words = paras = wchars = 0;

	RTFInit ();

	/* install counting hooks and process the input stream */

	RTFSetClassCallback (rtfText, Text);
	RTFSetClassCallback (rtfControl, Control);
	RTFRead ();
	printf ("%ld chars\t%ld words\t%ld paragraphs", chars, words, paras);
	tchars += chars;
	twords += words;
	tparas += paras;
}

static void Text ()
{
	++chars;
	if (rtfMajor != ' ')
		++wchars;
	else if (wchars > 0)
		++words;
}


static void Control ()
{
	if (rtfMajor != rtfSpecialChar)
		return;
	switch (rtfMinor)
	{
	case rtfPage:
	case rtfSect:
	case rtfLine:
	case rtfPar:
		++paras;
		++chars;
		if (wchars > 0)
		{
			++words;
			wchars = 0;
		}
		break;
	case rtfNoBrkSpace:
	case rtfTab:
		++chars;
		if (wchars > 0)
		{
			++words;
			wchars = 0;
		}
		break;
	case rtfNoBrkHyphen:
		++chars;
		++wchars;
		break;
	}
}
