/*
	ESTOOLS0.H -- limited header file for use with ESTOOLS.DLL
	Copyright  Eugene Sokolov 1992-1993, (516)632-7892,
	esokolov@sbchm1.chem.sunysb.edu

	You can freely copy, change or redistribute this file as long
	as this notice remains intact.
*/
#ifndef __WINDOWS_H
#define STRICT
#include <windows.h>
#endif /* __WINDOWS_H */

#ifndef __ESTOOLS_H
#define __ESTOOLS_H

/* Tool Bar styles */

#define TB_RESOURCE_VERSION 0xE100 // Resource script version, new to v.1.01 !!!

#define TBS_CHILD	0x0	// Translated into WS_CHILD -- default;
#define TBS_POPUP	0x1	// Translated into WS_POPUP;
#define TBS_MOVABLE	0x0	// Has caption -- default;
#define TBS_FIXED	0x2	// No caption  -- ignored if TBS_POPUP set;
#define TBS_NOBORDER	0x0	// No border around controls -- default;
#define TBS_BORDER	0x4	// Has a border around controls
				// if it is clear, than value at TBP_BORDER
				// offset is ignored;
#define TBS_VISIBLE	0x8	// Translated into WS_VISIBLE;


/* Tool Bar button styles */
#define TBB_STANDARD	0x0	// Standard Windows-like button -- default;
#define TBB_AUTO2STATE	0x1	// Button remains depressed untill another button
				// in the same tool bar is pressed;
#define TBB_2STATE	0x2	// Button remains depressed until it state is changed
				// by sending it a message TBM_CHANGEBTNSTATE -- you need to
				// register to know how it works or try to figure out yourself;
#define TBB_STATIC	(TBB_AUTO2STATE | TBB_2STATE)
				//Combination of the two above
#define TBB_DISABLED	0x4	// Button disabled (shadowed)
#define TBB_PRESSED	0x8	// Button initially pressed

/* Base for messages */
#define UNDEFINED   WM_USER+???      //it is defined in a real estools.h
// Do not try to use any of these definitions in your program, they
//will produce an error

/* Notification messges */

#define TBN_CHANGED UNDEFINED+16
					//
					//
					//
					//

/* Tool Bar messages -- need to register to use them or try to find out */
#define TBM_BASE	   UNDEFINED
#define TBM_SETBTNSTATE    (TBM_BASE)		//
#define TBM_GETBTNSTATE    (TBM_BASE+1)  	//
#define TBM_SETBTNSTYLE    (TBM_BASE+2)		//        The
#define TBM_GETBTNSTYLE    (TBM_BASE+3)		//   explanation for
#define TBM_SETTBSTYLE	   (TBM_BASE+4)		//   these messages
						//   is placed here
						//    in the real
						//     estools.h.
						//
						//
						//
						//
						//
#define TBM_GETTBSTYLE	   (TBM_BASE+5)		//
						//
						//
#ifndef RC_INVOKED
/* Structures describing the header of TB resource */
typedef struct tagToolBarControl
{
   UINT tbcBmp;           //Bitmap resource ID
   UINT tbcMsg;           //Button ID
   UINT	tbcStl;           //Button style
}TBCONTROLSTRUCT;
typedef TBCONTROLSTRUCT FAR* LPTBCONTROLSTRUCT;

typedef struct tagTBResourceHeader
{
   UINT nVersion;	  // ATTENTION !!! New in this version
			  // Resource version number. Added for future
			  // compatibility. Has to be set to 0xE100
			  // (TB_RESOURCE_VERSION)
   UINT nWndName;         // String ID -- identifies TB's name
   WORD wStyle;           // TB style
   int  nXSize;           // Button width
   int  nYSize;           // Button height
   int  nBorder;          // Border size
   int  nRowLen;          // Number of button per horozontal row.
   int  nCtrl;            // Total number of buttons
   TBCONTROLSTRUCT tbcsCtrl[1];  //Individual buttons.
}TBRESOURCEHEADER;
typedef TBRESOURCEHEADER FAR* LPTBRESOURCEHEADER;

/* Functions exported from estools.dll */

/*
   UINT  CALLBACK ESToolBarVers	( VOID );
   Retrieves a version number of DLL.
   DLL version.

   Parameters:
      NONE.
   Returns:
      DLL version number, in hexadecimal. Current version is 1.01,
      this function returns 0x101. For example for the version
      3.21 it will return 0x321.
*/
UINT  CALLBACK	ESToolBarVers	( VOID );

/*
   HWND CALLBACK CreateToolBar( HINSTANCE hInst, LPSTR lpszTemplate,
      HWND hwndParent, POINT pntPosition );
   Creates a tool bar control.

   Parameters:
      hInst:		Instance handle (must be an instance of application,
			NOT library);
      lpszTemplate:	Pointer to the null terminated name of the TB template.
      hwndParent:	Parent window of the TB control.
      pntPosition:      Initial position of the TB control. Pay attention,
			is is a POINT struct itself, not a pointer, do not
			try to supply NULL.
   Returns:
      On sucsess returns a window handle of the TB control, NULL otherwise.
*/
HWND CALLBACK	CreateToolBar	( HINSTANCE, LPSTR, HWND, POINT );

/*
   BOOL CALLBACK DeleteToolBar( HWND hwnd );
   Destroys the tool bar. This function is called when the TB
   window reseives WM_DESTROY message.

   Parameters:
      hwnd:		Window handle of the TB control to be destroyed
   Returns:
      On sucsess returns TRUE, FALSE otherwise.
*/
BOOL CALLBACK 	DeleteToolBar	( HWND );

/*
   int  CALLBACK GetButtonNumber( HWND hwnd, UINT nId );
   Retrieves the button number from it's ID number,
   analogous to GetDlgItem except that the TB buttons
   are not individual windows and consequently do not have
   handles.

   Parameters:
      hwnd:	TB window handle;
      nId	Button ID (equal to the wParam of WM_COMMAND from
		the corresponding button, or second parameter (tbsMsg)
		in the TB resource).
   Returns:
      Button number, which can be used to change button's state or style.
      If no button with such ID exists function returns -1. If several
      buttons share the same ID it returns first it encounters.

*/
int  CALLBACK	GetButtonNumber	( HWND, UINT );

#endif /* RC_INVOKED */

#endif /* __ESTOOLS_H */