/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl.gtk;

import com.l2fprod.gui.plaf.skin.DefaultButton;
import com.l2fprod.gui.plaf.skin.SkinSplitPane;
import com.l2fprod.gui.plaf.skin.impl.AbstractSkinSplitPane;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkUtils;
import com.l2fprod.gui.plaf.skin.impl.gtk.parser.GtkParser;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.SwingConstants;

final class GtkSplitPane
extends AbstractSkinSplitPane
implements SkinSplitPane,
SwingConstants {
    DefaultButton h_gutter;
    DefaultButton v_gutter;
    DefaultButton h_thumb;
    DefaultButton v_thumb;
    DefaultButton up;
    DefaultButton down;
    DefaultButton left;
    DefaultButton right;

    public GtkSplitPane(GtkParser gtkParser) throws Exception {
        this.h_gutter = GtkUtils.newButton(gtkParser, "GtkPaned", new String[]{"function", "orientation"}, new String[]{"BOX", "HORIZONTAL"});
        this.v_gutter = GtkUtils.newButton(gtkParser, "GtkPaned", new String[]{"function", "orientation"}, new String[]{"BOX", "VERTICAL"});
        this.h_thumb = GtkUtils.newButton(gtkParser, "GtkPaned", new String[]{"function", "orientation"}, new String[]{"HANDLE", "HORIZONTAL"});
        if (this.h_thumb == null) {
            this.h_thumb = this.h_gutter;
        }
        this.v_thumb = GtkUtils.newButton(gtkParser, "GtkPaned", new String[]{"function", "orientation"}, new String[]{"HANDLE", "VERTICAL"});
        if (this.v_thumb == null) {
            this.v_thumb = this.v_gutter;
        }
        this.up = GtkUtils.newButton(gtkParser, "GtkPaned", new String[]{"function", "arrow_direction"}, new String[]{"ARROW", "UP"});
        this.down = GtkUtils.newButton(gtkParser, "GtkPaned", new String[]{"function", "arrow_direction"}, new String[]{"ARROW", "DOWN"});
        this.left = GtkUtils.newButton(gtkParser, "GtkPaned", new String[]{"function", "arrow_direction"}, new String[]{"ARROW", "LEFT"});
        this.right = GtkUtils.newButton(gtkParser, "GtkPaned", new String[]{"function", "arrow_direction"}, new String[]{"ARROW", "RIGHT"});
    }

    public Dimension getPreferredSize(JSplitPane jSplitPane) {
        Insets insets = jSplitPane.getInsets();
        int n = 0;
        int n2 = 0;
        if (jSplitPane.getOrientation() == 1) {
            n = Math.max(Math.max(this.up.getWidth(), this.down.getWidth()), 10);
            n2 = jSplitPane.getHeight() + insets.top + insets.bottom;
        } else {
            n2 = Math.max(Math.max(this.left.getHeight(), this.right.getHeight()), 10);
            n = jSplitPane.getWidth() + insets.left + insets.right;
        }
        Dimension dimension = new Dimension(n, n2);
        return dimension;
    }

    public Dimension getArrowPreferredSize(int n) {
        switch (n) {
            case 1: {
                return new Dimension(this.up.getWidth(), this.up.getHeight());
            }
            case 5: {
                return new Dimension(this.down.getWidth(), this.down.getHeight());
            }
            case 7: {
                return new Dimension(this.left.getWidth(), this.left.getHeight());
            }
            case 3: {
                return new Dimension(this.right.getWidth(), this.right.getHeight());
            }
        }
        throw new Error("Invalid direction " + n);
    }

    public boolean status() {
        return true;
    }

    public boolean installSkin(JComponent jComponent) {
        return true;
    }

    public boolean paintArrow(Graphics graphics, AbstractButton abstractButton, int n) {
        Dimension dimension = abstractButton.getSize();
        switch (n) {
            case 1: {
                this.down.paint(graphics, 0, 0, dimension.width, dimension.height, abstractButton);
                break;
            }
            case 5: {
                this.up.paint(graphics, 0, 0, dimension.width, dimension.height, abstractButton);
                break;
            }
            case 7: {
                this.left.paint(graphics, 0, 0, dimension.width, dimension.height, abstractButton);
                break;
            }
            case 3: {
                this.right.paint(graphics, 0, 0, dimension.width, dimension.height, abstractButton);
            }
        }
        return true;
    }

    public boolean paintGutter(Graphics graphics, JSplitPane jSplitPane, Dimension dimension) {
        if (jSplitPane.getOrientation() == 1) {
            this.h_gutter.paint(graphics, 0, 0, dimension.width, dimension.height, jSplitPane);
            return true;
        }
        this.v_gutter.paint(graphics, 0, 0, dimension.width, dimension.height, jSplitPane);
        return true;
    }

    public boolean paintThumb(Graphics graphics, JSplitPane jSplitPane, Dimension dimension) {
        if (jSplitPane.getOrientation() == 1 && this.h_thumb != null) {
            this.h_thumb.paint(graphics, Math.max(0, (dimension.width - this.h_thumb.getWidth()) / 2), (dimension.height - this.h_thumb.getHeight()) / 2, Math.min(dimension.width, this.h_thumb.getWidth()), this.h_thumb.getHeight(), jSplitPane);
        } else if (jSplitPane.getOrientation() == 0 && this.v_thumb != null) {
            this.v_thumb.paint(graphics, (dimension.width - this.v_thumb.getWidth()) / 2, Math.max(0, (dimension.height - this.v_thumb.getHeight()) / 2), this.v_thumb.getWidth(), Math.min(dimension.height, this.v_thumb.getHeight()), jSplitPane);
        } else {
            return false;
        }
        return true;
    }
}

