

#ifdef PDF417ENCODEDLL_EXPORTS
#define PDF417ENCODEDLL_API __declspec(dllexport)
#else
#define PDF417ENCODEDLL_API __declspec(dllimport)
#endif

#define USE_ASPECT_RATIO     0
#define FIXED_RECTANGLE      1
#define FIXED_COLUMNS        2
#define FIXED_ROWS           4
#define USE_ERROR_LEVEL      16

typedef struct tagPDF417CONTEXT
{
	int symbology;
	int nHeight;
	int nWidth;
	int nRows;
	int nColumns;
	int nErrorCorrectLevel;
	int nMargin;
	COLORREF clForeGround;
	COLORREF clBackGround;
	char cData[7000];
	char cEncodedData[90][1000];
	char errtxt[100];
}PDF417CONTEXT;

PDF417ENCODEDLL_API void InitWorkSpace(PDF417CONTEXT *pPdf417Ctx);
PDF417ENCODEDLL_API BOOL FreeWorkSpace();
PDF417ENCODEDLL_API BOOL PDF417Encode2File(PDF417CONTEXT *pPdf417Ctx, LPCTSTR lpImageFile);
PDF417ENCODEDLL_API HBITMAP PDF417Encode2Bitmap(PDF417CONTEXT *pPdf417Ctx);

