#include <math.h>

#include "sources.cpp\licht.cpp"
#include "sources.cpp\gtri.cpp"

#include "sources.cpp\3dd.h"


/*
 Implementation der 3D Engine.
 Fuer die Erklaerung des Algorithmus sei hier auf die beiliegende Textdatei
 verwiesen.

 Autor: Tobias Schwinger                                                  */



/////////// Routinen zur erstellung der Rotationstabellen //////////////////


void kurven_berechnen()
{
  word c; // 14Bit Festpunkt - hoechstmoeglicher Faktor fuer 16Bit imul
  for (c=0; c<=rotationsschritte; c++) {
    sinuz[c]=(int)(sinl((pi*2*c)/rotationsschritte) * 16384);
    cosinuz[c]=(int)(cosl((pi*2*c)/rotationsschritte) * 16384);
  }
}



/////////// Implementation Klasse Koerper //////////////////////////////////


koerper::koerper(int n_polys,int n_punkte)
{
  poly_anz=n_polys;
  punkt_anz=n_punkte;

  polys=new tri[poly_anz];
  mpnkte=new punkt[poly_anz];
  mpnkte2=new punkt[poly_anz];

  punkte=new punkt[punkt_anz];
  punkte2=new punkt[punkt_anz];
  pnktlst2d=new ue_2d_punkt[punkt_anz];

  for(int c=0; c<=punkt_anz; c++) pnktlst2d[c].zaehler=0;
  abbildungszaehler=1;
}


koerper::koerper(int n_polys,int n_punkte,tri *poly_liste,
					punkt *pnkt_liste, punkt *mpnkt_liste)
{
  poly_anz=n_polys;
  punkt_anz=n_punkte;

  polys=poly_liste;
  punkte=pnkt_liste;
  mpnkte=mpnkt_liste;

  punkte2=new punkt[punkt_anz];
  mpnkte2=new punkt[poly_anz];
  pnktlst2d=new ue_2d_punkt[punkt_anz];
  abbildungszaehler=1;
}


koerper::~koerper()
{
  delete polys;
  delete punkte;
  delete mpnkte;
  delete punkte2;
  delete mpnkte2;
  delete pnktlst2d;
}


void koerper::mittelpunkte(void)
{
  word c;
  for(c=0; c<=poly_anz; c++) {
    mpnkte[c].x=(int)((punkte[polys[c].p1].x)+
		      (punkte[polys[c].p2].x)+
		      (punkte[polys[c].p3].x))/3;
    mpnkte[c].y=(int)((punkte[polys[c].p1].y)+
		      (punkte[polys[c].p2].y)+
		      (punkte[polys[c].p3].y))/3;
    mpnkte[c].z=(int)((punkte[polys[c].p1].z)+
		      (punkte[polys[c].p2].z)+
		      (punkte[polys[c].p3].z))/3;
  }
}


void koerper::rotieren(word xr,word yr,word zr,listentyp quelle)
{
  punkt *src;
  int xrs,xrc,yrs,yrc,zrs,zrc;
  int x,y,z;
  int c;

  if (quelle==ursprung) {
    src=punkte;
  } else {
    src=punkte2;
  }

  xrs=sinuz[xr];
  xrc=cosinuz[xr];
  yrs=sinuz[yr];
  yrc=cosinuz[yr];
  zrs=sinuz[zr];
  zrc=cosinuz[zr];

  for(c=0; c<=punkt_anz; c++) {
    x=src[c].x;
    y=src[c].y;
    z=src[c].z;
    if (yr!=0) asm {  // Ungluecklicherweise konnte ich diese Assembler-
      mov   ax,[yrc]  // routine nicht als Macro definieren...
      mov   bx,[x]    // Mein Preprozessor behauptete das Assembler Statement
      add   bx,bx     // sei zu lang (laut Dokumentation stimmt die Laenge).
      add   bx,bx
      imul  bx        // Hier wird eine 16Bit-Festpunkt-Zahl erzeugt, damit
      mov   di,dx     // ich nach dem imul mit dx (highword) fortfahren kann.
       mov   ax,[yrs]
      mov   cx,[z]
      add   cx,cx
      add   cx,cx
      imul  cx
      add   di,dx
      mov   [x],di
       mov   ax,[yrc]
      imul  cx
      mov   di,dx
       mov   ax,[yrs]
      imul  bx
      sub   di,dx
      mov   [z],di
    };
    if (xr!=0) asm {
      mov   ax,[xrc]
      mov   bx,[z]
      add   bx,bx
      add   bx,bx
      imul  bx
      mov   di,dx
      mov   ax,[xrs]
       mov   cx,[y]
      add   cx,cx
      add   cx,cx
      imul  cx
      add   di,dx
      mov   [z],di
       mov   ax,[xrc]
      imul  cx
      mov   di,dx
       mov   ax,[xrs]
      imul  bx
      sub   di,dx
      mov   [y],di
    }
    if (zr!=0) asm {
      mov   ax,[zrc]
      mov   bx,[y]
      add   bx,bx
      add   bx,bx
      imul  bx
      mov   di,dx
      mov   ax,[zrs]
       mov   cx,[x]
      add   cx,cx
      add   cx,cx
      imul  cx
      add   di,dx
      mov   [y],di
       mov   ax,[zrc]
      imul  cx
      mov   di,dx
       mov   ax,[zrs]
      imul  bx
      sub   di,dx
      mov   [x],di
    }
    punkte2[c].x=x;
    punkte2[c].y=y;
    punkte2[c].z=z;
  }

  if (quelle==ursprung) {
    src=mpnkte;
  } else {
    src=mpnkte2;
  }
  for(c=0; c<=poly_anz; c++) {
    x=src[c].x;
    y=src[c].y;
    z=src[c].z;
    if (yr!=0) asm {
      mov   ax,[yrc]
      mov   bx,[x]
      add   bx,bx
      add   bx,bx
      imul  bx
      mov   di,dx
       mov   ax,[yrs]
      mov   cx,[z]
      add   cx,cx
      add   cx,cx
      imul  cx
      add   di,dx
      mov   [x],di
       mov   ax,[yrc]
      imul  cx
      mov   di,dx
       mov   ax,[yrs]
      imul  bx
      sub   di,dx
      mov   [z],di
    };
    if (xr!=0) asm {
      mov   ax,[xrc]
      mov   bx,[z]
      add   bx,bx
      add   bx,bx
      imul  bx
      mov   di,dx
      mov   ax,[xrs]
       mov   cx,[y]
      add   cx,cx
      add   cx,cx
      imul  cx
      add   di,dx
      mov   [z],di
       mov   ax,[xrc]
      imul  cx
      mov   di,dx
       mov   ax,[xrs]
      imul  bx
      sub   di,dx
      mov   [y],di
    }
    if (zr!=0) asm {
      mov   ax,[zrc]
      mov   bx,[y]
      add   bx,bx
      add   bx,bx
      imul  bx
      mov   di,dx
      mov   ax,[zrs]
       mov   cx,[x]
      add   cx,cx
      add   cx,cx
      imul  cx
      add   di,dx
      mov   [y],di
       mov   ax,[zrc]
      imul  cx
      mov   di,dx
       mov   ax,[zrs]
      imul  bx
      sub   di,dx
      mov   [x],di
    }
    mpnkte2[c].x=x;
    mpnkte2[c].y=y;
    mpnkte2[c].z=z;
  }
}



void koerper::bewegen(punkt vektor,listentyp quelle)
{
  punkt *src;
  int c;

  if (quelle==ursprung) {
    src=punkte;
  } else {
    src=punkte2;
  }

  for(c=0; c<=punkt_anz; c++) {
    punkte2[c].x=src[c].x+vektor.x;
    punkte2[c].y=src[c].y+vektor.y;
    punkte2[c].z=src[c].z+vektor.z;
  }

  if (quelle==ursprung) {
    src=mpnkte;
  } else {
    src=mpnkte2;
  }
  for(c=0; c<=poly_anz; c++) {
    mpnkte2[c].x=src[c].x+vektor.x;
    mpnkte2[c].y=src[c].y+vektor.y;
    mpnkte2[c].z=src[c].z+vektor.z;
  }
}


void koerper::skalieren(float x,float y,float z,listentyp quelle,listentyp ziel)
{
  punkt *src,*dst;
  int c;

  if (quelle==ursprung) {
    src=punkte;
  } else {
    src=punkte2;
  }

  if (ziel==ursprung) {
    dst=punkte;
  } else {
    dst=punkte2;
  }

  for(c=0; c<=punkt_anz; c++) {
    dst[c].x=(int)src[c].x*x;
    dst[c].y=(int)src[c].y*y;
    dst[c].z=(int)src[c].z*z;
  }

  if (quelle==ursprung) {
    src=mpnkte;
  } else {
    src=mpnkte2;
  }
  if (ziel==ursprung) {
    dst=mpnkte;
  } else {
    dst=mpnkte2;
  }

  for(c=0; c<=poly_anz; c++) {
    dst[c].x=(int)src[c].x*x;
    dst[c].y=(int)src[c].y*y;
    dst[c].z=(int)src[c].z*z;
  }
}


void koerper::abbilden(raum *welt,beleuchtung *licht,int z_off)
{
  word c,i;
  word p1,p2,p3;
  int x1,y1,z1,x2,y2,z2,x3,y3,z3;
  abbildungszaehler++;
  i=welt->indexz;
  for(c=0; c<=poly_anz; c++) {
    p1=polys[c].p1; p2=polys[c].p2; p3=polys[c].p3;
    z1=punkte2[p1].z; z2=punkte2[p2].z; z3=punkte2[p3].z;
    if ( ((z1-=z_off)<=0) || ((z2-=z_off)<=0) || ((z3-=z_off)<=0)) continue;
    x1=punkte2[p1].x; y1=punkte2[p1].y;
    x2=punkte2[p2].x; y2=punkte2[p2].y;
    x3=punkte2[p3].x; y3=punkte2[p3].y;

    // Falls der Punkt noch nicht in 2d umgerechnet wurde, es jetzt tun.
    // Ansonsten die 2d Koordinaten holen.
    if (pnktlst2d[p1].zaehler!=abbildungszaehler) {
      pnktlst2d[p1].licht=licht->helligkeit_ermitteln(x1,y1,z1+z_off);
      asm {
	mov   ax,[x1]     // z-stretch Projektion (so nenne ich sie)
	mov   cx,[z1]
	mov   dx,ax
	sal   ax,8
	sar   dx,8
	idiv  cx
	add   ax,x_mid
	mov   [x1],ax
	mov   ax,[y1]
	mov   dx,ax
	sal   ax,8
	sar   dx,8
	idiv  cx
	add   ax,y_mid
	mov   [y1],ax
      }
      pnktlst2d[p1].zaehler=abbildungszaehler;
      pnktlst2d[p1].x=x1;
      pnktlst2d[p1].y=y1;
    }  else { x1=pnktlst2d[p1].x; y1=pnktlst2d[p1].y; }

    if (pnktlst2d[p2].zaehler!=abbildungszaehler) {
      pnktlst2d[p2].licht=licht->helligkeit_ermitteln(x2,y2,z2+z_off);
      asm {
	mov   ax,[x2]
	mov   cx,[z2]
	mov   dx,ax
	sal   ax,8
	sar   dx,8
	idiv  cx
	add   ax,x_mid
	mov   [x2],ax
	mov   ax,[y2]
	mov   dx,ax
	sal   ax,8
	sar   dx,8
	idiv  cx
	add   ax,y_mid
	mov   [y2],ax
      }
      pnktlst2d[p2].zaehler=abbildungszaehler;
      pnktlst2d[p2].x=x2;
      pnktlst2d[p2].y=y2;
    } else { x2=pnktlst2d[p2].x; y2=pnktlst2d[p2].y; }

    if (pnktlst2d[p3].zaehler!=abbildungszaehler) {
      pnktlst2d[p3].licht=licht->helligkeit_ermitteln(x3,y3,z3+z_off);
      asm {
	mov   ax,[x3]
	mov   cx,[z3]
	mov   dx,ax
	sal   ax,8
	sar   dx,8
	idiv  cx
	add   ax,x_mid
	mov   [x3],ax
	mov   ax,[y3]
	mov   dx,ax
	sal   ax,8
	sar   dx,8
	idiv  cx
	add   ax,y_mid
	mov   [y3],ax
      }
      pnktlst2d[p3].zaehler=abbildungszaehler;
      pnktlst2d[p3].x=x3;
      pnktlst2d[p3].y=y3;
    } else { x3=pnktlst2d[p3].x; y3=pnktlst2d[p3].y; }

    // Verdeckte Flaechen (dem Betrachter abgewandte) auslassen.
    if ( (y1-y3)*(x2-x1)-(x1-x3)*(y2-y1) >=0) continue;

    // In die Listen des Raums eintragen.
    welt->daten[i].bauanl=&polys[c];
    welt->daten[i].koords=pnktlst2d;
    welt->sort[i].z=mpnkte2[c].z;
    welt->sort[i].index=i++;
  }
  welt->indexz=i;
}



/////////// Implementation Klasse Raum /////////////////////////////////////


raum::raum(word max_polygone)
{
  sort=new zsrt[max_polygone];
  daten=new flaeche[max_polygone];
  indexz=0;
}


raum::~raum()
{
  delete sort;
  delete daten;
}


void raum::sortieren()
{
  if (indexz>0) qsort(0,indexz-1);
}


void raum::qsort(int l,int r)
{
  int i,j;
  int pivot;
  zsrt zw;

  if (r>l) {
    pivot=sort[r].z;
    i=l;
    j=r;
    do {
      while (sort[i].z<pivot) i++;
      do j--; while (sort[j].z>pivot);
      zw=sort[i];
      sort[i]=sort[j];
      sort[j]=zw;
    } while (j>i);

    sort[j]=sort[i];
    sort[i]=sort[r];
    sort[r]=zw;

    qsort(l,i-1);
    qsort(i+1,r);
  }
}


void raum::zeichnen()
{
  word i,p1,p2,p3,c1,c2,c3;
  int c,x1,y1,x2,y2,x3,y3;
  ue_2d_punkt *pkt;

  if (indexz==0) return;
  // poly_init;
  for (c=indexz-1; c>=0; c--) {
    i=sort[c].index;
    p1=daten[i].bauanl->p1;
    p2=daten[i].bauanl->p2;
    p3=daten[i].bauanl->p3;
    pkt=daten[i].koords;
    x1=pkt[p1].x; y1=pkt[p1].y;
    x2=pkt[p2].x; y2=pkt[p2].y;
    x3=pkt[p3].x; y3=pkt[p3].y;
    c1=c2=c3=daten[i].bauanl->farb << 5;
    c1+=pkt[p1].licht; c2+=pkt[p2].licht; c3+=pkt[p3].licht;
    GTriangle(x1,y1,c1,x2,y2,c2,x3,y3,c3);
  }
  indexz=0;
}




/////////// Vektoroperationen /////////////////////////////////////////////


punkt operator+(punkt p1,punkt p2)    // Addition zweier Vektoren
{
  p1.x+=p2.x; p1.y+=p2.y; p1.z+=p2.z;
  return(p1);
}


punkt operator*(punkt p,float faktor) // Skalierung eines Vektors
{
  p.x=(int)p.x*faktor; p.y=(int)p.y*faktor; p.z=(int)p.z*faktor;
  return(p);
}


void punkt_rotieren(punkt &p,word xr,word yr,word zr) // Rotation
{
  int x,y,z,xrs,xrc,yrs,yrc,zrs,zrc;

  xrs=sinuz[xr]; xrc=cosinuz[xr];
  yrs=sinuz[yr]; yrc=cosinuz[yr];
  zrs=sinuz[zr]; zrc=cosinuz[zr];

  x=p.x; y=p.y; z=p.z;
  if (yr!=0) asm {    // Ungluecklicherweise konnte ich diese Assembler-
    mov   ax,[yrc]    // routine nicht als Macro definieren...
    mov   bx,[x]      // Mein Preprozessor behauptete das Assembler Statement
    add   bx,bx       // sei zu lang (laut Dokumentation stimmt die Laenge).
    add   bx,bx
    imul  bx
    mov   di,dx
     mov   ax,[yrs]
    mov   cx,[z]
    add   cx,cx
    add   cx,cx
    imul  cx
    add   di,dx
    mov   [x],di
     mov   ax,[yrc]
    imul  cx
    mov   di,dx
     mov   ax,[yrs]
    imul  bx
    sub   di,dx
    mov   [z],di
  };
  if (xr!=0) asm {
    mov   ax,[xrc]
    mov   bx,[z]
    add   bx,bx
    add   bx,bx
    imul  bx
    mov   di,dx
    mov   ax,[xrs]
     mov   cx,[y]
    add   cx,cx
    add   cx,cx
    imul  cx
    add   di,dx
    mov   [z],di
     mov   ax,[xrc]
    imul  cx
    mov   di,dx
    mov   ax,[xrs]
     imul  bx
    sub   di,dx
    mov   [y],di
  }
  if (zr!=0) asm {
    mov   ax,[zrc]
    mov   bx,[y]
    add   bx,bx
    add   bx,bx
    imul  bx
    mov   di,dx
    mov   ax,[zrs]
     mov   cx,[x]
    add   cx,cx
    add   cx,cx
    imul  cx
    add   di,dx
    mov   [y],di
     mov   ax,[zrc]
    imul  cx
    mov   di,dx
     mov   ax,[zrs]
    imul  bx
    sub   di,dx
    mov   [x],di
  }
  p.x=x; p.y=y; p.z=z;
}





