/*  Bill Menees -- Cup of Fungus Software (c) 1993
	Directory Pop program - companion to Push
	Uses a file to simulate a stack of directory
	names.  One can push a dir, go anywhere they
	want, and then return to the old dir by just
	popping the old dir.
	Simple minded -- little error checking --
	DOS specific file functions :-(
*/
#include <stdio.h>
#include <string.h>
#include <dir.h>
#define FILEPLACE "c:\\pushpop.stk"
#define TEMPPLACE "c:\\tempfile.stk"

int main(void)
{
	char dir[MAXDIR], prevdir[MAXDIR], buffer[MAXDIR];
	FILE *dirstack, *temp;
	int singleflag=1;
	struct ffblk ffblk;

	/* checks to see if file exists. If not it exits quietly. */
	if(findfirst(FILEPLACE, &ffblk, 255)==0)
	{
		sprintf(buffer, "attrib %s -h", FILEPLACE);
		system(buffer);
	}
	else
	{
		exit(0);
	}

	/* opens the stack and temp file for work */
	if((dirstack=fopen(FILEPLACE,"rt"))==NULL)
	{
		printf("Unable to open %s\n", FILEPLACE);
		exit(1);
	}
	if(fscanf(dirstack, " %s", prevdir)==EOF) exit(3);
	if((temp=fopen(TEMPPLACE, "wt"))==NULL)
	{
		printf("Unable to create a temporary file!");
		exit(2);
	}
	while(fscanf(dirstack, " %s", dir)!=EOF)
	{
		singleflag=0;
		fprintf(temp, "%s\n", prevdir);
		strcpy(prevdir, dir);
	}
	/* now prevdir is the one we want to go into   */
	/* the rest were written to the temp file. */
	fclose(dirstack);
	fclose(temp);
	/* del dirstack and rename temp file */
	sprintf(buffer, "del %s", FILEPLACE);
	system(buffer);
	rename(TEMPPLACE, FILEPLACE);
	if(singleflag==1) system(buffer);
	else
	{
		sprintf(buffer, "attrib %s +h", FILEPLACE);
		system(buffer);
	}
	/* now go into drive and dir */
	chdir(prevdir);
	sprintf(buffer, "%c:", prevdir[0]);  /* drive=1st letter of prevdir */
	system(buffer);
	return 0;
}
