;****************************************************************************
;*
;*				MegaGraph Graphics Library
;*
;*                  Copyright (C) 1993 Kendall Bennett.
;*					All rights reserved.
;*
;* Filename:	$RCSfile: sv_page.asm $
;* Version:		$Revision: 1.1 $
;*
;* Language:	80386 Assembler
;* Environment:	IBM PC (MS DOS)
;*
;* Description:	This source file contains the code needed to change display
;*			pages on supported SuperVGA adapters, along with tables to
;*			find the correct routines for a specified video card.
;*
;*			Not all SuperVGA's support extended page flipping, so
;*			unsupported cards are marked in the table.
;*
;* $Id: sv_page.asm 1.1 1993/03/03 10:27:23 kjb Exp $
;*
;* Revision History:
;* -----------------
;*
;* $Log: sv_page.asm $
;* Revision 1.1  1993/03/03  10:27:23  kjb
;* Initial revision
;*
;****************************************************************************

_TEXT	ENDS
_DATA	SEGMENT

; Table of SuperVGA page flipping routines by video card. Unsupported cards
; are marked with a NONE_page.

chippage dw	NONE_page

SVGA_page dw	NONE_page		;  0 No Chip
	dw	VESA_page		;  1 VESA SuperVGA
	dw	ATI_page		;  2 ATI Technologies SuperVGA
	dw	NONE_page		;  3 AHEAD A SuperVGA (NONE)
	dw	AHEADB_page		;  4 AHEAD B SuperVGA
	dw	CHIPS_page		;  5 Chips & Technologies SuperVGA
	dw	NONE_page		;  6 Everex SuperVGA (NONE)
	dw	NONE_page		;  7 Genoa Systems SuperVGA (NONE)
	dw	NONE_page		;  8 OAK Technologies SuperVGA (NONE)
	dw	PARADISE_page		;  9 Paradise SuperVGA
	dw	TRIDENT88_page		; 10 Trident 8800 SuperVGA
	dw	TRIDENT89_page		; 11 Trident 8900 SuperVGA
	dw	VIDEO7_page		; 12 Video7 SuperVGA
	dw	ET3000_page		; 13 Tseng Labs ET3000 SuperVGA
	dw	ET4000_page		; 14 Tseng Labs ET4000 SuperVGA
	dw	NCR_page		; 15 NCR 77C22E SuperVGA
	dw	S3_page		; 16 S3 SuperVGA
	dw	NONE_page		; 17 AcuMos SuperVGA
	dw	NONE_page		; 18 AL2101 SuperVGA
	dw	NONE_page		; 19 MXIC SuperVGA
	dw	P2000_page		; 20 P2000 SuperVGA
	dw	NONE_page		; 21 RT3106 SuperVGA
	dw	CIRRUS_page		; 22 Cirrus 5422 SuperVGA

_DATA	ENDS
_TEXT	SEGMENT

;----------------------------------------------------------------------------
; NewPage	Set the visible page start address.
;----------------------------------------------------------------------------
;
; Program the start address for the appropriate video cards. If the card
; is not a SuperVGA, we simply set the lower 16 bits of the start address,
; otherwise we also set the top bits for the SuperVGA adapter.
;
; Note that interrupts will be off when these routines are called.
;
; These routines assumes that access to the SuperVGA's extended registers
; has already been set up (if required).
;
; Entry:		BL	- Index of start address low register
;			BH	- Bits 7-0 of new start address
;			CL	- Index of start address high register
;			CH	- Bits 15-8 of new start address
;			SI	- Bits 16+ for new start address
;
; Registers:	AX,BX,CX,DX,SI
;
;----------------------------------------------------------------------------

setpage	PROC	near

VGApage PROC near
	mov	dx,03D4h		; DX := CRTC I/O port (3D4h)
	mov	ah,bh
	mov	al,0dH
	out	dx,ax		; output low byte to index 0d
	mov	ah,ch
	mov	al,0cH
	out	dx,ax		; output low byte to index 0c
	mov	bx,si		; BX := Bits 16+ for start address
	ret
VGApage ENDP

NONE_page:
	call	VGApage
	ret

VESA_page:
	mov		cl,bh			; CX := Bits 15-0 of start address
	mov		ax,cx
	mov		dx,si			; DX:AX := start address
	div		[BytesPerLine]		; Divide by bytes per line value
	mov		cx,dx
	mov		dx,ax			; DX := starting scanline number
	mov		ax,4F07h		; Set display start service
	xor		bx,bx
	int		10h				; Set the display start address
	ret

ATI_page:
	call	VGApage
	mov		dx,1CEh
	mov		al,0B0h			; Index of start address register
	out		dx,al
	inc		dx
	in		al,dx			; Read old value
	and		al,3Fh			; Mask out old bits 7-6
	and		bl,3			; Mask out bottom two bits
	shl		bl,1			; Shift into position
	shl		bl,1
	shl		bl,1
	shl		bl,1
	shl		bl,1
	shl		bl,1
	or		al,bl			; Combine the values
	out		dx,al			; Output the result
	ret

AHEADB_page:
	call	VGApage
	mov		dx,03CEh
	mov		al,01Ch
	out		dx,al			; Index the start address register
	inc		dx
	in		al,dx			; Read current value
	and		al,0FCh			; Mask out old address values
	and		bl,3			; Mask out bottom two bits
	or		al,bl			; Or in the new start address
	out		dx,al			; Output the address
	ret

CHIPS_page:
	call	VGApage
	mov		dx,03D6h
	mov		al,0Ch
	mov		ah,bl
	out		dx,ax			; Set the extended start address
	mov		al,04h
	out		dx,al			; Index memory map register
	inc		dx
	in		al,dx			; Read register value
	or		al,4			; Set bit 2 for extended paging
	out		dx,al			; Set the value
	ret

PARADISE_page:
	call	VGApage
	mov		dx,03CEh
	mov		al,0Dh
	out		dx,al			; Index PR3 CRT Control register
	inc		dx
	in		al,dx			; Read current value
	and		al,0E7h			; Zero out bits 4-3
	and		bl,3			; Mask out bottom 2 bits
	shl		bl,1			; Shift into correct position
	shl		bl,1
	shl		bl,1
	or		al,bl			; Or in the new start address
	out		dx,al			; Output the address
	ret

TRIDENT88_page:
	call	VGApage
	mov		dx,3D4h			; DX := CRTC I/O port
	mov		al,01Eh
	out		dx,al			; Index module testing register
	inc		dx
	in		al,dx			; Read current value
	and		al,0DFh			; Mask out start address bit 5
	and		bl,1			; Only want one bit
	shl		bl,1			; Put into correct position
	shl		bl,1
	shl		bl,1
	shl		bl,1
	shl		bl,1
	or		al,bl           	; Or in the new start address
	or		al,80h			; Set bit 7 for enable bit 16
	out		dx,al			; Output the address
	ret

TRIDENT89_page:
	call	VGApage
	push	bx
	mov		dx,3D4h			; DX := CRTC I/O port
	mov		al,01Eh
	out		dx,al			; Index module testing register
	inc		dx
	in		al,dx			; Read current value
	and		al,05Fh			; Mask out start address
	and		bl,1			; Only want one bit
	shl		bl,1			; Put into correct position
	shl		bl,1
	shl		bl,1
	shl		bl,1
	shl		bl,1
	or		al,bl			; Or in new start address values
	or		al,80h			; Set bit 7 for enable bit 16
	out		dx,al			; Output the address
	mov		dx,3C4h
	mov		al,0Bh
	out		dx,al
	inc		dl
	xor		al,al
	out		dx,al			; Select old mode control registers
	dec		dl
	mov		al,0Eh			; Index old mode control register
	out		dx,al
	inc		dl
	in		al,dx			; Read old value
	and		al,0FEh         	; Mask out old value
	pop		bx
	shr		bl,1
	and		bl,1          		; Mask out only bit 17 of address
	or		al,bl           	; Combine with old value
	out		dx,al			; Output the address
	ret

VIDEO7_page:
	call	VGApage
	mov		dx,3C4h
	mov		al,0F6h
	out		dx,al			; Index extended start address
	inc		dx
	in		al,dx			; Read current value
	and		al,0CFh			; Zero out start address 17-16 bit 5-4
	and		bl,3			; Mask out all but bottom 2 bits
	shl		bl,1			; Shift left into correct position
	shl		bl,1
	shl		bl,1
	shl		bl,1
	or		al,bl			; Or in the new start address
	out		dx,al			; Output the address
	ret

ET3000_page:
	call	VGApage
	mov		dx,3D4h			; DX := CRTC I/O port
	mov		al,23h			; Index extended start address
	out		dx,al
	inc		dx
	in		al,dx			; Read current value
	and		al,0FDh			; Zero out start address
	and		bl,1			; Only one bit is valid
	shl		bl,1			; Put bit into correct pos.
	or		al,bl			; Or in the new start address
	out		dx,al			; Output the address
	ret

ET4000_page:
	call	VGApage
	mov		dx,3D4h			; DX := CRTC I/O port
	mov		al,33h         		; Index extended start address
	out		dx,al
	inc		dx
	in		al,dx			; Read current value
	and		al,0FCh			; Zero out start address
	and		bl,3          		; Mask out all but bottom 2 bits
	or		al,bl			; Or in new start address
	out		dx,al			; Output the address
	ret

NCR_page:
	call	VGApage
	mov		dx,3C4h
	mov		al,31h			; Index of start address register
	out		dx,al
	inc		dx
	in		al,dx			; Read old value
	and		al,0F0h			; Clear bottom four bits
	and		bl,0Fh			; Mask out bottom four bits
	or		al,bl
	out		dx,al			; Set the new value
	ret

S3_page:
	call	VGApage
	mov		bh,bl			; Save top 4 bits
	mov		dx,3D4h			; DX := CRTC I/O port
	mov		ax,4838h		; Enable extended registers
	out		dx,ax
	mov		al,31h			; Index of S3R1
	out		dx,al
	inc		dl
	in		al,dx			; Read old value of S3R1
	and		al,0CFh			; Mask off bits 5-4
	and		bl,3			; Mask off bottom two bits
	shl		bl,1			; Shift into bit pos 5-4
	shl		bl,1
	shl		bl,1
	shl		bl,1
	or		al,bl			; Or in starting address value
	out		dx,al			; Set the new value
	dec		dl
	cmp		VideoMem,1024
	jbe		@@S33			; Chip is a 911 or 924
	mov		ax,0A039h		; Unlock system control registers
	out		dx,ax
	mov		al,51h			; Index of CR51
	out		dx,al
	inc		dl
	in		al,dx			; Read value of CR51
	shr		bh,1
	shr		bh,1
	and		bh,3			; Mask of bottom two bits
	or		al,bh			; Or in top 2 bits of start address
	out		dx,al			; Write the value back again
	dec		dl
	mov		ax,0039h		; Lock system control registers
	out		dx,ax
@@S33:	mov		ax,0038h		; Disable extended registers
	out		dx,ax
	ret

P2000_page:
	call	VGApage
	mov		dx,3CEh
	mov		al,21h			; Index of start address register
	out		dx,al
	inc		dx
	in		al,dx			; Read old value
	and		al,0F8h			; Clear out bottom 3 bits
	and		bl,7			; Mask off bottom three bits
	or		al,bl			; Or in starting address value
	out		dx,al			; Set the new value
	ret

CIRRUS_page:
	call	VGApage
	mov		dx,3D4h			; DX := CRTC I/O port
	mov		al,1Bh			; Index of start address register
	out		dx,al
	inc		dx
	in		al,dx			; Read old value
	and		al,0FAh			; Clear out bits 0 and 2
	mov		bh,bl
	and		bh,2			; BH := bit 17 of start address
	shl		bh,1			; BH := bit 17 in bit pos 2
	and		bl,1			; BL := bit 16 of start address
	or		bl,bh			; BL := combined bit 16 and bit 17
	or		al,bl			; Or in starting address value
	out		dx,al			; Set the new value
	ret

setpage	ENDP
