;------------------------------ subs.asm -------------------------------------
;
; Some graphics routines I use regularly.
; The vga* routines take care of overlapping and also do dword operations 
; whenever possible. Don't worry, be happy.
;
; void far _SetCH (int ctype, int nbanks, int width);
; void far _SetPG (int page);
; void far _SetVS (long offset);
; void far _SetWM (int mode);
;
; void far _ILoop (int pva, int pdy, int pdx, int pdvx, int pdvy, int pcolor);
; void far _SLoop (int vaddr, int lcount, int incv, int color);
;
; void far movw (int length, int fbase, int from, int tbase, int to);
;
; void far vgaput (int to, int from, int fbase, int nbytes);
;
; void far vgaget (int to, int tbase, int from, int nbytes);
;
; void far vgamov (int to, int from, int nbytes);
;
; void far vgaset (int to, int color, int nbytes);
;
;-----------------------------------------------------------------------------

_TEXT	SEGMENT  BYTE PUBLIC 'CODE'
_TEXT	ENDS
_DATA	SEGMENT  WORD PUBLIC 'DATA'
_DATA	ENDS
CONST	SEGMENT  WORD PUBLIC 'CONST'
CONST	ENDS
_BSS	SEGMENT  WORD PUBLIC 'BSS'
_BSS	ENDS
DGROUP	GROUP	CONST,	_BSS,	_DATA
	ASSUME	CS: _TEXT, DS: DGROUP, SS: DGROUP, ES: DGROUP

VGASEG	EQU	0a000H

_DATA	SEGMENT
	EXTRN	__ReadPage:WORD
	EXTRN	__GrType:WORD
	EXTRN	__GrSizeX:WORD

CurBank		dw	0FFh		; Currently active read/write bank
BytesPerLine	dw	1
VesaGran	dw	1
VesaBank	dw	1
VideoMem	dw	256		; how much memory we have (in 1KB)

_DATA	ENDS
_TEXT	SEGMENT


	INCLUDE sv_pages.asm

	INCLUDE sv_banks.asm


;-----------------------------------------------------------------------------
;
; void far _SetCH (int ctype, int nbanks, int width);
;
;	Set the vga chip type.
;
;-----------------------------------------------------------------------------
	PUBLIC	__SetCH
__SetCH	PROC far

ctype	EQU	WORD PTR[BP+6]
cbanks	EQU	WORD PTR[BP+8]
cwidth	EQU	WORD PTR[BP+10]

	push	bp
	mov	bp,sp
	push	ax
	push	bx

	mov	bx,ctype
	cmp	bx,21
	jle	__SetC1
	mov	bx,0
__SetC1:
	add	bx,bx
	mov	ax,SVGA_page[bx]
	mov	chippage,ax
	mov	ax,SVGA_bank[bx]
	mov	chipbank,ax

	mov	ax,cbanks
	mov	VideoMem,ax

	mov	ax,cwidth
	mov	BytesPerLine,ax

	pop	bx
	pop	ax
	mov	sp,bp
	pop	bp
	ret

__SetCH	ENDP


;-----------------------------------------------------------------------------
;
; void far _SetPG (int page);
;
;	Set the vga active page.
;
;-----------------------------------------------------------------------------
	PUBLIC	__SetPG
__SetPG	PROC far
ppage	EQU	WORD PTR[BP+6]


	push	bp
	mov	bp,sp
	push	ax

	mov	ax,ppage
	call	setbank

	pop	ax
	mov	sp,bp
	pop	bp
	ret
__SetPG	ENDP


;-----------------------------------------------------------------------------
;
; void far _SetVS (long offset);
;
;	Set the vga visual start address.
;
;-----------------------------------------------------------------------------
	PUBLIC	__SetVS
__SetVS	PROC far

plow	EQU	WORD PTR[BP+6]
phigh	EQU	WORD PTR[BP+8]

	push	bp
	mov	bp,sp
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
;
	mov	cx,plow		; get low word
	mov	si,phigh	; get high word
	clc
	rcr	si,1
	rcr	cx,1
	clc
	rcr	si,1		; si has most sb
	rcr	cx,1		; ch has middle sb
	mov	bh,cl		; bh nad least sb
	pushf
	cli
	call	[chippage]
	popf
;
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	mov	sp,bp
	pop	bp
	ret
__SetVS	ENDP


;-----------------------------------------------------------------------------
;
; void far _SetWM (int mode);
;
;	Set write mode for ILoop/SLoop.
;
;-----------------------------------------------------------------------------
	PUBLIC	__SetWM
__SetWM	PROC far

pmode	EQU	WORD PTR[BP+6]

	push	bp
	mov	bp,sp

	mov	ax,pmode
	mov	al,088H			; mov
	test	ah,003H			; GrXOR|GrOR?
	jz	$xxsm2			; no, straight mov
	test	ah,001H			; GrXOR?
	jz	$xxsm1			; no, must be GrOR
	mov	al,030H			; xor
	jmp	SHORT $xxsm2
$xxsm1:
	mov	al,008H			; or
$xxsm2:
	mov	cs:BYTE PTR $cxxx0+1,al	; set opcode
	mov	cs:BYTE PTR $cxxx1+1,al
	mov	cs:BYTE PTR $cxxx2+1,al
	mov	cs:BYTE PTR $cxxx3+1,al

	mov	sp,bp
	pop	bp
	ret

__SetWM	ENDP


;-----------------------------------------------------------------------------
;
; void far _ILoop (int pva, int pdy, int pdx, int pdvx, int pdvy, int pcolor);
;
;	An implementation of Bresenham's algorithm with modifications.
;	Called from GrLine.c
;
;-----------------------------------------------------------------------------
	PUBLIC	__ILoop
__ILoop	PROC far

pva	EQU	WORD PTR[BP+6]		; si
pdy   	EQU	WORD PTR[BP+8]		; di
pdx 	EQU	WORD PTR[BP+10]		; cx (count)
pdvx  	EQU	WORD PTR[BP+12]		; dx
pdvy	EQU	WORD PTR[BP+14]		; immed
pcolor	EQU	WORD PTR[BP+16]		; ah
					; al = vga page
					; bx = err
; Modified instructions:
; x4		put constants in immediates
; x2-3,x5-6	customise page tracking
; xxx0		mov/xor/or color type (see __setWM)
;
; Note that here we do:	new_dx = 010000H
;			new_dy = dy*new_dx/dx
;
	push	bp
	mov	bp,sp
	push	di
	push	si
	push	es
;
	mov	cx,pdx			; count: Rcx
;	cmp	cx,16
;	ja	$ilong			; long  line
;	jmp	$zloop			; short line		386	486
$ilong:					;			===	===
	mov	dx,pdy			; dy*0x10000L		  4	  1
	xor	ax,ax			;			  2	  1
	div	cx			; new dy =dy*010000L/dx	 22	 24
	mov	di,ax			; new dy: Rdi		  2	  1
;								 ==	 ==
	mov	dx,pdvx			; dvx: Rdx		 30	 27
	or	dx,dx			; pdvx ?
	mov	bx,07204H		; jc:add
	jns	$posdvx
	mov	bx,0732cH		; jnc:sub
$posdvx:
	mov	cs:BYTE PTR $ilx2,bh	; set jc/jnc
	mov	cs:BYTE PTR $ilx3,bl	; set add/sub
;
	mov	ax,pdvy
	add	ax,dx
	mov	cs:WORD PTR $ilx4+2,ax	; dvy+dvx: Immed
;	or	ax,ax			; dvx+dvy ? (have flags from 'add')
	mov	bx,07304H		; jnc:add
	jns	$posdvy
	mov	bx,0722cH		; jc:sub
$posdvy:
	mov	cs:BYTE PTR $ilx5,bh	; set jc/jnc
	mov	cs:BYTE PTR $ilx6,bl	; set add/sub
;
	mov	ax,__ReadPage		; ppage: Ral
;
	mov	bx,pcolor
	mov	ah,bl			; color: Rah
;
	mov	bx,VGASEG
	mov	es,bx			; VGABASE: Res
;
	mov	bx,08000H		; err: Rbx
;
	mov	si,pva			; va: Rsi
;
	jmp	SHORT $ill0
;
; the main drawing loop (long line)
;
;								386	486
;								===	===
$ill3a:
	add	si,dx			; va += dvx		  2	  1
$ilx2:	jc	$ilp1			; if page crossing	  3/[7]	  1/[3]
$ilp1r:
$ill3:
$ilp2r:
$cxxx0:	mov	es:[si],ah		; vram = color (^=,|=)	4	2
$ill0:
	dec	cx			;			2	1
	js	$ilret			; if end of line	3/[7]	1/[3]
	add	bx,di			; err += dy		2	1
	jnc	$ill3a			; if err < dx		3/7	1/3
$ilx4:	add	si,01234H		; va += dvx+dvy		2	1
$ilx5:	jnc	$ill3			; if NO page crossing	7/[3]	3/[1]
;								=====	=====
;								23/23	10/10
$ilp2:
$ilx6:	add	al,001H			; ++ page (or --)
	call	setbank
	jmp	SHORT $ilp2r
$ilp1:
$ilx3:	add	al,001H			; ++ page (or --)
	call	setbank
	jmp	SHORT $ilp1r
;
$ilret:
	and	ax,000ffH		; save page
	mov	__ReadPage,ax
	mov	ax,si			; return va
	pop	es
	pop	si
	pop	di
	mov	sp,bp
	pop	bp
	ret
;
; Short line version.
;
$zloop:
	mov	ax,pdy			; 4  1 (old)
	mov	cs:WORD PTR $zlx8+2,ax	; 2  1 (old)	; dy: Immed
	mov	di,cx			; 2  1 (old)	; dx: Rdi
;					;== ==
;					; 8  3 (old)
;
	mov	dx,pdvx			; dvx: Rdx
	or	dx,dx			; pdvx ?
	mov	bx,07204H		; jc:add
	jns	$zlpdvx
	mov	bx,0732cH		; jnc:sub
$zlpdvx:
	mov	cs:BYTE PTR $zlx2,bh	; set jc/jnc
	mov	cs:BYTE PTR $zlx3,bl	; set add/sub
;
	mov	ax,pdvy
	add	ax,dx
	mov	cs:WORD PTR $zlx4+2,ax	; dvx+dvy: Immed
;	or	ax,ax			; pdvy ?
	mov	bx,07304H		; jnc:add
	jns	$zlpdvy
	mov	bx,0722cH		; jc:sub
$zlpdvy:
	mov	cs:BYTE PTR $zlx5,bh	; set jnc/jc
	mov	cs:BYTE PTR $zlx6,bl	; set add/sub
;
	mov	ax,__ReadPage		; ppage: Ral
;
	mov	bx,pcolor
	mov	ah,bl			; color: Rah
;
	mov	bx,VGASEG
	mov	es,bx			; VGABASE: Res
;
	mov	bx,cx
	sar	bx,1			; err: Rbx
;
	mov	si,pva			; va: Rsi
	jmp	SHORT $zll0
;
; the main drawing loop (short line)
;
;				  386  486
;				  ===  ===
$zll3a:
	add	si,dx		;   2    1	; va += dvx
$zlx2:	jc	$zlp1		;   3\7  1\3	; if page crossing
$zlp1r:
$zlp2r:
$zll3:
$cxxx3:	mov	es:[si],ah	; 4    2	; vram = color (or ^= or |=)
$zll0:
	dec	cx		; 2    1
	js	$ilret		; 3\7  1\3	; if end of line
$zlx8:	add	bx,01234H	; 2    1 	; err += dy
	cmp	bx,di		; 2    1 	; err : dx
	jl	$zll3a		; 3/7  1/3	; err < dx
	sub	bx,di		; 2    1	; err -= dx
$zlx4:	add	si,01234H	; 2    1	; va += dvx+dvy
$zlx5:	jnc	$zll3		; 7\3  3\1	; if no page crossing
;				;===== =====
;				;27/25 12/11	; total
$zlp2:
$zlx6:	add	al,001H				; ++ page (or --)
	call	setbank
	jmp	SHORT $zlp2r
$zlp1:
$zlx3:	add	al,001H				; ++ page (or --)
	call	setbank
	jmp	SHORT $zlp1r

__ILoop	ENDP


;-----------------------------------------------------------------------------
;
; void far _SLoop (int vaddr, int lcount, int incv, int color);
;
;	Used to draw simple lines (0 and 45 degrees in 4 quadrants).
;	Called from GrLine.c
;
;-----------------------------------------------------------------------------
	PUBLIC	__SLoop
__SLoop	PROC far

vaddr	EQU	WORD PTR[BP+6]		; es:si
lcount	EQU	WORD PTR[BP+8]		; dx
incv	EQU	WORD PTR[BP+10]		; cx
color	EQU	WORD PTR[BP+12]		; bx

	push	bp
	mov	bp,sp
	push	si
	push	es
;
	mov	ax,__ReadPage
	mov	bx,color		; color
	mov	cx,incv			; incv
	mov	dx,lcount		; lcount
	mov	si,VGASEG
	mov	es,si
	mov	si,vaddr		; vaddr
;
	dec	dx
	js	$slret			; nothing to do
;
	or	cx,cx			; incv ?
	js	$sldec			; decrementing
	jmp	SHORT $slinc		; incrementing
;
; the main drawing loop (incrementing)
;								386	486
$sll1:					;			===	===
$cxxx1:	mov	es:[si],bl		; vram = color (^=,|=)	4	2
	dec	dx			; --count		2	1
	js	$slret			;         < 0		3/[7]	1/[3]
$slinc:
	add	si,cx			; vaddr += incv		2	1
	jnc	$sll1			; vaddr out of page	7/[1]	3/[1]
;								=====	=====
;								18	8
	inc	al			; ++page
	call	setbank
	jmp	SHORT $sll1
;
; the main drawing loop (decrementing)
;
$sll2:
$cxxx2:	mov	es:[si],bl		; vram  = color (mov/xor/or)
	dec	dx			; --count
	js	$slret			;         < 0
$sldec:
	add	si,cx			; vaddr += incv
	jc	$sll2			; vaddr out of page
;
	dec	al			; --page
	call	setbank
	jmp	SHORT $sll2
;
;
$slret:
	and	ax,000ffH		; return page
	mov	__ReadPage,ax
	mov	ax,si			; return va
	pop	es
	pop	si
	mov	sp,bp
	pop	bp
	ret

__SLoop	ENDP


;-----------------------------------------------------------------------------
;
; void far movw (int length, int fbase, int from, int tbase, int to);
;
;	The subroutine will move length words from fbase:from to tbase:to.
;	Not used much (if at all).
;
;-----------------------------------------------------------------------------
	PUBLIC _movw
_movw	PROC  far

plength EQU	WORD PTR[BP+6]
pfbase	EQU	WORD PTR[BP+8]
pfrom	EQU	WORD PTR[BP+10]
ptbase	EQU	WORD PTR[BP+12]
pto	EQU	WORD PTR[BP+14]

	push	bp
	mov	bp,sp
	push	ds
	push	es
	push	si
	push	di
;
	mov	es,ptbase
	mov	di,pto
	mov	ds,pfbase
	mov	si,pfrom
	mov	cx,plength
;
	cld
	rep	movsw
;
	pop	di
	pop	si
	pop	es
	pop	ds
	pop	bp
	ret

_movw	ENDP


;-----------------------------------------------------------------------------
;
; void far vgaput (int to, int from, int fbase, int nbytes);
;
;    The subroutine will move 'nbytes' bytes from fbase:from to VGASEG:to
;
;-----------------------------------------------------------------------------
	PUBLIC _vgaput
_vgaput	PROC  far

pto	EQU	WORD PTR[BP+6]
pfrom	EQU	WORD PTR[BP+8]
pfbase	EQU	WORD PTR[BP+10]
plength EQU	WORD PTR[BP+12]

	push	bp
	mov	bp,sp
	push	ds
	push	es
	push	si
	push	di
;
	mov	ax,VGASEG
	mov	es,ax
	mov	di,pto
	mov	ds,pfbase
	mov	si,pfrom
	mov	bx,plength
;
	cld
	mov	cx,di
	and	cx,03H		; head size
	sub	bx,cx		; update length
	rep	movsb		; move head
	mov	cx,bx
	shr	cx,1
	shr	cx,1
;	rep	movsd		; move body
	DB	0F3H,066H,0A5H	; rep opsiz:movsd
	and	bx,03H		; tail length
	mov	cx,bx		; move tail
	rep	movsb
vgapret:
	pop	di
	pop	si
	pop	es
	pop	ds
	pop	bp
	ret

_vgaput	ENDP


;-----------------------------------------------------------------------------
;
; void far vgaget (int to, int tbase, int from, int nbytes);
;
;    The subroutine will move 'nbytes' bytes to tbase:to from VGASEG:from
;
;-----------------------------------------------------------------------------
	PUBLIC _vgaget
_vgaget	PROC  far

pto	EQU	WORD PTR[BP+6]
ptbase	EQU	WORD PTR[BP+8]
pfrom	EQU	WORD PTR[BP+10]
plength EQU	WORD PTR[BP+12]
;
	push	bp
	mov	bp,sp
	push	ds
	push	es
	push	si
	push	di
;
	mov	es,ptbase
	mov	di,pto
	mov	ax,VGASEG
	mov	ds,ax
	mov	si,pfrom
	mov	bx,plength
;
	cld
	mov	cx,si
	and	cx,03H		; head size
	sub	bx,cx		; update length
	rep	movsb		; move head
	mov	cx,bx
	shr	cx,1
	shr	cx,1
;	rep	movsd		; move body
	DB	0F3H,066H,0A5H	; rep opsiz:movsd
	and	bx,03H		; tail length
	mov	cx,bx		; move tail
	rep	movsb
vgagret:
	pop	di
	pop	si
	pop	es
	pop	ds
	pop	bp
	ret

_vgaget	ENDP


;-----------------------------------------------------------------------------
;
; void far vgamov (int to, int from, int nbytes);
;
;    The subroutine will move 'nbytes' bytes to VGASEG:to from VGASEG:from
;
;-----------------------------------------------------------------------------
	PUBLIC _vgamov
_vgamov	PROC  far

pto	EQU	WORD PTR[BP+6]
pfrom	EQU	WORD PTR[BP+8]
plength EQU	WORD PTR[BP+10]

	push	bp
	mov	bp,sp
	push	ds
	push	es
	push	si
	push	di
;
	mov	ax,VGASEG
	mov	es,ax
	mov	di,pto
	mov	ds,ax
	mov	si,pfrom
	mov	bx,plength
;
	mov	ax,si		; from
	sub	ax,di		; from - to
	cmp	ax,8		; (from-to) ? 8
	jl	movmr		;           >
;
	cld
	mov	cx,di
	and	cx,03H		; head size
	sub	bx,cx		; update length
	rep	movsb		; move head
	mov	cx,bx
	shr	cx,1
	shr	cx,1
;	rep	movsd		; move body
	DB	0F3H,066H,0A5H	; rep opsiz:movsd
	and	bx,03H		; tail length
	mov	cx,bx		; move tail
	rep	movsb
vgamret:
	pop	di
	pop	si
	pop	es
	pop	ds
	pop	bp
	ret
movmr:
	std
	add	si,bx		; point at last byte
	dec	si
	add	di,bx
	dec	di
;
	mov	cx,di
	and	cx,03H		; head size
	sub	bx,cx		; update length
	rep	movsb		; move head
	mov	cx,bx
	shr	cx,1
	shr	cx,1
	sub	si,3		; point at last dword
	sub	di,3
;	rep	movsd		; move body
	DB	0F3H,066H,0A5H	; rep opsiz:movsd
	and	bx,03H		; tail length
	add	si,3		; point at last byte
	add	di,3
	mov	cx,bx		; move tail
	rep	movsb
	jmp	vgamret

_vgamov	ENDP


;-----------------------------------------------------------------------------
;
; void far vgaset (int to, int color, int nbytes);
;
;    The subroutine will set 'nbytes' bytes at 'to' to 'color'
;    It respects the GrXOR/GrOR bits.
;
;-----------------------------------------------------------------------------
	PUBLIC _vgaset
_vgaset	PROC  far

pto	EQU	WORD PTR[BP+6]
pcolor	EQU	WORD PTR[BP+8]
plength EQU	WORD PTR[BP+10]

	push	bp
	mov	bp,sp
	push	es
	push	di
;
	mov	ax,VGASEG
	mov	es,ax
	mov	di,pto
	mov	bx,plength
	mov	ax,pcolor
	test	ah,003H		; GrXOR|GrOR?
	jnz	vgaset1		; yes
;
	mov	ah,al		; for word set
	cld
	mov	cx,di
	and	cx,01H		; head size
	sub	bx,cx		; update length
	rep	stosb		; set head
	mov	cx,bx
	shr	cx,1
	rep	stosw		; set body
	and	bx,01H		; tail length
	mov	cx,bx
	rep	stosb		; set tail
vgasret:
	pop	di
	pop	es
	pop	bp
	ret
;
vgaset1:
	test	ah,001H		; GrXOR?
	jnz	vgaxor		; yes
vgaor:
	mov	cx,di
	and	cx,01H		; head size
	jz	vgaor1
	or	es:[di],al	; set head
	inc	di		; advance
	dec	bx		; update length
vgaor1:
	mov	cx,bx
	shr	cx,1
	jz	vgaor3
	mov	ah,al		; for word set
vgaor2:
	or	es:[di],ax	; set body
	add	di,2		; advance
	dec	cx		; loop
	jnz	vgaor2
vgaor3:
	and	bx,01H		; tail length
	jz	vgasret
	or	es:[di],al	; set tail
	jmp	SHORT vgasret
;
vgaxor:
	mov	cx,di
	and	cx,01H		; head size
	jz	vgaxor1
	xor	es:[di],al	; set head
	inc	di		; advance
	dec	bx		; update length
vgaxor1:
	mov	cx,bx
	shr	cx,1
	jz	vgaxor3
	mov	ah,al		; for word set
vgaxor2:
	xor	es:[di],ax	; set body
	add	di,2		; advance
	dec	cx		; loop
	jnz	vgaxor2
vgaxor3:
	and	bx,01H		; tail length
	jz	vgasret
	xor	es:[di],al	; set tail
	jmp	SHORT vgasret

_vgaset	ENDP


_TEXT	ENDS
	END
