; TEXT.ASM Assembly routines for Color Graphics Adapter text printing.
;          Used by WRIMAGE.C and written by John W. Ratcliff
;          Copyright (c) 1987 Compute!

_TEXT   SEGMENT  BYTE PUBLIC 'CODE'
_TEXT   ENDS
CONST   SEGMENT  WORD PUBLIC 'CONST'
CONST   ENDS
_BSS    SEGMENT  WORD PUBLIC 'BSS'
_BSS    ENDS
_DATA   SEGMENT  WORD PUBLIC 'DATA'
_DATA   ENDS
DGROUP  GROUP   CONST,  _BSS,   _DATA
        ASSUME  CS: _TEXT, DS: DGROUP, SS: DGROUP, ES: DGROUP



_DATA   SEGMENT
_sec    db      0
_hsec   db      0
durat   dw      0
start   dw      0
x       db      0
y       db      0
x1      db      0
x2      db      0
y1      db      0
y2      db      0
col     db       0, 1, 9, 3, 11, 4, 12, 2, 10, 5, 13, 6, 14, 8, 7, 15
ytab    dw  0, 160, 320, 480, 640, 800, 960, 1120, 1280, 1440
        dw  1600, 1760, 1920, 2080, 2240, 2400, 2560, 2720, 2880, 3040
        dw  3200, 3360, 3520, 3680, 3840, 4000
_DATA   ENDS

        public  _tprint,_sec,_hsec,_setmode
        public  _getime,_keystat,_flushk,_cursoff
        public  _sound,_sound2

_TEXT   SEGMENT


_setmode proc   near
; This routine set the graphics mode as specified
; by the BIOS interrupt 10h function 0
; al contains the video mode
; Modes are as follows:
;  0    40x25   Black and White text
;  1    40x25   Color text
;  2    80x25   Black and White text
;  3    80x25   Color text
;  4    320x200 Color graphics
;  5    320x200 Black and White graphics
;  6    640x200 Black and White graphics
;  7            mono graphics
;  9    TANDY MODE GRAPHICS
;  13   320x200 16 color EGA graphics
;  14   640x200 16 color EGA graphics
;  16   640x350 16 color EGA graphics
        push    bp
        mov     bp,sp
        mov     ax,[bp+4]
        mov     ah,0
        int     10h
        pop     bp
        ret
_setmode endp

_sound   proc    near
; sound(tone,duration)
        push    bp
        mov     bp,sp
        mov     ax,[bp+6]
        mov     durat,ax
        mov     bx,[bp+4]
        mov     al,10110110b
        out     43h,al
        mov     ax,bx
        out     42h,al
        mov     al,ah
        out     42h,al
        in      al,61h
        or      al,3
        out     61h,al
        mov     bl,al
        mov     ah,00h
        int     1ah     ; get clock count
        mov     start,dx
snd0:   mov     ah,00
        int     1ah
        sub     dx,start
        cmp     dx,durat
        jl      snd0
        mov     al,bl
        and     al,0fch
        out     61h,al
        pop     bp
        ret
_sound   endp



_sound2  proc    near
; sound(tone,duration)
        push    bp
        mov     bp,sp
        mov     cx,[bp+6]
        mov     bx,[bp+4]
        call    _sounder
        pop     bp
        ret
_sound2  endp

_sounder proc    near
; bx register contains the tone
; cx contains the duration
        mov     al,10110110b
        out     43h,al
        mov     ax,bx
        out     42h,al
        mov     al,ah
        out     42h,al
        in      al,61h
        or      al,3
        out     61h,al
        mov     bl,al

snd20:  nop
        nop
        nop
        nop
        loop    snd20


        mov     al,bl
        and     al,0fch
        out     61h,al
        ret
_sounder endp


_tprint  proc    near

; This routine will cause a text print. the format of the call is
; as follows:
; tprint(x,y,l,bc,fc,text)

; x is the x location on the screen
; y is the y location on the screen
; l is the length to be output (padded on the right with spaces to length)
; is length is passed as zero then only the string will be output.
; bc is the background color 0-15
; fc is the foreground color 0-15
; text is the pointer to the text you wish to output.

        push    bp
        mov     bp,sp
        push    es
        mov     ax,0b800h
        mov     es,ax           ; es addresses the screen ram
        mov     ax,[bp+4]
        shl     ax,1            ; times two
        mov     bx,[bp+6]       ; get the y location
        shl     bx,1            ; times two for word boundaries
        mov     si,ytab[bx]             ; multiply by 160
        add     si,ax           ; now ax has offset into screen ram
        mov     cx,[bp+8]       ; cx contains the length
        mov     bx,[bp+10]      ; background color
        shl     bl,1
        shl     bl,1
        shl     bl,1
        shl     bl,1            ; moved to high nibble
        mov     ax,[bp+12]
        mov     bh,al           ; foreground color goes into bl
        or      bh,bl           ; now the atribute byte in in bl
        mov     di,[bp+14]      ; offset to text pointer in di
        mov     ch,0            ; counter for number of chars done
tp0:    mov     bl,ds:[di]      ; get character
        cmp     bl,0
        je      tpdn            ; text print finished
        mov     dx,03dah
rtr:    in      al,dx
        sar     al,1
        jc      rtr
rtr1:   in      al,dx
        sar     al,1
        jnc     rtr1
        mov     es:[si],bl
        inc     si
rtr0:   in      al,dx
        sar     al,1
        jc      rtr0
rtr2:   in      al,dx
        sar     al,1
        jnc     rtr2
        mov     es:[si],bh
        inc     si
        inc     di
        inc     ch
        jmp     tp0
tpdn:   cmp     ch,cl
        jge     tpdn0
        sub     cl,ch
        mov     ch,0
        mov     bl,20h

tpd:    mov     dx,03dah
rtr3:   in      al,dx
        sar     al,1
        jc      rtr3
rtr4:   in      al,dx
        sar     al,1
        jnc     rtr4
        mov     es:[si],bl
        inc     si
rtr5:   in      al,dx
        sar     al,1
        jc      rtr5
rtr6:   in      al,dx
        sar     al,1
        jnc     rtr6
        mov     es:[si],bh
        inc     si
        loop    tpd
tpdn0:  pop     es
        pop     bp
        ret

_tprint  endp


_flushk   proc    near
        mov     ah,0ch
        mov     al,0
        int     21h
        ret
_flushk   endp

_keystat proc    near
        mov     ah,0bh
        int     21h
        mov     ah,0
        ret
_keystat endp

_getime proc     near
        mov     ah,2ch
        int     21h
        mov     _sec,dh
        mov     _hsec,dl
        ret
_getime  endp

_cursoff proc    near
; Move the cursor to a position we have set to a background color of
; black during the game
        mov     ah,02h
        mov     dh,16h
        mov     dl,0
        mov     bh,0h
        int     10h
        ret
_cursoff endp

_TEXT   ENDS
        END
