/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 34                        
                                                                            
Demonstrates the use of the SoundBlaster routines in WGTSB.LIB.             
                                                                            
  PROJECT                                                             
 This program requires the files WGT4.LIB and WGTSB.LIB to be linked.       
                                                                            
  DATA FILES                                                          
 SOCIETY.CMF, CONHIT.VOC, BADGER.VOC, SBFMDRV.COM, CT-VOICE.DRV             
                                                                            
ͼ
*/
#include <conio.h>
#include <wgtsb.h>
#include <wgt4.h>


color pal[256];                 /* Our palette */

unsigned fmversion;             /* FM driver version number */
unsigned sbversion;             /* SB driver version number */

wgtsong song;                   /* Pointer to our music */
wgtvoice badger;                /* Pointers to sounds */
wgtvoice conanhit;

/* Returns 1 if user has clicked within defined region, 0 otherwise */
int hitbutton (int x, int y, int x2, int y2)
{
  if (but > 0)
    return ((mx >= x) && (mx <= x2) && (my >= y) && (my <= y2));
  else return 0;
}


void main(void)

{
  int ok;
  int speaker = 1;              /* Our speaker toggle starts at ON */

  sbintnum = 7;                 /* Change these if you need to */
  sbioaddr = 0x220;		/* set SB ports and interrupts */
  ok = wfindfm ();		/* init FM sound */
  if (ok == -1) 
  {
    printf("You must run SBFMDRV.COM before using this program!");
    exit(1);
  }
  ok = winitsb (sbintnum);      /* init digital sound */
  if (ok == -1) 
  {
    printf("CT-VOICE.DRV not found in directory!");
    exit(1);             /* could not load in CT-Voice driver from current 
	                    directory (or library file) */
  }
  if (ok == -2) 
  {
    printf("SB init error!");
    exit(1);
  }
  fmversion = wfmversion ();
  sbversion = wsbversion ();

  song = wloadcmf("society.cmf");       /* Load our music */
  badger = wloadvoc("badger.voc");      /* And sound effects */
  conanhit = wloadvoc("conhit.voc");

  vga256();                             /* Switch to graphics mode */
  wreadpalette (0, 255, pal);
  wsetrgb (253, 63, 63, 63, pal);       /* And set palette for buttons */
  wsetrgb (254, 40, 40, 40, pal);
  wsetrgb (255, 20, 20, 20, pal);
  wsetpalette (0, 255, pal);

  wtextcolor (15);                      /* Draw our user interface */
  wtexttransparent (TEXTFGBG);
  wtextbackground (254);
  wbutt (0, 0, 45, 10);
  wouttextxy (6, 2, NULL, "QUIT");
  wbutt (70, 0, 172, 10);
  wouttextxy (76, 2, NULL, "Play Sound 1");
  wbutt (180, 0, 285, 10);
  wouttextxy (186, 2, NULL, "Pause Sound");
  wbutt (70, 20, 172, 30);
  wouttextxy (76, 22, NULL, "Play Sound 2");
  wbutt (180, 20, 285, 30);
  wouttextxy (186, 22, NULL, "Resume Sound");
  wbutt (70, 50, 182, 60);
  wouttextxy (76, 52, NULL, "Play CMF Song");
  wbutt (70, 70, 182, 80);
  wouttextxy (76, 72, NULL, "Stop CMF Song");
  wbutt (190, 50, 305, 60);
  wouttextxy (196, 52, NULL, "Speed = 12000");
  wbutt (190, 70, 305, 80);
  wouttextxy (196, 72, NULL, "Speed =  5000");

  wbutt (0, 100, 200, 199);
  wgtprintf (6, 110, NULL, "FM Driver version: %u", fmversion);
  wgtprintf (6, 120, NULL, "SB Driver version: %u", sbversion);
  wouttextxy (6, 140, NULL, "FM Music status:");
  wouttextxy (6, 150, NULL, "Digital sound  :");

  wbutt (50, 170, 150, 180);
  wouttextxy (56, 172, NULL, "Speaker ON ");

  minit ();
  mon ();
  wfmreset ();

  do {
    if (hitbutton (70, 0, 172, 10))     /* Play sound 1 */
    {
      wstopvoc();
      wplayvoc(badger);
      noclick();
    } else
    if (hitbutton (70, 20, 172, 30))    /* Play sound 2 */
    {
      wstopvoc();
      wplayvoc(conanhit);
      noclick();
    } else
    if (hitbutton (180, 0, 285, 10))    /* Pause sound */
    {
      wpausevoc();
      noclick();
    } else
    if (hitbutton (180, 20, 285, 30))   /* Resume sound */
    {
      wresumevoc();
      noclick();
    } else
    if (hitbutton (70, 50, 182, 60))   /* Play CMF */
    {
      wfmstopmusic ();
      wplaycmf (song);
      noclick();
    } else
    if (hitbutton (70, 70, 182, 80))   /* Stop CMF */
    {
      wfmstopmusic ();
      noclick();
    } else
    if (hitbutton (50, 170, 150, 180)) /* Toggle Speaker */
    {
      speaker = !speaker;
      moff ();
      if (speaker)
        wouttextxy (56, 172, NULL, "Speaker ON ");
      else
        wouttextxy (56, 172, NULL, "Speaker OFF");
      mon ();
      wsetspeaker (speaker);
      noclick();
    } else
    if (hitbutton (190, 50, 305, 60))   /* Song tempo = 12000 */
    {
      wfmsongspeed (12000);
    } else
    if (hitbutton (190, 70, 305, 80))   /* Song tempo = 5000 */
    {
      wfmsongspeed (5000);
    }

    wgtprintf(142, 140, NULL, "%5i", fmstat);   /* Update status of sounds */
    wgtprintf(142, 150, NULL, "%5i", sbstat);

  } while ( (!kbhit ()) && (!hitbutton (0, 0, 45, 10) ) );

  while (kbhit ())
    getch();
  moff();
  mdeinit ();
  wfmstopmusic ();
  wfreecmf (song);
  wfreevoc (badger);
  wfreevoc (conanhit);
  wdeinitsb();	// deinit digital sound

  textmode (C80);
}