/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 12                        
                                                                            
Demonstrates mouse functions and msetbounds.                                
                                                                            
  PROJECT                                                             
 This program requires the file WGT4.LIB to be linked.          	     
                                                                            
  DATA FILES                                                          
 NONE                                                                       
                                                                            
ͼ
*/

#include <wgt4.h>

int px,py,pbut; 	/* Temporary variables for mouse information */
int ox,oy;
int oldmode;
	    
void main(void)
{
  if ( !vgadetected() )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit(0);
  }
  oldmode=wgetmode();
  vga256();

  wcls(0);
  minit();   /* Initialize mouse */
  mon();	   /* turn it on */

  wtextcolor(15);
  wtexttransparent(TEXTFGBG);

  msetbounds(50,50,270,150);
  /* Set new mouse boundaries */

  do {
  /* Note that WGT 4.0 will automatically update the mouse
     variables mx,my and but.  It is recommended you store them
     in an alternate set of variables where you require to read in
     the mouse position since the coordinates change continuously. */

    px=mx;
    py=my;
    pbut=but;  /* stores info into mx,my,but */

    wclip(0,0,319,199); /* Reset clipping so text will show */
    wgtprintf(0,0,NULL,"X: %i     Y: %i     Button: %i      ",px,py,pbut);
    wclip(50,50,270,150);

    /* Clip circles to same area to give the effect of a small screen. */

    if (pbut != 0) /* button pressed */
    {
      moff();				/* Remember to turn off the  */
      wsetcolor(my);			/* mouse cursors before drawing */
      wfill_circle(mx,my,30);		/* or the mouse shape will smear */
      mon();				/* on the screen. */
    }
  } while (!kbhit());
  getch();

  moff();
  wcls(0);
  mon();

  msetbounds(0,0,319,199);		/* Set new mouse boundaries */
  wclip(0,0,319,199); 			/* Reset clipping */

  do {
    px=mx;
    py=my;
    pbut=but;

    wgtprintf(0,0,NULL,"X: %i     Y: %i     Button: %i      ",px,py,pbut);

    if (pbut != 0) 	/* This will draw a continuous line while the
			   button is pressed. */
    {
      if (ox !=-1)
      {
	moff();
	wsetcolor(my);
	wline(ox,oy,px,py);
	mon();
      }
      ox=px;
      oy=py;
    }
    else { ox=-1; oy=-1; }   /* Set to impossible values */

  } while (!kbhit());
  getch();

  msetbounds(0,0,319,199);
  mdeinit ();                   /* Deinitialize the mouse handler */
  wsetmode(oldmode);
}