;ͻ
;                                                                           
;                Polygonfiller for Texturemapped polygons                   
;                                                                           
;          Draws a Texture-mapped polygon in Tweakedmode (320x200)          
;                                                                           
;                          Programmed by Fantom                             
;                                                                           
;                 (c) An Ultimate Brains Production (c)                     
;                                                                           
;                     Version 2.4 / 17.8.93 / 12.19                         
;                                                                           
;ͼ

;                       Texture Mapping
;                       ---------------

;        ͻ
;         UPPER 16BIT         LOWER 16BIT        
;͹  Inner: add ecx,eax
;  REG     HI WORD      HI BYTE      LO BYTE            adc ebx,ebp
;͹         adc bh,dl
;  EAX    X-INC LSW       ---          ---              mov dh,[ds:bx]
;͹         mov [es:di],dh
;  ECX    TXT-X LSW       ---       LOOPCOUNT           add di,80
;͹         loop Inner
;  EDX       ---      TEXTUREDATA     Y-INC    
;͹
;  EBP    Y-INC LSW   X-INC  SIGN     X-INC    
;͹
;  EBX    TXT-Y LSW    TEXTURE Y    TEXTURE X  
;ͼ

	Ideal
	model small
	P386

SC_INDEX                equ     03c4h   ;Sequence Controller Index
CRTC_INDEX              equ     03d4h   ;CRT Controller Index
MISC_OUTPUT             equ     03c2h   ;Miscellaneous Output register
SCREEN_SEG              equ     0a000h  ;segment of display memory in TweakM
SCREEN_WIDTH            equ     320
MAP_MASK                equ     2       ;Map Mask register index in SC
INPUT_STATUS_1          equ     03dah   ;Input Status 1 register
START_ADDRESS_HIGH      equ     0ch     ;bitmap start address high db
START_ADDRESS_LOW       equ     0dh     ;bitmap start address low db
Row                     =       0

;
	MACRO sini                              ;;eax=sin(ax)*32768
;

	and ax,255
	shl ax,1
	push bx
	mov bx,ax
	xor eax,eax
	mov ax,[sintable+bx]
	pop bx

	ENDM

;
	MACRO kosini                            ;;eax=cos(ax)*32768
;

	add ax,64
	and ax,255
	shl ax,1
	push bx
	mov bx,ax
	xor eax,eax
	mov ax,[sintable+bx]
	pop bx

	ENDM

;
	Segment Code 'Code'                 ;Ok... Let's code it!
;

	Assume cs:Code,ds:Data

Start:  call InitD                      ;Let's Init this crap!
	call Tweakon                    ;Tweaked mode ON
	call SetPalette                 ;Let's set the palette

Again:  call waitborder                 ;Here we just do a stupid
	call Rotate                     ;Loop.. Rotations, projections
	call Proj                       ;And stuff like that...
	call clean
	call Texture                    ;Let's Draw IT!
	call showp                      ;Change active window
	add [XRot+4],1                  ;Rotation of the next frame
	mov ah,0bh                      ;Do you wanna quit?
	int 21h
	cmp al,0ffh
	jne Again
	mov ah,7
	int 21h
	cmp al,1bh                      ;Yes you will! -> Stop
	je Stop
	jmp Again                       ;Until then ---> LOOOOOPPP
Stop:   mov ax,3                        ;Let's get the hell out of here
	int 10h
	mov ax,4c00h
	int 21h

;
	Proc Texture
;


	xor bx,bx                       ;Actually BX = PolNumber to be drawn!
	call TopLeft                    ;Find the upperleft corner
	call InitTex                    ;Init texture

FillL:  call FillIt                     ;Fill-loop... Fill the first V-line
	dec [Top]                       ;First Line done. Next TopEdge?
	jge NoSrcT                      ;If not -> NoSrcT
	call NewSTop                    ;Else get new SourceTopLine
	dec [Top]                       ;TopLineDX - 1
	jmp SkipST                      ;No advance for the first point
NoSrcT: mov eax,[SrcTXA]                ;Let's advance along the SrcTop
	mov ebx,[SrcTYA]                ;.....
	add [SrcTX],eax                 ;.....
	add [SrcTY],ebx                 ;.....
SkipST: dec [Bot]                       ;And let's do it on Bottom line too!
	jge NoSrcB                      ;This is the same thing as above..
	call NewSBot                    
	dec [Bot]
	jmp SkipSB
NoSrcB: mov eax,[SrcBXA]                ;Advance...
	mov ebx,[SrcBYA]
	add [SrcBX],eax
	add [SrcBY],ebx

SkipSB: inc [DestTX]                    ;Advance along DESTINATION..
	dec [DTop]                      ;Next DestTopLine?
	jge NoDTop                      ;If not -> NoDTop
	call NewTop                     ;Else get new DestinationTopLine
	jmp SkipDT                      ;No advance for the first point
NoDTop: mov eax,[DestTYA]               ;Advance...
	add [DestTY],eax

SkipDT: dec [DBot]                      ;Do the same thing as above...
	jge NoDBot
	call NewBot
	jmp SkipDB
NoDBot: mov eax,[DestBYA]
	add [DestBY],eax

SkipDB: dec [PolWidht]                  ;Is there any V-lines to draw?
	jge FillL                       ;If there is -> FillL
	ret                             ;That's all!

	ENDP

;
	Proc FillIt
;

	mov dx,SC_INDEX                 ;Let's prepare SC_INDEX
	mov al,MAP_MASK                 ;For the MAP_MASK
	out dx,al                       ;.....
	mov ax,[Word DestBY+2]          ;How many pixels to Draw?
	sub ax,[Word DestTY+2]          ;.....
	jl SkipIt                       ;If < 0 nothing to draw -> SkipIt
	inc ax                          ;Plus one
	mov [Dest],ax                   ;Dest = pixels to draw

	mov eax,[SrcTX]                 ;Initial start and end point
	mov edx,[SrcTY]                 ;for source line
	mov ebx,[SrcBX]
	mov ecx,[SrcBY]

	sub ebx,eax                     ;Calculate DX and DY
	sub ecx,edx
	mov eax,ebx
	mov bx,[Dest]                   ;Divide them by Dest
	movsx ebx,bx
	cdq
	idiv ebx
	mov [SXA],eax                   ;SourceX advance / dest. pixel
	mov eax,ecx
	cdq
	idiv ebx
	mov [SYA],eax                   ;SourceY advance / dest. pixel

	mov ax,SCREEN_SEG               ;Calculate Init Pixel on dest. 
	add ax,[PageOffset]             ;V-line
	mov es,ax                       ;.....
	mov bx,[Word DestTY+2]
	add bx,bx
	mov di,[Rows+bx]
	mov bx,[DestTX]
	mov cx,bx
	shr bx,2
	add di,bx
	and cx,3
	mov al,1
	shl al,cl
	mov dx,SC_INDEX+1               ;Don't forget the mask!
	out dx,al                       ;.....

	mov ebp,[SYA]                   ;Let's initialize registers
	rol ebp,16                      ;for InnerLoop...
	mov dx,bp                       ;BH = Src Y-coordinate
	mov eax,[SXA]                   ;BL = Src X-coordinate
	rol eax,16                      ;Notice!!:
	mov bp,ax                       ;---------
	xor ax,ax                       ;Source image is assumed to be
	mov ecx,[SrcTX]                 ;256-pixels wide. Therefore 
	rol ecx,16                      ;Indexing table with BX gives you
	mov ebx,[SrcTY]                 ;directly source pixel (BH,BL)!
	rol ebx,16                      ;.....
	mov bh,bl
	mov bl,cl

	mov cx,[Dest]                   ;Number of pixels to be drawn
	dec cx                          ;.....
	jz SkipIt                       ;.....

InnerL: add ecx,eax                     ;These are fixed-point calculations
	adc ebx,ebp                     ;Try to figure it out by yourself
	adc bh,dl                       ;There is a table in the beginning
	mov dh,[Tex+bx]                 ;of this file to determine the usage
	mov [es:di],dh                  ;of registers..
	add di,80                       ;Next Row..
	loop InnerL                     ;Continue until V-line is drawn
SkipIt: ret

	ENDP

;
	Proc InitTex
;

	mov ax,[TopP]                   ;Initialize Source and destination
	mov [CurTE],ax                  ;Lines
	mov [CurBE],ax                  ;CurTE = Current Topline End
	mov [CurSTE],ax                 ;CurSTE = Current Src Topline End
	mov [CurSBE],ax                 ;.....

	call NewTop                     ;Init...
	call NewBot
	call NewSTop
	call NewSBot
	ret

	ENDP

;
	Proc NewSTop
;

	mov ax,[NTop]                   ;DX of the new Dest. Topline
	mov [Top],ax                    ;Store it

	mov bx,[CurSTE]                 ;Current Src Top End

	add bx,bx                       ;BX = BX*2
	mov bx,[TPol+bx]                ;Get number of that point
	shl bx,2                        ;multiply by 4
	mov ax,[TPisteet+bx]            ;X-coordinate (TPisteet=TexturePoints)
	mov cx,[TPisteet+bx+2]          ;Y-coordinate

	mov bx,[CurSTS]                 ;Current Src Top Start
	add bx,bx                       ;...
	mov bx,[TPol+bx]
	shl bx,2
	sub ax,[TPisteet+bx]            ;Current Src Top DX
	sub cx,[TPisteet+bx+2]          ;Current Src Top DY

	mov dx,[TPisteet+bx]            ;Init point for source line
	mov bx,[TPisteet+bx+2]          ;.....
	shl ebx,16                      ;Make it fixed-point
	shl edx,16
	mov [SrcTX],edx                 ;Store!
	mov [SrcTY],ebx
	mov si,[Top]                    ;Divide Src Top DX and DY
	inc si                          ;by Destination line DX+1
	movsx esi,si                    ;....
	movsx eax,ax
	shl eax,16
	cdq
	idiv esi
	mov [SrcTXA],eax                ;SrcTopX Initpoint advance / V-line
	add [SrcTX],eax                 ;Add it on InitPointX

	movsx eax,cx                    
	shl eax,16
	cdq
	idiv esi
	mov [SrcTYA],eax                ;SrcTopY Initpoint advance / V-line
	add [SrcTY],eax                 ;Add it on InitpointY
	ret

	ENDP

;
	Proc NewSBot
;

	mov ax,[NBot]                   ;Exactly the same thing as above
	mov [Bot],ax                    ;But for Src Bottomline

	mov bx,[CurSBE]

	add bx,bx
	mov bx,[TPol+bx]
	shl bx,2
	mov ax,[TPisteet+bx]
	mov cx,[TPisteet+bx+2]

	mov bx,[CurSBS]
	add bx,bx
	mov bx,[TPol+bx]
	shl bx,2
	sub ax,[TPisteet+bx]
	sub cx,[TPisteet+bx+2]

	mov dx,[TPisteet+bx]
	mov bx,[TPisteet+bx+2]
	shl ebx,16
	shl edx,16
	mov [SrcBX],edx
	mov [SrcBY],ebx
	mov si,[Bot]
	inc si
	movsx esi,si
	movsx eax,ax
	shl eax,16
	cdq
	idiv esi
	mov [SrcBXA],eax
	add [SrcBX],eax

	movsx eax,cx
	shl eax,16
	cdq
	idiv esi
	mov [SrcBYA],eax
	add [SrcBY],eax
	ret

	ENDP

;
	Proc NewTop
;

NewT:   mov ax,[CurTE]                  ;Current TopLine endpoint
	mov [CurTS],ax                  ;Make it startpoint
	mov [CurSTS],ax                 ;For Source too
	mov bx,ax                       ;Let's take new endpoint
	inc bx                          ;we are moving clockwise on
	and bx,3                        ;polygons Vertexlist. There is
	mov [CurTE],bx                  ;always 4 points in a list..
	mov [CurSTE],bx                 ;(that should not be a constant..
					;maybe in the next version...)
	add bx,bx                       ;Init Dest Topline
	mov bx,[Pol+bx]                 ;You have seen this part of code
	shl bx,2                        ;Before...
	mov ax,[Pisteet+bx]
	mov cx,[Pisteet+bx+2]

	mov bx,[CurTS]
	add bx,bx
	mov bx,[Pol+bx]
	shl bx,2
	sub ax,[Pisteet+bx]             ;If DX = 0 let's have next Dest.
	jz NewT                         ;edgeline (there is no reason to 
	mov [DTop],ax                   ;scan vertical Edges) 
	jge NoNeg                       ;Let's fix it by one...
	sub ax,2                        ;i.e if DX < 0 -> minus 1
	neg [DTop]                      ;    if DX > 0 -> plus 1
NoNeg:  inc ax
	sub cx,[Pisteet+bx+2]           ;Same thing on DY
	jge NoNeg1
	sub cx,2
NoNeg1: inc cx

	mov bx,[Pisteet+bx+2]           ;New Destination Topline InitpointY
	shl ebx,16                      ;Make it fixed point
	mov [DestTY],ebx                ;Store

	mov si,[DTop]                   ;Let's calculate Dest Topline
	mov [NTop],si                   ;Advances..
	inc [NTop]

	movsx eax,cx
	add si,2
	movsx esi,si
	shl eax,16
	cdq
	idiv esi
	mov [DestTYA],eax               ;Here we have Dest Topline YAdvance
	bt eax,31                       ;Let's do some fixing if necessary
	jnc NoNeg2                      ;....
	add [DestTY],eax
	add [DestTY],10000h
NoNeg2: ret

	ENDP

;
	Proc NewBot
;

NewB:   mov ax,[CurBE]                  ;Guess what.... it's all above....
	mov [CurBS],ax
	mov [CurSBS],ax
	mov bx,ax
	dec bx
	and bx,3
	mov [CurBE],bx
	mov [CurSBE],bx

	add bx,bx
	mov bx,[Pol+bx]
	shl bx,2
	mov ax,[Pisteet+bx]
	mov cx,[Pisteet+bx+2]

	mov bx,[CurBS]
	add bx,bx
	mov bx,[Pol+bx]
	shl bx,2
	sub ax,[Pisteet+bx]
	jz NewB
	mov [DBot],ax
	jge NoNeg3
	sub ax,2
	neg [DBot]
NoNeg3: inc ax
	sub cx,[Pisteet+bx+2]
	jge NoNeg4
	sub cx,2
NoNeg4: inc cx

	mov bx,[Pisteet+bx+2]
	shl ebx,16
	mov [DestBY],ebx

	mov si,[DBot]
	mov [NBot],si
	inc [NBot]

	movsx eax,cx
	add si,2
	movsx esi,si
	shl eax,16
	cdq
	idiv esi
	mov [DestBYA],eax
	bt eax,31
	jnc NoNeg5
	add [DestBY],10000h
	ret
NoNeg5: add [DestBY],eax
	ret

	ENDP

;
	PROC TopLeft
;

	mov [Py],32767                  ;Here we just find out the
	mov [Px],32767                  ;upperleft point of the polygon
	mov [Sx],0                      ;SX = Biggest X

	mov ax,32767
	xor bx,bx
	xor si,si
	xor ecx,ecx
	mov di,[Poly+bx]
	mov cx,4
	mov [TopP],0
Poll:   push ecx
	mov cx,[ds:di]
	mov bx,[Pisteet+ecx*4]          ;Pisteet = Points 
	mov cx,[Pisteet+ecx*4+2]
	cmp bx,ax
	ja  Jatka2                      ;Jatka = Continue
	mov ax,bx
	mov [Px],bx
	jl  ThisOne
	cmp [Py],cx
	jle Jatka2
ThisOne:mov [Py],cx
	mov [TopP],si
Jatka2: cmp [Sx],bx
	ja Menoks                       ;Menoks = GO!
	mov [Sx],bx
Menoks: inc si
	add di,2
	pop ecx
	dec ecx
	jnz poll
	mov ax,[Sx]
	sub ax,[Px]                     ;PX = Smallest X
	inc ax
	mov [PolWidht],ax               ;Polygon widht in pixels
	mov ax,[Px]                     ;Let's start from the leftmost
	mov [DestTX],ax                 ;Coordinate
	ret

	ENDP

;
	PROC TweakOn
;

	mov     ax,13h                  ;Tweaked mode
	int     10h                     ;Let the BIOS set up an
	mov     dx,SC_INDEX             ;Ordinary 320x200 MCGA
	mov     ax,0604h                ;....
	out     dx,ax
	mov     dx,SC_INDEX
	mov     ax,0f02h
	out     dx,ax
	mov     ax,SCREEN_SEG
	mov     es,ax
	sub     di,di
	sub     ax,ax
	mov     cx,8000h
	rep     stosw
	mov     dx,CRTC_INDEX           ;Let's do some Tweaked things
	mov     ax,14h
	out     dx,ax
	mov     ax,0e317h
	out     dx,ax
	ret

	ENDP

;
	PROC InitD
;

	cld                             ;Just initialize registers...
	xor eax,eax
	xor ebx,ebx
	xor ecx,ecx
	xor edx,edx
	xor edi,edi
	xor esi,esi
	mov ax,Data
	mov ds,ax
	ret

	ENDP

;
	PROC SetPalette
;

	mov     si,Offset Pal           ;These palette routines
	mov     al,0                    ;Are originally programmed
	mov     dx,3c8h                 ;By Future Crew.. Thanx guys!
	out     dx,al                   ;Them appear in their demo
	mov     dx,3c9h                 ;Called Mental Surgery
	mov     cx,768                  ;       ______________
invid1: lodsb
	out     dx,al
	loop    invid1
	ret

	ENDP

;
	PROC WaitBorder
;

	push    ax
	push    dx
	mov     dx,3dah
wbr1:   in      al,dx
	test    al,8
	jnz     wbr1
wbr2:   in      al,dx
	test    al,8
	jz      wbr2
	pop     dx
	pop     ax
	ret

	ENDP

;
	PROC Rotate
;

	mov si,Offset Dpist             ;Let's rotate some coordinates 
	mov di,Offset Rotated
	mov cx,4                        ;Just four of them

	mov ax,[XRot]
	sini
	mov [KXSin],ax
	mov ax,[XRot]
	kosini
	mov [KXCos],ax
	mov ax,[XRot+2]
	sini
	mov [KYSin],ax
	mov ax,[XRot+2]
	kosini
	mov [KYCos],ax
	mov ax,[XRot+4]
	sini
	mov [KZSin],ax
	mov ax,[XRot+4]
	kosini
	mov [KZCos],ax

	mov ax,[KZCos]                  ;Calculate Transformation
	imul [KYCos]                    ;Matrix...
	mov bx,dx                       ;(Long lives Selfmodification)
	mov ax,[KZSin]
	imul [KXSin]
	shl dx,1
	mov ax,[KYSin]
	imul dx
	add bx,dx
	mov [Word @@A+1],bx

	mov ax,[KZSin]
	neg ax
	imul [KYCos]
	mov bx,dx
	mov ax,[KZCos]
	imul [KXSin]
	shl dx,1
	mov ax,[KYSin]
	imul dx
	add bx,dx
	mov [Word @@B+1],bx

	mov ax,[KXCos]
	imul [KYSin]
	mov [Word @@C+1],dx

	mov ax,[KZSin]
	imul [KXCos]
	mov [Word @@D+1],dx

	mov ax,[KZCos]
	imul [KXCos]
	mov [Word @@E+1],dx

	mov ax,[KXSin]
	neg ax
	sar ax,1
	mov [Word @@F+1],ax

	mov ax,[KZCos]
	neg ax
	imul [KYSin]
	mov bx,dx
	mov ax,[KZSin]
	imul [KXSin]
	shl dx,1
	mov ax,[KYCos]
	imul dx
	add bx,dx
	mov [Word @@G+1],bx

	mov ax,[KZSin]
	imul [KYSin]
	mov bx,dx
	mov ax,[KZCos]
	imul [KXSin]
	shl dx,1
	mov ax,[KYCos]
	imul dx
	add bx,dx
	mov [Word @@H+1],bx

	mov ax,[KXCos]
	imul [KYCos]
	mov [Word @@L+1],dx

RotL:

@@A:    mov ax,1234h
	imul [Word si]
	mov bx,dx
@@B:    mov ax,1234h
	imul [Word si+2]
	add bx,dx
@@C:    mov ax,1234h
	imul [Word si+4]
	add bx,dx
	shl bx,2
	mov [ds:di],bx

@@D:    mov ax,1234h
	imul [Word si]
	mov bx,dx
@@E:    mov ax,1234h
	imul [Word si+2]
	add bx,dx
@@F:    mov ax,1234h
	imul [Word si+4]
	add bx,dx
	shl bx,2
	mov [ds:di+2],bx

@@G:    mov ax,1234h
	imul [Word si]
	mov bx,dx
@@H:    mov ax,1234h
	imul [Word si+2]
	add bx,dx
@@L:    mov ax,1234h
	imul [Word si+4]
	add bx,dx
	shl bx,2
	mov [ds:di+4],bx

	add si,6
	add di,8
	dec cx
	jnz RotL
	ret

ENDP

;
	PROC Proj
;

	xor ecx,ecx                     ;And then...
	xor edi,edi                     ;Let's project them...

	mov cx,1
ML:     xor esi,esi
	push cx
	dec cx
	mov si,[ObjDot+ecx*2]
	mov cx,[si]
	cmp cx,0
	je  @@Next
	add si,2
ProL:   push cx
	mov cx,[ecx*2+esi-2]
	shl cx,2
	mov bp,cx
	add cx,cx
	mov bx,[Rotated+ecx+4]
	movsx ebx,bx
	add ebx,[KZ]
	add ebx,1024

	mov ax,[Rotated+ecx]
	cwde
	cdq
	shl eax,8
	idiv ebx
	mov dx,ax
	sar dx,2
	add ax,dx
	add ax,[XCenter]
	mov [Pisteet+bp],ax

	mov ax,[Rotated+ecx+2]
	cwde
	neg eax
	cdq
	shl eax,8
	idiv ebx
	add ax,[YCenter]
	mov [Pisteet+bp+2],ax

	pop cx
	dec cx
	jnz ProL
@@Next: pop cx
	dec cx
	jnz ML
	ret

	ENDP

;
	PROC Clean
;

	mov dx,SC_INDEX                 ;Vacuum suck!
	mov ax,0f02h                    ;Clear the passive screen
	out dx,ax
	mov ax,SCREEN_SEG
	add ax,[PageOffset]
	mov es,ax
	sub di,di
	sub eax,eax
	mov cx,4000
lop:    rep stosd
	ret

	ENDP

;
	PROC ShowP
;

	push    bx                      ;This is originally from
	push    cx                      ;XSHARP!!
	push    dx                      ;Little modifications done!
	push    ax

	mov     bl,START_ADDRESS_LOW
	mov     bh,[Byte ptr StartOffset]
	mov     cl,START_ADDRESS_HIGH
	mov     ch,[Byte ptr StartOffset+1]
	mov     dx,CRTC_INDEX
	mov     ax,bx
	out     dx,ax
	mov     ax,cx
	out     dx,ax

	cmp     [PageOffset],0
	jne     Page0
	mov     [PageOffset],1024
	mov     [StartOffset],16384
	pop     ax
	pop     dx
	pop     cx
	pop     bx
	ret

Page0:  mov     [PageOffset],0
	mov     [StartOffset],0
	pop     ax
	pop     dx
	pop     cx
	pop     bx
	ret

	ENDP

	ENDS

;
	Segment Data 'Data'
;



	Label Sintable Word

	include "sintable.inc"

	Label Tex Byte

	include "texture.inc"

	dw 256 DUP(0)

	Label Pal Byte

	include "textpal.inc"

KXSin   dw 0
KXCos   dw 0
KYSin   dw 0
KYCos   dw 0
KZSin   dw 0
KZCos   dw 0
XRot    dw 0,0,0
ObjDot  dw Point
Point   dw 4,0,1,2,3
XCenter dw 160
YCenter dw 100
KZ      dd 2300
StartOffset dw 0
PageOffset  dw 0
TopP    dw 0
CurTS   dw 0
CurTE   dw 0
CurBS   dw 0
CurBE   dw 0
CurSTS  dw 0
CurSTE  dw 0
CurSBS  dw 0
CurSBE  dw 0

SrcTX   dd 0
SrcTY   dd 0
SrcBX   dd 0
SrcBY   dd 0
SrcTXA  dd 0
SrcTYA  dd 0
SrcBXA  dd 0
SrcBYA  dd 0

SXA     dd 0
SYA     dd 0

DestTX  dw 0
DestTY  dd 0
DestBX  dd 0
DestBY  dd 0
DestTXA dd 0
DestTYA dd 0
DestBXA dd 0
DestBYA dd 0

DeltaX  dd 0
DeltaY  dd 0
x1      dw 0
x2      dw 0
y1      dw 0
y2      dw 0
Dest    dw 0
Py      dw 0
Px      dw 0
Sx      dw 0
Top     dw 0
Bot     dw 0
DTop    dw 0
DBot    dw 0
NTop    dw 0
NBot    dw 0
Count   dw 0

PolWidht dw 0
Color   db 0
Frames  dw 0
Taulukko dw 1000 DUP(0)

Dpist   dw -256*3,320*3,0,256*3,320*3,0,256*3,-320*3,0,-256*3,-320*3,0

Rotated dw 500 Dup(0)

LABEL   Rows Word

	Rept 200

	dw Row

	Row = Row+80

	EndM

Poly    dw polygon
polygon dw 0,1,2,3

pol     dw 0,1,2,3

Polyt   dw pol1

pol1    dw 4,0,0,1,2,3

Pisteet dw 500 DUP(0)

Tpol    dw 0,1,2,3

Tpisteet dw 0,0,63,0,63,63,0,63

	ENDS

	Stack 200h

	END start
	END


