typedef	long	time_t;			/* ugly! */

/*LINTLIBRARY*/

#include <stdio.h>
#include <types.h>
#include <task.h>
#include <q.h>
#include <netq.h>
#include <net.h>
#include <custom.h>
#include <netbuf.h>
#include <icmp.h>
#include <ip.h>
#include <timer.h>
#include <ntcp.h>
#include <ntcpblk.h>


#define	GETTIME		0x2c	/* PC-DOS -- for generating sockets */

char *NullStr = "";

/*  Copyright 1983 by the Massachusetts Institute of Technology  */
/*  Copyright 1984,1985 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */
#include	<notice.h>

/*
 * This TCP requires the UNIX tasking package to run.  It runs as two tasks:
 * TCPsend, which handles all data transmission, and TCPprocess, which
 * processes the incoming data from the circular buffer. The data is placed
 * in the circular buffer by tcp_rcv() which is upcalled from internet on an
 * arriving packet.  It now pays attention to the foreign window (and will
 * block the sending process when necessary), handles "dally" acking 
 * correctly, but needs a local flow-control method desparately.
 * Major rewrite spring '84 by Don Gillies.
 */

/* Process some received data for tcp. Upcall the data to the user and
 * ensure that the data will be properly ACKed
 */

tcp_process(con)
register TcpCon con; 
{	/* connection block; passed by task creation */

	STARTPROCESS;
	if (in_more(tcpfd)) tk_yield();	/* collect another pkt if we can */

	if((con->avail >= 0)) {
		tcp_upcall(con,TCPUC_SIZE); /* upcall at most UC_SIZE bytes */
	}
/*	else printf("TCPprocess awake with nothing to process!\n"); */
	ENDPROCESS;
}

static tcp_upcall(con,lth)	/* internal procedure */
register TcpCon con;
int	lth;			/* number of bytes we want to upcall */
{
	int	i;
	int	entry;		/* temp for sending bytes to client */
	int	first_offset;	/* first byte to upcall to user */
	int	last_offset;	/* last byte to upcall to user */
	int	size;		/* number of bytes in first upcall */
	int	choplth;	/* # of bytes we can upcall, considering: */
				/* lth, local window, con->avail */

	first_offset = 0;
	last_offset = con->avail; /* try to upcall everything */
	
	choplth = min(con->loc_win,lth);

	if (last_offset > choplth - 1) { /* chop short if we must */
		last_offset = choplth - 1;
		tk_wake(con->TCPprocess);	/* empty the rest later */
	}

#ifdef	DEBUG
	if (TCDBG)
		printf("Sending client %d bytes\n",last_offset-first_offset + 1);
#endif

	entry  = (con->taken + 1) & BUFMASK;

/*	This loop will upcall 1 character at a time	*/
/*	the last upcall gets the new window.		*/
/*	for(i=first_offset; i<last_offset ; i++)
		(*(con->tc_dispose))(con,con->circbuf+((entry+i)&BUFMASK), 1);

	if (i==last_offset) {			
		con->loc_win = (*(con->tc_dispose))(con,
					con->circbuf+((entry+i)&BUFMASK), 1);
	}
*/
	/* this upcall sends a chunk of data */
	/* it upcalls 2 chunks when the data wraps in circular buffer */
	/* first, compute bytes to upcall */
	size = last_offset + 1;
	if (entry + last_offset > BUFMASK) {
	    i = BUFSIZE - entry;	/* bytes to end of buffer */
	    (*(con->tc_dispose))(con,con->circbuf + entry,i);
	    entry = (entry + i) & BUFMASK;
	    size -= i;
	}
	con->loc_win = (*(con->tc_dispose))(con,con->circbuf+entry,size);

	first_offset = last_offset + 1;
	for(i = con->maxchunks; i >= 0; i--) {
		if(con->free[i]) {
			if(i == con->maxchunks) con->maxchunks--;
			continue;
		}
		con->first[i] -= first_offset;
		con->last[i]  -= first_offset;
	}
	con->taken = (con->taken + first_offset) & BUFMASK;
	con->avail -= first_offset;
	con->otp->tc_win	 = con->loc_win - con->avail - 1;
	(con->otp)->tc_ack	+= first_offset;
	tcpbrcv			+= first_offset;

	/* ack the packet if no one else will and it isn't the final TIMEWAIT packet */
	if (con->SendReason == NOREASON && con->conn_state != TIMEWAIT) {
	        /* dally if we are verging on silly window syndrome, or */
		/* if we have more packets to process (and can combine  */
		/* acks) */
		if (in_more(tcpfd) || con->otp->tc_win < con->loc_lowwater)
		    dally_ack(con);
		else tcp_sendack(con);
	}
}		

tcp_flush(con)	/* pushes all data to the user.  Used when we get a FIN */
register TcpCon con;
{
	while (con->avail >= 0)
	    tcp_upcall(con,TCPUC_SIZE);		/* upcall everything */
	tk_sleep(con->TCPprocess);		/* no need to upcall more */

}

/* The dally timer goes off a while after  we have data to ACK.  It calls
 * this procedure, which tries to send the ACK, in the hopes that some
 * user data has entered the ACK packet while we "dallyed".
 */
tcp_ack(con) 
register TcpCon con;
{
#ifdef DEBUG
	if (TCDBG) printf("delayed ACK waking up TCPsend\n");
#endif 
	tm_clear(con->tmack);
	tcp_sendack(con);	/* send at least an ack */
}

/* Just shift the data in a buffer, moving len bytes from from to to. */

shift(from, to, len)
register char *to;		/* destination */
register char *from;		/* source */
int len; 
{			/* length in bytes */
	if(len < 0) {
		printf("tcp: shift: bad arg--len < 0");
		return;
	}
	while(len--)
		*to++ = *from++;
}

/* Swap the bytes in a tcp packet. */

tcp_swab(pkt)
struct	tcp *pkt; 
{	/* ptr to tcp packet to be swapped */

	pkt->tc_srcp = swab(pkt->tc_srcp);
	pkt->tc_dstp = swab(pkt->tc_dstp);
	pkt->tc_seq  = lswap(pkt->tc_seq);
	pkt->tc_ack  = lswap(pkt->tc_ack);
	pkt->tc_win  = swab(pkt->tc_win);
	pkt->tc_urg  = swab(pkt->tc_urg);
}


/* 4 abstractions that make the TCP easy to use are:
 *				Wakes Send Task?     Blocks?	  Net Ascii?
 *    tprintf(con,char *format,...)   yes	  if buffer full    yes
 *    tputs(con,char *string)	      yes	  if buffer full    yes
MACRO tputc(con,char c)     	      no	  if buffer full    no
 *    trputc(con,char c)	      yes	  if buffer full    no
 * 
 * NOTE: none of these routines return a value.
 *
 */

tprintf(con, format, args)		/* printf onto the network */
register TcpCon con;
char *format;
int args;
{
	extern char *_sp;
	int store_string();
	char here[120];

	_sp = here;
	_format_string(store_string, NULL, &format);
	*_sp = '\0';
	tputs(con,here);
}

tputs(con,str)			/* puts a string onto network */
char	*str;
register TcpCon con; 
{	register char c;
	/* specify there's new data before buffer it -- in case we block */
	if (!(c = *str)) return;
	do {	if(c == '\n') tputc(con,'\r');
		tputc(con,c);
		if(c == '\r') tputc(con,'\0');
	} while (c = *++str);
	/* specify new data if we haven't already (in Tfixit) */
	if (con->SendReason < NEWDATA) tcp_newdata(con);
}
/* In a rather cryptic way, Tfixit readjusts pointers if a tputc fills the
 * current packet.  If con->blth < 0, then no bytes should have been written
 * and the pointer is backspaced.  In this case, FALSE is returned so that
 * the while loop will be retried (after the task block).  If con->blth
 * was zero, then the packet was perfectly filled, and TRUE is returned
 * because the last data byte was correctly placed in the packet.
 */
int Tfixit(con)
register TcpCon con;
{   int oldlth;
    oldlth = con->blth;
    if (con->blth < 0) con->bptr--;	/* was window zero "unwrite char" */
    else con->blth--;			/* make sure blth < 0 */
    /* blth < 0 signals to tcp_rcv that we've blocked */
    /* can't block without sending out the data */
    con->odlen = con->bptr - con->odp;
    if (con->SendReason < NEWDATA && con->odlen) tcp_newdata(con);
    tk_block();		/* when we unblock, the window should be recomputed */
    return (oldlth);	/* return false if the character was written */
}
/* OBSOLETE */
/* commented out
int tc_put(con,c)		
register TcpCon con;
char c;
{
	if(con->blk_inpt || con->odlen >= MAXBUF)  || 
	    (unsigned) con->odlen > con->frn_win) 
		return(1);
	(con->odp)[con->odlen++] = c;
	return(0);
}
*/

int trputc(con,c)
register TcpCon con;
char c;	 		/* character to send */
{	
	tcp_newdata(con);
	tputc(con,c);
}

/* Indicate the presence of urgent data.  Just sets the urgent pointer to
 * the current data length and wakes up the sender.
 */

tcp_urgent(con) 
register TcpCon con;
{
	(con->otp)->tc_urg = con->bptr - con->odp;
	(con->otp)->tc_furg = 1;
	tk_wake(con->TCPsend);
}

/* Initiate the TCP closing sequence.  This routine will return immediately;
 * when the close is complete the user close function will be called.
 */

tcp_close(con) register TcpCon con;
{	
	switch(con->conn_state) {
	case ESTAB:
	case SYNRCVD:	
		con->conn_state = FINSENT;
		break;
	case FINRCVD:	
		con->conn_state = R_AND_S;
		break;
	default: 	
		printf("TCP_CLOSE: already closed\n");
		return;
	}
	/* send the FIN packet */
	con->retry_time = CLORT;	/* set close retry time */
	con->otp->tc_fin = 1;
	con->blk_inpt	= BLOCKED;
	wind_recomp(con);		/* compute new window */
	tcp_newdata(con);
}

/* expedite (resend and push) a packet */
tcp_ex(con) register TcpCon con; 
{
	tk_wake(con->TCPsend);
	(con->otp)->tc_psh = 1;
	return;
}

/* Handle a timer upcall. */
tmhnd(con) register TcpCon con;
{ 
#ifdef DEBUG
	if (TCDBG) printf("Timed out waiting for ACK\n"); 
#endif
	tm_clear(con->tcptm);
	tk_wake(con->TCPsend);
}

/* Closes and resets whoever just talked to you with packet p */
tc_clrs(p, fhost)
PACKET p;
in_name fhost; 
{
	long ltemp;
	unsigned myport;
	register struct tcp *ptp;
	struct tcpph php;
	ptp = (struct tcp *)in_data(in_head(p));

	/* swap port numbers */
	myport = ptp->tc_dstp;
	ptp->tc_dstp = ptp->tc_srcp;
	ptp->tc_srcp = myport;

	/* fill in the rest of the header */
	ltemp = ptp->tc_seq;
	ptp->tc_seq = ptp->tc_ack;
	ptp->tc_ack = ltemp + ptp->tc_syn;	/* ack his syn */
	ptp->tc_thl = sizeof(struct tcp) >> 2;
	ptp->tc_uu1 = 0;
	ptp->tc_fin = 0;
	ptp->tc_syn = 0;
	ptp->tc_rst = 1;	/* The RESET bit */
	ptp->tc_psh = 1;
	ptp->tc_fack = 1;
	ptp->tc_furg = 0;
	ptp->tc_uu2 = 0;
	ptp->tc_win = 0;
	tcp_swab(ptp);

	/* Set up the tcp pseudo header */
	php.tp_src = in_mymach(fhost);
	php.tp_dst = fhost;
	php.tp_zero = 0;
	php.tp_pro = TCPPROT;
	php.tp_len = swab(sizeof(struct tcp));

	/* checksum the packet */
	ptp->tc_cksum = cksum(&php, sizeof(struct tcpph)>>1, 0);
	ptp->tc_cksum = ~cksum(ptp, sizeof(struct tcp)>>1, 0);

	in_write(tcpfd, p, sizeof(struct tcp), fhost);
}

/* the following 4 functions provide support so that 2 connections */
/* may never LISTEN to the same port nor OPEN on the same socket. */
unsigned tcp_gen_socket()	/* generates an unused socket # >= 1000 */
{	
	int i;  
	unsigned j;
	i = 0;
	if ((j = (unsigned)get_dosl(GETTIME)) < 1000) j += 1000;

	while(i < connects)
		if (j == conlist[i++]->srcport) { 
			j++; 
			i=0; 
		}
	return(j);
}

/* finds out if anyone is listening on a certain port.  Useful for creating
 * passive connections */
TcpCon tcp_is_port(port)
unsigned port;
{
	int i; 
	for (i = 0; i < connects; i++)
		if (conlist[i]->srcport==port &&
		    conlist[i]->conn_state == LISTEN) return(conlist[i]);
	return(0);
}

/* finds an active connection on the (port,fhost) socket, or rets 0 if none */
/* useful for creating active connections */
TcpCon tcp_is_socket(port,fhost)
unsigned port;
in_name	 fhost;
{
	int i;
	for (i = 0; i< connects; i++)
		if (conlist[i]->srcport == port && 
		    conlist[i]->fhost == fhost) return(conlist[i]);
	return(0);
}

/* finds a passive or active connection for local port, foreign port, foreign
 * host.  Useful for demuxing packets */
TcpCon tcp_resolve_con(LocPort,ForPort,ForHost)
unsigned LocPort,ForPort;
in_name	 ForHost;
{
	int i;
	register TcpCon con;
	for(con = conlist[i = 0]; i < connects ; con = conlist[++i]) {
		if (con->srcport == LocPort) {
			if ((con->fhost == ForHost && con->dstport == ForPort)
			    ||(con->conn_state == LISTEN)) {
#ifdef DEBUG
				if (TCDBG) printf("Found port %d\n",i);
#endif
				return(con);
			}
			/* Awesome hack:  while one host is opening on a   */
			/* listened socket, drop all other hosts' SYN pkts.*/
			/* this keeps the other hosts from being RESET by  */
			/* tcp_rcv, until the us_open upcall occurs.  If   */
			/* the client re-listens from that upcall, the     */
			/* socket will never be deaf to foreign hosts.	   */
			if (con->conn_state == SYNRCVD) {
				return((TcpCon) 1);	/* drop packet */
			}
		}
	}
	return(0);
}

#ifdef DEBUG
tcp_prpacket(tcphdr,dataptr,datalen)
register struct tcp *tcphdr;
char *dataptr;
int datalen;
{	printf("<FROM:%d>",tcphdr->tc_srcp);
	printf("<SEQ=%D>",tcphdr->tc_seq);
	if (tcphdr->tc_fack) printf("<ACK=%D>",tcphdr->tc_ack);
	printf("<CTL=%s%s%s%s>",tcphdr->tc_syn ? "SYN," : NullStr,
	tcphdr->tc_fin ? "FIN," : NullStr, tcphdr->tc_fack ? "FACK," :NullStr,
	tcphdr->tc_rst ? "RST," : NullStr);
	printf("<WIND=%d>",tcphdr->tc_win);
	printf("<DATA=%d>\n",datalen);
}
#endif

tcp_clean(con,status)	/* cleans up after a connection closes */
register TcpCon con;	/* may be called by send process, but not receive. */
int status;		/* tells the way it closed */
{
	register int i;
	task *victim;
	int	(*cloproc)();

	victim = con->TCPsend;	/* fiddle with these after deallocation */
	cloproc = con->tc_close;
	
	tk_kill(con->TCPprocess);
	pkt_free(con->opbi);	/* free the output packet */
	tm_clear(con->tmack);
	tm_free(con->tmack);	/* connection */
	tm_clear(con->tcptm);
	tm_free(con->tcptm);
	cfree((char *)con);	/* nuke connection block thoroughly. */
	for (i = 0;i < connects; i++) {	/* delete the entry from conlist */
		if (con == conlist[i]) {
			for(; i < connects; i++)
				conlist[i] = conlist[i + 1];
		}
	}
	connects--;
	(*cloproc)(con,status);	/* tell user it closed, and how */
	tk_kill(victim);
	return;
}

tcp_newdata(con)		/* makes sure data on net will be resent */
register TcpCon con;
{
#ifdef DEBUG
	if (TCDBG) printf("Waking send for new data %d %d\n",con->SendReason,con->TCPsend->ev_flg);
#endif
	con->SendReason = NEWDATA;
	tk_wake(con->TCPsend);
}

tcp_sendack(con)	/* makes sure an ack is being sent to the net */
register TcpCon con;
{
#ifdef DEBUG
	if (TCDBG) printf("Waking send for an ACK %d %d\n",con->SendReason,con->TCPsend->ev_flg);
#endif
	con->piggied = TRUE;
	if (con->SendReason < ONE_ACK) con->SendReason = ONE_ACK;
	tk_wake(con->TCPsend);
}

tcp_hush(con)
register TcpCon con;
{
#ifdef DEBUG
	if (TCDBG) printf("Hushing Timers\n");
#endif

	tm_clear(con->tcptm);
	tm_clear(con->tmack);
	con->SendReason = 0;
}

dally_ack(con)
register TcpCon con;
{	
	register int dally_time;
	dally_time = (int) (con->ack_time - cticks);
	if (con->SendReason < ONE_ACK) {
	    con->SendReason = ONE_ACK;
	    if (dally_time > 0) {
/*		printf("Set Dally timer for %d",dally_time); */
		tm_tset(dally_time, tcp_ack, (unsigned) con, con->tmack);
	    }
	    else tcp_sendack(con);
	}
}

tcp_timewait(con)	/* handles processing for pkt received in TIMEWAIT */
register TcpCon con;
{
	tcp_hush(con);
	con->SendReason = TIME_WAIT;
	tk_sleep(con->TCPsend);
	con->retry_time = TW_TIME;
#ifdef DEBUG
	if (TCDBG) printf("Setting ack timer for TIMEWAIT %d\n",con->SendReason);
#endif
	tm_clear(con->tcptm);
	tm_tset(con->retry_time,tmhnd,(unsigned) con,con->tcptm);
}


int *tc_errmsg()
{
	printf("TCP_GETU: user field was unitialized\n");
	return(NULL);
}
