/* Copyright 1984 by the Massachusetts Institute of Technology  */

#define MAXBUF	    512		/* maximum output buffer size, - 1 */
#define BUFSIZE 512
#define BUFMASK (BUFSIZE-1)
#define TOTALCHUNKS 4
#define TCPUC_SIZE 32

typedef struct {		/* State information for a TCP connection */
	int	conn_state;	/* connection state */
	in_name fhost;		/* foreign host */
	unsigned dstport;	/* destination ports */
	unsigned srcport;	/* source port */
	PACKET	opbi;		/* ptr to output packet buffer */
	struct	tcp *otp;	/* ptr to output pkt tcp hdr */
	char	*odp;		/* ptr to start of output packet data */
	char	*bptr;		/* ptr to first empty byte there */
	int	odlen;		/* bytes of data in output packet */
	int	blth;		/* bytes user can place in outgoing packet */
	unsigned frn_win;	/* size of foreign window */
	unsigned loc_win;	/* local window sizes */
	unsigned loc_lowwater;

	timer	*tcptm;		/* The tcp timer */
	timer	*tmack;		/* ack tmr: delays acks hoping for new data */
	long	ack_time;	/* When last ACK was sent.  */
	int	retry_time;	/* retransmission timeout (tcptm ticks)*/
	int	ack_dally;	/* pause between receptions and acks */
	int	piggied;	/* set when ack is piggbacked */
	int	tw_to_live;	/* See below: Max # of pkts to send in timewait*/

	int	SendReason;	/* set when there's a packet to send, or in timewait */
	int	blk_inpt;	/* prevents/blocks new sends after close req*/

	struct	tcpph ophp;	/* tcp psuedo hdr for cksum calc */

	task	*TCPsend;	/* the two processes used by TCP */

	int	(*tc_open)();	/* called to signal open channel */
	int	(*tc_timeout)();/* called on initial/resend tmo */
	int	(*tc_dispose)();/* called to send user the data */
	int	(*tc_buff)();	/* called when TCP will accept more data */
	int	(*tc_fclose)();	/* called when foreign host wants to close */
	int	(*tc_close)();	/* called when both sides have closed */

	int	*ufield;	/* user defined data field */
	int	usafe;		/* to detect unitialized user fields */

/* begin random additions */
	int	avail;
	int	taken;
	int	numchunks, maxchunks, lastchunk;
	int 	first[TOTALCHUNKS];
	int 	last[TOTALCHUNKS];
	int 	free[TOTALCHUNKS];
	char	circbuf[BUFSIZE];
	task	*TCPprocess;
/* end random additions */
	}  tcp_con, *TcpCon;

/* Timer Timeouts.  These can vastly affect the performance of TCP */
/* INITRT: long so that no extra SYN destroys the opening */
/* CONNRT: short so that dropped packets are soon rexmitted */
/*  CLORT: long because some TCP's (vax) don't wait in the timewait state */
/*	    -- so multiple FIN's might prompt the foreign host to reset */
/* TW_TIME: long so we can respond to a foreign rexmit before closing*/
/* ACKDALLY: short for TELNET, zero for PC-PC telnet sending bulk data */

#define	INITRT		4 * TPS	/* retry time(secs)--initial request */
#define CONNRT		2 * TPS	/* retry time(secs)--after connected*/
#define CLORT		4 * TPS	/* retry time(secs)--when closing */
#define TW_TIME		8 * TPS	/* timewait close time(secs) */

#define ACKDALLY	7	/* delay from rcv->pkt to send->ack */

/* A bug in TCP is that two TCP's can simultaneously close, both reach */
/* TIMEWAIT, and a single leftover packet can then cause a deadlock of acks */
/* to go flying from both sides.  TW_MAX limits the number of ACKS that */
/* can be sent out. */
#define	TW_PKTS		3	/* max # of addt'l timewait pkts to send */

#define	TCPSTACK	500	/* tcp tasks stack sizes(bytes) */
#define	TCPWINDOW	1000	/* normal advertised window */
#define	TCPLOWIND	500	/* low water mark on window */

#define MAXCONS		7	/* maximum # of simultaneous connections */

#ifndef	TRUE			/* makes lint happy */
#define	TRUE		1
#define	FALSE		0
#endif


#define	TCDBG	(TPTRACE & NDEBUG)

int		tmhnd(), tcp_ack(), tcp_send(), tcp_rcv();
unsigned	tcp_gen_socket();
TcpCon		tcp_is_socket(), tcp_open(), tcp_find_passive(),
		tcp_is_port(), tcp_listen(), tcp_resolve_con();
in_name		in_mymach();
int		*tc_errmsg();

extern	unsigned	tcppsnt;	/* number of packets sent */
extern	unsigned	tcpprcv;	/* number of packets received */
extern	unsigned	tcpbsnt;	/* number of bytes sent */
extern	unsigned	tcpbrcv;	/* number of bytes received */
extern	unsigned	tcprack;	/* # of bytes received and acked */
extern	unsigned	tcpsock;	/* # of packets not for my socket */
extern	unsigned	tcpresend;	/* # of resent packets */
extern	unsigned	tcprercv;	/* # of old packets received */
extern	unsigned	bd_chk;		/* # of pkts with bad checksums */
extern	unsigned	ign_win;	/* # of pkts that ignore our window */

extern	IPCONN	tcpfd;			/* con ID for calling internet */

extern	int	connects;		/* number of connections */
extern	long	cticks;			/* clock ticks variable */
extern  long	get_dosl();		/* calls dos function */
extern  unsigned get_ds();		/* gets DS register value */

extern	TcpCon conlist[];		/* table of ptrs to connection blks */
extern	struct	tcpph	iphp;		/* incoming pseudohdr for cksum calc */

#define	OutOfBounds(x,y,z)	(x < y | x > z)

#define	DebWG	2				/* debugging flag */

#define	tcp_fhost(xxx)	(xxx->fhost)	/* tells who you're talking to */


/* When TCPSTUB is defined and test.b loaded, you can test TCP by
 * hand, interactively simulating the foreign host.
 */

#ifdef	TCPSTUB
#undef	in_data
#undef	in_head
#define	in_data(xxx)	xxx
#define	in_head(xxx)	xxx
#define	in_more(xx)	FALSE
#define	in_free(xyz)	3
#define in_open(x,y)	(IPCONN) TRUE
#define	in_mymach(x)	0x26001A12
#define in_init()	In_init()
#define in_write(x,y,z,p)	In_write(x,y,z,p)
#define in_alloc(x,y)	In_alloc(x,y)
#define tm_tset(x,y,z,q) printf("set tmr %d to %d\n",z,x)
PACKET	In_alloc();

#endif

#define	STARTPROCESS	while(1) {		/* start a process */
#define ENDPROCESS	tk_block();}		/* ends a process */

/* prioritized reasons for waking send task */
#define	NOREASON	0	/* reasons for invoking a packet send */
#define	TIME_WAIT	1	/* timer used for timewait timeout */ 
#define	ONE_ACK		2	/* only send packet once */
#define	NEWDATA		3	/* do resends of the packet */
#define TIMELIMIT	8 + NEWDATA	/* when rexmit timeouts are serious */
					/* enough to upcall the user */

#define tc_put(Con,C)		(*Con->bptr++ = C, --Con->blth)
#define tputc(Con,C)		while(tc_put(Con,C)<=0 && Tfixit(Con))
/* always transmit at least 1 byte so if the foreign window closes, we */
/* we continue to get window updates when it opens up */
#define wind_recomp(Con)	Con->blth = Con->blk_inpt & (min(Con->frn_win,MAXBUF) - Con->odlen)

#define	BLOCKED		0		/* constants values for blk_inpt */
#define UNBLOCKED	0177777

/* type safe user functions.  They may be inefficient, but finding */
/* this kind of bug is a bitch + 2 (I had to once) */
#define tcp_setu(xx,yy)	(xx->usafe = TRUE,xx->ufield= (int *) yy)
#define tcp_getu(xx)	(xx->usafe ? xx->ufield : (int *)tc_errmsg())
#define tcp_is_open(xx) (xx->conn_state == ESTAB | xx->conn_state == FINRCVD)
#define tcp_new_wind(con,x) {int twin;					\
			con->loc_win = x;				\
			twin = con->loc_win - (con->avail + 1);		\
			if (twin != con->otp->tc_win) {			\
				con->otp->tc_win = twin;		\
			    	tcp_sendack(con);			\
			}}			

