;=============================================================================
; rplasma - Runtime real plasma clouds demo.
;                                                   File created: 9-28-93
; Copyright (C) 1993, Carlos Hasan                 Last modified: 9-28-93
;
; Description:
;   This file implements a runtime real plasma using sinus overlapping
;   waves at random speeds using the VGA 320x400x256 mode. Based on the
;   Vangelis Plasma demo code.
;
; Portability:
;  Requires Turbo Assembler 3.2 or better to be assembler.
;  Dependent on the IBM PC 286 and the VGA graphics card.
;=============================================================================

                .model  small,pascal
                .286

                global  SinusPlasma:proc

;======================= Demo equates and data ===============================

TIMEOUT         equ     70 * 6                  ; 6 secs for timeout.

                .data

                include sintable.inc            ; sinus table.

Palette         db      768 dup (?)             ; plasma palette.
FadePalette     db      768 dup (?)             ; faded palette.
WavHPos1        db      ?                       ; wave horizontal and
WavHPos2        db      ?                       ; vertical positions
WavVPos1        db      ?                       ; and increments.
WavVPos2        db      ?
WavHAdd1        db      ?                       ; WARNING: the four waves
WavHAdd2        db      ?                       ;  positions must be at
WavVAdd1        db      ?                       ;  consecutive addresses.
WavVAdd2        db      ?
Fade            db      ?                       ; fade level.
Esckey          db      ?                       ; true if key pressed.
Timer           dw      ?                       ; timer counter.

;======================= Demo routines =======================================

                .code

;-----------------------------------------------------------------------------
; SetPalette - set the 256 entries of the VGA color palette.
; In:
;   DS:SI - Palette structure address.
;-----------------------------------------------------------------------------

SetPalette      proc near

                mov     cx,768
                mov     dx,3C8h
                xor     al,al
                out     dx,al
                mov     dx,3DAh
WaitVRT:        in      al,dx
                test    al,8
                jz      WaitVRT
                mov     dx,3C9h
                rep     outsb
WaitVRTE:       in      al,dx
                test    al,8
                jnz     WaitVRTE
                ret

SetPalette      endp

;-----------------------------------------------------------------------------
; SinusPlasma - Performs the demonstration.
; In:
;   DS - Data segment.
;-----------------------------------------------------------------------------

SinusPlasma     proc

                pusha
                push    ds
                push    es

                mov     ax,0013h                ; set 320x200x256 mode.
                int     10h

                mov     ax,ds                   ; set black palette.
                mov     es,ax
                lea     di,[FadePalette]
                mov     cx,768
                xor     ax,ax
                cld
                rep     stosb
                lea     si,[FadePalette]
                call    SetPalette

                mov     dx,3C4h                 ; setup VGA tricky
                mov     ax,0604h                ; 320x400x256 mode.
                out     dx,ax
                mov     ax,0F02h                ; enable 4-planes.
                out     dx,ax
                mov     dx,3D4h                 ; disable dword mode
                mov     ax,0014h
                out     dx,ax
                mov     ax,0E317h               ; enable byte mode
                out     dx,ax
                mov     ax,0009h                ; dup each scan 1 times
                out     dx,ax

                mov     ax,0A000h
                mov     es,ax
                xor     di,di
                mov     cx,8000h                ; clear video memory.
                xor     ax,ax
                cld
                rep     stosw

                mov     [Fade],0                ; setup variables.
                mov     [EscKey],0
                mov     [Timer],0

                mov     [WavHPos1],0            ; setup wave parameters.
                mov     [WavHPos2],0
                mov     [WavVPos1],0
                mov     [WavVPos2],0
                mov     [WavHAdd1],2
                mov     [WavHAdd2],1
                mov     [WavVAdd1],3
                mov     [WavVAdd2],4

GenPalette:     lea     di,[Palette]            ; generation of the
                xor     al,al                   ; plasma palette.
                mov     [di+0],al
                mov     [di+1],al
                mov     [di+2],al
                add     di,3
                mov     cx,1
GP0:            mov     al,63
                mov     ah,cl
                mov     bl,al
                sub     bl,cl
                mov     [di+0],al
                mov     [di+1],ah
                mov     [di+2],bl
                add     di,3
                inc     cx
                cmp     cx,64
                jb      Gp0

                xor     cx,cx
Gp1:            mov     al,63
                sub     al,cl
                mov     ah,63
                mov     bl,cl
                mov     [di+0],al
                mov     [di+1],ah
                mov     [di+2],bl
                add     di,3
                inc     cx
                cmp     cx,64
                jb      Gp1

                xor     cx,cx
Gp2:            mov     al,0
                mov     ah,63
                sub     ah,cl
                mov     bl,63
                mov     [di+0],al
                mov     [di+1],ah
                mov     [di+2],bl
                add     di,3
                inc     cx
                cmp     cx,64
                jb      Gp2

                xor     cx,cx
Gp3:            mov     al,cl
                mov     ah,0
                mov     bl,63
                mov     [di+0],al
                mov     [di+1],ah
                mov     [di+2],bl
                add     di,3
                inc     cx
                cmp     cx,64
                jb      Gp3

PlasmaLoop:     cmp     [EscKey],0              ; change fade level.
                jne     FadeOut
FadeIn:         mov     bl,[Fade]
                cmp     bl,64
                jae     SkipFade
                inc     [Fade]
                jmp     FadeInOut
FadeOut:        mov     bl,[Fade]
                cmp     bl,0
                jbe     FadeInOut
                dec     [Fade]

FadeInOut:      lea     si,[Palette]            ; set faded palette.
                lea     di,[FadePalette]
                mov     cx,768
                mov     ax,ds
                mov     es,ax
                cld
FadeLoop:       lodsb
                mul     bl
                shr     ax,6
                stosb
                loop    FadeLoop

SkipFade:       lea     si,[FadePalette]
                call    SetPalette

                mov     ax,0A000h
                mov     es,ax

                lea     si,[SinusTable]

                mov     di,80*100+10            ; top left corner.

                mov     ah,100                  ; 100 lines.
                mov     cl,[WavVPos1]
                mov     ch,[WavVPos2]
VertLoop:       push    ax
                mov     ah,60                   ; 60 columns.
                mov     dl,[WavHPos1]
                mov     dh,[WavHPos2]
HorizLoop:      mov     bx,bp                   ; get random value.
                mov     al,bl
                xor     bh,bh
                mov     bl,dl
                add     al,[bx+si]
                mov     bl,dh
                add     al,[bx+si]
                mov     bl,cl
                add     al,[bx+si]
                mov     bl,ch
                add     al,[bx+si]
                or      al,1
                stosb
                add     dl,1
                add     dh,3
                dec     ah
                jne     HorizLoop
                add     di,80+20                ; skip scan line.
                add     cl,7
                add     ch,3
                pop     ax
                dec     ah
                jne     VertLoop                ; next plasma line.

                inc     bp                      ; get random value.
                mov     bx,bp
                xor     bl,bh
                xor     bl,[di-1]
                xor     bl,cl
                xor     bl,dl
                add     bl,ch
                add     bl,dh

                test    bl,8                    ; change waves speed.
                jne     SpeedDown
SpeedUp:        and     bx,3
                cmp     [WavHAdd1+bx],+7
                jg      ChangePos
                inc     [WavHAdd1+bx]
                jmp     ChangePos
SpeedDown:      and     bx,3
                cmp     [WavHAdd1+bx],-7
                jl      ChangePos
                dec     [WavHAdd1+bx]

ChangePos:      mov     al,[WavHAdd1]           ; change waves positions.
                add     [WavHPos1],al
                mov     al,[WavHAdd2]
                add     [WavHPos2],al
                mov     al,[WavVAdd1]
                add     [WavVPos1],al
                mov     al,[WavVAdd2]
                add     [WavVPos2],al

                mov     ah,1                    ; if any key pressed,
                int     16h
                jz      CheckTimer
                mov     ah,0
                int     16h
                jmp     BeginFadeOut

CheckTimer:     inc     [Timer]                 ; or timeout,
                cmp     [Timer],TIMEOUT
                jb      CheckExit

BeginFadeOut:   inc     [EscKey]                ; then fade-out and exit.

CheckExit:      cmp     [Fade],0
                je      PlasmaExit
                jmp     PlasmaLoop

PlasmaExit:     mov     ax,0003h
                int     10h

                pop     es
                pop     ds
                popa
                ret

SinusPlasma     endp

                end
