VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsRegistry"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Type SECURITY_ATTRIBUTES
    nLength              As Long
    lpSecurityDescriptor As Long
    bInheritHandle       As Boolean
End Type

Private Const MAX_SIZE = 2048
Private Const MAX_INISIZE = 8192

' Constants for Registry top-level keys
Public Enum RegistryHive
    HKEY_CURRENT_USER = &H80000001
    HKEY_LOCAL_MACHINE = &H80000002
    HKEY_USERS = &H80000003
    HKEY_DYN_DATA = &H80000006
    HKEY_CURRENT_CONFIG = &H80000005
    HKEY_CLASSES_ROOT = &H80000000
End Enum

' Return values
Public Enum ReturnCodes
    ERROR_SUCCESS = 0&
    ERROR_FILE_NOT_FOUND = 2&
    ERROR_MORE_DATA = 234
    ERROR_NO_MORE_ITEMS = 259&
End Enum


Public Enum RegCreateKeyExValues
    REG_OPTION_NON_VOLATILE = 0
    REG_CREATED_NEW_KEY = &H1
    REG_OPENED_EXISTING_KEY = &H2
End Enum

' Registry data types
Public Enum DataTypes
    REG_NONE = 0
    REG_SZ = 1
    REG_BINARY = 3
    REG_DWORD = 4
End Enum

' Registry security attributes
Public Enum SecurityAttributes
    KEY_QUERY_VALUE = &H1
    KEY_SET_VALUE = &H2
    KEY_CREATE_SUB_KEY = &H4
    KEY_ENUMERATE_SUB_KEYS = &H8
End Enum

Private Declare Function RegEnumValue Lib "advapi32.dll" _
        Alias "RegEnumValueA" (ByVal hKey As Long, ByVal dwIndex As Long, _
        ByVal lpValueName As String, lpcbValueName As Long, ByVal lpReserved As Long, _
        lpType As Long, lpData As Any, lpcbData As Long) As Long

Private Declare Function RegDeleteValue Lib "advapi32.dll" _
        Alias "RegDeleteValueA" _
        (ByVal hKey As Long, ByVal lpValueName As String) _
        As Long

Private Declare Function RegDeleteKey Lib "advapi32.dll" _
        Alias "RegDeleteKeyA" _
        (ByVal hKey As Long, ByVal lpSubKey As String) As Long

Private Declare Function RegOpenKeyEx Lib "advapi32.dll" _
        Alias "RegOpenKeyExA" _
        (ByVal hKey As Long, ByVal lpSubKey As String, _
        ByVal ulOptions As Long, ByVal samDesired As Long, _
        phkResult As Long) As Long

Private Declare Function RegCreateKeyEx Lib "advapi32.dll" _
        Alias "RegCreateKeyExA" _
        (ByVal hKey As Long, ByVal lpSubKey As String, _
        ByVal Reserved As Long, ByVal lpClass As String, _
        ByVal dwOptions As Long, ByVal samDesired As Long, _
        lpSecurityAttributes As SECURITY_ATTRIBUTES, phkResult As Long, _
        lpdwDisposition As Long) As Long

Private Declare Function RegQueryValueEx Lib "advapi32.dll" _
        Alias "RegQueryValueExA" _
        (ByVal hKey As Long, ByVal lpszValueName As String, _
        ByVal lpdwReserved As Long, lpdwType As Long, _
        lpData As Any, lpcbData As Long) As Long

Private Declare Function RegSetValueEx Lib "advapi32.dll" _
        Alias "RegSetValueExA" _
        (ByVal hKey As Long, ByVal lpValueName As String, _
        ByVal Reserved As Long, ByVal dwType As Long, _
        lpData As Any, ByVal cbData As Long) As Long

Private Declare Function RegEnumKey Lib "advapi32.dll" Alias _
        "RegEnumKeyA" (ByVal hKey As Long, ByVal dwIndex As Long, _
        ByVal lpName As String, ByVal cbName As Long) As Long

Private Declare Function RegCloseKey Lib "advapi32.dll" _
        (ByVal hKey As Long) As Long

Private Declare Function GetPrivateProfileSection Lib "kernel32" _
        Alias "GetPrivateProfileSectionA" (ByVal lpAppName As String, _
        ByVal lpReturnedString As String, ByVal nSize As Long, ByVal _
        lpFileName As String) As Long
        
Private Declare Function GetPrivateProfileString Lib "kernel32" _
        Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, _
        ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString _
        As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
        
Private Declare Function WritePrivateProfileString Lib "kernel32" _
        Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, _
        ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lpFileName As String) _
        As Long

Private Declare Function GetPrivateProfileInt Lib "kernel32" _
        Alias "GetPrivateProfileIntA" (ByVal lpApplicationName As String, _
        ByVal lpKeyName As String, ByVal nDefault As Long, ByVal lpFileName _
        As String) As Long

Public Function DeleteKey(ByVal TopKey As RegistryHive, _
    ByVal sSubKey As String, ByVal sKeyName As String) As Long
'
' Use this function to:
'   -   Delete a registry key.
'
' sTopKey
'   -   A top level registry key abbreviation {"HKCU","HKLM","HKU","HKDD","HKCC","HKCR"}
'
' sSubKey
'   -   A registry subkey.
'
' sKeyName
'   -   The name of the key to delete.
'
' Return Value
'   -   0 if successful, non-zero otherwise.
'
' Example
'   lResult = DeleteKey("HKCU", "Software\YourKey\...\YourApp", "KeyToDelete")
'   Call DeleteKey("HKCU", "Software\YourKey\...\YourApp", "KeyToDelete")
'
' NOTE:
'   The key to be deleted cannot be a top-level key
'   and cannot have any sub-keys.
'
Dim lTopKey As Long
Dim lHandle As Long
Dim lResult As Long

On Error GoTo DeleteKeyError
lResult = 99

lResult = RegOpenKeyEx(TopKey, sSubKey, 0, KEY_CREATE_SUB_KEY, lHandle)
If lResult = ERROR_SUCCESS Then
    lResult = RegDeleteKey(lHandle, sKeyName)
End If

If lResult = ERROR_SUCCESS Or lResult = ERROR_FILE_NOT_FOUND Then
    DeleteKey = ERROR_SUCCESS
Else
    DeleteKey = lResult
End If
Exit Function

DeleteKeyError:
    DeleteKey = lResult
End Function

Public Function DeleteValue(ByVal TopKey As RegistryHive, ByVal sSubKey As String, ByVal sValueName As String) As Long
'
' Use this function to:
'   -   Delete a registry value.
'   -   Delete an .ini file value.
'
' sTopKeyOrIniFile
'   -   A top level registry key abbreviation {"HKCU","HKLM","HKU","HKDD","HKCC","HKCR"} or
'   -   The full path of an .ini file (ex. "C:\Windows\MyFile.ini")
'
' sSubKeyOrSection
'   -   A registry subkey or
'   -   An .ini file section name
'
' sValueName
'   -   A registry entry or
'   -   An .ini file entry
'
' Return Value
'   -   0 if successful, non-zero otherwise.
'
' Example 1   -   Delete a registry value.
'   lResult = DeleteValue("HKCU", "Software\YourKey\LastKey\YourApp", "EntryToDelete")
'
' Example 2   -   Delete an .ini file value.
'   lResult = DeleteValue("C:\Windows\Myfile.ini", "SectionName", "EntryToDelete")
'
Dim lTopKey As Long
Dim lHandle As Long
Dim lResult As Long

On Error GoTo DeleteValueError
    
lResult = RegOpenKeyEx(TopKey, sSubKey, 0, KEY_SET_VALUE, lHandle)
If lResult = ERROR_SUCCESS Then
    lResult = RegDeleteValue(lHandle, sValueName)
End If

If lResult = ERROR_SUCCESS Or lResult = ERROR_FILE_NOT_FOUND Then
    DeleteValue = ERROR_SUCCESS
Else
    DeleteValue = lResult
End If

Exit Function

DeleteValueError:
    DeleteValue = lResult
End Function

Public Function EnumKey(ByVal TopKey As RegistryHive, ByVal sSubKey As String, sValues As String) As Long
'
' Use this function to:
'   -   Enumerate the subkeys of a registry key.
'
' sTopKey
'   -   A top level registry key abbreviation {"HKCU","HKLM","HKU","HKDD","HKCC","HKCR"}
'
' sSubKey
'   -   A registry subkey
'
' sValues
'   -   A returned string of the form:
'           SubKeyName|SubKeyName|.... SubKeyName||
'
'           Where - "|" equals vbNullChar (chr(0)).
'
' Return Value
'   -   0 if successful, non-zero otherwise.
'
' Example 1
'   lResult = EnumKey("HKLM", "Software\Microsoft", sValues)
'
Dim bDone    As Boolean
Dim lTopKey  As Long
Dim lHandle  As Long
Dim lResult  As Long
Dim lIndex   As Long
Dim sKeyName As String

On Error GoTo EnumKeyError
lResult = 99
'
' Open the registry SubKey.
'
lResult = RegOpenKeyEx(TopKey, sSubKey, 0, KEY_ENUMERATE_SUB_KEYS, lHandle)
If lResult <> ERROR_SUCCESS Then GoTo EnumKeyError
'
' Get all subkeys until ERROR_NO_MORE_ITEMS or an error occurs.
'
Do While Not bDone
    sKeyName = Space$(MAX_SIZE)
    lResult = RegEnumKey(lHandle, lIndex, sKeyName, MAX_SIZE)
    
    If lResult = ERROR_SUCCESS Then
        sValues = sValues & Trim$(sKeyName)
        lIndex = lIndex + 1
    Else
        bDone = True
    End If
Loop
sValues = sValues & vbNullChar
If Len(sValues) = 1 Then sValues = sValues & vbNullChar
'
' Close the key.
'
EnumKey = RegCloseKey(lHandle)
Exit Function
'
' Error processing.
'
EnumKeyError:
    EnumKey = lResult
End Function


Public Function EnumValue(ByVal TopKey As RegistryHive, ByVal sSubKey As String, sValues As String) As Long
'
' Use this function to:
'   -   Enumerate the values of a registry key or
'
' TopKey
'   -   A top level registry key
'
' sSubKeyOrSection
'   -   A registry subkey or
'
' sValues
'   -   A returned string of the form:
'           EntryName=Value|EntryName=Value|.... EntryName=Value||
'
'           Where - Value can be a string or binary value.
'           and   - "|" equals vbNullChar (chr(0)).
'
' Return Value
'   -   0 if successful, non-zero otherwise.
'
' Example
'   lResult = EnumValue("HKCU", "Software\YourKey\LastKey\YourApp", sValues)
'
'
' NOTE:
'   When enumerating registry values, only string, dword and binary values
'   with a length under 2 bytes (which allows for true/false values) are returned.
'
Dim lHandle    As Long
Dim lResult    As Long
Dim lValueLen  As Long
Dim lIndex     As Long
Dim lValue     As Long
Dim lValueType As Long
Dim lData      As Long
Dim lDataLen   As Long
Dim bDone      As Boolean
Dim sValueName As String
Dim sValue     As String

On Error GoTo EnumValueError
lResult = 99
    
' Open the registry SubKey.
'
lResult = RegOpenKeyEx(TopKey, sSubKey, 0, KEY_QUERY_VALUE, lHandle)
If lResult <> ERROR_SUCCESS Then GoTo EnumValueError
'
' Get all values until ERROR_NO_MORE_ITEMS or an error occurs.
'
Do While Not bDone
    lDataLen = MAX_SIZE
    lValueLen = lDataLen
    sValueName = Space$(lDataLen)
    
    lResult = RegEnumValue(lHandle, lIndex, sValueName, lValueLen, 0, lValueType, ByVal lData, lDataLen)
    If lResult = ERROR_SUCCESS Then
        Select Case lValueType
            Case REG_SZ
                sValue = Space$(lDataLen)
                sValueName = Left$(sValueName, lValueLen)
                lResult = RegQueryValueEx(lHandle, sValueName, 0, REG_SZ, ByVal sValue, lDataLen)
                If lResult = ERROR_SUCCESS Then
                    sValues = sValues & sValueName & "=" & sValue
                Else
                    GoTo EnumValueError
                End If
            Case REG_DWORD
                lResult = RegQueryValueEx(lHandle, sValueName, 0, REG_NONE, lValue, lDataLen)
                If lResult = ERROR_SUCCESS Then
                    sValueName = Left$(sValueName, lValueLen)
                    sValues = sValues & sValueName & "=" & lValue & vbNullChar
                Else
                    GoTo EnumValueError
                End If
            Case REG_BINARY
                If lDataLen <= 2 Then
                    lResult = RegQueryValueEx(lHandle, sValueName, 0, REG_NONE, lValue, lDataLen)
                    If lResult = ERROR_SUCCESS Then
                        sValueName = Left$(sValueName, lValueLen)
                        sValues = sValues & sValueName & "=" & lValue & vbNullChar
                    Else
                        GoTo EnumValueError
                    End If
                End If
            Case Else
        End Select
        lIndex = lIndex + 1
    Else
        bDone = True
    End If
Loop
sValues = sValues & vbNullChar
If Len(sValues) = 1 Then sValues = sValues & vbNullChar
'
' Close the key.
'
lResult = RegCloseKey(lHandle)
EnumValue = lResult

Exit Function
'
' Error processing.
'
EnumValueError:
    EnumValue = lResult
End Function





Public Function ReadValue(ByVal TopKey As RegistryHive, _
    ByVal sSubKeyOrSection As String, ByVal sValueName As String, _
    ByVal sValueType As String, ByVal vDefault As Variant, _
    vValue As Variant) As Long
'
' Use this function to read a:
'   -   String, 16-bit binary (True|False), 32-bit integer registry value
'
' TopKey
'   -   A top level registry key
'
' sSubKeyOrSection
'   -   A registry subkey
'
' sValueName
'   -   A registry entry
'
' sValueType
'   -   "S" to read a string value or
'   -   "B" to read a 16-bit binary value (applies to registry use only) or
'   -   "D" to read a 32-bit number value (applies to registry use only).
'
' vDefault
'   -   The default value to return. It can be a string or boolean.
'
' vValue
'   -   The value read. It can be a string or boolean.
'   -   vDefault if unsuccessful
'
' Return Value
'   -   0 if successful, non-zero otherwise.
'
' Example 1   -   Read a string value from the registry.
'   lResult = ReadValue("HKCU", "Software\YourKey\LastKey\YourApp", "AppName", "S", "", sValue)
'
' Example 2   -   Read a boolean (True|False) value from the registry.
'   lResult = ReadValue("HKCU", "Software\YourKey\LastKey\YourApp", "AutoHide", "B", False, bValue)
'
' Example 3   -   Read an integer value from the registry.
'   lResult = ReadValue("C:\Windows\Myfile.ini", "SectionName", "NumApps", "D", 12345, lValue)
'
Dim lHandle     As Long
Dim lLenData    As Long
Dim lResult     As Long
Dim lDefault    As Long
Dim lValue      As Long
Dim sValue      As String
Dim sSubKeyPath As String
Dim sDefaultStr As String
Dim bValue      As Boolean

On Error GoTo ReadValueError
lResult = 99
vValue = vDefault

' Open the registry SubKey.
'
lResult = RegOpenKeyEx(TopKey, sSubKeyOrSection, 0, KEY_QUERY_VALUE, lHandle)
If lResult <> ERROR_SUCCESS Then
    ReadValue = lResult
    Exit Function
End If
'
' Get the actual value.
'
Select Case UCase$(sValueType)
    Case "S"
        '
        ' String value. The first query gets the string length. The second
        ' gets the string value.
        '
        lResult = RegQueryValueEx(lHandle, sValueName, 0, REG_SZ, "", lLenData)
        If lResult = ERROR_MORE_DATA Then
            sValue = Space(lLenData)
            lResult = RegQueryValueEx(lHandle, sValueName, 0, REG_SZ, ByVal sValue, lLenData)
        End If
        If lResult = ERROR_SUCCESS Then  'Remove null character.
            vValue = Left$(sValue, lLenData - 1)
        Else
            GoTo ReadValueError
        End If
    Case "B"
        lLenData = Len(bValue)
        lResult = RegQueryValueEx(lHandle, sValueName, 0, REG_BINARY, bValue, lLenData)
        If lResult = ERROR_SUCCESS Then
            vValue = bValue
        Else
            GoTo ReadValueError
        End If
    Case "D"
        lLenData = 32
        lResult = RegQueryValueEx(lHandle, sValueName, 0, REG_DWORD, lValue, lLenData)
        If lResult = ERROR_SUCCESS Then
            vValue = lValue
        Else
            GoTo ReadValueError
        End If
End Select
'
' Close the key.
'
lResult = RegCloseKey(lHandle)
ReadValue = lResult

Exit Function
'
' Error processing.
'
ReadValueError:
    ReadValue = lResult
End Function



Public Function WriteValue(ByVal TopKey As RegistryHive, _
    ByVal sSubKeyOrSection As String, ByVal sValueName As String, _
    ByVal sValueType As String, ByVal vValue As Variant) As Long
'
' Written by Dave Scarmozzino  www.TheScarms.com
'
' Use this function to write a:
'   -   String, 16-bit binary (True|False), 32-bit integer registry value or
'   -   String value to an .ini file.
'
' sTopKeyOrIniFile
'   -   A top level registry key abbreviation {"HKCU","HKLM","HKU","HKDD","HKCC","HKCR"} or
'   -   The full path of an .ini file (ex. "C:\Windows\MyFile.ini")
'
' sSubKeyOrSection
'   -   A registry subkey or
'   -   An .ini file section name
'
' sValueName
'   -   A registry entry or
'   -   An .ini file entry
'
' sValueType
'   -   "S" to write a string value or
'   -   "B" to write a 16-bit binary value (applies to registry use only) or
'   -   "D" to write a 32-bit number value (applies to registry use only).
'
' vValue
'   -   The value to write. It can be a string, binary or integer.
'
' Return Value
'   -   0 if successful, non-zero otherwise.
'
' Example 1   -   Write a string value to the registry.
'   lResult = WriteValue("HKCU", "Software\YourKey\LastKey\YourApp", "AppName", "S", "MyApp")
'
' Example 2   -   Write a True|False value to the registry.
'   lResult = WriteValue("HKCU", "Software\YourKey\LastKey\YourApp", "AutoHide", "B", True)
'
' Example 3   -   Write an integer value to the registry.
'   lResult = WriteValue("HKCU", "Software\YourKey\LastKey\YourApp", "NumOfxxx", "D", 12345)
'
' Example 4   -   Write a string value to an .ini file.
'   lResult = WriteValue("C:\Windows\Myfile.ini", "SectionName", "AppName", "S", "MyApp")
'
' NOTE:
'   This function cannot write a non-string value to an .ini file.
'
Dim hKey                As Long
Dim lOptions            As Long
Dim lsamDesired         As Long
Dim lHandle             As Long
Dim lDisposition        As Long
Dim lLenData            As Long
Dim lResult             As Long
Dim lValue              As Long
Dim sClass              As String
Dim sValue              As String
Dim sSubKeyPath         As String
Dim bValue              As Boolean
Dim tSecurityAttributes As SECURITY_ATTRIBUTES

On Error GoTo WriteValueError
lResult = 99
    
sClass = ""
lOptions = REG_OPTION_NON_VOLATILE
lsamDesired = KEY_CREATE_SUB_KEY Or KEY_SET_VALUE
'
' Create the SubKey or open it if it exists. Return its handle.
' lDisposition will be REG_CREATED_NEW_KEY if the key did not exist.
'
lResult = RegCreateKeyEx(TopKey, sSubKeyOrSection, 0, sClass, lOptions, lsamDesired, tSecurityAttributes, lHandle, lDisposition)
If lResult <> ERROR_SUCCESS Then GoTo WriteValueError
'
' Set the actual value.
'
Select Case UCase$(sValueType)
    Case "S"
        sValue = vValue
        lLenData = Len(sValue) + 1
        lResult = RegSetValueEx(lHandle, sValueName, 0, REG_SZ, ByVal sValue, lLenData)
    Case "B"
        bValue = vValue
        lLenData = Len(bValue)
        lResult = RegSetValueEx(lHandle, sValueName, 0, REG_BINARY, bValue, lLenData)
    Case "D"
        lValue = CInt(vValue)
        lLenData = 4
        lResult = RegSetValueEx(lHandle, sValueName, 0, REG_DWORD, lValue, lLenData)
End Select
'
' Close the key.
'
If lResult = ERROR_SUCCESS Then
    lResult = RegCloseKey(lHandle)
    WriteValue = lResult
    Exit Function
End If

Exit Function
'
' Error processing.
'
WriteValueError:
    WriteValue = lResult
End Function



