

<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>
       

<% PageUtils.jspStart(request); %>

<%@ page import="java.util.*" %>   
      
<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
<%@ page import="com.workroll.app.util.*" %>

<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ISSUES_POPUP,request); %>
 
<%@ include file="../global/topInclude.jsp" %>
<%@ include file="../global/cookieJs.jsp" %>
<%@ include file="../global/validationJs.jsp" %>
<%!

static final String[] SORT_LABELS=
{
	"(none)",
	"ID",
	"Assigning user",
	"Assigned-to user",
	"Status",
	"Priority",
	"Project name",
	"Instance name",
	"Open date",
	"Due date",
	"Description",
};
static final String[] SORT_NAMES=
{
	"idSort", // we take "no sort" to mean sort by ID.
	"idSort",
	"assignedByUserFullnameSort",
	"assignedToUserFullnameSort",
	"statusSort",
	"prioritySort",
	"projectNameSort",
	"instanceNameSort",
	"openDateSort",
	"dueDateSort",
	"descriptionSort",	
};

%>        

<%


com.theavocadopapers.client.Client client=controller.getClient();
boolean allowImport=(client.isExp());



%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>

<%@ include file="../global/headInclude.jsp" %>
<%@ include file="../global/popupHeadInclude.jsp" %>




<script language="JavaScript">

top.focus()

top.returnValue=null


var EXPORT_EOL_CHARS="<%=WorkRollConstants.EXPORT_EOL_CHARS%>"
var EXPORT_TAB_CHARS="<%=WorkRollConstants.EXPORT_TAB_CHARS%>"

function doImport()
{
	var els=document.forms["mainForm"].elements
	
	if (okToShowDialog("importnotabsub") && els["tabSubstitute"].value.length==0)
	{

		var okToProceed=generalConfirm("You have not specified a sequence of characters to be replaced by a tab character; OK to proceed?"+dontShowHTML("importnotabsub",true))
			if (!okToProceed)
			{
				return false
			}

	}
	if (okToShowDialog("importnoeolsub") && els["eolSubstitute"].value.length==0)
	{

		var okToProceed=generalConfirm("You have not specified a sequence of characters to be replaced by an end-of-line marker; OK to proceed?"+dontShowHTML("importnoeolsub",true))
			if (!okToProceed)
			{
				return false
			}

	}
	if (els["file1"].value.length==0)
	{
		errorAlert("You have not specified a file to upload. Please choose one and try again.",els["file1"])
		return false
	}


	if (els["tabSubstitute"].value.indexOf("_")>-1 || els["tabSubstitute"].value.indexOf("\t")>-1)
	{
		errorAlert("The characters you specify to be replaced by a tab character may not include underscores (\"_\") or tab characters. Please fix and try again.",els["tabSubstitute"])
		return false
	}
	if (els["eolSubstitute"].value.indexOf("_")>-1 || els["eolSubstitute"].value.indexOf("\t")>-1)
	{
		errorAlert("The characters you specify to be replaced by an end-of-line sequence may not include underscores (\"_\") or tab characters. Please fix and try again.",els["tabSubstitute"])
		return false
	}

	var containsHeaderRow=""+radioGroupValue(document.forms["mainForm"],"containsHeaderRow")
	var containsIgnorableIdColumn=""+radioGroupValue(document.forms["mainForm"],"containsIgnorableIdColumn")
	var byUsersAreUsernames=""+radioGroupValue(document.forms["mainForm"],"byUsersAreUsernames")
	var toUsersAreUsernames=""+radioGroupValue(document.forms["mainForm"],"toUsersAreUsernames")
	var removeQuotes=""+radioGroupValue(document.forms["mainForm"],"removeQuotes")
	
	var tabSubstitute=""+escape(els["tabSubstitute"].value)
	var eolSubstitute=""+escape(els["eolSubstitute"].value)
	var file1=""+escape(els["file1"].value)
	
	var openDateFormat=""+selectValue(els["openDateFormat"])
	var dueDateFormat=""+selectValue(els["dueDateFormat"])


	if (els["savePrefs"].checked)
	{
		setCookie
		(
			"impp",
			""
				+containsHeaderRow+"_"
				+containsIgnorableIdColumn+"_"
				+byUsersAreUsernames+"_"
				+toUsersAreUsernames+"_"
				+removeQuotes+"_"
				+tabSubstitute+"_"
				+eolSubstitute+"_"
				+openDateFormat+"_"
				+dueDateFormat+"_"
				+file1,
			null,
			"/"
		)
	}
	//alert("before submit, radioGroupValue(document.forms[\"mainForm\"],\"containsIgnorableIdColumn\")="+radioGroupValue(document.forms["mainForm"],"containsIgnorableIdColumn"))
	hidePageAndShowPleaseWait()
	return true
}
function setDefaults()
{
	var els=document.forms["mainForm"].elements
	
	checkRadioWithNameAndValue("mainForm", "containsHeaderRow", "false")
	checkRadioWithNameAndValue("mainForm", "containsIgnorableIdColumn", "true")
	checkRadioWithNameAndValue("mainForm", "byUsersAreUsernames", "true")
	checkRadioWithNameAndValue("mainForm", "toUsersAreUsernames", "true")
	checkRadioWithNameAndValue("mainForm", "removeQuotes", "false")
	
	els["tabSubstitute"].value=unescape(EXPORT_TAB_CHARS)
	els["eolSubstitute"].value=unescape(EXPORT_EOL_CHARS)

	selectMenuOption(els["openDateFormat"],"0")
	selectMenuOption(els["dueDateFormat"],"0")

	generalAlert("Form values have been set to defaults that match files exported from another WorkRoll installation with the \"set WorkRoll export/import defaults\" option.")

}

function init()
{
	var containsHeaderRow="false"
	var containsIgnorableIdColumn="true"
	var byUsersAreUsernames="true"
	var toUsersAreUsernames="true"
	var removeQuotes="false"
	
	var tabSubstitute=EXPORT_TAB_CHARS
	var eolSubstitute=EXPORT_EOL_CHARS
	var file1=""

	var openDateFormat="0"
	var dueDateFormat="0"
	
	var importPrefsCookie=getCookie("impp")
	if (importPrefsCookie!=null)
	{
		var prefs=importPrefsCookie.split("_")
		var c=0;
		containsHeaderRow=prefs[c]; c++
		containsIgnorableIdColumn=prefs[c]; c++
		byUsersAreUsernames=prefs[c]; c++
		toUsersAreUsernames=prefs[c]; c++
		removeQuotes=prefs[c]; c++
		tabSubstitute=prefs[c]; c++
		eolSubstitute=prefs[c]; c++
		openDateFormat=prefs[c]; c++
		dueDateFormat=prefs[c]; c++
		file1=prefs[c]; c++
	}
	
	var els=document.forms["mainForm"].elements
	
	checkRadioWithNameAndValue("mainForm", "containsHeaderRow", containsHeaderRow)
	checkRadioWithNameAndValue("mainForm", "containsIgnorableIdColumn", containsIgnorableIdColumn)
	checkRadioWithNameAndValue("mainForm", "byUsersAreUsernames", byUsersAreUsernames)
	checkRadioWithNameAndValue("mainForm", "toUsersAreUsernames", toUsersAreUsernames)
	checkRadioWithNameAndValue("mainForm", "removeQuotes", removeQuotes)
	
	els["tabSubstitute"].value=unescape(tabSubstitute)
	els["eolSubstitute"].value=unescape(eolSubstitute)

	// not possible (security issue, probably):
	//els["file1"].value=unescape(file1)

	selectMenuOption(els["openDateFormat"],openDateFormat)
	selectMenuOption(els["dueDateFormat"],dueDateFormat)

	if (false) // document.getElementById("submitButton").focus)
	{
		document.getElementById("submitButton").focus()
	}
}
</script> 

<style type="text/css">
BODY {background-color:#F2F2E1; }
.inputClass {padding:2px; height:20px; border: 1px solid #7F7F5E; font-size:11px; font-family:arial,helvetica; width:294px; } 
.textareaClass {padding:4px; height:120px; width:294px; border: 1px solid #7F7F5E; font-size:11px; font-family:arial,helvetica; } 
.selectClass {padding:2px; width:294px; border: 1px solid #7F7F5E; font-size:11px; font-family:arial,helvetica; }
.defaultButton {background-color:#A2A27A; border:1px solid #444434; width:65px; height:18px; font-family:arial,helvetica; font-size:11px; color:#444434;">}

</style>

 
  
 
</head>

<%@ include file="../global/bodyOpen.jsp" %>  

<div id=popupMainDiv style="width:525px; ">

<form action=processImport.jsp name=mainForm id=mainForm method=post onSubmit="return doImport()" ENCTYPE="multipart/form-data">

<font class=bodyFont>
<%
if (allowImport)
{
%>
	<span class=firstSentenceFont>
	You may import<%=HelpManager.helpLink("importing","F2F2E1",request)%> issues into the WorkRoll database
	</span> 

	by uploading a text file (which can be generated, for example, by a text editor, a spreadsheet program such as Microsoft Excel, a database export, or an export from another WorkRoll installation) using the form at the bottom of this page.  The file must be structured according to the following specifications (for your reference, a sample file is <a href=txt/sample.txt target=_blank>here</a>).  Note that any text file exported by WorkRoll can later be imported by WorkRoll:

	<ol type="1">
	<li>Each row must contain exactly one issue, consisting of the ten following fields, which must be separated by a tab character.  The ten fields (which must appear in order) are:<BR><BR>

		<ol type="A">
		<li><B>Assigned-by user<%=HelpManager.helpLink("assignedByUser","F2F2E1",request)%>: </B>Full name or username (you specify which below) of the user by whom this issue was assigned; the user must be an <I>existing</I> WorkRoll user.  Full names are not case-sensitive; usernames are.

		<li><B>Assigned-to user<%=HelpManager.helpLink("assignedToUser","F2F2E1",request)%>: </B>Full name or username (you specify which below) of the user to whom this issue was assigned; the user must be an <I>existing</I> WorkRoll user.  Full names are not case-sensitive; usernames are.

		<li><B>Status<%=HelpManager.helpLink("status","F2F2E1",request)%>: </B>The status of the issue: either "Open", "Resolved", "Closed", or an empty string (which will be interpreted to mean "Open").  This field is not case-sensitive.

		<li><B>Priority<%=HelpManager.helpLink("priority","F2F2E1",request)%>: </B>The priority of the issue: either "Very Low", "Low", "Normal", "High", "Emergency", or an empty string (which will be interpreted to mean "Normal"). This field is not case-sensitive.

		<li><B>Project<%=HelpManager.helpLink("project","F2F2E1",request)%>: </B>The name of the project; the project must be an <I>existing</I> WorkRoll project.  If the issue should not be associated with any particular project, this field must contain either "All instances" or an empty string.  This field is not case-sensitive.

		<li><B>Instance<%=HelpManager.helpLink("instance","F2F2E1",request)%>: </B>The name of the instance; the instance must be an <I>existing</I> WorkRoll instance.  If the issue should not be associated with any particular instance, this field must contain either "All instances" or an empty string.  This field is not case-sensitive.

		<li><B>Opened date<%=HelpManager.helpLink("openedDate","F2F2E1",request)%>: </B>The date on which the issue was opened, in the format you specify below, or an empty string (which will be interpreted as today's date).  The date must be in the format you specify below.  

		<li><B>Due date<%=HelpManager.helpLink("dueDate","F2F2E1",request)%>: </B>The date and time on which the issue is due, or an empty string (which will be interpreted as today's date, with no time set).  If you specify a time, permitted values are any times whose "minute" and "second" values are "00" (for example, 00:00:00, 01:00:00, 02:00:00, and so on, up to and including 23:00:00).  There are also three "special" valid values: 09:30:00 denotes start-of-work; 17:30:00 denotes end-of-work; and 23:59:00 denotes that no time has been specified.  If you do not specify a time, the time will not be set (that is, not specifying a time is the same as specifying 23:59:00).  Note that times must be in twenty-four-hour format, meaning that 13:00:00 denotes 1:00 PM, 23:00:00 denotes 11:00 PM, 00:00:00 denotes midnight, etc.).  The date and time must be in the format you specify below.

		<li><B>URL<%=HelpManager.helpLink("url","F2F2E1",request)%>: </B>The URL, if any, associated with this issue.  There is no limit on the length of this field. Empty string indicates no URL. (Note that when WorkRoll displays this field, it is displayed as part of the description, but for the purposes of importing and exporting, it is a separate field.)

		<li><B>Description<%=HelpManager.helpLink("description","F2F2E1",request)%>: </B>The description text of the issue (not including the URL, if any, which is treated as a separate field, per the above item).  This field may not be left empty.  There is no limit on the length of this field.
		</ol><BR>


	<LI>To support importing of tab-delimited text files exported from other WorkRoll installations (such files would contain an issue-id<%=HelpManager.helpLink("id","F2F2E1",request)%> field), one field may, optionally, precede the assigned-by-user field (resulting in eleven, not ten, fields).  If it is present, it must be present for all issues, and it must contain either a positive whole number (that is, a sequence of characters containing numerals and nothing else, including commas, minus-signs, or decimal points) or an empty string.  However, <I>this field will be completely ignored during the import, since imported issues are assigned new IDs.</I>

	<BR><BR><LI>Lines may not end in a tab character (each line, therefore, must contain exactly nine tab characters separating the ten fields above -- unless the "ignored" ID field precedes the assigned-by-user field as mentioned above, in which case there must be ten tab characters separating eleven fields).  The two valid structures for each line of text are therefore (with "[T]" representing a tab character, "[E]" representing the end of the line, and "field0" representing the optional, ignored ID field), without the quotes:<BR><BR>

	&nbsp;&nbsp;&nbsp;&nbsp;"field0[T]field1[T]field2[T]field3[T]field4[T]field5[T]field6[T]field7[T]field8[T]field9[T]field10[E]"<BR><BR>

	&nbsp;&nbsp;&nbsp;&nbsp;"field1[T]field2[T]field3[T]field4[T]field5[T]field6[T]field7[T]field8[T]field9[T]field10[E]"<BR><BR>


	<LI>Also to support importing of files exported from other WorkRoll installations, prepended sortable-prefix<%=HelpManager.helpLink("sortablePrefix","F2F2E1",request)%> sequences beginning with "[" and ending with "]" are permitted but will be ignored for status, priority, and both date fields (for example, "[1051212757504] 2003-04-24" is identical to "2003-04-24" for importing purposes).

	<BR><BR><LI>Also to support WorkRoll-generated exports, your file may optionally contain a row of column-header text such as the one that WorkRoll exports.  If your file does include such a row, however, it will be ignored during the import.  WorkRoll optionally exports the following column-header row, which is therefore accepted for imports (with "[T]" representing a tab character and "[E]" representing the end of the line), without the quotes:<BR><BR>

	&nbsp;&nbsp;&nbsp;&nbsp;" ID[T]By[T]To[T]Status[T]Priority[T]Project[T]Instance[T]Opened[T]Due[T]URL[T]Description[E]"<BR><BR>

	(Note the space character before the "ID"; it is exported deliberately to circumvent a bug in some versions of Microsoft Excel.)  Since you may also be importing data without the optional and ignored ID column, the following column-header row is also accepted for imports:<BR><BR>
	&nbsp;&nbsp;&nbsp;&nbsp;"By[T]To[T]Status[T]Priority[T]Project[T]Instance[T]Opened[T]Due[T]URL[T]Description[E]"<BR><BR>


	<LI>Space characters leading or trailing any fields will be ignored, except in the description-text field, which will be imported as-is.

	<BR><BR><LI>Issue fields may contain neither tab characters nor linebreaks; you will specify below which (if any) series of characters should be converted into tabs or linebreaks after the import.

	<BR><BR><LI>Fields containing double quotation marks do <I>not</I> themselves need to begin and end with double quotation marks, although they may begin and end this way (and you may optionally have them removed after the import).

	<BR><BR><LI>The file must be in Windows-, Macintosh-, or UNIX-friendly format (that is, the end-of-line sequence must be either CR, LF, or CR-LF; if you don't know what this means, don't worry as long as you use a Windows, Macintosh, or UNIX computer).

	<BR><BR><LI>Blank lines (lines containing no text or only space or tab characters) will be ignored.

	<BR><BR><LI>Creating the text file manually (that is, for example, by creating it in a text editor such as Notepad or SimpleText) is possible but not recommended.  If you need to create an importable file from scratch, using a spreadsheet application such as Microsoft Excel will likely be much easier (but bear in mind that depending on the application, since tab-delimited formats vary slightly from program to program, you may still need to "touch up" the file in a text editor to conform to the specifications above).

	<BR><BR><LI>Issues will be added to the database in the order in which they appear in the file.  Since WorkRoll allows you to sort issues by most fields (and since they are listed by open-date if you do not specify a sort), generally the database order (that is, the order in which IDs are assigned to issues) does not matter, If this does matter for your purposes, ensure that the issues in your file are in the correct order.


	</ol>
	<BR>

	<a name="formTop"></a>

	<I>After you have read the above instructions, please do one of the following...  </I>

	<ul>
	<li>If you are importing issues after having exported then from another WorkRoll installation using the "set WorkRoll export/import defaults" option, click "set WorkRoll export/import defaults", then choose a file to upload under "File to upload for export," then press "OK", <I>or</I>
	<li>If you are importing issues from a source other than another WorkRoll installation (or from a WorkRoll installation, but not with the "set WorkRoll export/import defaults" option), choose import preferences in the form below, then choose a file to upload under "File to upload for export," then press "OK".
	</ul>

	<input id="defaultsButton" onclick="setDefaults()" class=defaultButton type=button value="set WorkRoll export/import defaults" style="width:190px;"><BR><BR>


	<span class=boldishFont>Characters to be replaced by tab character (if any) are:<BR></span>
	<input type=text name=tabSubstitute id=tabSubstitute class=inputText style="width:75px;"><%=HtmlUtils.doubleLB(request,5)%>


	<span class=boldishFont>Characters to be replaced by end-of-line marker (if any) are:<BR></span>
	<input type=text name=eolSubstitute id=eolSubstitute class=inputText style="width:75px;"><BR>


	<span class=boldishFont>Leading and trailing double-quote characters should be removed:</span> <%=HtmlUtils.getYesNoRadios(false, "removeQuotes")%><BR>


	<span class=boldishFont>The file contains a row of column-header text, which should be ignored:</span> <%=HtmlUtils.getYesNoRadios(true, "containsHeaderRow")%><BR>

	<span class=boldishFont>Each row begins with an ID field, which should be ignored:</span> <%=HtmlUtils.getYesNoRadios(true, "containsIgnorableIdColumn")%><BR>


	<span class=boldishFont>Assigned-by users are identified by existing users'...</span> <%=HtmlUtils.getYesNoRadios(true, "byUsersAreUsernames", "Username"+HelpManager.helpLink("username","F2F2E1",request), "Full name"+HelpManager.helpLink("fullName","F2F2E1",request))%><BR>

	<span class=boldishFont>Assigned-to users are identified by existing users'...</span> <%=HtmlUtils.getYesNoRadios(true, "toUsersAreUsernames", "Username"+HelpManager.helpLink("username","F2F2E1",request), "Full name"+HelpManager.helpLink("fullName","F2F2E1",request))%><%=HtmlUtils.doubleLB(request,5)%>


	<span class=boldishFont>The opened-date field is in this format:<BR></span>
	<select name=openDateFormat id=openDateFormat class=selectText style="width:130px;">
	<option value="<%=""+WorkRollConstants.DATE_FORMAT_MMDDYYYY_SLASHES%>"><%=GeneralUtils.getDateFormatLabel(WorkRollConstants.DATE_FORMAT_MMDDYYYY_SLASHES)%></option>
	<option value="<%=""+WorkRollConstants.DATE_FORMAT_MMDDYY_SLASHES%>"><%=GeneralUtils.getDateFormatLabel(WorkRollConstants.DATE_FORMAT_MMDDYY_SLASHES)%></option>
	<option value="<%=""+WorkRollConstants.DATE_FORMAT_YYYYMMDD_DASHES%>"><%=GeneralUtils.getDateFormatLabel(WorkRollConstants.DATE_FORMAT_YYYYMMDD_DASHES)%></option>
	<option value="<%=""+WorkRollConstants.DATE_FORMAT_DDMMYYYY_SLASHES%>"><%=GeneralUtils.getDateFormatLabel(WorkRollConstants.DATE_FORMAT_DDMMYYYY_SLASHES)%></option>
	<option value="<%=""+WorkRollConstants.DATE_FORMAT_DDMMYY_SLASHES%>"><%=GeneralUtils.getDateFormatLabel(WorkRollConstants.DATE_FORMAT_DDMMYY_SLASHES)%></option>
	</select><%=HtmlUtils.doubleLB(request,5)%>

	<span class=boldishFont>The due-date field is in this format:<BR></span>
	<select name=dueDateFormat id=dueDateFormat class=selectText style="width:130px;">
	<option value="<%=""+WorkRollConstants.DATE_FORMAT_MMDDYYYY_SLASHES%>"><%=GeneralUtils.getDateFormatLabel(WorkRollConstants.DATE_FORMAT_MMDDYYYY_SLASHES)%></option>
	<option value="<%=""+WorkRollConstants.DATE_FORMAT_MMDDYY_SLASHES%>"><%=GeneralUtils.getDateFormatLabel(WorkRollConstants.DATE_FORMAT_MMDDYY_SLASHES)%></option>
	<option value="<%=""+WorkRollConstants.DATE_FORMAT_YYYYMMDD_DASHES%>"><%=GeneralUtils.getDateFormatLabel(WorkRollConstants.DATE_FORMAT_YYYYMMDD_DASHES)%></option>
	<option value="<%=""+WorkRollConstants.DATE_FORMAT_DDMMYYYY_SLASHES%>"><%=GeneralUtils.getDateFormatLabel(WorkRollConstants.DATE_FORMAT_DDMMYYYY_SLASHES)%></option>
	<option value="<%=""+WorkRollConstants.DATE_FORMAT_DDMMYY_SLASHES%>"><%=GeneralUtils.getDateFormatLabel(WorkRollConstants.DATE_FORMAT_DDMMYY_SLASHES)%></option>
	</select><%=HtmlUtils.doubleLB(request,5)%>



	<BR>

	<span class=boldishFont>File to upload for import</span> (click "Browse" to choose the file from your computer's file system):<BR>
	<input type=file name=file1 <%=(controller.getClient().isExp() && controller.getClient().isWin())?"class=inputText style=\"width:350px;\"":""%> ><BR>
	<BR>

	<input type=checkbox checked name=savePrefs id=savePrefsTrue value=true><label for="savePrefsTrue">Remember these preferences for this session</label><BR><BR>


	<BR>
	When you've completed the form above, click "OK"; you will get a chance to look at your issues as imported by WorkRoll before they are actually stored in the database (and WorkRoll will notify you of any problems with the formatting and structure of your data).<BR><BR><BR>

	<input id="submitButton" class=formButton type=submit value="OK"> <input  class=formButton type=button value=cancel onclick="top.close()"><BR>

	<BR>
<%
}
else
{
	%>
	<B>Please use Microsoft Internet Explorer to import uploads.</B><BR>
	<%
}
%>
</font>

</form>	

</div>

<%@ include file="../global/popupBodyClose.jsp" %>

</html>


<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>


