<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>

<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%

String mode=controller.getParam("mode"); // "add" or "edit"
boolean success=controller.getParamAsBoolean("success",true);



ArrayList allProjects=Manager.selectAllProjects();
if (allProjects==null)
{
	allProjects=new ArrayList();
}
String[] names=new String[allProjects.size()];
int[] ids=new int[allProjects.size()];



for (int i=0; i<allProjects.size(); i++)
{
	Project project=(Project)allProjects.get(i);
	names[i]=project.getName();
	ids[i]=project.getId();
}

%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<%@ include file="../global/headInclude.jsp" %>

<script language="JavaScript">

</script>

<style type="text/css">

</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>

<div id=mainDiv>
<span class=standardTextBlockWidth>
<form>
<font class=bodyFont>


<%
if (success)
{
	if (mode.equals("edit"))
	{
		%>
		<span class=firstSentenceFont>Your changes have been made.</span> The current set of projects appears below. You may now:

		<ul>
		<li><A href="menu.jsp">return to the global admin menu</a>
		<li><a href="projects.jsp">make more project changes</a>
		<li><a href="addProjects.jsp">add projects</a>
		<%=HtmlUtils.doubleLB(request)%>
		</ul>
		<%
	}
	if (mode.equals("add"))
	{
		%>
		<span class=firstSentenceFont>Your additions have been made.</span> The current set of projects appears below.  You may now:

		<ul>
		<li><A href="menu.jsp">return to the global admin menu</a>
		<li><a href="addProjects.jsp">add more projects</a>
		<li><a href="projects.jsp">make project changes</a>

		<%=HtmlUtils.doubleLB(request)%>
		</ul>
		<%
	}
}
else
{
	%>
	<span class=firstSentenceFont>There was a problem.</span> Some or all of your data may not have been saved. The current list of projects is below.  You may now:

		<ul>
		<li><A href="../feedback/compose.jsp">report the problem you just experienced</a>
		<li><A href="menu.jsp">return to the global admin menu</a>
		<li><a href="addProjects.jsp">add more projects</a>
		<li><a href="projects.jsp">make project changes</a>

		<%=HtmlUtils.doubleLB(request)%>
		</ul>

	<%
}
%>

<table border=0 cellspacing=0 cellpadding=0 width=300> 
<%@ include file="projectsTableHeaderRow.jsp" %>
 
<% 

for (int i=0; i<names.length; i++)
{
	%>
	<input type=hidden name=id<%=i%> id=id<%=i%> value="<%=ids[i]%>">
	<tr class=<%=((((double)i/2)==(double)((int)(i/2)))?"evenDataRow":"oddDataRow")%> height=22>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	<td align=left><font class=columnDataFont>&nbsp;<%=names[i]%>&nbsp;&nbsp;&nbsp;<BR></font></td>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	</tr>
	<%=HtmlUtils.getHorizRuleTr(5, request)%>
	<%
}

%>

</table><BR>

<%=HtmlUtils.doubleLB(request)%><BR>


<br></font>

</form></span>
</div>

<%@ include file="../global/bodyClose.jsp" %>

</html>

<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

