<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="javax.mail.*" %>
<%@ page import="javax.mail.internet.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.mail.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
  
<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setRequiredRequestMethod("POST",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%

boolean success=false;

String defAddrAddedParam="";


try
{
	InstallationConfig installationConfig=controller.getCurrentInstallationConfig();

	installationConfig.setMailSubjectPrefixInitialNotification(controller.getParam("mailSubjectPrefixInitialNotification"));
	installationConfig.setMailSubjectPrefixChangeNotification(controller.getParam("mailSubjectPrefixChangeNotification"));
	installationConfig.setMailSubjectPrefixReminderApproaching(controller.getParam("mailSubjectPrefixReminderApproaching"));
	installationConfig.setMailSubjectPrefixReminderMissed(controller.getParam("mailSubjectPrefixReminderMissed"));
	installationConfig.setSmtpHost(controller.getParam("smtpHost"));
	installationConfig.setSmtpLocalhost(controller.getParam("smtpLocalhost"));
	installationConfig.setSmtpUsername(controller.getParam("smtpUsername"));
	installationConfig.setSmtpPassword(controller.getParam("smtpPassword"));
	installationConfig.setSmtpPort(controller.getParamAsInt("smtpPort"));
	installationConfig.setDoNotifications(controller.getParamAsBoolean("doNotifications"));

	// store to static var and also save to db:
	controller.storeInstallationConfig(installationConfig);
	
	


	// check if notifications are enabled; if they are, then all users must have an assigned e-mail
	// address; if some found that don't, assign one:
	if (installationConfig.isDoNotifications())
	{
		ArrayList users=Manager.selectAllUsers();
		for (int i=0; i<users.size(); i++)
		{
			User user=(User)users.get(i);
			String email=user.getEmailAddress();
			if (email==null || email.trim().length()==0)
			{
				user.setEmailAddress(new String(installationConfig.getAdminEmail()));
				Manager.updateUser(user);
				defAddrAddedParam=new String(installationConfig.getAdminEmail());
			}
		}
	}



	success=true;
}
catch (Throwable t)
{
	success=false;
	Printer.pe("storing iconfig",t);
}



controller.redirect("showEmailConfigChanges.jsp?success="+(success?"true":"false")+"&defAddrAdded="+defAddrAddedParam);
%>


<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

