package demo;

import java.math.BigDecimal;
import java.util.Vector;

import com.japisoft.formula.Formula;
import com.japisoft.formula.FormulaFactory;
import com.japisoft.formula.FunctionResolver;
import com.japisoft.formula.ListOfArgument;
import com.japisoft.formula.SymbolResolver;
import com.japisoft.formula.Variant;
import com.japisoft.formula.lib.AbstractLib;
import com.japisoft.formula.lib.LibManager;
import com.japisoft.formula.lib.standard.AbstractFunction;
import com.japisoft.formula.node.EvaluateException;
import com.japisoft.formula.operator.BinaryOperator;
import com.japisoft.formula.operator.OperatorContext;
import com.japisoft.formula.operator.binary.MINUSOperator;

/**
 * List of JFormula test
 * @author (c) 2005 JAPISoft / http://www.japisoft.com
 * @version 1.0
 * */
public class UnitTest implements SymbolResolver, FunctionResolver {

	public Variant getValue(String function, ListOfArgument args) {
		if ( "test1".equals( function ) ) {	// Always Ok
			return new Variant( "ok" );
		} else
		if ( "test2".equals( function ) ) {	// Concat
			StringBuffer sb = new StringBuffer();
			for ( int i = 0; i < args.getArgumentCount(); i++ ) {
				sb.append( args.getArgumentAt( i ).getStringValue() );
			}
			return new Variant( sb.toString() );
		} else
		if ( "test3".equals( function ) ) { // Element a in List
			if ( args.getArgumentCount() >= 2 ) {
				Variant v1 = args.getArgumentAt( 0 );
				Variant v2 = args.getArgumentAt( 1 );
				if ( v2.isList() ) {
					Vector v = v2.getListValue();
					return new Variant( v.contains( v1 ) );
				}
			}
		} else
		if ( "test4".equals( function ) ) {
			double r = 0;
			for ( int i = 0; i < args.getArgumentCount(); i++ ) {
				Variant v = args.getArgumentAt( i );
				if ( v.isDouble() ) {
					r += v.getDoubleValue();
				}
			}
			return new Variant( r );
		}
		return null;
	}	

	public Variant getValue(String symbol) {
		if ( "zz".equals( symbol ) )
			return new Variant( 2 );
		if ( "hh".equals( symbol ) )
			return new Variant( 3 );
		return null;
	}

	public static void run( boolean high, Object[] exprs ) {

		System.out.println( "========================= " + high + "========================" );

		FormulaFactory factory = FormulaFactory.getInstance( high );
		Formula f = factory.getFormula();
		f.addSymbolResolver( new UnitTest() );
		f.addFunctionResolver( new UnitTest() );
		
		((AbstractLib)LibManager.getLib()).install( new fun1() );
		((AbstractLib)LibManager.getLib()).install( new fun2() );
	
		f.getOperatorFactory().setBinaryOperator( "zzz", new ZZZBinaryOperator() );
		f.getOperatorFactory().setBinaryOperator( MINUSOperator.NAME, new NewMinusBinaryOperators() );
		
		f.setSymbolValue( "x1", 10 );
		f.setSymbolValue( "x2", 20 );
		
		int nbError = 0;

		for ( int i = 0 /* ( exprs.length / 2 ) - 1*/; i < ( exprs.length / 2 ); i++ ) {
			String expr = ( String )exprs[ i * 2 ];
			f.setExpression( expr );
			try {
				Variant v = f.evaluate();
				System.out.println( expr + "=" + v );
				if ( !v.getObjectResult().equals( exprs[ ( i * 2 ) + 1 ] ) ) {
					System.out.println( "************** Wrong result WAIT FOR " + exprs[ ( i * 2 ) + 1 ] );
					nbError++;
				}
			} catch( EvaluateException exc ) {
				System.out.println( expr + "=>" + exc.getMessage() );
				// exc.printStackTrace();
			}
		}

		System.out.println();
		if ( nbError == 0 )
			System.out.println( "No Error" );
		else
			System.out.println( nbError + " errors ");
	}

	public static void main( String[] args ) throws Throwable {

		Object[] exprs1 = {
				"1", new Double( 1 ),
				"-1", new Double( -1 ),
				"-1+1", new Double( -1 + 1 ),
				"-(1+1)", new Double( -2 ),
				"1+1", new Double( 2 ),
				"(1)", new Double( 1 ),
				"(1+1)", new Double( 2 ),
				"[1-2]", new Double( 1 ),
				"[3-1]", new Double( 2 ),
				"1-1", new Double( 0 ),
				"1-1+1", new Double( 1 ),
				"1-(1+1)", new Double( -1 ),
				"2*3", new Double( 6 ),
				"2/3", new Double( 2.0 / 3.0 ),
				"2*3/4", new Double( 2.0 * 3.0 / 4.0 ),
				"1+2*3", new Double( 1.0 + 2.0 * 3.0 ),
				"1-2*3", new Double( 1.0 - 2.0 * 3.0 ),
				"1/2+3", new Double( 1.0 / 2.0 + 3.0 ),
				"2*3-1", new Double( 2.0 * 3.0 - 1.0 ),
				"2^3", new Double( Math.pow( 2.0, 3.0 ) ),
				"5%3", new Double( 5.0 % 3.0 ),
				"-'a'", null,
				"1%0", null,
				"1/0", null,
				"1>2", new Boolean( false ),
				"1<2", new Boolean( true ),
				"2>=2", new Boolean( true ),
				"2>2", new Boolean( false ),
				"2<=2", new Boolean( true ),
				"2<2", new Boolean( false ),
				"1==1", new Boolean( true ),
				"1==2", new Boolean( false ),
				"1!=1", new Boolean( false ),
				"1!=2", new Boolean( true ),
				"1<>2", new Boolean( true ),
				"'a'>='b'", new Boolean( "a".compareTo( "b" ) >= 0 ),
				"'a'>'b'", new Boolean( "a".compareTo( "b" ) > 0 ),
				"'a'<'b'", new Boolean( "a".compareTo( "b" ) < 0 ),
				"'a'<='b'", new Boolean( "a".compareTo( "b" ) <= 0 ),
				"'a'<='b'", new Boolean( "a".compareTo( "b" ) <= 0 ),
				"'a'=='b'", new Boolean( "a".compareTo( "b" ) == 0 ),
				"'a'!='b'", new Boolean( "a".compareTo( "b" ) != 0 ),
				"'a'=='a'", new Boolean( "a".compareTo( "a" ) == 0 ),
				"'a'<>'a'", new Boolean( "a".compareTo( "a" ) != 0 ),
				"a=1", new Double( 1 ),
				"a", new Double( 1 ),
				"a=(a*a*2)", new Double( 2 ),
				"a", new Double( 2 ),
				"b=TRUE", new Boolean( true ),
				"c=false", new Boolean( false ),
				"d='ok'", "ok",
				"d", "ok",
				"!true", new Boolean( false ),
				"!false", new Boolean( true ),
				"!(1==1)", new Boolean( false ),
				"!(1!=1)", new Boolean( true ),
				"!1", null,
				"2a", new Double( 4 ),
				"2a+2a", new Double( 8 ),
				"a%", new Double( 0.02 ),
				"80%", new Double( 0.8 ),
				"true and true", new Boolean( true ),
				"true and false", new Boolean( false ),
				"false and false", new Boolean( false ),
				"false and false", new Boolean( false ),
				"true or true", new Boolean( true ),
				"true or false", new Boolean( true ),
				"false or true", new Boolean( true ),
				"false or false", new Boolean( false ),
				"true xor true", new Boolean( true ^ true ),
				"true xor false", new Boolean( true ^ false ),
				"false xor true", new Boolean( false ^ true ),
				"false xor false", new Boolean( false ^ false ),
				"not true", Boolean.FALSE,
				"not ( true or false )", Boolean.FALSE,
				"true equals false", Boolean.FALSE,
				"false equals false", Boolean.TRUE,
				"b=true\na=false\na&&b", new Boolean( false ),
				"b=true\na=false\na||b", new Boolean( true ),
				"b=true\na=false\na~b", new Boolean( true ),
				"if true then 'ok'", "ok",
				"if false then 'ok'", "No result",
				"if true then 'ok' else 'error'", "ok",
				"if false then 'error' else 'ok'", "ok",
				"b=true\na=false\nif ( a || b) then a else b", new Boolean( false ),
				"( 1 >= 2 || 2 >= 3 )", new Boolean( false ),
				"if ( 1 >= 2 || 3 >= 3 ) then 'ok' else 'error'", "ok",
				"b=true\nif ( b != false ) then 'ok'", "ok",
				"a=1\nif ( a > 1 || ( a != 2 || a == 1 ) ) then 'ok'", "ok",
				"cos( 1 )", new Double( Math.cos( 1 ) ),
				"cos( 2 ) + sin( 1 )", new Double( Math.cos( 2 ) + Math.sin( 1 ) ),  
		};
		
		run( false, exprs1 );

		Object[] exprs2 = {
				"1", new BigDecimal( 1 ),
				"-1", new BigDecimal( -1 ),
				"-1+1", new BigDecimal( -1 + 1 ),
				"1+1", new BigDecimal( 2 ),
				"(1)", new BigDecimal( 1 ),
				"(1+1)", new BigDecimal( 2 ),
				"[1-2]", new BigDecimal( 1 ),
				"[3-1]", new BigDecimal( 2 ),
				"1-1", new BigDecimal( 0 ),
				"1-1+1", new BigDecimal( 1 ),
				"1-(1+1)", new BigDecimal( -1 ),
				"2*3", new BigDecimal( 6 ),
				"2/3", new BigDecimal( 2.0 ).divide( new BigDecimal( 3.0 ), Formula.DEF_HP_SCALE, Formula.DEF_ROUNDING_MODE ),
				"2*3/4", new BigDecimal( 2.0 ).multiply( new BigDecimal( 3.0 ).divide( new BigDecimal( 4.0 ), Formula.DEF_HP_SCALE, Formula.DEF_ROUNDING_MODE ) ), 
				"1+2*3", new BigDecimal( 1.0 ).add( ( new BigDecimal( 2.0 ) ).multiply( new BigDecimal( 3.0 ) ) ),
				"1-2*3", new BigDecimal( 1.0 ).subtract( new BigDecimal( 2.0 ).multiply( new BigDecimal( 3.0 ) ) ),
				"1/2+3", new BigDecimal( 1.0 ).divide( new BigDecimal( 2.0 ), Formula.DEF_HP_SCALE, Formula.DEF_ROUNDING_MODE ).add( new BigDecimal( 3.0 ) ),
				"2*3-1", ( new BigDecimal( 2.0 ).multiply( new BigDecimal( 3.0 ) ) ).subtract( new BigDecimal( 1.0 ) ),
				"2^3", new BigDecimal( Math.pow( 2.0, 3.0 ) ),
				"5%3", new BigDecimal( 5.0 % 3.0 ),
				"-'a'", null,
				"1%0", null,
				"1/0", null,
				"1>2", new Boolean( false ),
				"1<2", new Boolean( true ),
				"2>=2", new Boolean( true ),
				"2>2", new Boolean( false ),
				"2<=2", new Boolean( true ),
				"2<2", new Boolean( false ),
				"1==1", new Boolean( true ),
				"1==2", new Boolean( false ),
				"1!=1", new Boolean( false ),
				"1!=2", new Boolean( true ),
				"1<>2", new Boolean( true ),
				"'a'>='b'", new Boolean( "a".compareTo( "b" ) >= 0 ),
				"'a'>'b'", new Boolean( "a".compareTo( "b" ) > 0 ),
				"'a'<'b'", new Boolean( "a".compareTo( "b" ) < 0 ),
				"'a'<='b'", new Boolean( "a".compareTo( "b" ) <= 0 ),
				"'a'<='b'", new Boolean( "a".compareTo( "b" ) <= 0 ),
				"'a'=='b'", new Boolean( "a".compareTo( "b" ) == 0 ),
				"'a'!='b'", new Boolean( "a".compareTo( "b" ) != 0 ),
				"'a'=='a'", new Boolean( "a".compareTo( "a" ) == 0 ),
				"'a'<>'a'", new Boolean( "a".compareTo( "a" ) != 0 ),
				"a=1", new BigDecimal( 1 ),
				"a", new BigDecimal( 1 ),
				"a=(a*a*2)", new BigDecimal( 2 ),
				"a", new BigDecimal( 2 ),
				"b=TRUE", new Boolean( true ),
				"c=false", new Boolean( false ),
				"d='ok'", "ok",
				"d", "ok",
				"!true", new Boolean( false ),
				"!false", new Boolean( true ),
				"!(1==1)", new Boolean( false ),
				"!(1!=1)", new Boolean( true ),
				"!1", null,
				"2a", new BigDecimal( 4 ),
				"2a+2a", new BigDecimal( 8 ),
				"a%", new BigDecimal( 2 ).divide( new BigDecimal( 100 ), Formula.DEF_HP_SCALE, Formula.DEF_ROUNDING_MODE ),
				"80%", new BigDecimal( 80 ).divide( new BigDecimal( 100 ), Formula.DEF_HP_SCALE, Formula.DEF_ROUNDING_MODE ), 
				"true and true", new Boolean( true ),
				"true and false", new Boolean( false ),
				"false and false", new Boolean( false ),
				"false and false", new Boolean( false ),
				"true or true", new Boolean( true ),
				"true or false", new Boolean( true ),
				"false or true", new Boolean( true ),
				"false or false", new Boolean( false ),
				"true xor true", new Boolean( true ^ true ),
				"true xor false", new Boolean( true ^ false ),
				"false xor true", new Boolean( false ^ true ),
				"false xor false", new Boolean( false ^ false ),
				"b=true\na=false\na&&b", new Boolean( false ),
				"b=true\na=false\na||b", new Boolean( true ),
				"b=true\na=false\na~b", new Boolean( true ),
				"if true then 'ok'", "ok",
				"if false then 'ok'", "No result",
				"if true then 'ok' else 'error'", "ok",
				"if false then 'error' else 'ok'", "ok",
				"b=true\na=false\nif ( a || b) then a else b", new Boolean( false ),
				"( 1 >= 2 || 2 >= 3 )", new Boolean( false ),
				"if ( 1 >= 2 || 3 >= 3 ) then 'ok' else 'error'", "ok",
				"b=true\nif ( b != false ) then 'ok'", "ok",
				"a=1\nif ( a > 1 || ( a != 2 || a == 1 ) ) then 'ok'", "ok",
				"cos(2)",new BigDecimal( Math.cos( 2 ) ),
				"cos(2)+1", new BigDecimal( Math.cos( 2 ) ).add( new BigDecimal( 1 ) ) 
		};

		run( true, exprs2 ); 

		Vector v1 = new Vector();
		v1.addElement( new Variant( new Double( 1 ) ) );
		v1.addElement( new Variant( new Double( 2 ) ) );

		Vector v2 = new Vector( v1 );
		v2.addElement( new Variant( v1 ) );

		Vector v3 = new Vector();
		v3.addElement( new Variant( new Double( 1 ) ) );
		v3.addElement( new Variant( new Double( 2 ) ) );
		v3.addElement( new Variant( new Double( 3 ) ) );
		v3.addElement( new Variant( new Double( 4 ) ) );

		Vector v4 = new Vector();
		v4.addElement( new Variant( new Double( 1 ) ) );
		v4.addElement( new Variant( new Double( 2 ) ) );
		v4.addElement( new Variant( new Double( 3 ) ) );

		Object[] expr3 = new Object[] {
				"(1,2)", v1,
				"(1,2,(1,2))", v2,
				"2*max(1,2,3)", new Double( 6 ),
				"strlen('test')", new Double( 4 ),
				"zz + hh", new Double( 5 ),
				"rr + hh", new Double( 5 ),
				"test1( 'ok?', 2 )", "ok",
				"test2( 'aa', 'bb', 'cc')", "aabbcc",
				"test3( 'a', ( 'b', 'a', 'd', 'z' ) )", Boolean.TRUE,
				"test3( 'a', ( 'b', 'a1', 'd', 'z' ) )", Boolean.FALSE,
				"test4( 1, 2 , 4, false )", new Double( 7 ),
				"summ( 1 , 2 , 3 )", new Double( 6 ),
				"ind( 2, ( 4, 5, 6, 2 ) )", Boolean.TRUE,
				"2 in ( 5, 6 )", Boolean.FALSE,
				"2 in ( 1, 2, 4 )", Boolean.TRUE,
				"(1,2)+(3,4)", v3,
				"(1,2)+3", v4,
				"3+(1,2)", v4,
				"'a'+'b'", "ab",
				"(1,2,3,4)-4", v4,
				"(1,2,3,4)-(3,4)", v1,
				"x1+x2", new Double( 30 ),
				"x1+1", new Double( 11 ),
				"1 zzz 2", new Double( ( 1.0 + 2.0 ) / 2.0 ),
				"2x1", new Double( 20 ),
				"'abc'-'ab'", "c"
		};

		run( false, expr3 );


		System.exit( 0 ); // Due to the unregistered version protection
	}

	///////////////////////////////////////////////////////////////////////////

	// New functions
	
	/** Install a new sum function */
	static class fun1 extends AbstractFunction {
		public fun1() {
			super( "summ", AbstractFunction.ANY ); 
		}

		public Variant evaluate(ListOfArgument args) {
			double sum = 0;
			for ( int i = 0; i < args.getArgumentCount(); i++ ) {
				Variant v = args.getArgumentAt( i );
				if ( v.isDouble() )
					sum += v.getDoubleValue();
			}
			return new Variant( sum );
		}
	}

	/** Install a new in function */
	static class fun2 extends AbstractFunction {
		public fun2() {
			super( "ind", new Class[] { Double.class, Vector.class } );
		}

		public Variant evaluate( ListOfArgument args ) {
			double d = args.getArgumentAt( 0 ).getDoubleValue();
			Vector l = args.getArgumentAt( 1 ).getListValue();
			return new Variant( l.contains( new Variant( d ) ) );
		}

	}

	// New operators
	
	static class ZZZBinaryOperator implements BinaryOperator {
		public Object eval(OperatorContext context) throws EvaluateException {
			Double d1 = (Double)context.getValue1();
			Double d2 = (Double)context.getValue2();
			return new Double( ( d1.doubleValue() + d2.doubleValue() ) / 2.0 );
		}
	}

	static class NewMinusBinaryOperators implements BinaryOperator {
		public Object eval(OperatorContext context) throws EvaluateException {
			Object o = context.getValue1();
			if ( o instanceof String ) {
				String s1 = (String)o;
				String s2 = (String)context.getValue2();
				int i = 0;
				for ( i = 0; i < Math.min( s1.length(), s2.length() ) && s1.charAt( i ) == s2.charAt( i ); i++ ) {}
				if ( i > 0 )
					return s1.substring( i );
			}
			MINUSOperator delegate = new MINUSOperator();
			return delegate.eval( context );
		}
	}

}
