/*
 * Decompiled with CFR 0.152.
 */
package stec.xpos;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import stec.pos.ByteArray;
import stec.pos.Common;
import stec.xpos.KeysStore;
import stec.xpos.ObjectStore;
import stec.xpos.ObjectStoreReference;
import stec.xpos.ValuesStore;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class CheckObjectStore {
    private boolean int;
    private boolean char;
    private boolean byte;
    private boolean else = true;
    private ObjectStoreReference for;
    private long do;
    private long if;
    private long try;
    private long new;
    private long goto;
    private long a;
    private boolean case;

    public static final void main(String[] stringArray) throws Throwable {
        Common.logo("Persistent Object Store Checker");
        if (stringArray.length < 1) {
            System.out.println("Usage: <java> stec.xpos.CheckObjectStore <options> <store>");
            System.out.println();
            System.out.println("Options:");
            System.out.println("-d            do not display progress");
            System.out.println("-l            check links");
            System.out.println("-u            display utilization");
            System.out.println("-v            verbose messages");
            return;
        }
        CheckObjectStore.check(stringArray);
    }

    public static final boolean check(String[] stringArray) throws Throwable {
        String string;
        int n;
        CheckObjectStore checkObjectStore = new CheckObjectStore();
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).charAt(0) == '-'; ++n) {
            if (string.equalsIgnoreCase("-d")) {
                checkObjectStore.else = false;
                continue;
            }
            if (string.equalsIgnoreCase("-l")) {
                checkObjectStore.char = true;
                continue;
            }
            if (string.equalsIgnoreCase("-u")) {
                checkObjectStore.byte = true;
                continue;
            }
            if (string.equalsIgnoreCase("-v")) {
                checkObjectStore.int = true;
                continue;
            }
            System.out.println("Invalid parameter: ".concat(String.valueOf(String.valueOf(string))));
            return false;
        }
        if (n >= n2) {
            System.out.println("Store was not specified.");
            return false;
        }
        try {
            if (!checkObjectStore.if(stringArray[n])) {
                boolean bl = false;
                return bl;
            }
            if (checkObjectStore.byte) {
                checkObjectStore.a(stringArray[n]);
            }
        }
        catch (Exception exception) {
            throw Common.getRootCause(exception);
        }
        return true;
    }

    public static final boolean check(String[] stringArray, String[] stringArray2) {
        boolean bl = true;
        int n = stringArray2.length;
        String[] stringArray3 = new String[n + 1];
        System.arraycopy(stringArray2, 0, stringArray3, 0, n);
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray[i];
            System.out.print(String.valueOf(String.valueOf(string)).concat(": "));
            stringArray3[n] = string;
            try {
                boolean bl2 = CheckObjectStore.check(stringArray3);
                if (bl2) {
                    System.out.println("PASSED");
                    continue;
                }
                bl = false;
                System.out.println("FAILED");
                continue;
            }
            catch (Throwable throwable) {
                bl = false;
                System.out.println("FAILED");
                throwable.printStackTrace();
            }
        }
        return bl;
    }

    private final boolean a(RandomAccessFile randomAccessFile, String string) throws IOException {
        int n = randomAccessFile.readInt();
        if (this.int) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" volume descriptor count: ").append(n))));
        }
        if (n < 1) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" volume descriptor count must be at least one (1): ").append(n))));
            return false;
        }
        for (int i = 0; i < n; ++i) {
            File file;
            String string2 = randomAccessFile.readUTF();
            if (this.int) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" volume descriptor file name: ").append(string2))));
            }
            if (!(file = new File(string2)).exists()) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" volume descriptor filename must not be a directory: ").append(string2))));
                return false;
            }
            if (file.isDirectory()) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" volume descriptor filename must not be a directory: ").append(string2))));
                return false;
            }
            long l = randomAccessFile.readLong();
            if (this.int) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" volume descriptor maximum page count: ").append(l))));
            }
            if (i == n - 1) {
                if (l >= (long)1 || l == (long)-1) continue;
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" volume descriptor maximum page count must be at least one (1): ").append(l))));
                return false;
            }
            if (l >= (long)1) continue;
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" volume descriptor maximum page count must be at least one (1): ").append(l))));
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean if(String string) throws Exception {
        boolean bl;
        block48: {
            boolean bl2;
            block47: {
                boolean bl3;
                block46: {
                    boolean bl4;
                    block45: {
                        boolean bl5;
                        block44: {
                            boolean bl6;
                            block43: {
                                boolean bl7;
                                block42: {
                                    boolean bl8;
                                    block41: {
                                        boolean bl9;
                                        block40: {
                                            boolean bl10;
                                            block39: {
                                                boolean bl11;
                                                block38: {
                                                    boolean bl12;
                                                    block37: {
                                                        RandomAccessFile randomAccessFile;
                                                        block35: {
                                                            boolean bl13;
                                                            block36: {
                                                                boolean bl14;
                                                                block34: {
                                                                    boolean bl15;
                                                                    block33: {
                                                                        boolean bl16;
                                                                        block32: {
                                                                            boolean bl17;
                                                                            block31: {
                                                                                boolean bl18;
                                                                                block30: {
                                                                                    File file;
                                                                                    if (this.int) {
                                                                                        System.out.println("Checking object store");
                                                                                    }
                                                                                    if (this.int) {
                                                                                        System.out.println("Store: ".concat(String.valueOf(String.valueOf(string))));
                                                                                    }
                                                                                    if (!(file = new File(string)).exists()) {
                                                                                        System.out.println("Store does not exist: ".concat(String.valueOf(String.valueOf(string))));
                                                                                        return false;
                                                                                    }
                                                                                    if (file.isDirectory()) {
                                                                                        System.out.println("Store can not be a directory: ".concat(String.valueOf(String.valueOf(string))));
                                                                                        return false;
                                                                                    }
                                                                                    this.do = file.length();
                                                                                    if (this.int) {
                                                                                        System.out.println("Store file length: ".concat(String.valueOf(String.valueOf(this.do))));
                                                                                    }
                                                                                    if (this.do < (long)ObjectStore.else) {
                                                                                        System.out.println("Store file length is too small.");
                                                                                        System.out.println("Minimum store file length: ".concat(String.valueOf(String.valueOf(ObjectStore.else))));
                                                                                        System.out.println("Current mapper file length: ".concat(String.valueOf(String.valueOf(this.do))));
                                                                                        return false;
                                                                                    }
                                                                                    randomAccessFile = new RandomAccessFile(string, "rw");
                                                                                    try {
                                                                                        randomAccessFile.seek(0L);
                                                                                        byte by = randomAccessFile.readByte();
                                                                                        if (this.int) {
                                                                                            System.out.println("Store type: ".concat(String.valueOf(String.valueOf(by))));
                                                                                        }
                                                                                        if (by != ObjectStore.goto) {
                                                                                            System.out.println("Store type mismatch.");
                                                                                            System.out.println("Required store type: ".concat(String.valueOf(String.valueOf(ObjectStore.goto))));
                                                                                            System.out.println("Current store type: ".concat(String.valueOf(String.valueOf(by))));
                                                                                            bl18 = false;
                                                                                            Object var8_7 = null;
                                                                                            break block30;
                                                                                        }
                                                                                        short s = randomAccessFile.readShort();
                                                                                        if (this.int) {
                                                                                            System.out.println("Store version: ".concat(String.valueOf(String.valueOf(s))));
                                                                                        }
                                                                                        if (s != ObjectStore.void) {
                                                                                            System.out.println("Store version mismatch.");
                                                                                            System.out.println("Required store version: ".concat(String.valueOf(String.valueOf(ObjectStore.void))));
                                                                                            System.out.println("Current store version: ".concat(String.valueOf(String.valueOf(s))));
                                                                                            bl17 = false;
                                                                                            break block31;
                                                                                        }
                                                                                        if (!this.a(randomAccessFile, "Table")) {
                                                                                            bl16 = false;
                                                                                            break block32;
                                                                                        }
                                                                                        if (!this.a(randomAccessFile, "Mapper")) {
                                                                                            bl15 = false;
                                                                                            break block33;
                                                                                        }
                                                                                        if (!this.a(randomAccessFile, "Keys")) {
                                                                                            bl14 = false;
                                                                                            break block34;
                                                                                        }
                                                                                        if (this.a(randomAccessFile, "Values")) break block35;
                                                                                        bl13 = false;
                                                                                        break block36;
                                                                                    }
                                                                                    catch (Throwable throwable) {
                                                                                        Object var8_14 = null;
                                                                                        randomAccessFile.close();
                                                                                        throw throwable;
                                                                                    }
                                                                                }
                                                                                randomAccessFile.close();
                                                                                return bl18;
                                                                            }
                                                                            Object var8_8 = null;
                                                                            randomAccessFile.close();
                                                                            return bl17;
                                                                        }
                                                                        Object var8_9 = null;
                                                                        randomAccessFile.close();
                                                                        return bl16;
                                                                    }
                                                                    Object var8_10 = null;
                                                                    randomAccessFile.close();
                                                                    return bl15;
                                                                }
                                                                Object var8_11 = null;
                                                                randomAccessFile.close();
                                                                return bl14;
                                                            }
                                                            Object var8_12 = null;
                                                            randomAccessFile.close();
                                                            return bl13;
                                                        }
                                                        Object var8_13 = null;
                                                        randomAccessFile.close();
                                                        this.for = ObjectStore.do(string);
                                                        if (this.for == null) {
                                                            System.out.println("Store is in use: ".concat(String.valueOf(String.valueOf(string))));
                                                            return false;
                                                        }
                                                        try {
                                                            if (!this.if()) {
                                                                bl12 = false;
                                                                Object var11_33 = null;
                                                                break block37;
                                                            }
                                                            if (!this.else()) {
                                                                bl11 = false;
                                                                break block38;
                                                            }
                                                            if (!this.new()) {
                                                                bl10 = false;
                                                                break block39;
                                                            }
                                                            if (!this.for()) {
                                                                bl9 = false;
                                                                break block40;
                                                            }
                                                            if (!this.a()) {
                                                                bl8 = false;
                                                                break block41;
                                                            }
                                                            if (!this.byte()) {
                                                                bl7 = false;
                                                                break block42;
                                                            }
                                                            if (!this.do()) {
                                                                bl6 = false;
                                                                break block43;
                                                            }
                                                            if (this.char) {
                                                                if (!this.try()) {
                                                                    bl5 = false;
                                                                    break block44;
                                                                }
                                                                if (!this.case()) {
                                                                    bl4 = false;
                                                                    break block45;
                                                                }
                                                                if (!this.int()) {
                                                                    bl3 = false;
                                                                    break block46;
                                                                }
                                                            }
                                                            if (!this.char()) {
                                                                bl2 = false;
                                                                break block47;
                                                            }
                                                            bl = true;
                                                            break block48;
                                                        }
                                                        catch (Throwable throwable) {
                                                            Object var11_45 = null;
                                                            this.for.close();
                                                            throw throwable;
                                                        }
                                                    }
                                                    this.for.close();
                                                    return bl12;
                                                }
                                                Object var11_34 = null;
                                                this.for.close();
                                                return bl11;
                                            }
                                            Object var11_35 = null;
                                            this.for.close();
                                            return bl10;
                                        }
                                        Object var11_36 = null;
                                        this.for.close();
                                        return bl9;
                                    }
                                    Object var11_37 = null;
                                    this.for.close();
                                    return bl8;
                                }
                                Object var11_38 = null;
                                this.for.close();
                                return bl7;
                            }
                            Object var11_39 = null;
                            this.for.close();
                            return bl6;
                        }
                        Object var11_40 = null;
                        this.for.close();
                        return bl5;
                    }
                    Object var11_41 = null;
                    this.for.close();
                    return bl4;
                }
                Object var11_42 = null;
                this.for.close();
                return bl3;
            }
            Object var11_43 = null;
            this.for.close();
            return bl2;
        }
        Object var11_44 = null;
        this.for.close();
        return bl;
    }

    private final boolean if() throws IOException {
        if (this.int) {
            System.out.println("Checking lookup table header");
        }
        if (this.int) {
            System.out.println("Lookup table type: ".concat(String.valueOf(String.valueOf(this.for.a.new.byte))));
        }
        if (this.for.a.new.byte != 4) {
            System.out.println("Lookup table type mismatch.");
            System.out.println("Required lookup table type: 4");
            System.out.println("Current lookup table type: ".concat(String.valueOf(String.valueOf(this.for.a.new.byte))));
            return false;
        }
        if (this.int) {
            System.out.println("Lookup table version: ".concat(String.valueOf(String.valueOf(this.for.a.new.new))));
        }
        if (this.for.a.new.new != 256) {
            System.out.println("Lookup table version mismatch.");
            System.out.println("Required lookup table version: 256");
            System.out.println("Current lookup table version: ".concat(String.valueOf(String.valueOf(this.for.a.new.new))));
            return false;
        }
        long l = this.for.a.new.try;
        if (this.int) {
            System.out.println("Lookup table page count: ".concat(String.valueOf(String.valueOf(l))));
        }
        if (l < (long)1) {
            System.out.println("Mapper lookup table page count must be at least one (1): ".concat(String.valueOf(String.valueOf(l))));
            return false;
        }
        long l2 = 0L;
        int n = this.for.a.new.else.length;
        for (int i = 0; i < n; ++i) {
            File file;
            long l3;
            String string = this.for.a.new.else[i].if;
            long l4 = this.for.a.new.else[i].a;
            if (l4 < (long)1) {
                System.out.println("Lookup table maximum page count must be greater or equal to 1: ");
                System.out.println("Lookup table maximum page count: ".concat(String.valueOf(String.valueOf(l4))));
                System.out.println("Volume file name: ".concat(String.valueOf(String.valueOf(string))));
                return false;
            }
            l2 += l4;
            long l5 = i == 0 ? 22L + l4 * 8L : 11L + l4 * 8L;
            if (l5 == (l3 = (file = new File(string)).length())) continue;
            System.out.println("Lookup table file length is not correct.");
            System.out.println("Current lookup table file length: ".concat(String.valueOf(String.valueOf(l3))));
            System.out.println("Estimated lookup table file length: ".concat(String.valueOf(String.valueOf(l5))));
            System.out.println("Volume lookup table file name: ".concat(String.valueOf(String.valueOf(string))));
            return false;
        }
        if (this.int) {
            System.out.println("Lookup table total page count: ".concat(String.valueOf(String.valueOf(l2))));
        }
        if (l2 != this.for.a.new.try) {
            System.out.println("Lookup table page count is not correct.");
            System.out.println("Current lookup table page count: ".concat(String.valueOf(String.valueOf(this.for.a.new.try))));
            System.out.println("Estimated lookup table page count: ".concat(String.valueOf(String.valueOf(l2))));
            return false;
        }
        return true;
    }

    private final boolean else() throws IOException {
        if (this.int) {
            System.out.println("Checking mapper header");
        }
        if (this.int) {
            System.out.println("Mapper type: ".concat(String.valueOf(String.valueOf(this.for.a.do.if))));
        }
        if (this.for.a.do.if != 5) {
            System.out.println("Mapper type mismatch.");
            System.out.println("Required mapper type: 5");
            System.out.println("Current mapper type: ".concat(String.valueOf(String.valueOf(this.for.a.do.if))));
            return false;
        }
        if (this.int) {
            System.out.println("Mapper version: ".concat(String.valueOf(String.valueOf(this.for.a.do.do))));
        }
        if (this.for.a.do.do != 256) {
            System.out.println("Mapper version mismatch.");
            System.out.println("Required mapper version: 256");
            System.out.println("Current mapper version: ".concat(String.valueOf(String.valueOf(this.for.a.do.do))));
            return false;
        }
        if (this.int) {
            System.out.println("Mapper page count: ".concat(String.valueOf(String.valueOf(this.for.a.do.h))));
        }
        if (this.for.a.do.h < (long)0) {
            System.out.println("Mapper page count must be at least zero (0): ".concat(String.valueOf(String.valueOf(this.for.a.do.h))));
            return false;
        }
        if (this.int) {
            System.out.println("Mapper maximum page count: ".concat(String.valueOf(String.valueOf(this.for.a.do.o))));
        }
        if (this.for.a.do.o != (long)-1 && this.for.a.do.h > this.for.a.do.o) {
            System.out.println("Mapper page count exceeds maximum page count.");
            System.out.println("Mapper maximum page count: ".concat(String.valueOf(String.valueOf(this.for.a.do.o))));
            System.out.println("Mapper page count: ".concat(String.valueOf(String.valueOf(this.for.a.do.h))));
            return false;
        }
        long l = this.for.a.do.else;
        if (this.int) {
            System.out.println("Mapper free list page number: ".concat(String.valueOf(String.valueOf(l))));
        }
        if (l < (long)-1) {
            System.out.println("Mapper free list page number is not valid ".concat(String.valueOf(String.valueOf(l))));
            return false;
        }
        if (l >= this.for.a.do.h) {
            System.out.println("Mapper free list page number exceeds page count.");
            System.out.println("Mapper page count: ".concat(String.valueOf(String.valueOf(this.for.a.do.h))));
            System.out.println("Mapper free list page number: ".concat(String.valueOf(String.valueOf(l))));
            return false;
        }
        if (this.int) {
            System.out.println("Mapper free count: ".concat(String.valueOf(String.valueOf(this.for.a.do.m))));
        }
        if (this.int) {
            System.out.println("Mapper record count: ".concat(String.valueOf(String.valueOf(this.for.a.do.e))));
        }
        if (this.for.a.do.e < (long)0) {
            System.out.println("Mapper record count must be at least zero (0): ".concat(String.valueOf(String.valueOf(this.for.a.do.e))));
            return false;
        }
        if (this.for.a.do.e > this.for.a.do.h) {
            System.out.println("Mapper record count exceeds page count.");
            System.out.println("Mapper page count: ".concat(String.valueOf(String.valueOf(this.for.a.do.h))));
            System.out.println("Mapper record count: ".concat(String.valueOf(String.valueOf(this.for.a.do.e))));
            return false;
        }
        long l2 = 0L;
        int n = this.for.a.do.q.length;
        for (int i = 0; i < n; ++i) {
            File file;
            long l3;
            long l4;
            String string = this.for.a.do.q[i].if;
            long l5 = this.for.a.do.q[i].a;
            if (i == n - 1) {
                if (l5 < (long)1 && l5 != (long)-1) {
                    System.out.println("Mapper maximum page count must be greater or equal to 1.");
                    System.out.println("Maximum page count: ".concat(String.valueOf(String.valueOf(l5))));
                    System.out.println("Volume file name: ".concat(String.valueOf(String.valueOf(string))));
                    return false;
                }
            } else if (l5 < (long)1) {
                System.out.println("Mapper maximum page count must be greater or equal to 1.");
                System.out.println("Mapper maximum page count: ".concat(String.valueOf(String.valueOf(l5))));
                System.out.println("Volume file name: ".concat(String.valueOf(String.valueOf(string))));
                return false;
            }
            l2 = l5 == (long)-1 ? -1L : (l2 += l5);
            if (l5 == (long)-1 || (l4 = i == 0 ? 54L + l5 * 49L : 11L + l5 * 49L) == (l3 = (file = new File(string)).length())) continue;
            System.out.println("Mapper file length is not correct.");
            System.out.println("Current mapper file length: ".concat(String.valueOf(String.valueOf(l3))));
            System.out.println("Estimated mapper file length: ".concat(String.valueOf(String.valueOf(l4))));
            System.out.println("Volume file name: ".concat(String.valueOf(String.valueOf(string))));
            return false;
        }
        if (this.int) {
            System.out.println("Mapper total page count: ".concat(String.valueOf(String.valueOf(l2))));
        }
        if (l2 != this.for.a.do.o) {
            System.out.println("Mapper maximum page count is not correct.");
            System.out.println("Current mapper maximum page count: ".concat(String.valueOf(String.valueOf(this.for.a.do.o))));
            System.out.println("Estimated mapper maximum page count: ".concat(String.valueOf(String.valueOf(l2))));
            return false;
        }
        return true;
    }

    private final boolean new() throws IOException {
        if (this.int) {
            System.out.println("Checking keys store header");
        }
        if (this.int) {
            System.out.println("Keys store type: ".concat(String.valueOf(String.valueOf(this.for.a.int.if))));
        }
        if (this.for.a.int.if != KeysStore.do) {
            System.out.println("Keys store type mismatch.");
            System.out.println("Required keys store type: ".concat(String.valueOf(String.valueOf(KeysStore.do))));
            System.out.println("Current keys store type: ".concat(String.valueOf(String.valueOf(this.for.a.int.if))));
            return false;
        }
        if (this.int) {
            System.out.println("Keys store version: ".concat(String.valueOf(String.valueOf(this.for.a.int.do))));
        }
        if (this.for.a.int.do != KeysStore.if) {
            System.out.println("Keys store version mismatch.");
            System.out.println("Required keys store version: ".concat(String.valueOf(String.valueOf(KeysStore.if))));
            System.out.println("Current keys store version: ".concat(String.valueOf(String.valueOf(this.for.a.int.do))));
            return false;
        }
        if (this.int) {
            System.out.println("Keys store page length: ".concat(String.valueOf(String.valueOf(this.for.a.int.a))));
        }
        if (this.for.a.int.a < 1) {
            System.out.println("Keys store page length must be at least one (1): ".concat(String.valueOf(String.valueOf(this.for.a.int.a))));
            return false;
        }
        if (this.int) {
            System.out.println("Keys store page count: ".concat(String.valueOf(String.valueOf(this.for.a.int.d))));
        }
        if (this.for.a.int.d < (long)0) {
            System.out.println("Keys store page count must be at least zero (0): ".concat(String.valueOf(String.valueOf(this.for.a.int.d))));
            return false;
        }
        if (this.int) {
            System.out.println("Keys store maximum page count: ".concat(String.valueOf(String.valueOf(this.for.a.int.h))));
        }
        if (this.for.a.int.h != (long)-1 && this.for.a.int.d > this.for.a.int.h) {
            System.out.println("Keys store page count exceeds maximum page count.");
            System.out.println("Keys store maximum page count: ".concat(String.valueOf(String.valueOf(this.for.a.int.h))));
            System.out.println("Keys store page count: ".concat(String.valueOf(String.valueOf(this.for.a.int.d))));
            return false;
        }
        long l = this.for.a.int.byte;
        if (this.int) {
            System.out.println("Keys store free list page number: ".concat(String.valueOf(String.valueOf(l))));
        }
        if (l < (long)-1) {
            System.out.println("Keys store free list page number is not valid ".concat(String.valueOf(String.valueOf(l))));
            return false;
        }
        if (l >= this.for.a.int.d) {
            System.out.println("Keys store free list page number exceeds page count.");
            System.out.println("Keys store page count: ".concat(String.valueOf(String.valueOf(this.for.a.int.d))));
            System.out.println("Keys store free list page number: ".concat(String.valueOf(String.valueOf(l))));
            return false;
        }
        if (this.int) {
            System.out.println("Keys store free count: ".concat(String.valueOf(String.valueOf(this.for.a.int.g))));
        }
        long l2 = 0L;
        int n = this.for.a.int.j.length;
        for (int i = 0; i < n; ++i) {
            File file;
            long l3;
            long l4;
            String string = this.for.a.int.j[i].if;
            long l5 = this.for.a.int.j[i].a;
            if (i == n - 1) {
                if (l5 < (long)1 && l5 != (long)-1) {
                    System.out.println("Keys store maximum page count must be greater or equal to 1.");
                    System.out.println("Keys store maximum page count: ".concat(String.valueOf(String.valueOf(l5))));
                    System.out.println("Volume file name: ".concat(String.valueOf(String.valueOf(string))));
                    return false;
                }
            } else if (l5 < (long)1) {
                System.out.println("Keys store maximum page count must be greater or equal to 1.");
                System.out.println("Keys store maximum page count: ".concat(String.valueOf(String.valueOf(l5))));
                System.out.println("Volume file name: ".concat(String.valueOf(String.valueOf(string))));
                return false;
            }
            l2 = l5 == (long)-1 ? -1L : (l2 += l5);
            int n2 = 9 + this.for.a.int.a;
            if (l5 == (long)-1 || (l4 = i == 0 ? 50L + l5 * (long)n2 : 11L + l5 * (long)n2) == (l3 = (file = new File(string)).length())) continue;
            System.out.println("Keys store file length is not correct.");
            System.out.println("Current keys store file length: ".concat(String.valueOf(String.valueOf(l3))));
            System.out.println("Estimated keys store file length: ".concat(String.valueOf(String.valueOf(l4))));
            System.out.println("Volume file name: ".concat(String.valueOf(String.valueOf(string))));
            return false;
        }
        if (this.int) {
            System.out.println("Keys store total page count: ".concat(String.valueOf(String.valueOf(l2))));
        }
        if (l2 != this.for.a.int.h) {
            System.out.println("Keys store maximum page count is not correct.");
            System.out.println("Current keys store maximum page count: ".concat(String.valueOf(String.valueOf(this.for.a.int.h))));
            System.out.println("Estimated keys store maximum page count: ".concat(String.valueOf(String.valueOf(l2))));
            return false;
        }
        return true;
    }

    private final boolean for() throws IOException {
        if (this.int) {
            System.out.println("Checking values store header");
        }
        if (this.int) {
            System.out.println("Values store type: ".concat(String.valueOf(String.valueOf(this.for.a.char.if))));
        }
        if (this.for.a.char.if != ValuesStore.do) {
            System.out.println("Values store type mismatch.");
            System.out.println("Required values store type: ".concat(String.valueOf(String.valueOf(ValuesStore.do))));
            System.out.println("Current values store type: ".concat(String.valueOf(String.valueOf(this.for.a.char.if))));
            return false;
        }
        if (this.int) {
            System.out.println("Values store version: ".concat(String.valueOf(String.valueOf(this.for.a.char.do))));
        }
        if (this.for.a.char.do != ValuesStore.if) {
            System.out.println("Values store version mismatch.");
            System.out.println("Required values store version: ".concat(String.valueOf(String.valueOf(ValuesStore.if))));
            System.out.println("Current values store version: ".concat(String.valueOf(String.valueOf(this.for.a.char.do))));
            return false;
        }
        if (this.int) {
            System.out.println("Values store page length: ".concat(String.valueOf(String.valueOf(this.for.a.char.a))));
        }
        if (this.for.a.char.a < 1) {
            System.out.println("Values store page length must be at least one (1): ".concat(String.valueOf(String.valueOf(this.for.a.char.a))));
            return false;
        }
        if (this.int) {
            System.out.println("Values store page count: ".concat(String.valueOf(String.valueOf(this.for.a.char.d))));
        }
        if (this.for.a.char.d < (long)0) {
            System.out.println("Values store page count must be at least zero (0): ".concat(String.valueOf(String.valueOf(this.for.a.char.d))));
            return false;
        }
        if (this.int) {
            System.out.println("Values store maximum page count: ".concat(String.valueOf(String.valueOf(this.for.a.char.h))));
        }
        if (this.for.a.char.h != (long)-1 && this.for.a.char.d > this.for.a.char.h) {
            System.out.println("Values store page count exceeds maximum page count.");
            System.out.println("Values store maximum page count: ".concat(String.valueOf(String.valueOf(this.for.a.char.h))));
            System.out.println("Values store page count: ".concat(String.valueOf(String.valueOf(this.for.a.char.d))));
            return false;
        }
        long l = this.for.a.char.byte;
        if (this.int) {
            System.out.println("Values store free list page number: ".concat(String.valueOf(String.valueOf(l))));
        }
        if (l < (long)-1) {
            System.out.println("Values store free list page number is not valid ".concat(String.valueOf(String.valueOf(l))));
            return false;
        }
        if (l >= this.for.a.char.d) {
            System.out.println("Values store free list page number exceeds page count.");
            System.out.println("Values store page count: ".concat(String.valueOf(String.valueOf(this.for.a.char.d))));
            System.out.println("Values store free list page number: ".concat(String.valueOf(String.valueOf(l))));
            return false;
        }
        if (this.int) {
            System.out.println("Values store free count: ".concat(String.valueOf(String.valueOf(this.for.a.char.g))));
        }
        long l2 = 0L;
        int n = this.for.a.char.j.length;
        for (int i = 0; i < n; ++i) {
            File file;
            long l3;
            long l4;
            String string = this.for.a.char.j[i].if;
            long l5 = this.for.a.char.j[i].a;
            if (i == n - 1) {
                if (l5 < (long)1 && l5 != (long)-1) {
                    System.out.println("Values store maximum page count must be greater or equal to 1.");
                    System.out.println("Values store maximum page count: ".concat(String.valueOf(String.valueOf(l5))));
                    System.out.println("Volume file name: ".concat(String.valueOf(String.valueOf(string))));
                    return false;
                }
            } else if (l5 < (long)1) {
                System.out.println("Values store maximum page count must be greater or equal to 1.");
                System.out.println("Values store maximum page count: ".concat(String.valueOf(String.valueOf(l5))));
                System.out.println("Volume file name: ".concat(String.valueOf(String.valueOf(string))));
                return false;
            }
            l2 = l5 == (long)-1 ? -1L : (l2 += l5);
            int n2 = 9 + this.for.a.char.a;
            if (l5 == (long)-1 || (l4 = i == 0 ? 50L + l5 * (long)n2 : 11L + l5 * (long)n2) == (l3 = (file = new File(string)).length())) continue;
            System.out.println("Values store file length is not correct.");
            System.out.println("Current values store file length: ".concat(String.valueOf(String.valueOf(l3))));
            System.out.println("Estimated values store file length: ".concat(String.valueOf(String.valueOf(l4))));
            System.out.println("Volumes file name: ".concat(String.valueOf(String.valueOf(string))));
            return false;
        }
        if (this.int) {
            System.out.println("Values store total page count: ".concat(String.valueOf(String.valueOf(l2))));
        }
        if (l2 != this.for.a.char.h) {
            System.out.println("Values store maximum page count is not correct.");
            System.out.println("Current values store maximum page count: ".concat(String.valueOf(String.valueOf(this.for.a.char.h))));
            System.out.println("Estimates values store maximum page count: ".concat(String.valueOf(String.valueOf(l2))));
            return false;
        }
        return true;
    }

    private final boolean a() throws IOException {
        if (this.int) {
            System.out.println("Checking mapper free list");
        }
        long l = this.for.a.do.else;
        long l2 = 0L;
        long l3 = this.for.a.do.m;
        long l4 = this.for.a.do.h;
        long l5 = -1L;
        while (l != (long)-1) {
            ++l2;
            if (this.int && this.else) {
                Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(l2))).append(" - ").append(l3).append(": ").append((int)((double)l2 / (double)l3 * 100.0)).append("%"))));
                this.case = true;
            }
            if (l < (long)0) {
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Mapper page number is not valid: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
            if (l >= l4) {
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Mapper page exceeds page count.");
                System.out.println("Mapper page count: ".concat(String.valueOf(String.valueOf(l4))));
                System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
            this.for.a.do.do(l);
            byte[] byArray = this.for.a.do.new;
            byte by = ByteArray.getByte(byArray, 0);
            if (by != 0) {
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Mapper page is not available.");
                System.out.println("Mapper page flags: ".concat(String.valueOf(String.valueOf(by))));
                System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
            long l6 = ByteArray.getLong(byArray, 1);
            if (l6 != l5) {
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Mapper previous page is not correct.");
                System.out.println("Mapper last page number: ".concat(String.valueOf(String.valueOf(l5))));
                System.out.println("Mapper previous page number: ".concat(String.valueOf(String.valueOf(l6))));
                System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
            l5 = l;
            l = ByteArray.getLong(byArray, 9);
        }
        if (this.case) {
            System.out.println();
            this.case = false;
        }
        if (l2 != this.for.a.do.m) {
            System.out.println("Mapper free list page count is not correct.");
            System.out.println("Current mapper free list page count: ".concat(String.valueOf(String.valueOf(this.for.a.do.m))));
            System.out.println("Estimated free list page count: ".concat(String.valueOf(String.valueOf(l2))));
            return false;
        }
        return true;
    }

    private final boolean byte() throws IOException {
        if (this.int) {
            System.out.println("Checking keys store free list");
        }
        long l = this.for.a.int.byte;
        long l2 = 0L;
        long l3 = this.for.a.int.g;
        long l4 = this.for.a.int.d;
        while (l != (long)-1) {
            ++l2;
            if (this.int && this.else) {
                Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(l2))).append(" - ").append(l3).append(": ").append((int)((double)l2 / (double)l3 * 100.0)).append("%"))));
                this.case = true;
            }
            if (l < (long)0) {
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Keys store page number is not valid: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
            if (l >= l4) {
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Keys store page exceeds page count.");
                System.out.println("Keys store page count: ".concat(String.valueOf(String.valueOf(l4))));
                System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
            this.for.a.int.int(l);
            byte by = ByteArray.getByte(this.for.a.int.new, 0);
            if (by != 0) {
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Keys store page is not available.");
                System.out.println("Keys store page flags: ".concat(String.valueOf(String.valueOf(by))));
                System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
            l = ByteArray.getLong(this.for.a.int.new, 1);
        }
        if (this.case) {
            System.out.println();
            this.case = false;
        }
        if (l2 != this.for.a.int.g) {
            System.out.println("Keys store free list page count is not correct.");
            System.out.println("Current keys store free list page count: ".concat(String.valueOf(String.valueOf(this.for.a.int.g))));
            System.out.println("Estimated keys store free list page count: ".concat(String.valueOf(String.valueOf(l2))));
            return false;
        }
        return true;
    }

    private final boolean do() throws IOException {
        if (this.int) {
            System.out.println("Checking Values store free list");
        }
        long l = this.for.a.char.byte;
        long l2 = 0L;
        long l3 = this.for.a.char.g;
        long l4 = this.for.a.char.d;
        while (l != (long)-1) {
            ++l2;
            if (this.int && this.else) {
                Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(l2))).append(" - ").append(l3).append(": ").append((int)((double)l2 / (double)l3 * 100.0)).append("%"))));
                this.case = true;
            }
            if (l < (long)0) {
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Values store page number is not valid: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
            if (l >= l4) {
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Values store page exceeds page count.");
                System.out.println("Values store page count: ".concat(String.valueOf(String.valueOf(l4))));
                System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
            this.for.a.char.int(l);
            byte by = ByteArray.getByte(this.for.a.char.new, 0);
            if (by != 0) {
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Values store page is not available.");
                System.out.println("Values store page flags: ".concat(String.valueOf(String.valueOf(by))));
                System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(l))));
                return false;
            }
            l = ByteArray.getLong(this.for.a.char.new, 1);
        }
        if (this.case) {
            System.out.println();
            this.case = false;
        }
        if (l2 != this.for.a.char.g) {
            System.out.println("Values store free list page count is not correct.");
            System.out.println("Current values store free list page count: ".concat(String.valueOf(String.valueOf(this.for.a.char.g))));
            System.out.println("Estimates values store free list page count: ".concat(String.valueOf(String.valueOf(l2))));
            return false;
        }
        return true;
    }

    private final boolean char() throws Exception {
        long l;
        if (this.int) {
            System.out.println("Checking mapper");
        }
        long l2 = this.for.a.do.h;
        long l3 = this.for.a.new.try;
        long l4 = this.for.a.int.d;
        long l5 = this.for.a.char.d;
        byte[] byArray = this.for.a.int.new;
        byte[] byArray2 = this.for.a.char.new;
        long l6 = 0L;
        for (l = 0L; l < l3; ++l) {
            long l7 = this.for.a.new.a(l);
            if (this.int && this.else) {
                Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(l + (long)1))).append(" - ").append(l3).append(": ").append((int)((double)(l + (long)1) / (double)l3 * 100.0)).append("%"))));
                this.case = true;
            }
            long l8 = -1L;
            while (l7 != (long)-1) {
                Object object;
                long l9;
                int n;
                byte by;
                if (l7 < (long)0) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper page number is not valid: ".concat(String.valueOf(String.valueOf(l7))));
                    return false;
                }
                if (l7 >= l2) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper page number exceeds page count.");
                    System.out.println("Mapper page count: ".concat(String.valueOf(String.valueOf(l2))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l7))));
                    return false;
                }
                ++l6;
                this.for.a.do.do(l7);
                byte[] byArray3 = this.for.a.do.new;
                byte by2 = ByteArray.getByte(byArray3, 0);
                if (by2 != 1) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper page number is not in use.");
                    System.out.println("Mapper page flags: ".concat(String.valueOf(String.valueOf(by2))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l7))));
                    return false;
                }
                long l10 = ByteArray.getLong(byArray3, 1);
                if (l10 != l8) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper previous page number is not correct.");
                    System.out.println("Mapper last page number: ".concat(String.valueOf(String.valueOf(l8))));
                    System.out.println("Mapper previous page number: ".concat(String.valueOf(String.valueOf(l10))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l7))));
                    return false;
                }
                l8 = l7;
                int n2 = ByteArray.getInt(byArray3, 33);
                if (n2 < 1) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Key length must be at least one (1): ".concat(String.valueOf(String.valueOf(n2))));
                    return false;
                }
                this.try += (long)n2;
                long l11 = ByteArray.getLong(byArray3, 25);
                if (l11 == (long)-1) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Key page number was not found: ".concat(String.valueOf(String.valueOf(l7))));
                    return false;
                }
                long l12 = l11;
                while (l12 != (long)-1) {
                    if (l12 < (long)0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Key page number is not valid: ".concat(String.valueOf(String.valueOf(l12))));
                        return false;
                    }
                    if (l12 >= l4) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Key page number exceeds page count.");
                        System.out.println("Keys store page count: ".concat(String.valueOf(String.valueOf(l4))));
                        System.out.println("Key page number: ".concat(String.valueOf(String.valueOf(l12))));
                        return false;
                    }
                    this.for.a.int.int(l12);
                    by = ByteArray.getByte(byArray, 0);
                    if (by != 1) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Key page number is not in use.");
                        System.out.println("Key page flags: ".concat(String.valueOf(String.valueOf(by))));
                        System.out.println("Key page number: ".concat(String.valueOf(String.valueOf(l12))));
                        return false;
                    }
                    l12 = ByteArray.getLong(byArray, 1);
                    ++this.goto;
                }
                byte[] byArray4 = new byte[n2];
                this.for.a.int.a(l11, byArray4);
                byte by3 = byArray4[0];
                switch (by3) {
                    case 0: {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Key object type cannot be null.");
                        System.out.println("Key object type: ".concat(String.valueOf(String.valueOf(by3))));
                        System.out.println("Key page number: ".concat(String.valueOf(String.valueOf(l11))));
                        return false;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 2: {
                        n = 3;
                        break;
                    }
                    case 3: {
                        n = 3;
                        break;
                    }
                    case 4: {
                        n = 5;
                        break;
                    }
                    case 5: {
                        n = 9;
                        break;
                    }
                    case 6: {
                        n = 5;
                        break;
                    }
                    case 7: {
                        n = 9;
                        break;
                    }
                    case 8: {
                        n = -1;
                        break;
                    }
                    case 9: {
                        n = -1;
                        break;
                    }
                    case 10: {
                        n = 2;
                        break;
                    }
                    case 11: {
                        n = -1;
                        break;
                    }
                    case 15: {
                        n = -1;
                        break;
                    }
                    case 12: {
                        n = 9;
                        break;
                    }
                    case 13: {
                        n = -1;
                        break;
                    }
                    case 14: {
                        n = -1;
                        break;
                    }
                    default: {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Key object type is not correct.");
                        System.out.println("Key object type: ".concat(String.valueOf(String.valueOf(by3))));
                        System.out.println("Key page number: ".concat(String.valueOf(String.valueOf(l11))));
                        return false;
                    }
                }
                if (n != -1 && n != n2) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Key object length is not correct.");
                    System.out.println("Estimated key object length: ".concat(String.valueOf(String.valueOf(n))));
                    System.out.println("Current key object length: ".concat(String.valueOf(String.valueOf(n2))));
                    System.out.println("Key page number: ".concat(String.valueOf(String.valueOf(l11))));
                    return false;
                }
                long l13 = ByteArray.getLong(byArray3, 17);
                if (l13 != (l9 = this.for.a.byte(object = ByteArray.decodeObject(byArray4, 0)))) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Key hash code is not correct.");
                    System.out.println("Estimated key hash code: ".concat(String.valueOf(String.valueOf(l9))));
                    System.out.println("Current key hash code: ".concat(String.valueOf(String.valueOf(l13))));
                    System.out.println("Key page number: ".concat(String.valueOf(String.valueOf(l11))));
                    return false;
                }
                int n3 = ByteArray.getInt(byArray3, 45);
                if (n3 < 1) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Value length must be at least one (1): ".concat(String.valueOf(String.valueOf(n3))));
                    return false;
                }
                this.new += (long)n3;
                long l14 = ByteArray.getLong(byArray3, 37);
                if (l14 == (long)-1) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Value page number was not found: ".concat(String.valueOf(String.valueOf(l7))));
                    return false;
                }
                l12 = l14;
                while (l12 != (long)-1) {
                    if (l12 < (long)0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Value page number is not valid: ".concat(String.valueOf(String.valueOf(l12))));
                        return false;
                    }
                    if (l12 >= l5) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Value page number exceeds page count.");
                        System.out.println("Values store page count: ".concat(String.valueOf(String.valueOf(l5))));
                        System.out.println("Value page number: ".concat(String.valueOf(String.valueOf(l12))));
                        return false;
                    }
                    this.for.a.char.int(l12);
                    by = ByteArray.getByte(byArray2, 0);
                    if (by != 1) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Value page number is not in use.");
                        System.out.println("Value page flags: ".concat(String.valueOf(String.valueOf(by))));
                        System.out.println("Value page number: ".concat(String.valueOf(String.valueOf(l12))));
                        return false;
                    }
                    l12 = ByteArray.getLong(byArray2, 1);
                    ++this.a;
                }
                byte[] byArray5 = new byte[n3];
                this.for.a.char.a(l14, byArray5);
                by3 = byArray5[0];
                switch (by3) {
                    case 0: {
                        n = 1;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 2: {
                        n = 3;
                        break;
                    }
                    case 3: {
                        n = 3;
                        break;
                    }
                    case 4: {
                        n = 5;
                        break;
                    }
                    case 5: {
                        n = 9;
                        break;
                    }
                    case 6: {
                        n = 5;
                        break;
                    }
                    case 7: {
                        n = 9;
                        break;
                    }
                    case 8: {
                        n = -1;
                        break;
                    }
                    case 9: {
                        n = -1;
                        break;
                    }
                    case 10: {
                        n = 2;
                        break;
                    }
                    case 11: {
                        n = -1;
                        break;
                    }
                    case 15: {
                        n = -1;
                        break;
                    }
                    case 12: {
                        n = 9;
                        break;
                    }
                    case 13: {
                        n = -1;
                        break;
                    }
                    case 14: {
                        n = -1;
                        break;
                    }
                    default: {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Value object type is not correct.");
                        System.out.println("Value object type: ".concat(String.valueOf(String.valueOf(by3))));
                        System.out.println("Value object page number: ".concat(String.valueOf(String.valueOf(l14))));
                        return false;
                    }
                }
                if (n != -1 && n != n3) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Value object length is not correct.");
                    System.out.println("Estimated value object length: ".concat(String.valueOf(String.valueOf(n))));
                    System.out.println("Current value object length: ".concat(String.valueOf(String.valueOf(n3))));
                    System.out.println("Value object page number: ".concat(String.valueOf(String.valueOf(l14))));
                    return false;
                }
                Object object2 = ByteArray.decodeObject(byArray5, 0);
                l7 = ByteArray.getLong(byArray3, 9);
            }
        }
        if (this.case) {
            System.out.println();
            this.case = false;
        }
        if (this.int) {
            System.out.println();
            l = this.for.a.goto();
            System.out.println("Average key page count: ".concat(String.valueOf(String.valueOf(l == (long)0 ? 0.0 : (double)this.goto / (double)l))));
            System.out.println("Average value page count: ".concat(String.valueOf(String.valueOf(l == (long)0 ? 0.0 : (double)this.a / (double)l))));
            System.out.println("Average key length: ".concat(String.valueOf(String.valueOf(l == (long)0 ? 0.0 : (double)this.try / (double)l))));
            System.out.println("Average value length: ".concat(String.valueOf(String.valueOf(l == (long)0 ? 0.0 : (double)this.new / (double)l))));
        }
        if (l6 != this.for.a.do.e) {
            System.out.println("Mapper record count is not correct.");
            System.out.println("Current mapper record count: ".concat(String.valueOf(String.valueOf(this.for.a.do.e))));
            System.out.println("Estimated mapper record count: ".concat(String.valueOf(String.valueOf(l6))));
            return false;
        }
        return true;
    }

    private final boolean try() throws IOException {
        block70: {
            long l;
            byte by;
            byte[] byArray;
            long l2;
            long l3;
            if (this.int) {
                System.out.println("Checking mapper links");
            }
            long l4 = this.for.a.new.try;
            long l5 = this.for.a.do.h;
            long l6 = this.for.a.do.else;
            for (l3 = 0L; l3 < l4; ++l3) {
                l2 = this.for.a.new.a(l3);
                if (l2 == (long)-1) continue;
                this.for.a.do.do(l2);
                byArray = this.for.a.do.new;
                by = ByteArray.getByte(byArray, 0);
                if (by != 1) {
                    System.out.println("Mapper lookup table base page number is not in use.");
                    System.out.println("Mapper lookup table base page flags: ".concat(String.valueOf(String.valueOf(by))));
                    System.out.println("Mapper lookup table base page number: ".concat(String.valueOf(String.valueOf(l2))));
                    return false;
                }
                l = ByteArray.getLong(byArray, 1);
                if (l == (long)-1) continue;
                System.out.println("Mapper lookup table base page number has previous page.");
                System.out.println("Mapper lookup table base page previous page number: ".concat(String.valueOf(String.valueOf(l))));
                System.out.println("Mapper lookup table base page number: ".concat(String.valueOf(String.valueOf(l2))));
                return false;
            }
            for (l3 = 0L; l3 < l5; ++l3) {
                long l7;
                long l8;
                if (this.int && this.else) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(l3 + (long)1))).append(" - ").append(l5).append(": ").append((int)((double)(l3 + (long)1) / (double)l5 * 100.0)).append("%"))));
                    this.case = true;
                }
                this.for.a.do.do(l3);
                byArray = this.for.a.do.new;
                by = ByteArray.getByte(byArray, 0);
                l = ByteArray.getLong(byArray, 1);
                if (l < (long)-1) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper previous page number is not correct.");
                    System.out.println("Mapper previous page number: ".concat(String.valueOf(String.valueOf(l))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l3))));
                    return false;
                }
                if (l >= l5) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper previous page number exceeds mapper page count.");
                    System.out.println("Mapper previous page number: ".concat(String.valueOf(String.valueOf(l))));
                    System.out.println("Mapper page count: ".concat(String.valueOf(String.valueOf(l5))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l3))));
                    return false;
                }
                if (l == l3) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper previous page number cannot be the same as the current page number.");
                    System.out.println("Mapper previous page number: ".concat(String.valueOf(String.valueOf(l))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l3))));
                    return false;
                }
                long l9 = ByteArray.getLong(byArray, 9);
                if (l9 < (long)-1) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper next page number is not correct.");
                    System.out.println("Mapper next page number: ".concat(String.valueOf(String.valueOf(l9))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l3))));
                    return false;
                }
                if (l9 >= l5) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper next page number exceeds mapper page count.");
                    System.out.println("Mapper next page number: ".concat(String.valueOf(String.valueOf(l9))));
                    System.out.println("Mapper page count: ".concat(String.valueOf(String.valueOf(l5))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l3))));
                    return false;
                }
                if (l9 == l3) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper next page number cannot be the same as the current page number.");
                    System.out.println("Mapper next page number: ".concat(String.valueOf(String.valueOf(l9))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l3))));
                    return false;
                }
                if (by == 0) {
                    l2 = l6;
                    l8 = 0L;
                    while (l2 != (long)-1) {
                        if (l2 == l3) {
                            ++l8;
                        }
                        this.for.a.do.do(l2);
                        byArray = this.for.a.do.new;
                        l2 = ByteArray.getLong(byArray, 9);
                    }
                    if (l8 == (long)0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Mapper page marked as available was not found on free list: ".concat(String.valueOf(String.valueOf(l3))));
                        return false;
                    }
                    if (l8 > (long)1) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Mapper page marked as available was found multiple times on free list.");
                        System.out.println("Mapper page reference count: ".concat(String.valueOf(String.valueOf(l8))));
                        System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l3))));
                        return false;
                    }
                    l8 = 0L;
                    for (l7 = 0L; l7 < l4; ++l7) {
                        l2 = this.for.a.new.a(l7);
                        if (l3 != l2) continue;
                        ++l8;
                    }
                    if (l8 > (long)0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("One ore more lookup table pages link to this free page.");
                        System.out.println("Mapper lookup table page reference count: ".concat(String.valueOf(String.valueOf(l8))));
                        System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l3))));
                        return false;
                    }
                } else if (by == 1) {
                    l8 = 0L;
                    for (l7 = 0L; l7 < l4; ++l7) {
                        l2 = this.for.a.new.a(l7);
                        if (l3 != l2) continue;
                        ++l8;
                    }
                    if (l == (long)-1) {
                        if (l8 == (long)0) {
                            if (this.case) {
                                System.out.println();
                                this.case = false;
                            }
                            System.out.println("No lookup table page links to this base page: ".concat(String.valueOf(String.valueOf(l3))));
                            return false;
                        }
                        if (l8 > (long)1) {
                            if (this.case) {
                                System.out.println();
                                this.case = false;
                            }
                            System.out.println("More than one lookup table page links to this base page.");
                            System.out.println("Mapper lookup table page reference count: ".concat(String.valueOf(String.valueOf(l8))));
                            System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l3))));
                            return false;
                        }
                    } else if (l8 > (long)0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("One ore more lookup table pages link to this non base page.");
                        System.out.println("Mapper lookup table page reference count: ".concat(String.valueOf(String.valueOf(l8))));
                        System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l3))));
                        return false;
                    }
                    l8 = 0L;
                    for (l7 = 0L; l7 < l4; ++l7) {
                        l2 = this.for.a.new.a(l7);
                        while (l2 != (long)-1) {
                            if (l2 == l3) {
                                ++l8;
                            }
                            this.for.a.do.do(l2);
                            byArray = this.for.a.do.new;
                            l2 = ByteArray.getLong(byArray, 9);
                        }
                    }
                    if (l8 == (long)0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("No mapper page links to this mapper: ".concat(String.valueOf(String.valueOf(l3))));
                        return false;
                    }
                    if (l8 > (long)1) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Mapper page was found multiple times.");
                        System.out.println("Mapper page reference count: ".concat(String.valueOf(String.valueOf(l8))));
                        System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l3))));
                        return false;
                    }
                } else {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper page flags are not correct.");
                    System.out.println("Mapper page flags: ".concat(String.valueOf(String.valueOf(by))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l3))));
                    return false;
                }
                long l10 = 0L;
                long l11 = 0L;
                for (l2 = 0L; l2 < l5; ++l2) {
                    if (l2 == l3) continue;
                    this.for.a.do.do(l2);
                    byArray = this.for.a.do.new;
                    byte by2 = ByteArray.getByte(byArray, 0);
                    long l12 = ByteArray.getLong(byArray, 1);
                    long l13 = ByteArray.getLong(byArray, 9);
                    if (l12 == l3) {
                        if (by2 != by) {
                            if (this.case) {
                                System.out.println();
                                this.case = false;
                            }
                            System.out.println("Mapper page previous link is to a page whose flags are not the same.");
                            System.out.println("Next mapper page flags: ".concat(String.valueOf(String.valueOf(by2))));
                            System.out.println("Mapper page flags: ".concat(String.valueOf(String.valueOf(by))));
                            System.out.println("Next mapper page number: ".concat(String.valueOf(String.valueOf(l2))));
                            System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l3))));
                            return false;
                        }
                        if (l9 == (long)-1) {
                            if (this.case) {
                                System.out.println();
                                this.case = false;
                            }
                            System.out.println("Mapper page previous link is to a page whose next link is not to it.");
                            System.out.println("Current next mapper page number: ".concat(String.valueOf(String.valueOf(l9))));
                            System.out.println("Previous mapper page number: ".concat(String.valueOf(String.valueOf(l12))));
                            System.out.println("Next mapper page number: ".concat(String.valueOf(String.valueOf(l2))));
                            System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l3))));
                            return false;
                        }
                        ++l11;
                    }
                    if (l13 != l3) continue;
                    if (by2 != by) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Mapper page next link is to a page whose flags are not the same.");
                        System.out.println("Previous mapper page flags: ".concat(String.valueOf(String.valueOf(by2))));
                        System.out.println("Mapper page flags: ".concat(String.valueOf(String.valueOf(by))));
                        System.out.println("Previous mapper page number: ".concat(String.valueOf(String.valueOf(l2))));
                        System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l3))));
                        return false;
                    }
                    if (l == (long)-1) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Mapper page next link is to a page whose previous link is not to it.");
                        System.out.println("Current previous mapper page number: ".concat(String.valueOf(String.valueOf(l))));
                        System.out.println("Next mapper page number: ".concat(String.valueOf(String.valueOf(l13))));
                        System.out.println("Previous mapper page number: ".concat(String.valueOf(String.valueOf(l2))));
                        System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l3))));
                        return false;
                    }
                    ++l10;
                }
                if (l == (long)-1) {
                    if (l10 > (long)0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Mapper page does not have a previous page, but other mapper pages next page link to this page.");
                        System.out.println("Mapper previous page reference count: ".concat(String.valueOf(String.valueOf(l10))));
                        System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l3))));
                        return false;
                    }
                } else {
                    if (l10 == (long)0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Mapper page has a previous page, but no mapper pages next page link to this page: ".concat(String.valueOf(String.valueOf(l3))));
                        return false;
                    }
                    if (l10 > (long)1) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Mapper page has a previous page, but more than one (1) mapper pages next page link to this page.");
                        System.out.println("Mapper previous page reference count: ".concat(String.valueOf(String.valueOf(l10))));
                        System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l3))));
                        return false;
                    }
                }
                if (l9 == (long)-1) {
                    if (l11 <= (long)0) continue;
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper page does not have a next page, but other mapper pages previous page link to this page.");
                    System.out.println("Mapper next page reference count: ".concat(String.valueOf(String.valueOf(l11))));
                    System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l3))));
                    return false;
                }
                if (l11 == (long)0) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Mapper page has a next page, but no mapper pages prebious page link to this page: ".concat(String.valueOf(String.valueOf(l3))));
                    return false;
                }
                if (l11 <= (long)1) continue;
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Mapper page has a next page, but more than one (1) mapper pages prebious page link to this page.");
                System.out.println("Mapper next page reference count: ".concat(String.valueOf(String.valueOf(l11))));
                System.out.println("Mapper page number: ".concat(String.valueOf(String.valueOf(l3))));
                return false;
            }
            if (!this.case) break block70;
            System.out.println();
            this.case = false;
        }
        return true;
    }

    private final boolean case() throws IOException {
        block29: {
            if (this.int) {
                System.out.println("Checking keys store links");
            }
            long l = this.for.a.new.try;
            byte[] byArray = this.for.a.int.new;
            long l2 = this.for.a.int.d;
            long l3 = this.for.a.int.byte;
            for (long i = 0L; i < l2; ++i) {
                long l4;
                if (this.int && this.else) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i + (long)1))).append(" - ").append(l2).append(": ").append((int)((double)(i + (long)1) / (double)l2 * 100.0)).append("%"))));
                    this.case = true;
                }
                this.for.a.int.int(i);
                byte by = ByteArray.getByte(byArray, 0);
                long l5 = ByteArray.getLong(byArray, 1);
                if (l5 < (long)-1) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Keys store next page number is not correct.");
                    System.out.println("Keys store next page number: ".concat(String.valueOf(String.valueOf(l5))));
                    System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (l5 >= l2) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Keys store next page number exceeds keys store page count.");
                    System.out.println("Keys store next page number: ".concat(String.valueOf(String.valueOf(l5))));
                    System.out.println("Keys store page count: ".concat(String.valueOf(String.valueOf(l2))));
                    System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (l5 == i) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Keys store next page number cannot be the same as the current page number.");
                    System.out.println("Keys store next page number: ".concat(String.valueOf(String.valueOf(l5))));
                    System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (by == 0) {
                    long l6 = l3;
                    l4 = 0L;
                    while (l6 != (long)-1) {
                        if (l6 == i) {
                            ++l4;
                        }
                        this.for.a.int.int(l6);
                        l6 = ByteArray.getLong(byArray, 1);
                    }
                    if (l4 == (long)0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Keys store page marked as available was not found on free list: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (l4 > (long)1) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Keys store page marked as available was found multiple times on free list.");
                        System.out.println("Keys store page reference count: ".concat(String.valueOf(String.valueOf(l4))));
                        System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else if (by == 1) {
                    l4 = 0L;
                    for (long j = 0L; j < l; ++j) {
                        long l7 = this.for.a.new.a(j);
                        while (l7 != (long)-1) {
                            this.for.a.do.do(l7);
                            byte[] byArray2 = this.for.a.do.new;
                            long l8 = ByteArray.getLong(byArray2, 25);
                            while (l8 != (long)-1) {
                                if (l8 == i) {
                                    ++l4;
                                }
                                this.for.a.int.int(l8);
                                l8 = ByteArray.getLong(byArray, 1);
                            }
                            l7 = ByteArray.getLong(byArray2, 9);
                        }
                    }
                    if (l4 == (long)0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Used page was not found mapped to keys store entry: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (l4 > (long)1) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Used page was found mapped to multiple keys store pages.");
                        System.out.println("Keys store page reference count: ".concat(String.valueOf(String.valueOf(l4))));
                        System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Keys store page flags are not correct.");
                    System.out.println("Keys store page flags: ".concat(String.valueOf(String.valueOf(by))));
                    System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (l5 == (long)-1) continue;
                this.for.a.int.int(l5);
                byte by2 = ByteArray.getByte(byArray, 0);
                if (by2 == by) continue;
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Keys store page next link is to a page whose flags are not the same.");
                System.out.println("Keys store next page flags: ".concat(String.valueOf(String.valueOf(by2))));
                System.out.println("Keys store page flags: ".concat(String.valueOf(String.valueOf(by))));
                System.out.println("Keys store next page number: ".concat(String.valueOf(String.valueOf(l5))));
                System.out.println("Keys store page number: ".concat(String.valueOf(String.valueOf(i))));
                return false;
            }
            if (!this.case) break block29;
            System.out.println();
            this.case = false;
        }
        return true;
    }

    private final boolean int() throws IOException {
        block29: {
            if (this.int) {
                System.out.println("Checking Values store links");
            }
            long l = this.for.a.new.try;
            byte[] byArray = this.for.a.char.new;
            long l2 = this.for.a.char.d;
            long l3 = this.for.a.char.byte;
            for (long i = 0L; i < l2; ++i) {
                long l4;
                if (this.int && this.else) {
                    Common.status(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(i + (long)1))).append(" - ").append(l2).append(": ").append((int)((double)(i + (long)1) / (double)l2 * 100.0)).append("%"))));
                    this.case = true;
                }
                this.for.a.char.int(i);
                byte by = ByteArray.getByte(byArray, 0);
                long l5 = ByteArray.getLong(byArray, 1);
                if (l5 < (long)-1) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Values store next page number is not correct.");
                    System.out.println("Values store next page number: ".concat(String.valueOf(String.valueOf(l5))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (l5 >= l2) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Values store next page number exceeds values store page count.");
                    System.out.println("Values store next page number: ".concat(String.valueOf(String.valueOf(l5))));
                    System.out.println("Values store page count: ".concat(String.valueOf(String.valueOf(l2))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (l5 == i) {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Values store next page number cannot be the same as the current page number.");
                    System.out.println("Values store next page number: ".concat(String.valueOf(String.valueOf(l5))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (by == 0) {
                    long l6 = l3;
                    l4 = 0L;
                    while (l6 != (long)-1) {
                        if (l6 == i) {
                            ++l4;
                        }
                        this.for.a.char.int(l6);
                        l6 = ByteArray.getLong(byArray, 1);
                    }
                    if (l4 == (long)0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Values store page marked as available was not found on free list: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (l4 > (long)1) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Values store page marked as available was found multiple times on free list.");
                        System.out.println("Values store page reference count: ".concat(String.valueOf(String.valueOf(l4))));
                        System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else if (by == 1) {
                    l4 = 0L;
                    for (long j = 0L; j < l; ++j) {
                        long l7 = this.for.a.new.a(j);
                        while (l7 != (long)-1) {
                            this.for.a.do.do(l7);
                            byte[] byArray2 = this.for.a.do.new;
                            long l8 = ByteArray.getLong(byArray2, 37);
                            while (l8 != (long)-1) {
                                if (l8 == i) {
                                    ++l4;
                                }
                                this.for.a.char.int(l8);
                                l8 = ByteArray.getLong(byArray, 1);
                            }
                            l7 = ByteArray.getLong(byArray2, 9);
                        }
                    }
                    if (l4 == (long)0) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Used page was not found mapped to values store entry: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                    if (l4 > (long)1) {
                        if (this.case) {
                            System.out.println();
                            this.case = false;
                        }
                        System.out.println("Used page was found mapped to multiple values store pages.");
                        System.out.println("Values store page reference count: ".concat(String.valueOf(String.valueOf(l4))));
                        System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                        return false;
                    }
                } else {
                    if (this.case) {
                        System.out.println();
                        this.case = false;
                    }
                    System.out.println("Values store page flags are not correct.");
                    System.out.println("Values store page flags: ".concat(String.valueOf(String.valueOf(by))));
                    System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                    return false;
                }
                if (l5 == (long)-1) continue;
                this.for.a.char.int(l5);
                byte by2 = ByteArray.getByte(byArray, 0);
                if (by2 == by) continue;
                if (this.case) {
                    System.out.println();
                    this.case = false;
                }
                System.out.println("Values store page next link is to a page whose flags are not the same.");
                System.out.println("Values store next page flags: ".concat(String.valueOf(String.valueOf(by2))));
                System.out.println("Values store page flags: ".concat(String.valueOf(String.valueOf(by))));
                System.out.println("Values store next page number: ".concat(String.valueOf(String.valueOf(l5))));
                System.out.println("Values store page number: ".concat(String.valueOf(String.valueOf(i))));
                return false;
            }
            if (!this.case) break block29;
            System.out.println();
            this.case = false;
        }
        return true;
    }

    private final void a(String string) throws IOException {
        ObjectStoreReference objectStoreReference = ObjectStore.open(string, true);
        try {
            System.out.println();
            System.out.println("Lookup table utilization: ".concat(String.valueOf(String.valueOf(objectStoreReference.lookup_table_utilization() * (double)100))));
            System.out.println("Mapper page utilization: ".concat(String.valueOf(String.valueOf(objectStoreReference.a.do.h == (long)0 ? 0.0 : (double)objectStoreReference.a.do.e / (double)objectStoreReference.a.do.h * (double)100))));
            System.out.println("Keys store page utilization: ".concat(String.valueOf(String.valueOf(objectStoreReference.a.int.d == (long)0 ? 0.0 : (double)(objectStoreReference.a.int.d - objectStoreReference.a.int.g) / (double)objectStoreReference.a.int.d * (double)100))));
            System.out.println("Values store page utilization: ".concat(String.valueOf(String.valueOf(objectStoreReference.a.char.d == (long)0 ? 0.0 : (double)(objectStoreReference.a.char.d - objectStoreReference.a.char.g) / (double)objectStoreReference.a.char.d * (double)100))));
            System.out.println("Keys store space utilization: ".concat(String.valueOf(String.valueOf(objectStoreReference.a.int.d * (long)objectStoreReference.a.int.a == (long)0 ? 0.0 : (double)this.try / (double)(objectStoreReference.a.int.d * (long)objectStoreReference.a.int.a) * (double)100))));
            System.out.println("Values store space utilization: ".concat(String.valueOf(String.valueOf(objectStoreReference.a.char.d * (long)objectStoreReference.a.char.a == (long)0 ? 0.0 : (double)this.new / (double)(objectStoreReference.a.char.d * (long)objectStoreReference.a.char.a) * (double)100))));
            System.out.println("Key space utilization: ".concat(String.valueOf(String.valueOf(this.goto * (long)objectStoreReference.a.int.a == (long)0 ? 0.0 : (double)this.try / (double)(this.goto * (long)objectStoreReference.a.int.a) * (double)100))));
            System.out.println("Value space utilization: ".concat(String.valueOf(String.valueOf(this.a * (long)objectStoreReference.a.char.a == (long)0 ? 0.0 : (double)this.new / (double)(this.a * (long)objectStoreReference.a.char.a) * (double)100))));
            if (this.int) {
                System.out.println();
                System.out.println("Lookup table block usage:");
                long l = objectStoreReference.lookup_table_size();
                for (long i = 0L; i < l; ++i) {
                    System.out.print(i);
                    System.out.print(' ');
                    long l2 = objectStoreReference.lookup_table_page_count(i);
                    for (long j = 0L; j < l2; ++j) {
                        System.out.print('#');
                    }
                    System.out.println();
                }
            }
            Object var12_7 = null;
        }
        catch (Throwable throwable) {
            Object var12_8 = null;
            objectStoreReference.close();
            throw throwable;
        }
        objectStoreReference.close();
    }
}

