package test.db;

import org.aris.hldb.CS;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Products by Category<P>
 *
 * hldbBase template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework.<P>
 *
 * This class template creates classes which query the database using the hldb package. This package
 * uses stored procedures to perform any database operations. See the examples of OODB in order
 * to create a valid configuration file and generate database classes.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
class Products_by_CategoryBase implements Cloneable {
    // dirty bit
    protected boolean isDirty = false;

    // Connection
    protected CS cs;

    // ============================================================================
    // =       Variable declaration, according to table columns.                  =
    // ============================================================================
    protected String CategoryName;
    protected String ProductName;
    protected String QuantityPerUnit;
    protected Short UnitsInStock;
    protected boolean Discontinued;

    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * default constructor, protected.
     */
    protected Products_by_CategoryBase() {
    }

    /**
     * use this to create a new row by calling the setters and then insert().
     */
    public Products_by_CategoryBase(CS cs) {
        this.cs = cs;
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *)
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public Products_by_CategoryBase(CS cs, java.sql.ResultSet rs)
        throws java.sql.SQLException {
        this.cs = cs;
        setFromRs(rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        CategoryName = rs.getString("CategoryName");
        ProductName = rs.getString("ProductName");
        QuantityPerUnit = rs.getString("QuantityPerUnit");
        UnitsInStock = new Short(rs.getShort("UnitsInStock"));

        if (rs.wasNull()) {
            UnitsInStock = null;
        }

        ;
        Discontinued = rs.getBoolean("Discontinued");
    }

    // ============================================================================
    // =                  Setters and getters                                     =
    // ============================================================================

    /**
     * Getter for CategoryName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCategoryName() {
        return CategoryName;
    }

    /**
     * Setter for CategoryName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCategoryName(String value) {
        this.CategoryName = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Products_by_CategoryBase's by querying table field CategoryName
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCategoryName(
        int maxResults) throws SQLException {
        return getResultSetWithCategoryNameValueOf(cs, getCategoryName(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Products_by_CategoryBase's by querying table field CategoryName
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCategoryNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Products_by_CategoryBase_CategoryName");
        cc.setMaxRows(maxResults);

        try {
            cc.setString(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Products_by_CategoryBase's by querying table field CategoryName
     * for equality with the same CategoryName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCategoryName(int maxResults)
        throws SQLException {
        return getLinkedListWithCategoryNameValueOf(cs, getCategoryName(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Products_by_CategoryBase's by querying table field CategoryName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCategoryNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCategoryNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Products_by_CategoryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Products_by_CategoryBase's by querying table field CategoryName
     * for equality with the same CategoryName as this instance.
     */
    public Iterator getIteratorWithSameValueOfCategoryName(int maxResults)
        throws SQLException {
        return getIteratorWithCategoryNameValueOf(cs, getCategoryName(),
            maxResults);
    }

    /**
     * Gets an Iterator of Products_by_CategoryBase's by querying table field CategoryName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCategoryNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithCategoryNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for ProductName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getProductName() {
        return ProductName;
    }

    /**
     * Setter for ProductName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setProductName(String value) {
        this.ProductName = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Products_by_CategoryBase's by querying table field ProductName
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfProductName(
        int maxResults) throws SQLException {
        return getResultSetWithProductNameValueOf(cs, getProductName(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Products_by_CategoryBase's by querying table field ProductName
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithProductNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Products_by_CategoryBase_ProductName");
        cc.setMaxRows(maxResults);

        try {
            cc.setString(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Products_by_CategoryBase's by querying table field ProductName
     * for equality with the same ProductName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfProductName(int maxResults)
        throws SQLException {
        return getLinkedListWithProductNameValueOf(cs, getProductName(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Products_by_CategoryBase's by querying table field ProductName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithProductNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithProductNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Products_by_CategoryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Products_by_CategoryBase's by querying table field ProductName
     * for equality with the same ProductName as this instance.
     */
    public Iterator getIteratorWithSameValueOfProductName(int maxResults)
        throws SQLException {
        return getIteratorWithProductNameValueOf(cs, getProductName(),
            maxResults);
    }

    /**
     * Gets an Iterator of Products_by_CategoryBase's by querying table field ProductName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithProductNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithProductNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for QuantityPerUnit.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getQuantityPerUnit() {
        return QuantityPerUnit;
    }

    /**
     * Setter for QuantityPerUnit.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setQuantityPerUnit(String value) {
        this.QuantityPerUnit = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Products_by_CategoryBase's by querying table field QuantityPerUnit
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfQuantityPerUnit(
        int maxResults) throws SQLException {
        return getResultSetWithQuantityPerUnitValueOf(cs, getQuantityPerUnit(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Products_by_CategoryBase's by querying table field QuantityPerUnit
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithQuantityPerUnitValueOf(
        CS cs, String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Products_by_CategoryBase_QuantityPerUnit");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Products_by_CategoryBase's by querying table field QuantityPerUnit
     * for equality with the same QuantityPerUnit as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfQuantityPerUnit(
        int maxResults) throws SQLException {
        return getLinkedListWithQuantityPerUnitValueOf(cs,
            getQuantityPerUnit(), maxResults);
    }

    /**
     * Gets a LinkedList of Products_by_CategoryBase's by querying table field QuantityPerUnit
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithQuantityPerUnitValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithQuantityPerUnitValueOf(cs,
                value, maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Products_by_CategoryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Products_by_CategoryBase's by querying table field QuantityPerUnit
     * for equality with the same QuantityPerUnit as this instance.
     */
    public Iterator getIteratorWithSameValueOfQuantityPerUnit(int maxResults)
        throws SQLException {
        return getIteratorWithQuantityPerUnitValueOf(cs, getQuantityPerUnit(),
            maxResults);
    }

    /**
     * Gets an Iterator of Products_by_CategoryBase's by querying table field QuantityPerUnit
     * for equality with the "value".
     */
    public static Iterator getIteratorWithQuantityPerUnitValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithQuantityPerUnitValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for UnitsInStock.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public Short getUnitsInStock() {
        return UnitsInStock;
    }

    /**
     * Setter for UnitsInStock.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setUnitsInStock(Short value) {
        this.UnitsInStock = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Products_by_CategoryBase's by querying table field UnitsInStock
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfUnitsInStock(
        int maxResults) throws SQLException {
        return getResultSetWithUnitsInStockValueOf(cs, getUnitsInStock(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Products_by_CategoryBase's by querying table field UnitsInStock
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithUnitsInStockValueOf(CS cs,
        Short value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Products_by_CategoryBase_UnitsInStock");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.SMALLINT);
            } else {
                cc.setShort(1, value.shortValue());
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Products_by_CategoryBase's by querying table field UnitsInStock
     * for equality with the same UnitsInStock as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfUnitsInStock(int maxResults)
        throws SQLException {
        return getLinkedListWithUnitsInStockValueOf(cs, getUnitsInStock(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Products_by_CategoryBase's by querying table field UnitsInStock
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithUnitsInStockValueOf(CS cs,
        Short value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithUnitsInStockValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Products_by_CategoryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Products_by_CategoryBase's by querying table field UnitsInStock
     * for equality with the same UnitsInStock as this instance.
     */
    public Iterator getIteratorWithSameValueOfUnitsInStock(int maxResults)
        throws SQLException {
        return getIteratorWithUnitsInStockValueOf(cs, getUnitsInStock(),
            maxResults);
    }

    /**
     * Gets an Iterator of Products_by_CategoryBase's by querying table field UnitsInStock
     * for equality with the "value".
     */
    public static Iterator getIteratorWithUnitsInStockValueOf(CS cs,
        Short value, int maxResults) throws SQLException {
        return getLinkedListWithUnitsInStockValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for Discontinued.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public boolean getDiscontinued() {
        return Discontinued;
    }

    /**
     * Setter for Discontinued.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setDiscontinued(boolean value) {
        this.Discontinued = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Products_by_CategoryBase's by querying table field Discontinued
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfDiscontinued(
        int maxResults) throws SQLException {
        return getResultSetWithDiscontinuedValueOf(cs, getDiscontinued(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Products_by_CategoryBase's by querying table field Discontinued
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithDiscontinuedValueOf(CS cs,
        boolean value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Products_by_CategoryBase_Discontinued");
        cc.setMaxRows(maxResults);

        try {
            cc.setBoolean(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Products_by_CategoryBase's by querying table field Discontinued
     * for equality with the same Discontinued as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfDiscontinued(int maxResults)
        throws SQLException {
        return getLinkedListWithDiscontinuedValueOf(cs, getDiscontinued(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Products_by_CategoryBase's by querying table field Discontinued
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithDiscontinuedValueOf(CS cs,
        boolean value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithDiscontinuedValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Products_by_CategoryBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Products_by_CategoryBase's by querying table field Discontinued
     * for equality with the same Discontinued as this instance.
     */
    public Iterator getIteratorWithSameValueOfDiscontinued(int maxResults)
        throws SQLException {
        return getIteratorWithDiscontinuedValueOf(cs, getDiscontinued(),
            maxResults);
    }

    /**
     * Gets an Iterator of Products_by_CategoryBase's by querying table field Discontinued
     * for equality with the "value".
     */
    public static Iterator getIteratorWithDiscontinuedValueOf(CS cs,
        boolean value, int maxResults) throws SQLException {
        return getLinkedListWithDiscontinuedValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Free a callable statement that was returned by any of the class's members
     */
    public void freeCS(CallableStatement callableStatement) {
        cs.freeCS(callableStatement);
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        CallableStatement cc = null;

        try {
            cc = cs.allocCS("INSERT_Products_by_CategoryBase");

            cc.setString(1, getCategoryName());

            cc.setString(2, getProductName());

            cc.setString(3, getQuantityPerUnit());

            if (UnitsInStock == null) {
                cc.setNull(4, java.sql.Types.SMALLINT);
            } else {
                cc.setShort(4, getUnitsInStock().shortValue());
            }

            cc.setBoolean(5, getDiscontinued());

            cc.executeUpdate();

            isDirty = false;
        } finally {
            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    public void dump(String prefix) {
        System.out.println(prefix + "CategoryName:" + getCategoryName());

        System.out.println(prefix + "ProductName:" + getProductName());

        System.out.println(prefix + "QuantityPerUnit:" + getQuantityPerUnit());

        System.out.println(prefix + "UnitsInStock:" + getUnitsInStock());

        System.out.println(prefix + "Discontinued:" + getDiscontinued());
    }

    public void dump() {
        dump("");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();

        sb.append(CategoryName);
        sb.append(",");
        sb.append(ProductName);
        sb.append(",");
        sb.append(QuantityPerUnit);
        sb.append(",");
        sb.append(UnitsInStock);
        sb.append(",");
        sb.append(Discontinued);

        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
