/*
 * Decompiled with CFR 0.152.
 */
package org.aris.hldb;

import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.aris.hldb.AvailCS;
import org.aris.hldb.exceptions.KeyAlreadyExistsException;
import org.aris.hldb.pools.ConnectionProviderI;

public class CS {
    private Hashtable tm = new Hashtable(2);
    private Hashtable atm = new Hashtable(2);
    private ConnectionProviderI hlcon;

    public CS(ConnectionProviderI hl_con) {
        this.hlcon = hl_con;
    }

    public ConnectionProviderI gethlCon() {
        return this.hlcon;
    }

    public synchronized boolean exists(String key) {
        return this.tm.containsKey(key);
    }

    public synchronized void addSqlCall(String key, String sql, int resultSetType, int resultSetConcurency, int maxInPool) throws KeyAlreadyExistsException {
        if (this.exists(key)) {
            throw new KeyAlreadyExistsException("CS.addSqlCall: " + key + " already exists.");
        }
        this.tm.put(key, new AvailCS(this.hlcon, sql, resultSetType, resultSetConcurency, maxInPool));
    }

    public synchronized void addSqlCall(String key, String sql, int maxInPool) throws KeyAlreadyExistsException {
        if (this.exists(key)) {
            throw new KeyAlreadyExistsException("CS.addSqlCall: " + key + " already exists.");
        }
        this.tm.put(key, new AvailCS(this.hlcon, sql, maxInPool));
    }

    public synchronized CallableStatement allocCS(String key) throws SQLException {
        AvailCS acs = (AvailCS)this.tm.get(key);
        if (acs == null) {
            return null;
        }
        CallableStatement cs = acs.allocCS();
        this.atm.put(cs, acs);
        return cs;
    }

    public synchronized CallableStatement allocTransactionalCS(Connection con, String key) throws SQLException {
        AvailCS acs = (AvailCS)this.tm.get(key);
        if (acs == null) {
            return null;
        }
        return con.prepareCall(acs.getSql());
    }

    public synchronized CallableStatement freeCS(CallableStatement cs) {
        if (cs == null) {
            return null;
        }
        AvailCS acs = (AvailCS)this.atm.remove(cs);
        acs.freeCS(cs);
        return null;
    }

    public void execCS(String key) throws SQLException {
        CallableStatement cs = this.allocCS(key);
        try {
            cs.execute();
        }
        finally {
            this.freeCS(cs);
        }
    }

    public int execCSID(CallableStatement cs) throws SQLException {
        ResultSet rs = cs.executeQuery();
        rs.next();
        int t = rs.getInt(1);
        rs.close();
        return t;
    }

    public String execCS(String key, int parameter) throws SQLException {
        String t;
        CallableStatement cs = this.allocCS(key);
        try {
            cs.setInt(1, parameter);
            ResultSet rs = cs.executeQuery();
            t = rs.next() ? rs.getString(1) : null;
            rs.close();
        }
        finally {
            this.freeCS(cs);
        }
        return t;
    }

    public void dumpAllocated(PrintStream out) {
        out.println("---------------------------------------------------");
        out.println("hlCS has the following CallableStatement keys alloc");
        out.println("---------------------------------------------------");
        Set set = this.atm.entrySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String key = (String)((Object)it.next());
            out.println(key);
        }
        out.println("---------------------------------------------------");
    }
}

