/*
 * Decompiled with CFR 0.152.
 */
package org.aris.cache.idcache;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.aris.cache.idcache.CacheCallBackI;
import org.aris.cache.idcache.IdCacheStore;
import org.aris.maps.lists.LinkedListEx;

public class IdCache {
    private int cacheObjectCurrentMaximum = 0;
    private int cacheObjectsMin = 0;
    private int cacheObjectsMax = 0;
    private TreeMap cache = new TreeMap();
    private LinkedListEx useful = new LinkedListEx();
    private int usefulc = 0;
    private int hits = 0;
    private int misses = 0;
    private CacheCallBackI cacheCallBack;
    private float adjustFactor = 0.0f;
    private int dSize = 0;
    private float adjustFactorUnchanged = 0.0f;

    public synchronized void adjustMaxSize(int dSize) {
        int t = this.cacheObjectCurrentMaximum + dSize;
        if (t >= this.cacheObjectsMin && t <= this.cacheObjectsMax) {
            this.cacheObjectCurrentMaximum += dSize;
            if (dSize < 0) {
                while (this.useful.size() > this.cacheObjectCurrentMaximum) {
                    Object key = this.useful.getLast();
                    this.removeOnlyFromCache(key);
                }
            }
        }
    }

    private void checkForSizeAdjustation() {
        if (this.misses > 0) {
            float f = (float)this.hits / (float)this.misses;
            if (f < this.adjustFactor - this.adjustFactorUnchanged) {
                this.adjustMaxSize(this.dSize);
            } else if (f > this.adjustFactor + this.adjustFactorUnchanged) {
                this.adjustMaxSize(-this.dSize);
            }
        }
    }

    protected void incHits() {
        ++this.hits;
        this.checkForSizeAdjustation();
    }

    protected void incMisses() {
        ++this.misses;
        this.checkForSizeAdjustation();
    }

    public int getHits() {
        return this.hits;
    }

    public int getMisses() {
        return this.misses;
    }

    public IdCache(int cacheObjectsMin, int cacheObjectsMax, float adjustFactor, float adjustFactorUnchanged, int dSize, CacheCallBackI cacheCallBack) {
        this.IdCache0(cacheObjectsMin, cacheObjectsMax, adjustFactor, adjustFactorUnchanged, dSize, cacheCallBack);
    }

    public void IdCache0(int cacheObjectsMin, int cacheObjectsMax, float adjustFactor, float adjustFactorUnchanged, int dSize, CacheCallBackI cacheCallBack) {
        this.cacheObjectCurrentMaximum = cacheObjectsMax;
        this.cacheObjectsMin = cacheObjectsMin;
        this.cacheObjectsMax = cacheObjectsMax;
        this.cacheCallBack = cacheCallBack;
        this.adjustFactor = adjustFactor;
        this.dSize = dSize;
        this.adjustFactorUnchanged = adjustFactorUnchanged;
    }

    public IdCache(int cacheObjectsAverage, CacheCallBackI cacheCallBack) {
        int minmaxf = cacheObjectsAverage / 2;
        this.IdCache0(cacheObjectsAverage - minmaxf, cacheObjectsAverage + minmaxf, 1.0f, 0.5f, minmaxf / 10, cacheCallBack);
    }

    public synchronized boolean update(Object key, Object value) throws Exception {
        IdCacheStore ics;
        boolean success = this.cacheCallBack.updateKey(key, value);
        if (success && (ics = (IdCacheStore)this.cache.get(key)) != null) {
            ics.value = value;
            this.useful.remove(ics.linkedListExEntry);
            ics.linkedListExEntry = this.useful.addFirst(key);
        }
        return success;
    }

    public synchronized Object insert(Object key, Object value) throws Exception {
        key = this.cacheCallBack.insertKey(key, value);
        this.addJustToCache(key, value);
        return key;
    }

    public void addJustToCache(Object key, Object value) {
        if (this.usefulc == this.cacheObjectCurrentMaximum) {
            Object lkey = this.useful.removeLast();
            this.cache.remove(lkey);
        } else {
            ++this.usefulc;
        }
        IdCacheStore ics = new IdCacheStore(value);
        ics.linkedListExEntry = this.useful.addFirst(key);
        this.cache.put(key, ics);
    }

    public synchronized Object get(Object key) throws Exception {
        IdCacheStore ics = (IdCacheStore)this.cache.get(key);
        if (ics == null) {
            this.incMisses();
            Object v = this.cacheCallBack.findMissingKeyValue(key);
            if (v != null) {
                this.addJustToCache(key, v);
            }
            return v;
        }
        this.incHits();
        this.useful.remove(ics.linkedListExEntry);
        ics.linkedListExEntry = this.useful.addFirst(key);
        return ics.value;
    }

    public synchronized Object removeOnlyFromCache(Object key) {
        IdCacheStore ics = (IdCacheStore)this.cache.remove(key);
        if (ics != null) {
            this.useful.remove(ics.linkedListExEntry);
            --this.usefulc;
            return ics.value;
        }
        return null;
    }

    public synchronized Object remove(Object key) throws Exception {
        this.cacheCallBack.removeKey(key);
        return this.removeOnlyFromCache(key);
    }

    public synchronized void dump(boolean printvalues) {
        Map.Entry me;
        Iterator it = this.cache.entrySet().iterator();
        System.out.print("========================================\nTreeMap keys :\n[");
        while (it.hasNext()) {
            me = it.next();
            System.out.print(me.getKey());
            if (printvalues) {
                System.out.print("(" + ((IdCacheStore)me.getValue()).value + ")");
            }
            if (!it.hasNext()) continue;
            System.out.print(",");
        }
        System.out.println("]");
        System.out.print("Useful LinkedList keys :\n[");
        it = this.useful.iterator();
        while (it.hasNext()) {
            me = it.next();
            System.out.print(me);
            if (!it.hasNext()) continue;
            System.out.print(",");
        }
        System.out.println("]\n========================================");
        System.out.println("Cache stats: size=" + this.cache.size() + " Hits:" + this.getHits() + " Misses:" + this.getMisses());
        System.out.println("========================================");
    }
}

