// Page5.cpp : implementation file
//

#include "stdafx.h"
#include "bcgpcontrols.h"
#include "Page5.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPage5 property page

IMPLEMENT_DYNCREATE(CPage5, CBCGPPropertyPage)

CPage5::CPage5() : CBCGPPropertyPage(CPage5::IDD)
{
	//{{AFX_DATA_INIT(CPage5)
	m_bDescrArea = TRUE;
	m_bDotNetLook = FALSE;
	m_bHeader = TRUE;
	m_bMarkSortedColumn = TRUE;
	m_bColor = TRUE;
	//}}AFX_DATA_INIT

	m_wndList.m_bColor = TRUE;
}

CPage5::~CPage5()
{
}

void CPage5::DoDataExchange(CDataExchange* pDX)
{
	CBCGPPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPage5)
	DDX_Control(pDX, IDC_PROPLIST_LOCATION, m_wndPropListLocation);
	DDX_Control(pDX, IDC_LIST1, m_wndList);
	DDX_Check(pDX, IDC_DESCRIPTION_AREA, m_bDescrArea);
	DDX_Check(pDX, IDC_DOT_NET_LOOK, m_bDotNetLook);
	DDX_Check(pDX, IDC_HEADER, m_bHeader);
	DDX_Check(pDX, IDC_MARK_SORTED_COLUMN, m_bMarkSortedColumn);
	DDX_Check(pDX, IDC_COLOR_ROWS, m_bColor);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPage5, CBCGPPropertyPage)
	//{{AFX_MSG_MAP(CPage5)
	ON_BN_CLICKED(IDC_HEADER, OnHeader)
	ON_BN_CLICKED(IDC_DOT_NET_LOOK, OnDotNetLook)
	ON_BN_CLICKED(IDC_DESCRIPTION_AREA, OnDescriptionArea)
	ON_BN_CLICKED(IDC_MARK_SORTED_COLUMN, OnMarkSortedColumn)
	ON_BN_CLICKED(IDC_COLOR_ROWS, OnColorRows)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPage5 message handlers

const int nColumns = 4;
const int nRows = 50;

BOOL CPage5::OnInitDialog() 
{
	CBCGPPropertyPage::OnInitDialog();
	
	m_wndList.InsertColumn (0, _T("#"), LVCFMT_LEFT, 20);

	for (int nColumn = 1; nColumn < nColumns - 1; nColumn++)
	{
		m_wndList.InsertColumn (nColumn, CString ((TCHAR)(_T('A') + nColumn - 1)), LVCFMT_LEFT, 70);
	}

	for (int i = 0; i < nRows; i++)
	{
		CString str;
		str.Format ("%d", i);
		m_wndList.InsertItem (i, str);
		m_wndList.SetItemData (i, i);

		for (nColumn = 1; nColumn < nColumns - 1; nColumn++)
		{
			str.Format ("Item (%d, %d)", nColumn - 1, i);
			m_wndList.SetItemText (i, nColumn, str);
		}
	}
	
	m_wndList.SendMessage (LVM_SETEXTENDEDLISTVIEWSTYLE, 0,
						LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES);
	m_wndList.EnableMarkSortedColumn ();


	CRect rectPropList;
	m_wndPropListLocation.GetClientRect (&rectPropList);
	m_wndPropListLocation.MapWindowPoints (this, &rectPropList);

	m_wndPropList.Create (WS_CHILD | WS_VISIBLE | WS_TABSTOP | WS_BORDER, rectPropList, this, (UINT)-1);
	
	m_wndPropList.EnableHeaderCtrl ();
	m_wndPropList.EnableDesciptionArea ();

	CBCGPProp* pGroup1 = new CBCGPProp (_T("Appearance"));

	pGroup1->AddSubItem (new CBCGPProp (_T("3D Look"), (_variant_t) false,
		_T("Specifies the dialog's font will be nonbold and controls will have a 3D border")));

	CBCGPProp* pProp = new CBCGPProp (_T("Border"), _T("Dialog Frame"),
		_T("One of: None, Thin, Resizable, or Dialog Frame"));
	pProp->AddOption (_T("None"));
	pProp->AddOption (_T("Thin"));
	pProp->AddOption (_T("Resizable"));
	pProp->AddOption (_T("Dialog Frame"));
	pProp->AllowEdit (FALSE);

	pGroup1->AddSubItem (pProp);
	pGroup1->AddSubItem (new CBCGPProp (_T("Caption"), (_variant_t) _T("About Demo"),
		_T("Specifies the text that will be displayed in the dialog's title bar")));

	pGroup1->AddSubItem (new CBCGPProp (_T("Height"), (_variant_t) 250l,
		_T("Specifies the dialog's height")));
	pGroup1->AddSubItem (new CBCGPProp (_T("Width"), (_variant_t) 150l,
		_T("Specifies the dialog's width")));

	m_wndPropList.AddProperty (pGroup1);

	CBCGPProp* pGroup2 = new CBCGPProp (_T("Font"));

	LOGFONT lf;
	CFont* font = CFont::FromHandle ((HFONT) GetStockObject (DEFAULT_GUI_FONT));
	font->GetLogFont (&lf);

	pGroup2->AddSubItem (new CBCGPFontProp (_T("Font"), lf, CF_EFFECTS | CF_SCREENFONTS, _T("Specifies the default font for the dialog")));
	pGroup2->AddSubItem (new CBCGPProp (_T("Use System Font"), (_variant_t) true, _T("Specifies that the dialog uses MS Shell Dlg font")));

	m_wndPropList.AddProperty (pGroup2);

	CBCGPProp* pGroup3 = new CBCGPProp (_T("Misc"));
	pProp = new CBCGPProp (_T("(Name)"), _T("IDD_ABOUT_BOX (dialog)"));
	pProp->Enable (FALSE);
	pGroup3->AddSubItem (pProp);

	CBCGPColorProp* pColorProp = new CBCGPColorProp ("Window Color", RGB (192, 192, 192), NULL, "Specifies the default dialog color");
	pColorProp->EnableOtherButton ("Other...");
	pColorProp->EnableAutomaticButton ("Default", ::GetSysColor (COLOR_3DFACE));
	pGroup3->AddSubItem (pColorProp);

	static char BASED_CODE szFilter[] = "Icon Files (*.ico)|*.ico|All Files (*.*)|*.*||";
	pGroup3->AddSubItem (new CBCGPFileProp ("Icon", TRUE, "", "ico", 0, szFilter, "Specifies the dialog icon"));

	pGroup3->AddSubItem (new CBCGPFileProp ("Folder", "c:\\"));

	m_wndPropList.AddProperty (pGroup3);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CPage5::OnHeader() 
{
	UpdateData ();
	m_wndPropList.EnableHeaderCtrl (m_bHeader);
}

void CPage5::OnDotNetLook() 
{
	UpdateData ();
	m_wndPropList.SetVSDotNetLook (m_bDotNetLook);
}

void CPage5::OnDescriptionArea() 
{
	UpdateData ();
	m_wndPropList.EnableDesciptionArea (m_bDescrArea);
}

void CPage5::OnMarkSortedColumn() 
{
	UpdateData ();
	m_wndList.EnableMarkSortedColumn (m_bMarkSortedColumn);
}

COLORREF CMyListCtrl::OnGetCellTextColor (int nRow, int nColum)
{
	if (!m_bColor)
	{
		return CBCGPListCtrl::OnGetCellTextColor (nRow, nColum);
	}

	return (nRow % 2) == 0 ? RGB (128, 37, 0) : RGB (0, 0, 0);
}

COLORREF CMyListCtrl::OnGetCellBkColor (int nRow, int nColum)
{
	if (!m_bColor)
	{
		return CBCGPListCtrl::OnGetCellBkColor (nRow, nColum);
	}

	if (m_bMarkSortedColumn && nColum == m_iSortedColumn)
	{
		return (nRow % 2) == 0 ? RGB (233, 221, 229) : RGB (176, 218, 234);
	}

	return (nRow % 2) == 0 ? RGB (253, 241, 249) : RGB (196, 238, 254);
}


void CPage5::OnColorRows() 
{
	UpdateData ();
	m_wndList.m_bColor = m_bColor;
	m_wndList.RedrawWindow ();
}
