/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;

public class MatchPatternIterator
extends LocPathIterator {
    protected StepPattern m_pattern;
    protected int m_superAxis = -1;
    protected DTMAxisTraverser m_traverser;
    private static final boolean DEBUG = false;

    MatchPatternIterator(Compiler compiler, int opPos, int analysis) throws TransformerException {
        super(compiler, opPos, analysis, false);
        int firstStepPos = OpMap.getFirstChildPos(opPos);
        this.m_pattern = WalkerFactory.loadSteps(this, compiler, firstStepPos, 0);
        boolean fromRoot = false;
        boolean walkBack = false;
        boolean walkDescendants = false;
        boolean walkAttributes = false;
        if ((analysis & 0x28000000) != 0) {
            fromRoot = true;
        }
        if ((analysis & 0x5D86000) != 0) {
            walkBack = true;
        }
        if ((analysis & 0x70000) != 0) {
            walkDescendants = true;
        }
        if ((analysis & 0x208000) != 0) {
            walkAttributes = true;
        }
        this.m_superAxis = fromRoot || walkBack ? (walkAttributes ? 16 : 17) : (walkDescendants ? (walkAttributes ? 14 : 5) : 16);
    }

    public short acceptNode(int n, XPathContext xctxt) {
        try {
            try {
                xctxt.pushCurrentNode(n);
                xctxt.pushIteratorRoot(this.m_context);
                XObject score = this.m_pattern.execute(xctxt);
                short s = score == NodeTest.SCORE_NONE ? (short)3 : 1;
                Object var5_6 = null;
                xctxt.popCurrentNode();
                xctxt.popIteratorRoot();
                return s;
            }
            catch (TransformerException se) {
                throw new RuntimeException(se.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            xctxt.popCurrentNode();
            xctxt.popIteratorRoot();
            throw throwable;
        }
    }

    protected int getNextNode() {
        this.m_lastFetched = this.m_lastFetched == -1 ? this.m_traverser.first(this.m_context) : this.m_traverser.next(this.m_context, this.m_lastFetched);
        return this.m_lastFetched;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int nextNode() {
        int n;
        int savedStart;
        VariableStack vars;
        if (this.m_cachedNodes != null && this.m_next < this.m_cachedNodes.size()) {
            int next = this.m_cachedNodes.elementAt(this.m_next);
            this.incrementNextPosition();
            this.m_currentContextNode = next;
            return next;
        }
        if (this.m_foundLast) {
            this.m_lastFetched = -1;
            return -1;
        }
        if (this.m_stackFrame != -1) {
            vars = this.m_execContext.getVarStack();
            savedStart = vars.getStackFrame();
            vars.setStackFrame(this.m_stackFrame);
        } else {
            vars = null;
            savedStart = 0;
        }
        try {
            int next;
            while ((next = this.getNextNode()) != -1 && this.acceptNode(next, this.m_execContext) != 1 && next != -1) {
            }
            if (next != -1) {
                if (this.m_cachedNodes != null) {
                    this.m_cachedNodes.addElement(this.m_lastFetched);
                }
                ++this.m_next;
                int n2 = next;
                Object var6_7 = null;
                if (this.m_stackFrame == -1) return n2;
                vars.setStackFrame(savedStart);
                return n2;
            }
            this.m_foundLast = true;
            n = -1;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (this.m_stackFrame == -1) throw throwable;
            vars.setStackFrame(savedStart);
            throw throwable;
        }
        Object var6_8 = null;
        if (this.m_stackFrame == -1) return n;
        vars.setStackFrame(savedStart);
        return n;
    }

    public void setRoot(int context, Object environment) {
        super.setRoot(context, environment);
        this.m_traverser = this.m_cdtm.getAxisTraverser(this.m_superAxis);
    }
}

