/*
 * Decompiled with CFR 0.152.
 */
package javak.bo.sqlBuilder;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javak.bo.ModelTable;
import javak.bo.sqlBuilder.ViewTableFrame;
import javak.bo.sqlBuilder.boAttrAttrRelation;
import javak.bo.sqlBuilder.boRelationManager;
import javak.bo.sqlBuilder.sqlBuilderController;
import javak.exception.BOjavakException;
import javak.iface.bo.I_BOSetText;
import javak.iface.bo.I_SQLRenderer;
import javak.iface.bo.I_TableData;
import javak.iface.bo.I_VisualActionListener;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ViewTableFrameManager
extends JDesktopPane {
    private sqlBuilderController m_controller = null;
    private boolean drawMouseMarkerLine = false;
    private boRelationManager relManager = null;
    private boAttrAttrRelation movedRelation = null;
    private ViewTableFrame lastActiveFrame = null;
    private Vector visualActionListeners = null;

    public ViewTableFrameManager(boRelationManager boRelationManager2, sqlBuilderController sqlBuilderController2) {
        this.relManager = boRelationManager2;
        this.m_controller = sqlBuilderController2;
        this.visualActionListeners = new Vector(2, 2);
        this.add(this.relManager);
    }

    public void addVisualActionListener(I_VisualActionListener i_VisualActionListener) {
        if (!this.visualActionListeners.contains(i_VisualActionListener)) {
            this.visualActionListeners.add(i_VisualActionListener);
        }
    }

    public void removeVisualActionListener(I_VisualActionListener i_VisualActionListener) {
        this.visualActionListeners.remove(i_VisualActionListener);
    }

    private void fireVisualActionEvent() {
        Enumeration enumeration = this.visualActionListeners.elements();
        while (enumeration.hasMoreElements()) {
            I_VisualActionListener i_VisualActionListener = (I_VisualActionListener)enumeration.nextElement();
            i_VisualActionListener.visualChange();
        }
    }

    public void revalidateTableView() {
        JInternalFrame[] jInternalFrameArray = this.getAllTitleAttrFrames();
        int n = 0;
        while (n < jInternalFrameArray.length) {
            jInternalFrameArray[n].repaint();
            ++n;
        }
    }

    public int getNrOfElements() {
        return this.getAllAttrContainers().length;
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.relManager.setBounds(0, this.relManager.convertOffsetY(0), dimension.width, dimension.height + Math.abs(-50));
    }

    public JInternalFrame[] getAllTitleAttrFrames() {
        JInternalFrame[] jInternalFrameArray = super.getAllFrames();
        if (jInternalFrameArray.length == 0) {
            return new JInternalFrame[0];
        }
        Vector<JInternalFrame> vector = new Vector<JInternalFrame>(5, 5);
        int n = 0;
        while (n < jInternalFrameArray.length) {
            if (!(jInternalFrameArray[n] instanceof boRelationManager)) {
                vector.addElement(jInternalFrameArray[n]);
            }
            ++n;
        }
        JInternalFrame[] jInternalFrameArray2 = new JInternalFrame[vector.size()];
        Enumeration enumeration = vector.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            JInternalFrame jInternalFrame = (JInternalFrame)enumeration.nextElement();
            jInternalFrameArray2[n2++] = jInternalFrame;
        }
        return jInternalFrameArray2;
    }

    public ViewTableFrame getObjectByName(String string) {
        ViewTableFrame[] viewTableFrameArray = this.getAllAttrContainers();
        int n = 0;
        while (n < viewTableFrameArray.length) {
            if (viewTableFrameArray[n].getModelTable().getName().equals(string)) {
                return viewTableFrameArray[n];
            }
            ++n;
        }
        return null;
    }

    public void deactivateFocus() {
        try {
            this.relManager.setSelected(true);
        }
        catch (Exception exception) {
            this.setErrorMsg(exception.getMessage());
        }
    }

    public void setLastActiveFrame(ViewTableFrame viewTableFrame) {
        this.lastActiveFrame = viewTableFrame == null && viewTableFrame == this.lastActiveFrame ? null : viewTableFrame;
    }

    public String getNameLastActiveFrame() {
        if (this.lastActiveFrame == null) {
            return null;
        }
        return this.lastActiveFrame.getModelTable().getName();
    }

    public void removeTable(String string) {
        ViewTableFrame viewTableFrame = this.getObjectByName(string);
        if (viewTableFrame == null) {
            return;
        }
        try {
            viewTableFrame.setClosed(true);
        }
        catch (Exception exception) {
            this.setErrorMsg(exception.getMessage());
        }
    }

    public Object createNewBox(ModelTable modelTable) {
        int n = this.getNrOfElements();
        String string = modelTable.getName();
        if (this.getObjectByName(string) != null) {
            this.setErrorMsg("Table with name " + string + " may only be added once.");
            return null;
        }
        FontMetrics fontMetrics = this.relManager.getGraphics().getFontMetrics();
        ViewTableFrame viewTableFrame = new ViewTableFrame(modelTable, fontMetrics, this, this.m_controller);
        viewTableFrame.addMetaInfoListener(new I_BOSetText(){

            public void boSetText(I_SQLRenderer i_SQLRenderer) throws BOjavakException {
            }

            public void boSetText(String string) throws BOjavakException {
            }

            public void boSetText(I_TableData i_TableData) throws BOjavakException {
                Object[][] objectArray = i_TableData.getTableFormatValues();
                Object[] objectArray2 = i_TableData.getTableFormatColumns();
                AbstractTableModel abstractTableModel = new AbstractTableModel(this, objectArray2, objectArray){
                    private final /* synthetic */ Object[] val$header;
                    private final /* synthetic */ Object[][] val$values;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$header = objectArray;
                        this.val$values = objectArray2;
                    }

                    public int getColumnCount() {
                        return this.val$header.length;
                    }

                    public int getRowCount() {
                        return this.val$values.length;
                    }

                    public Object getValueAt(int n, int n2) {
                        return this.val$values[n][n2];
                    }
                };
                JTable jTable = ViewTableFrameManager.this.m_controller.getBottomArea().getInfoArea();
                jTable.setModel(abstractTableModel);
                int n = 0;
                while (n < objectArray2.length) {
                    jTable.getColumnModel().getColumn(n).setHeaderValue(objectArray2[n]);
                    ++n;
                }
            }
        });
        this.add(viewTableFrame);
        this.setLastActiveFrame(viewTableFrame);
        int n2 = viewTableFrame.getRootPane().getLocation().y;
        int n3 = n % 10 * n2;
        viewTableFrame.setLocation(n3, n3);
        viewTableFrame.moveToFront();
        this.fireVisualActionEvent();
        return viewTableFrame;
    }

    public Dimension getPreferredSize() {
        JInternalFrame[] jInternalFrameArray = this.getAllTitleAttrFrames();
        Dimension dimension = new Dimension(0, 0);
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        int n = 0;
        while (n < jInternalFrameArray.length) {
            jInternalFrameArray[n].getBounds(rectangle);
            int n2 = rectangle.x + rectangle.width + 10;
            int n3 = rectangle.y + rectangle.height + 10;
            dimension.width = dimension.width > n2 ? dimension.width : n2;
            dimension.height = dimension.height > n3 ? dimension.height : n3;
            ++n;
        }
        return dimension;
    }

    public StringBuffer buildRestTables(boolean bl, StringBuffer stringBuffer, Vector vector, boolean bl2) {
        boolean bl3 = true;
        ViewTableFrame[] viewTableFrameArray = this.getAllAttrContainers();
        int n = 0;
        while (n < viewTableFrameArray.length && !bl) {
            ViewTableFrame viewTableFrame = viewTableFrameArray[n];
            if (!vector.contains(viewTableFrame)) {
                if (!stringBuffer.toString().equals("")) {
                    if (bl3 && !bl2) {
                        stringBuffer = new StringBuffer("(" + stringBuffer + "), ");
                    } else {
                        stringBuffer.append(", ");
                    }
                }
                stringBuffer.append(this.m_controller.getStringManipulater().quoteString(viewTableFrame.getModelTable().getName()));
                bl3 = false;
            }
            ++n;
        }
        return stringBuffer;
    }

    public String getSQLTables() {
        String string = "";
        Hashtable hashtable = this.getUniqueTablenameList(null);
        Vector vector = new Vector(hashtable.size());
        Enumeration<Object> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((String)object).compareTo((String)object2);
            }
        };
        Collections.sort(vector, comparator);
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string.equals("")) {
                string = string + ", ";
            }
            string = string + this.m_controller.getStringManipulater().quoteString(string2);
        }
        return string;
    }

    public void drawMovingMouse(MouseEvent mouseEvent, ViewTableFrame viewTableFrame, int n, int n2, int n3) {
        ViewTableFrame viewTableFrame2 = this.getContainer(n2, n3, viewTableFrame);
        int n4 = -1;
        if (viewTableFrame2 != null) {
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            viewTableFrame2.getRootPane().getBounds(rectangle);
            n4 = viewTableFrame2.getClickedAttrIdx(n2 - viewTableFrame2.getX() - rectangle.x, n3 - viewTableFrame2.getY() - rectangle.y);
            viewTableFrame2.setMarkedIndex(n4);
        }
        this.movedRelation = this.relManager.drawMovingRelation(viewTableFrame, n, viewTableFrame2, n4, n2, n3, this.getGraphics(), this.movedRelation);
    }

    public void delegateMouseReleased(MouseEvent mouseEvent, ViewTableFrame viewTableFrame, int n, int n2, int n3) {
        this.relManager.eliminateDraggingRelation();
        ViewTableFrame viewTableFrame2 = this.getContainer(n2, n3, viewTableFrame);
        if (viewTableFrame2 != null) {
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            viewTableFrame2.getRootPane().getBounds(rectangle);
            int n4 = viewTableFrame2.getClickedAttrIdx(n2 - viewTableFrame2.getX() - rectangle.x, n3 - viewTableFrame2.getY() - rectangle.y);
            if (n4 >= 0) {
                this.relManager.addRelation(viewTableFrame, n, viewTableFrame2, n4);
            }
        }
        this.revalidate();
        this.repaint();
    }

    public ViewTableFrame getContainer(int n, int n2, ViewTableFrame viewTableFrame) {
        ViewTableFrame[] viewTableFrameArray = this.getAllAttrContainers();
        int n3 = 0;
        while (n3 < viewTableFrameArray.length) {
            ViewTableFrame viewTableFrame2 = viewTableFrameArray[n3];
            if (viewTableFrame2.contains(n - viewTableFrame2.getX(), n2 - viewTableFrame2.getY()) && viewTableFrame2 != viewTableFrame) {
                return viewTableFrame2;
            }
            ++n3;
        }
        return null;
    }

    public void mouseReleasedAfterMoving() {
        this.revalidate();
        this.repaint();
    }

    private ViewTableFrame[] getAllAttrContainers() {
        JInternalFrame[] jInternalFrameArray = this.getAllTitleAttrFrames();
        ViewTableFrame[] viewTableFrameArray = new ViewTableFrame[jInternalFrameArray.length];
        int n = 0;
        while (n < jInternalFrameArray.length) {
            viewTableFrameArray[n] = (ViewTableFrame)jInternalFrameArray[n];
            ++n;
        }
        return viewTableFrameArray;
    }

    private Hashtable getUniqueTablenameList(ViewTableFrame viewTableFrame) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ViewTableFrame[] viewTableFrameArray = this.getAllAttrContainers();
        int n = 0;
        while (n < viewTableFrameArray.length) {
            ViewTableFrame viewTableFrame2 = viewTableFrameArray[n];
            if (viewTableFrame2 != viewTableFrame) {
                hashtable.put(viewTableFrame2.getModelTable().getName(), "1");
            }
            ++n;
        }
        return hashtable;
    }

    public void removeAttrContainer(ViewTableFrame viewTableFrame) {
        this.removeAttrContainer(viewTableFrame, true);
    }

    private void removeAttrContainer(ViewTableFrame viewTableFrame, boolean bl) {
        this.relManager.removeRelationsWithObject(viewTableFrame);
        this.m_controller.getAttributeModificationManager().removeNoneTableLines(this.getUniqueTablenameList(viewTableFrame));
        if (bl) {
            this.fireVisualActionEvent();
            this.revalidate();
            this.repaint();
        }
    }

    public void removeAllTables() {
        ViewTableFrame[] viewTableFrameArray = this.getAllAttrContainers();
        int n = 0;
        while (n < viewTableFrameArray.length) {
            this.removeAttrContainer(viewTableFrameArray[n], false);
            ((Container)this).remove(viewTableFrameArray[n]);
            ++n;
        }
        this.revalidate();
        this.repaint();
    }

    public void addTable(String string, String string2, String string3, String string4, String string5) throws BOjavakException {
        this.m_controller.addTable(string, string2, string3, string4, string5);
    }

    public void setErrorMsg(String string) {
        this.m_controller.setErrorMsg(string);
    }
}

