PROGRAM umlaut;
USES CRT;

{$DEFINE fpc}

{$I-}

CONST
  {$IFNDEF fpc}       { Umlaute unter Dos/Windows }
  lae_kc   = #132;
  loe_kc   = #148;
  lue_kc   = #129;
  ss_kc    = #225;
  uae_kc   = #142;
  uoe_kc   = #153;
  uue_kc   = #154;
  {$ELSE}             { Umlaute unter Linux }
  lae_kc   = #228;
  loe_kc   = #246;
  lue_kc   = #252;
  ss_kc    = #223;
  uae_kc   = #196;
  uoe_kc   = #214;
  uue_kc   = #220;
{$ENDIF}
  escape   : ARRAY[0..6] OF STRING
           = ('\a','\o','\u','\s','\A','\O','\U');
  ascii    : ARRAY[0..6] OF CHAR
           = (lae_kc,loe_kc,lue_kc,ss_kc,uae_kc,uoe_kc,uue_kc);



VAR
  f1,f2       : TEXT;
  n1,n2,dummy : STRING;
  mode        : CHAR;
  i,j         : BYTE;

PROCEDURE Error;
BEGIN
  WRITELN('Fehler');
  HALT;
END;

PROCEDURE SwpStr(VAR str : STRING; oldstr,newstr : STRING);
VAR
  k : BYTE;
BEGIN
  WHILE POS(oldstr,str)>0 DO
  BEGIN
    k:=POS(oldstr,str);
    DELETE(str,k,LENGTH(oldstr));
    INSERT(newstr,str,k);
  END;
END;

BEGIN
  IF PARAMCOUNT=2 THEN
  BEGIN
    dummy:=COPY(PARAMSTR(1),1,2);
    IF LENGTH(dummy)>1 THEN
    BEGIN
      mode:=UPCASE(dummy[2]);
      IF NOT(mode IN ['A','E']) THEN Error;
    END ELSE Error;
    n1:=PARAMSTR(2);
    i:=POS('.',n1);
    IF i>0 THEN n2:=COPY(n1,1,i-1)+'.uml'
           ELSE n2:=n1+'.uml';
    ASSIGN(f1,n1);
    RESET(f1);
    IF IORESULT=0 THEN
    BEGIN
      ASSIGN(f2,n2);
      REWRITE(f2);
      IF IORESULT=0 THEN
      BEGIN
        WHILE NOT EOF(f1) DO
        BEGIN
          READLN(f1,dummy);
          IF dummy<>'' THEN
          BEGIN
            CASE mode OF
              'A' : FOR j:=0 TO 6 DO SwpStr(dummy,ascii[j],escape[j]);
              'E' : FOR j:=0 TO 6 DO SwpStr(dummy,escape[j],ascii[j]);
            END;
          END;
          WRITELN(f2,dummy);
        END;
        CLOSE(f1);
        CLOSE(f2);
        ERASE(f1);
        ASSIGN(f2,n2);
        RENAME(f2,n1);
        WRITELN('Ok');
      END ELSE Error;
    END ELSE Error;
  END ELSE BEGIN
             WRITELN('Syntax: -Option Quelldatei');
             WRITELN('a - Ascii nach Escape');
             WRITELN('e - Escape nach Ascii');
           END;
END.
