//
//  XTHtmlTagBanner.m
//  TadsTerp
//
//  Created by Rune Berg on 08/06/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTHtmlTagBanner.h"
#import "XTBaseTextHandler.h"
#import "XTAllocDeallocCounter.h"


@implementation XTHtmlTagBanner

OVERRIDE_ALLOC_FOR_COUNTER
OVERRIDE_DEALLOC_FOR_COUNTER

+ (NSString *)name
{
	return @"banner";
}

+ (BOOL)standalone
{
	return NO;
}

+ (BOOL)forT3
{
	return NO;
}

- (NSString *)safeBannerId
{
	NSString *bannerId = [self attributeAsString:@"id"];
	if (bannerId == nil) {
		bannerId = @"(no id)";
	}
	return bannerId;
}

- (BOOL)isForRemovingBanners
{
	BOOL res = ([self hasAttribute:@"removeall"] || [self hasAttribute:@"remove"]);
	return res;
}

- (void)onParsing:(NSObject<XTOutputTextParserProtocol> *)parser
{
	if ([self shouldBehaveAsContainer]) {
		[super onParsing:parser];
	} else {
		// XTHtmlTag behaviour:
		self.closed = YES;
		[parser appendTagToCurrentContainer:self];

	}
}

- (void)onClose:(NSObject<XTOutputTextParserProtocol> *)parser
{
	if ([self shouldBehaveAsContainer]) {
		[super onClose:parser];
	}
}

- (void)format:(NSObject<XTOutputFormatterProtocol> *)formatter
   textHandler:(XTBaseTextHandler *)textHandler;
{
	[super format:formatter textHandler:textHandler];

	NSArray *formattedElements = [formatter handleHtmlTagBannerOpen:self];
	[textHandler receiveFormattedElements:formattedElements];
}

- (void)formatExit:(NSObject<XTOutputFormatterProtocol> *)formatter
	   textHandler:(XTBaseTextHandler *)textHandler
{
	if ([self shouldBehaveAsContainer]) {
		NSArray *formattedElements = [formatter handleHtmlTagBannerClose];
		[textHandler receiveFormattedElements:formattedElements];

		[super formatExit:formatter textHandler:textHandler];
	}
}

- (BOOL)shouldBehaveAsContainer
{
	return (! [self isForRemovingBanners]);
}

@end
