//
//  XTFormattedOutputElement.h
//  TadsTerp
//
//  Created by Rune Berg on 10/07/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTHtmlTag.h"


@interface XTFormattedOutputElement : NSObject

typedef NS_ENUM(NSInteger, XTFormattedOutputElementType) {
    XTFormattedOutputElementRegularOutput,
	XTFormattedOutputElementTab,
    XTFormattedOutputElementGameTitle,
	XTFormattedOutputElementBannerStart,
	XTFormattedOutputElementBannerEnd,
	XTFormattedOutputElementBannerClear,
	XTFormattedOutputElementStatusLineModeStart,
	XTFormattedOutputElementStatusLineModeEnd,
	XTFormattedOutputElementStatusLineModeSuppress,
	XTFormattedOutputElementClearWhitespaceBeforeOrAfterBlockLevelTag,
	XTFormattedOutputElementBody,
	XTFormattedOutputElementTableStart,
	XTFormattedOutputElementTableEnd,
	XTFormattedOutputElementTableCaptionBottomStart,
	XTFormattedOutputElementTableCaptionBottomEnd,
	XTFormattedOutputElementTableCaptionTopStart,
	XTFormattedOutputElementTableCaptionTopEnd
};

@property XTFormattedOutputElementType elementType;
@property NSMutableAttributedString *attributedString;
@property XTHtmlTag *htmlTag;

+ (instancetype)regularOutputElement:(NSMutableAttributedString *)attributedString;

+ (instancetype)tabElement:(XTHtmlTag *)htmlTag attributedString:(NSMutableAttributedString *)attributedString;

+ (instancetype)gameTitleElement:(NSMutableAttributedString *)attributedString;

+ (instancetype)bannerStartElement:(XTHtmlTag *)htmlTag;

+ (instancetype)bannerEndElement;

+ (instancetype)bannerClearElement;

+ (instancetype)statusLineModeStart;

+ (instancetype)statusLineModeEnd;

+ (instancetype)statusLineModeSuppress;

+ (instancetype)clearWhitespaceBeforeOrAfterBlockLevelTagOutputElement;

+ (instancetype)bodyElement:(XTHtmlTag *)htmlTag;

+ (instancetype)tableStartElement;

+ (instancetype)tableEndElement;

+ (instancetype)tableCaptionBottomStartElement;

+ (instancetype)tableCaptionBottomEndElement;

+ (instancetype)tableCaptionTopStartElement;

+ (instancetype)tableCaptionTopEndElement;

- (BOOL)isRegularOutputElement;

- (BOOL)isTabElement;

- (BOOL)isRegularOutputElementWithString:(NSString *)str;

- (BOOL)isGameTitleElement;

- (BOOL)isBannerStartElement;

- (BOOL)isBannerEndElement;

- (BOOL)isBannerClearElement;

- (BOOL)isStatusLineModeStart;

- (BOOL)isStatusLineModeEnd;

- (BOOL)isStatusLineModeSuppress;

- (BOOL)isClearWhitespaceBeforeOrAfterBlockLevelTagOutputElement;

- (BOOL)isTableStart;

- (BOOL)isTableEnd;

- (BOOL)isBody;

- (BOOL)isTableCaptionBottomStartElement;

- (BOOL)isTableCaptionBottomEndElement;

- (BOOL)isTableCaptionTopStartElement;

- (BOOL)isTableCaptionTopEndElement;

- (NSString *)elementTypeAsString;

@end
