////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: itemCount() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _ITEM_COUNT_T_
#define _ITEM_COUNT_T_

#include <isindistinguishable.t>

#pragma C+

/*
 *  itemCount: function(list, flags)
 *
 *  Returns a count of the "listable" objects in list.  An
 *  object is listable (that is, it shows up in a room's description)
 *  if its isListed property is true.  This function is
 *  useful for determining how many objects (if any) will be listed
 *  in a room's description.  Indistinguishable items are counted as
 *  a single item (two items are indistinguishable if they both have
 *  the same immediate superclass, and their isEquivalent properties
 *  are both true.
 */
itemCount: function(list, ...) {
    local cnt, tot, i, obj, j;
    local flags = 0;
    
    if (argcount > 1) flags = getarg(2);

    tot = length(list);
    for (i = 1, cnt = 0 ; i <= tot ; ++i) {
        /* only consider this item if it's to be listed */
        obj = list[i];
        if ((flags & LCG_LISTALL) == LCG_LISTALL || obj.isListed) {
            /*
             *   see if there are other equivalent items later in the
             *   list - if so, don't count it (this ensures that each such
             *   item is counted only once, since only the last such item
             *   in the list will be counted) 
             */
            if (obj.isEquivalent) {
                local sc;
                
                sc = firstsc(obj);
                for (j = i + 1 ; j <= tot ; ++j) {
                    if (isIndistinguishable(obj, list[j]))
                        goto skip_this_item;
                }
            }
            
            /* count this item */
            ++cnt;
            
        skip_this_item: ;
        }
    }
    return cnt;
}

#pragma C-

#endif /* _ITEM_COUNT_T_ */
