////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: indirectlyContains() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _INDIRECTLY_CONTAINS_T_
#define _INDIRECTLY_CONTAINS_T_

#include <parent.t>

#pragma C+

/*
 *  indirectlyContains(o1, o2)
 *  
 *  Returns true if the common ancestor of o1 and o2 is o1; otherwise
 *  returns nil.
 */
indirectlyContains: function(o1, o2) {
    while (o2 != nil) {   
        if (o1 == o2)
            return true;
        o2 = parent(o2);
    }
    return nil;
}

#pragma C-

#endif /* _INDIRECTLY_CONTAINS_T_ */
