////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: endCommand() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _END_COMMAND_T_
#define _END_COMMAND_T_

#include <gactor.t>
#include <gcmdwordlist.t>
#include <gdobj.t>
#include <gdolist.t>
#include <giobj.t>
#include <gprep.t>
#include <gstatus.t>
#include <gverb.t>
#include <nestoutcapture.t>

#include <global.t>
#include <queue.t>

#pragma C+

endCommand: function(actor, verb, doList, prep, iobj, status) {
    local i, o, str, strList = [], scopeList;
    
    // Set Phase and Stage
    global.setCommandPhase(CP_ENDCOMMAND);
    
    // Set command status
    if (gStatus() == 0) gStatus(status);
    
    // Get remaining outcaptured display from aborted action methods
    str = nestOutcapture(nil);
    say(str);

    /*
     *  Display any queued messages that might not have been displayed
     *  due to an exit or abort.
     */
    queue.processQueue;
    global.prefixShow = nil;
    
    // Get list of endCommand reaction objects based on verb.scopeSense
    scopeList = actor.scope(verb.scopeSense, [], nil, nil);
    scopeList = intersect(scopeList, global.scopeEndCommandList);

    // Actor Reaction
    actor.actorEndCommand;

    // Location Reaction
    if (actor.location)
        actor.location.locEndCommand;
    
    // Queue list of Scope Object Reactions
    for (i = 1; i <= length(scopeList); ++i) {
        o = scopeList[i];
        
        if (o == actor || find(doList, o) != nil || o == iobj || o ==
        actor.location)
            continue;
            
        nestOutcapture(true);
        o.scopeEndCommand;
        str = nestOutcapture(nil);
        if (str != '')
            strList += [str];
    }
    for (i = 1; i <= length(strList); ++i) {
        str = strList[i];
        queue.queueMessage(actor, verb, doList, prep, iobj, status,
            str);
    }
    queue.processQueue;
    
    // Iobj Reaction
    if (iobj)
        iobj.iobjEndCommand;
    
    // Loop through Dobj Reactions
    for (i = 1; i <= length(doList); ++i) 
        doList[i].dobjEndCommand;    
    
    // Reset nestOutcapture - empty the stacks
    nestOutcapture(nil, true);
    
    gActor(parserGetMe());
    gVerb(nil);
    gDoList(nil);
    gDobj(nil);
    gPrep(nil);
    gIobj(nil);
    gStatus(0);

    gCmdWordList([]);
    
    // Set Phase and Stage
    global.setCommandPhase(CP_PARSING);
}

#pragma C-

#endif /* _END_COMMAND_T_ */
