////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: askForDobj() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _ASK_FOR_DOBJ_T_
#define _ASK_FOR_DOBJ_T_

#include <global.t>

#pragma C+

/*
 *  askForDobj: function
 *
 *  This is a simple cover function for the built-in function askdo.
 *  This cover function displays any outcaptured display. Note, that
 *  askdo does not return.
 */
askForDobj: function {
    local str;

    /* Capture any outcapture text and display it. */
    str = nestOutcapture(nil, true);
    say(str);
    
    /* ask for dobj */
    askdo;
}

#pragma C-

#endif /* _ASK_FOR_DOBJ_T_ */
