////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: RoomTravelable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _ROOM_TRAVELABLE_H_
#define _ROOM_TRAVELABLE_H_

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  RoomTravelable: object
 */
class RoomTravelable: object
    /*
     *   Direction handlers.  The directions are all set up to
     *   the default, which is no travel allowed.  To make travel
     *   possible in a direction, just assign a room to the direction
     *   property.
     */
    north = { return self.noExit; }
    south = { return self.noExit; }
    east  = { return self.noExit; }
    west  = { return self.noExit; }
    up    = { return self.noExit; }
    down  = { return self.noExit; }
    ne    = { return self.noExit; }
    nw    = { return self.noExit; }
    se    = { return self.noExit; }
    sw    = { return self.noExit; }
    in    = { return self.noExit; }
    out   = { return self.noExit; }
    
    /*
     *   noExit displays a message when the player attempts to travel
     *   in a direction in which travel is not possible.
     */
    noExit = { "%You% can't go that way. "; return nil; }
;

#pragma C-

#endif /* _ROOM_TRAVELABLE_H_ */
