////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: EnterableDisplayable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _ENTERABLE_DISPLAYABLE_H_
#define _ENTERABLE_DISPLAYABLE_H_

#include <roomdisplayable.h>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  EnterableDisplayable: RoomDisplayable
 *
 *  Rules for room display in an Enterable-style room.
 */
class EnterableDisplayable: RoomDisplayable
    /* 
     *  enterable objects should define an insideDesc if a description
     *  should be displayed.
     */
    insideDesc = ""
    
    /*
     *  In general we don't do a lookAround() when we enter an
     *  Enterable-style room.
     */
    enterRoom(actor) = {}
    lookAround(verbosity) = {
        self.dispBeginsDesc;
        self.statusRoot;
        self.dispEndsDesc;
        
        if (!self.isLit(gActor())) {
            self.dispParagraph;
            "It's pitch black. ";
        } else {
            if (self.location 
            && gActor().canSenseObj(sight, self.location)) {
                self.location.xtndLkAround(verbosity);
            }
        
            self.nrmLkAround(verbosity);
        }
    }
    
    statusRoot = {
        if (!self.isLit(gActor()))
            "In the dark.";
        else if (gActor().canSenseObj(sight, self.location))
            "<<self.location.sDesc>>, <<gActor().posture.desc>> 
            <<self.boardingPrep>> <<self.theDesc>>";
        else {
            caps();
            self.theDesc;
        }
    }  
;

#pragma C-

#endif /* _ENTERABLE_DISPLAYABLE_H_ */
