////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Connector 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//  Based on ADV3 (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _CONNECTOR_H_
#define _CONNECTOR_H_

#include <floatingdestination.h>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  Connector: FloatingDestination, Connection
 *
 *  Acts as a multi-way conduit for sense-passing between different 
 *  locations. If you desire a one-way conduit use a Connection.
 */
class Connector: FloatingDestination, Connection
    /*
     *  Returns a list of locations. If object has no location then the
     *  method returns an empty list. This method is used by scope() to 
     *  build a path that connects all of the object's possible
     *  locations.
     */
    getLocationsList = {
        local ret;
        if (proptype(self, &foundIn) == DTY_NIL)
            return [];
        else ret = self.foundIn;
        
        switch(datatype(foundIn)) {
            case DTY_OBJECT:
                return [ ret ];
            case DTY_LIST:
                return ret;
            default:
                return [];
        }
    }
    
; 

#pragma C-

#endif  /* _CONNECTOR_H_ */
