#ifndef SENSES
#define SENSES
#pragma C+

/*
** Senses.t --  Adds sound and smell descriptions to items.  Most everything
**              in here is thanks to Neil deMause.  Anything which isn't is
**              marked by my (Stephen Granade's) initials.
**
** Version history:
**   5 Apr 96 -- Initial release
**  24 Aug 96 -- Added a modification to room and Actor, as well as sense
**               information to verbs.  Also, the default touchdesc and
**               smelldesc now take isThem into account.
*/

#include "version.t"

sensesVersion : versionTag
    id="$Id: senses.t v1.0  7 Apr 96\n"
    author = 'Neil deMause'
    func = 'smell and listen handling'
;

// The new verbs
smellVerb:deepverb
    verb='smell'
    sdesc="smell"
    action(actor)={Me.location.smelldesc;} // can have a global room smell
    doAction='Smell'
;

listenverb:deepverb
    verb='listen'
    sdesc="listen"
    action(actor)={Me.location.listendesc;}    //add a listendesc
;                               //for any location
                                //where "listen" 
                                //should get a 
                                //specific response


listentoverb:deepverb
    verb='listen to'
    sdesc="listen to"
    doAction='ListenTo'
;


// Modification to touchVerb to add "feel" to it.  SRG
modify touchVerb
    verb = 'feel'
;


// New additions to "thing" to handle the new senses
modify thing
    verDoSmell(actor)={}
    doSmell(actor)={self.smelldesc;}
    smelldesc="\^<<self.thedesc>> <<self.isThem ? "do" : "does">>n't smell like
        anything in particular."
    verDoTouch(actor)={}
    doTouch(actor)={self.touchdesc;}
    touchdesc="<<!self.isThem ? "It feels" : "They feel" >> just like <<
        self.adesc>>."
    listendesc="You don't hear anything."
    verDoListenTo(actor)={}
    doListenTo(actor)={self.listendesc;}
;


// SRG: Modification to room so that "smell" doesn't print the room's thedesc.
modify room
    smelldesc = "%You% %do%n't smell anything unusual."
;


// SRG: Modification to Actor's touchdesc
modify Actor
    touchdesc = "I don't think <<self.thedesc>> would appreciate that. "
;


// Intangible, for smells and sounds and whatnot.  It can't be felt, looked
//  at, &c.
class intangible : fixeditem
    takedesc = "That can't be taken."
    verDoMove(actor)={"That can't be moved.";}
    verDoTouch(actor)={"That can't be touched.";}
    ldesc="That's not visible."
    verDoLookbehind(actor)="That's not visible."
    verDoAttack(actor)={"That can't be attacked.";}
    verDoAttackWith(actor)={"That can't be attacked.";}
    verIoPutOn(actor)={"You can't put anything on that.";}
;


// SRG: I have marked every verb which obviously requires the use of sight
//      with "sight=true".  This is useful if you want a room with a light
//      so bright that you cannot "look", "look at", &c.
modify inspectVerb
    sight=true;
modify lookBehindVerb
    sight=true;
modify lookInVerb
    sight=true;
modify lookThruVerb
    sight=true;
modify lookUnderVerb
    sight=true;
modify lookVerb
    sight=true;
modify readVerb
    sight=true;

#endif
