hell: room
  sdesc = "Hell"
  ldesc = {
    if (!self.seen) {
      self.seen := true;
      setdaemon(hellTimeDaemon,nil);                   // Cacofiend attacks you
      Me.dreaming := true;
    }
    "Being damned for all eternity, this is your 'home'. This particular cell of yours has no 
    real name or identifiable markings. You can't even recall if you've always been in this 
    particular station, or some other any longer. It appears to be a claustrophobic, hollowed-out 
    cave within the heart of an active volcano. If you strain, you can make out passageways
    to other caves, but turning your head to the side is often prohibitively painful. ";
  }
  noexit = "You're frozen in fear. "
  cnt = 1                                               // which turn in hell
  listendesc = {
    if (self.beeping)
      wakeup();
    else
      "You hear the sound of souls burning in agony. ";
  }
;

cave: decoration
  sdesc = "cave"
  noun = 'cave'
  location = hell
  ldesc = "One of many thousands, all alike. "
;
  
cacofiend: Actor
  location = hell
  sdesc = "Cacofiend"
  noun = 'cacofiend' 'fiend' 'creature' 'demon' 'devil'
  adjective = 'brawny' 'sinewy'
  takedesc = "I don't think that is possible. "
  ldesc = {
    "The Cacofiend is eight or nine feet tall, proportionally wide, and enormously muscular. Its skin 
    appears to be a kind of unearthly, fire-charred, thick crimson hide. Its face is grotesque, 
    misshapen -- with caking and protruding horns screaming out from its skull, angry daggers 
    for eyes, a rotting, bulbous nose...\ it's incapable of bearing personal malice, and carries itself
    like a mindless automation. ";
  }
  isHim = true
  actorDesc = {
    if (!self.seen) {
      self.seen := true;                // only display this the first time 
      "A brawny, sinewy Cacofiend stands before you, prepping you for the 
      punishment you are about to receive. ";
    }
    else {                                                                  
      "A Cacofiend is here. ";
    }
  }
  verDoSearch(actor) = { "He swats you away. "; }
  verDoHug(actor) = {"You hug the Cacofiend and he promptly tears your arms from your body. "; }
  verDoKiss(actor) = {"The Cacofiend turns away in disgust. "; }
  doSynonym('Search') = 'Lookin'
  actorAction(v, d, p, i) = {
    switch(rand(3)) {
      case 1:
        "<q>Rogga tu spi!</q>\ he bellows. ";
        break;
      case 2:
        "<q>Veezi un kie!</q>\ screams <<self.thedesc>>. ";
        break;
      case 3:
        "\^<<self.thedesc>> growls and stares right through you. ";
        break;
    }
    exit;
  }  
  verDoTellAbout(actor, io) = { self.verDoAskAbout(actor, io); }
  doTellAbout(actor, io) = { 
    "You wonder what <<self.thedesc>> has to say instead, so you ask him about it.\b";
    self.doAskAbout(actor, io); 
  }
  verDoAskFor(actor, io) = { self.disavow; }
  doAskFor(actor, io) = { self.doAskAbout(actor, io); }
  disavow = ""
  dontKnow = {
    local msg := [
      '<q>Rogga tu spi!</q>\ bellows '
      '<q>Veezi un kie!</q>\ screams ' 
      'A hearty, meaty laugh is what you get from '
      'A growl and a death stare is all you get from '
      '<q>Kayguh vo doe!</q>\ squeals ' 
    ];
    say(msg[rand(length(msg))]);
  }
  askWord(word, lst) = {
    dontKnow; "<<self.thedesc>>. ";
    return nil;
  }
  doHello = { 
    if (!self.helloSaid) {
      "<q>Grrr...</q>\ snorts <<self.thedesc>>. ";
      self.helloSaid := true;
    }
    else
      "\^<<self.sdesc>> stares intently at you. ";
  }
  verDoAttack(actor) = { }
  doAttack(actor) = { "It's hopeless. "; }
  verDoAttackWith(actor, iobj) = { }
  doAttackWith(actor, iobj) = { self.doAttack(actor); }
  doListenTo(actor) = { "\^<<self.sdesc>> isn't making much noise right now. "; }
  ioSynonym('GiveTo') = 'ShowTo'
  ioGiveTo(actor, dobj) = { "You're not carrying <<dobj.thedesc>>. "; }
  verDoTalkTo(actor) = { "You begin to speak but the cacofiend screams for your silence -- you quickly comply. "; }
;
  
intestine: fixeditem
  sdesc = "your intestine"
  adesc = "your intestine"
  thedesc = "your intestine"
  noun = 'intestine' 'intestines'
  ldesc = "Your intestine is in the process of disintegrating on the hot, scorched cave floor. "
  takedesc = "It's the least of your problems. "
;
    
breastbone: fixeditem
  sdesc = "your breastbone"
  adesc = { self.sdesc; }
  thedesc = { self.sdesc; }
  noun = 'breastbone' 'ribcage' 'rib' 'ribs'
  ldesc = "Your breastbone is exposed to the elements -- not a good thing. "
  takedesc = "It's the least of your problems. "
;

doctorStomach: fixeditem
  sdesc = "your stomach"
  adesc = { self.sdesc; }
  thedesc = { self.sdesc; }
  noun = 'stomach' 'belly' 'tummy'
  ldesc = "Seeing your stomach first hand is not a pretty site. "
  takedesc = "It's the least of your problems. "
;

doctorEntrails: fixeditem
  sdesc = "your entrails"
  adesc = { self.sdesc; }
  thedesc = { self.sdesc; }
  noun = 'entrails' 'guts'
  ldesc = "Seeing your entrails hanging from your ribcage is quite disconcerting. "
  takedesc = "It's the least of your problems. "
;

beepingSound: fixeditem
  sdesc = "beeping"
  noun = 'beeping' 'beep'
  ldesc = { wakeup(); }
  takedesc = "That's not something you can take. "
  listendesc = { wakeup(); }
;

wakeup: function
{
  "It sounds like a pager. Well, the parts that don't sound like souls burning in agony, anyway.\b ";
  "The Cacofiend hands you the pager. \b <q>It's for you...</q>\ he says with a shrug.\b ";
  morePrompt();                           // wait for any key
  remdaemon(hellTimeDaemon, nil);                
  Me.display := 'David McKinney, M.D';
  Me.travelTo(office);
  Me.dreaming := nil;
}

hellTimeDaemon: function(parm)
{
  if (hell.cnt > 0) "\b";                                 // force new line
  switch (hell.cnt++) {
    case 0:
      break;
    case 1:
      "The Cacofiend digs its nails into your flesh, right into the little divot above 
      your breastbone. You squirm, to no avail. ";
      breastbone.moveInto(hell);
      break;
    case 2:
      "The Cacofiend rips the skin of your chest, exposing your ribcage, stomach and 
      various entrails. One of your intestines slithers down to the hot floor. ";
      intestine.moveInto(hell);
      doctorStomach.moveInto(hell);
      doctorEntrails.moveInto(hell);
      break;
    case 3:
      "Something's beeping.\b";
      "The Cacofiend looks over toward your right for the source of the beeping. ";
      hell.beeping := true;
      beepingSound.moveInto(hell);
      break;
    case 4:
    case 5:
    case 6:
    case 7:
    case 9:
      "Something continues to beep. ";
      break;
    case 8:
      "Something continues to beep.\b ";
      "The Cacofiend looks over toward your right for the source of the beeping. ";
      break;
    case 10:
      "You look down and finally find the source of the beeping -- it's a pager. ";
      "The Cacofiend hands it to you. \b <q>It's for you...</q>\ he says.\b ";
      morePrompt();                           // wait for any key
      remdaemon(hellTimeDaemon, nil);                
      Me.display := 'David McKinney, M.D';
      Me.travelTo(office);
      break;
  }     
}     

office: room
  sdesc = "Your Office"
  ldesc = {
    if (!self.seen) {
      self.seen := true;
      "You never thought of yourself having some sort of 'God' complex, so awakening from a dream where you were 
      being burned alive in hell, purgatory or whatever is easily brushed off with a swig of Mr.\ Pibb and a couple 
      moments to simply compose yourself. You're on a hot streak now, anyway -- after successfully delivering
      quintuplets for that rock star two days ago (the lead singer for -- what was that band's name? 
      -- Scatbag or something, you think) you got the admiration of not only every Gen X-er on the staff, but your 
      daughter as well, for delivering the offspring of <q>the voice of her generation</q>. But impending fame 
      has its ups and downs -- while you're due to be interviewed by Salon.com for saving the woman's life, 
      it looks like your interviewer...\ will be Au James Wagner.\b
      You win some, you lose some. ";
      settimesys( '1:44 p.m.', 1, 2001, 10, 01 );
      setdaemon(burpDaemon, nil);
      pager.moveInto(Me);
      Me.whoDesc := 'You are also, technically, a shade damned to existing within a classical 
                    Christian afterlife according to the dreams you\'ve been having lately. ';
    }
    else {
      "You don't spend much time here in your office -- you've become much better 
      about organizing your time and responsibilities so you don't have to as you've
      gotten older. It's essentially a large, empty room dominated by your desk and computer. ";
    }
  }
  noexit = { "You can exit the office by going north. "; }
  north = { 
    local itemRem, thisItem;
    itemRem := parserGetMe().contents;
    while (car(itemRem)) {
      thisItem := car(itemRem);
      thisItem.moveInto(nil);
      itemRem := cdr(itemRem);
    }
    "You exit the office and rush over to the LDR.  You're updated by the nurse and quickly 
    head over to mom.  You take a look at the monitors, and do a very poor job of 
    attempting to conceal an expression of horror. You turn toward the nurse. \b
    <q>Let's get her over to the operating room,</q> you say.\b ";
    if (global.turnsofar < 34)                // if not past 1:54 already.
      settimesys( '1:53 p.m.', 1, 2001, 10, 01 );
    return ORdoctor;
  }
  out = (self.north)
  genericHint = true
;


officeItem: fixeditem
  sdesc = "Your Office"
  noun = 'office'
  ldesc = { office.ldesc; }
  location = office
  takedesc = "It's firmly attached. "
;

officeDesk: fixeditem, surface
  noun = 'desk'
  location = office
  sdesc = "desk"
  ldesc = "It's rather organized. "
;

officePC: fixeditem
  noun = 'PC' 'computer'    
  location = officeDesk
  sdesc = "computer"
  ldesc = "Your standard PC, monitor, keyboard, mouse, etc... You haven't had much to do 
          today -- it's running Solitaire for Windows. "
  verDoTurnon(actor) = { "The PC is already on. "; }
  verDoTurnoff(actor) = { "You always leave it on. "; }
;

officeScreen: fixeditem
  noun = 'screen' 'monitor'
  location = officePC
  sdesc = "screen"
  ldesc = "Solitaire for Windows is currently showing. "
  verDoTurnon(actor) = { "The monitor is already on. "; }
  verDoTurnoff(actor) = { "You always leave it on. "; }
  verDoRead(actor) = {self.ldesc;}
;

officeMouse: fixeditem
  noun = 'mouse' 
  location = officePC
  sdesc = "mouse"
  ldesc = "The mouse is not important. "
  verDoMove(actor) = { "You move the cursor around the screen. "; }
  verDoTouch(actor) = { "You move the cursor. "; }
;

officeKeyboard: fixeditem
  noun = 'keyboard' 
  location = officePC
  sdesc = "keyboard"
  ldesc = "The keyboard is not important. "
  verIoTypeOn( actor ) = { "Click...click...click... "; }
;

officeChair: chairitem
  sdesc = "chair"
  ldesc = "The chair is your standard office type chair; in other words, uncomfortable. "
  noun = 'chair'
  location = office
  reachable = { return(self.location.contents); }
;

solitaire: fixeditem
  sdesc = "solitaire"
  noun = 'solitaire'
  location = officeScreen
  ldesc = "Solitaire for Windows -- a classic. "
  takedesc = "It's a game on the PC. "
  verDoPlay(actor) = { 
    if (rand(20) = rand(20))
      "You actually win -- must be your lucky day! ";
    else
      "You lose the game. "; 
  }
;
    
pibb: item
  sdesc = "can of Mr.\ Pibb"
  noun = 'pibb'
  adjective = 'can of' 'can' 'mr.'
  location = office
  ldesc = "Ah, Mr.\ Pibb -- the unpopular carbonated beverage somewhat similar to Dr.\ Pepper, but without
          the six years of medical school. You've always had a soft spot for it. "
  verDoShake(actor) = { "There is no need to do that to <<self.thedesc>>. "; }
  verDoDrink(actor) = {}
  doDrink(actor) = {
    if (!self.isIn(Me)) {
      "You reach down and grab <<self.thedesc>> first. ";
      self.moveInto(Me);
    }
    "You take another swig. ";
  }
  count = 0
  isListed = {
    if (!self.seen) {
      self.seen := true;
      return nil;
    }
    else
      return true;
  }
  verDoDeflate(actor) = {}
  doDeflate(actor) = { self.doDrink(actor); }
  verDoOpen(actor) = { "It's already open. "; }
  verDoClose(actor) = { "You can't do that. "; }
;

burpDaemon: function(parm)
{
  switch (pibb.count++) {
    case 1:
      "\bYou let out a loud gassy burp; that Mr.\ Pibb was really carbonated. ";
      if (Me.location = ORdoctor)
        "The nurse looks at you and raises an eyebrow. ";
      break;
    case 5:
      "\bA small burp escapes from your mouth, definitely Mr.\ Pibb. ";
      if (Me.location = ORdoctor)
        "Thankfully, the nurse didn't hear it. ";
      break;
    case 10:
      "\bYou feel a bit gassy and force a burp, that Mr.\ Pibb is still haunting you. ";
      remdaemon(burpDaemon, nil);
      break;
  }
}

pager: item
  sdesc = "pager"
  noun = 'pager' 'beeper'
  ldesc = "From the extension, it looks like you're needed STAT in LDR 14. "
  verDoTurnoff(actor) = { "You should leave it on. "; }
  verDoTurnon(actor) = { "It's already on. "; }
;

ORdoctor: room
  sdesc = "Operating Room"
  ldesc = {
    "The Operating Room is fairly dark, save for the operating table 
    illuminated by the strong lights that the patient is on. ";
    if (!self.seen) {
      "The nurse updates you on the woman's condition. 
      \bBefore you is the patient's belly, prep'd for the C-Section. ";
      scalpel.moveInto(Me);
      self.seen := true;
    }
  }
  noexit = "You're not going anywhere right now. "
  genericHint = true
;

ORtable2: beditem
  sdesc = "OR table"
  ldesc = "The OR table is about three or four feet off the ground, and right next to a slew of medical
          equipment. The patient is currently on it. "
  noun = 'table'
  adjective = 'OR'
  outOfPrep = "off of"
  statusPrep = "on"
  location = ORdoctor
  verDoBoard(actor) = { "There's barely enough room for the patient. "; }
;

ORequipment2: decoration
  sdesc = "equipment"
  noun = 'equipment'
  location = ORdoctor
  ldesc = "The <<self.sdesc>> <<self.isntdesc>> important. "
;

patient: Actor
  sdesc = "patient"
  noun = 'patient' 'mom' 'charlise' 'woman'
  takedesc = "You decide to leave her be. "
  isHim = nil
  ldesc = {
    if (!belly.cut)
      "The patient is draped and ready for the C-Section. ";
    else
      "She's doing fine. ";
  }
  actorDesc = ""
  count = 0                             // used for daemon to trigger action
  location = ORdoctor
  msg = "You need to concentrate on the surgery. "
  verDoHug(actor) = { self.msg; }
  verDoKiss(actor) = { self.msg; }
  doSynonym('Search') = 'Lookin'
  actorAction(v, d, p, i) = { self.msg; }
  verDoTellAbout(actor, io) = { "The patient is sedated. "; }
  doTellAbout(actor, io) = { self.doAskAbout(actor, io); }
  verDoAskFor(actor, io) = { self.disavow; }
  doAskFor(actor, io) = { self.doAskAbout(actor, io); }
  disavow = "You need to concentrate on the surgery. "
  verDoAttack(actor) = {self.msg; }
  verDoAttackWith(actor, iobj) = {self.msg; }
  doListenTo(actor) = { "\^<<self.sdesc>> isn't making much noise right now. "; }
  ioSynonym('GiveTo') = 'ShowTo'
  ioGiveTo(actor, dobj) = { self.msg; }
  verDoTalkTo(actor) = { self.msg; }
  verDoCut(actor) = { 
    if (!scalpel.isIn(Me))
      "You try and use your finger, but it's not sharp enough. ";
    else if (belly.cut) 
      "The incision is large enough. ";
  }
  doCut(actor) = { 
    "(with the scalpel)\n";
    scalpel.ioCutWith(actor, self); 
  }
  verDoOperate(actor) = { self.verDoCut(actor); }
  doOperate(actor)  = { self.doCut(actor); }
;

belly: fixeditem
  sdesc = "belly"
  noun = 'belly' 'stomach'
  adjective = 'fat' 'woman\'s'
  location = patient
  ldesc = "The patient's stomach has been prepared for surgery. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached to her torso. "
  verDoRub(actor) = { "Out pops a Genie.  No, wait, that was your imagination.  You really should
                       cut back on Mr.\ Pibb. "; }
  verDoCut(actor) = { 
    if (!scalpel.isIn(Me))
      "You try and use your finger, but it's not sharp enough. ";
    else if (self.cut) 
      "The incision is large enough. ";
  }
  doCut(actor) = { 
    "(with the scalpel)\n";
    scalpel.ioCutWith(actor, self); 
  }
  verDoOperate(actor) = { self.verDoCut(actor); }
  doOperate(actor)  = { self.doCut(actor); }
;

scalpel: item
  sdesc = "scalpel"
  noun = 'scalpel'
  ldesc = "The scalpel is rather sharp. "
  verDoUse(actor) = {}
  doUse(actor) = { 
    "(on the patient's stomach)\n";
    self.ioCutWith(actor, belly);
  }
  verIoCutWith(actor) = {}
  ioCutWith(actor, dobj) = {
    if (!self.isIn(Me))
      "You're not carrying <<self.thedesc>>. ";
    else if (dobj = belly or dobj = patient) {
      if (belly.cut) 
        "The incision is large enough. "; 
      else {
        "You make a low transverse incision, and cut through the layers of muscle.  You can now see the baby. ";
        unbornBaby.moveInto(patient);
        belly.cut := true;
      }
    }
    else if (dobj = unbornCord) {
      "You double clamp the cord and cut it in the middle. ";
      unbornCord.moveInto(nil);
      setit(cutCord);    
      cutCord.moveInto(patient);
    }
    else if (dobj = nurse)
      "Easy there, Jack. ";
    else if (dobj = cutCord)
      "The cord does not present a problem any longer. ";
    else if (dobj = Me)
      "You already shaved today. ";
    else 
      "You shouldn't cut <<dobj.thedesc>> with <<self.thedesc>>. ";
  }
;

unbornBaby: fixeditem
  sdesc = "baby"
  noun = 'baby' 'head'
  ldesc = {
    if (cutCord.location = patient)
      "The baby girl looks like she can be easily delivered now. ";
    else
      "You notice the baby girl has a nucal cord. ";
    if (!self.seen) {
      "You try to reduce it by slipping the umbilical cord
      over the baby's head, but it's too tight. ";
      self.seen := true;
      unbornCord.moveInto(unbornBaby);
    }
  }
  verDoTake(actor) = { if (!self.seen) self.ldesc; }
  doTake(actor) = {
    if (cutCord.location = patient) {
      "The OR door swings open and somebody enters the room.  The nurse rushes over
      to him and has a quick conversation -- he takes a few steps back and watches intently. \b
      You reach in and extract the head.  The nurse suctions the head and nose, getting the 
      amniotic fluid out of the airway.  You then deliver the shoulders and the baby slides 
      out -- it doesn't make a sound.  You hand the baby girl to waiting pediatrician where 
      they attempt CPR.  After several minutes of frantic resuscitation, the baby stirs for a 
      moment, a split-second so short that you wonder if it existed at all. They continue to 
      attempt to revive her, but she collapses further. It's as if something more than
      a simple umbilical cord has taken her life...\b
      You see the worry and sweat pouring off the baby's father. This won't be easy...\ it never
      has been before. ";
      updateGameState('E');
      die();
    }
    else
      "You shouldn't deliver the baby until you've relieved the umbilical cord. ";
  }
  verDoPull(actor) = { self.verDoPull(actor); }
  verDoTurn(actor) = { 
    if (cutCord.location = patient)
      "The baby is in good position to be delivered. ";
    else
      "The umbilical cord prevents you from turning the baby. ";
  }
  verDoKiss(actor) = { "Yuch. "; }
  verDoAttack(actor) = { "You're license should be revoked. "; }
  
;

unbornCord: fixeditem
  sdesc = "umbilical cord"
  noun = 'cord'
  adjective = 'umbilical' 'nucal'
  ldesc = "It's wrapped around the little baby's neck. "
  takedesc = "You try to reduce the nucal cord, but it's just too tight. "
  verDoCut(actor) = { 
    if (!scalpel.isIn(Me))
      "You try and use your finger, but it's not sharp enough. ";
  }
  doCut(actor) = { 
    "(with the scalpel)\n";
    scalpel.ioCutWith(actor, self); 
  }
  verDoPull(actor) = { "You gently try and relieve the cord, but it's wrapped around the
                       baby's neck too tightly. "; }
  verDoPush(actor) = { "Pushing the nucal cord would probably cause more damage to the baby. "; }
  verDoMove(actor) = { "There is no give in the cord. "; }                       
  verDoUntie(actor) = { self.verDoPull(actor); }
;

cutCord: fixeditem
  sdesc = "umbilical cord"
  noun = 'cord'
  adjective = 'umbilical'
  ldesc = "It's been severed and is no longer a threat. "
  takedesc = "You gently tug at it, but it doesn't come out. "
  verDoCut(actor) = {}
  doCut(actor) = { 
    "(with the scalpel)\n";
    scalpel.ioCutWith(actor, self); 
  }
;

nurseOR: Actor
  sdesc = "nurse"
  name = 'nurse'
  noun = 'nurse' 'thompson'
  adjective = 'sarah'
  takedesc = "I don't think she would appreciate that. "
  isHer = true
  ldesc = "She looks to be in her mid-twenties and has dark hair and brown eyes beneath
          circular, Lennon-esque frames. "
  location = ORdoctor
  isHim = nil
  actorDesc = {
    if (!self.seen)
      self.seen := true;
    else if (self.location = LDR) {
      "The nurse is here. ";
    }
  }
  msg = "You need to concentrate on the surgery. "
  verDoHug(actor) = { self.msg; }
  verDoKiss(actor) = { self.msg; }
  doSynonym('Search') = 'Lookin'
  actorAction(v, d, p, i) = { self.msg; }
  verDoTellAbout(actor, io) = { "You should concentrate on the surgery. "; }
  doTellAbout(actor, io) = { self.doAskAbout(actor, io); }
  verDoAskFor(actor, io) = { self.disavow; }
  doAskFor(actor, io) = { self.doAskAbout(actor, io); }
  disavow = "You need to concentrate on the surgery. "
  verDoAttack(actor) = {self.msg; }
  verDoAttackWith(actor, iobj) = {self.msg; }
  doListenTo(actor) = { "\^<<self.sdesc>> isn't making much noise right now. "; }
  ioSynonym('GiveTo') = 'ShowTo'
  ioGiveTo(actor, dobj) = { self.msg; }
  verDoTalkTo(actor) = { self.msg; }
;

