/*
 * The Legend Lives!
 *
 * Executable and source code are
 *
 *                 Copyright (C) 1995 by David M. Baggett
 *
 * All rights reserved, except as follows:
 * 
 *    Electronic redistribution is permitted, but only if not for profit.
 *    Specifically, you may provide copies in electronic form ONLY if you
 *    do not charge anything beyond the distribution media cost AND if you
 *    do not alter the source code in any way.
 *
 * Note that the author reserves all rights to derivative works and
 * products.  This includes ports and enhanced versions.  The author will
 * typically grant permission for these when asked, but this will be
 * dealt with on a case by case basis only.
 *
 */

/*
 * Seed stuff.
 * Put here to reduce clutter in orf.t
 */
class sp: Readable, Item
	isseeds = true

	sdesc = { "packet of <<self.type>> seeds"; }
	ldesc = {
		"It's a small packet of seeds produced by Barfee,
		the galaxy's leading fruit and vegetable seed
		vendor.  The package reads \"Barfee "; self.type; " seeds:
		All seeds and no weeds, Barfee meets your
		needs in feeds.  Visit the Barfee Outlet:
		(8549, 4392, 8392).\"";
	}
	readdesc = { self.ldesc; }

	noun = 'seeds' 'packet' 'package' 'seed' 'barfee'

	//	
	// A long and disgusting set of overrides that we
	// shouldn't have to define.  We should update the
	// class library to unify all the "take" actions
	// at a low level, so that we can define an "on-take"
	// action that will happen when any of these verbs
	// are used.
	//
	paymessage = {
		"You'll have to pay for <<self.objprodesc(nil)>> first.";
	}
	verDoGiveto(actor, io) = {
		if (not VEGseller.paid and self.isin(VEGbin) or not FRUITseller.paid and self.isin(FRUITbin))
			self.paymessage;
		else
			inherited.verDoGiveto(actor, io);
	}	
	verDoPutX(actor, io, loctype) = {
		if (not VEGseller.paid and self.isin(VEGbin) or not FRUITseller.paid and self.isin(FRUITbin))
			self.paymessage;
		else
			inherited.verDoPutX(actor, io, loctype);
	}
	verDoTakeX(actor, obj, loctype) = {
		if (not VEGseller.paid and self.isin(VEGbin) or not FRUITseller.paid and self.isin(FRUITbin))
			self.paymessage;
		else
			inherited.verDoTakeX(actor, obj, loctype);
	}
	verDoPutthrough(actor, io) = {
		if (not VEGseller.paid and self.isin(VEGbin) or not FRUITseller.paid and self.isin(FRUITbin))
			self.paymessage;
		else
			inherited.verDoPutthrough(actor, io);
	}
	verDoThrowat(actor, io) = {
		if (not VEGseller.paid and self.isin(VEGbin) or not FRUITseller.paid and self.isin(FRUITbin))
			self.paymessage;
		else
			inherited.verDoThrowat(actor, io);
	}
	verDoThrowbehind(actor, io) = {
		if (not VEGseller.paid and self.isin(VEGbin) or not FRUITseller.paid and self.isin(FRUITbin))
			self.paymessage;
		else
			inherited.verDoThrowbehind(actor, io);
	}
	verDoThrowthrough(actor, io) = {
		if (not VEGseller.paid and self.isin(VEGbin) or not FRUITseller.paid and self.isin(FRUITbin))
			self.paymessage;
		else
			inherited.verDoThrowthrough(actor, io);
	}
	verDoThrowto(actor, io) = {
		if (not VEGseller.paid and self.isin(VEGbin) or not FRUITseller.paid and self.isin(FRUITbin))
			self.paymessage;
		else
			inherited.verDoThrowto(actor, io);
	}
	verDoThrowunder(actor, io) = {
		if (not VEGseller.paid and self.isin(VEGbin) or not FRUITseller.paid and self.isin(FRUITbin))
			self.paymessage;
		else
			inherited.verDoThrowunder(actor, io);
	}

	doTake(actor) = {
		if (self.isin(VEGbin)) {
			if (VEGseller.paid) {
				"The salescreature nods encouragingly as
				you reach into the bin and pull out the
				seed packet. ";
				
				VEGseller.paid := nil; // good for 1 packet
				inherited.doTake(actor);
			}
			else {
				"\"Senny, Au'm efrode yee nood tee pau 
				fair thawt sood pawckut,\" the salescreature
				chides.";
			}
		} 
		else if (self.isin(FRUITbin)) {
			if (FRUITseller.paid) {
				"As you reach into the fruit bin and fetch
				the seed packet, the Hoppian smiles broadly,
				revealing his two big front teeth. ";
				
				FRUITseller.paid := nil;
				inherited.doTake(actor);
			}
			else {
				"The Hoppian salesman raises his right paw.
				\"You'll have to pay first, I'm afraid,\"
				he says cautiously.";
			}
		}
		else
			inherited.doTake(actor);
	}
	verDoPlant(actor) = {}
	verDoPlantin(actor, io) = {}
	doPlant(actor) = { self.plantin(actor, nil); }
	plantin(actor, dobj) = {
#ifndef	DEMO
		if (Me.location = garden) {
			if (dobj <> nil and dobj <> gardendecoration)
				"You might try planting the seeds
				in the garden instead...";
			else {
				"You pour all the seeds out and bury them
				in the rich soil.  There is now a lump in
				the soil where you planted the seeds.";

				self.movein(nil);
				seedlump.myplant := self.myplant;
				seedlump.movein(Me.location);
				seedlump.makeknownto(Me);
			}
		}
		else {
#endif
			"This doesn't look like a very good place to
			plant seeds, frankly.";
#ifndef	DEMO
		}
#endif
	}
;

seedlump: Decoration
	grown = nil	// player hasn't pour growth formula on it yet
	myplant = nil	// what plant will come out of the lump
	sdesc = "lump in the soil where you planted seeds"
	ldesc = "All you can see is a lump where you planted the seeds."
	noun = 'lump' 'seeds'

	verDoTake(actor) = {
		"Getting the seeds back out of the ground where you planted
		them is going to be a tricky process at best.";
	}
;

class spv: sp isveg = true location = VEGbin;
class spf: sp isfruit = true location = FRUITbin;

// vegetable seeds
s1: spv
	type = "asparagus"
	myplant = plant1
	adjective = 'asparagus'
;
s2: spv
	type = "Todian bush bean"
	myplant = plant2
	adjective = 'todian' 'bush' 'bean'
;
s3: spv
	type = "Tellian pole bean"
	myplant = plant3
	adjective = 'tellian' 'pole' 'bean'
;
s4: spv
	type = "soybean"
	myplant = plant4
	adjective = 'soybean'
;
s5: spv
	type = "broccoli"
	myplant = plant5
	adjective = 'broccoli'
;
s6: spv
	type = "hawper sprouts"
	myplant = plant6
	adjective = 'hawper' 'sprouts'
;
s7: spv
	type = "cabbage"
	myplant = plant7
	adjective = 'cabbage'
;
s8: spv
	type = "Ten Foo"
	myplant = plant8
	adjective = 'ten' 'foo'
;
s9: spv
	type = "cantaloupe"
	myplant = plant9
	adjective = 'cantaloupe'
;
s10: spv
	type = "carrot"
	myplant = plant10
	adjective = 'carrot'
;
s11: spv
	type = "celery"
	myplant = plant11
	adjective = 'celery'
;
s12: spv
	type = "Tellian corn"
	myplant = plant12
	adjective = 'tellian' 'corn'
;
s13: spv
	type = "Hoppian black corn"
	myplant = plant13
	adjective = 'hoppian' 'black' 'corn'
;
eggseeds: spv, Knowntopic
	type = "Foonian eggplant"

#ifndef	DEMO
	myplant = egg
#endif

	adjective = 'foonian' 'eggplant'
;
s0: spv
	type = "Todian eggplant"
	myplant = plant0
	adjective = 'todian' 'eggplant'
;
s14: spv
	type = "tricolor corn"
	myplant = plant14
	adjective = 'tricolor' 'corn' 'tri' 'color' 'tri-color' 'colour' 'tri-colour'
;
s15: spv
	type = "cucumber"
	myplant = plant15
	adjective = 'cucumber'
;
s16: spv
	type = "endive"
	myplant = plant16
	adjective = 'endive'
;
s17: spv
	type = "Floran textured lettuce"
	myplant = plant17
	adjective = 'floran' 'textured' 'lettuce'
;
s18: spv
	type = "Alduvian pink lettuce"
	myplant = plant18
	adjective = 'alduvian' 'pink' 'lettuce'
;
s19: spv
	type = "Tellian lettuce"
	myplant = plant19
	adjective = 'tellian' 'lettuce'
;
s20: spv
	type = "onion"
	myplant = plant20
	adjective = 'onion'
;
s21: spv
	type = "pea"
	myplant = plant21
	adjective = 'pea'
;
s22: spv
	type = "peanut"
	myplant = plant22
	adjective = 'peanut'
;
s23: spv
	type = "radish"
	myplant = plant23
	adjective = 'radish'
;
s24: spv
	type = "spinach"
	myplant = plant24
	adjective = 'spinach'
;
s25: spv
	type = "strawberry"
	myplant = plant25
	adjective = 'strawberry'
;
s26: spv
	type = "yellow tomato"
	myplant = plant26
	adjective = 'yellow' 'tomato'
;
s27: spv
	type = "blue tomato"
	myplant = plant27
	adjective = 'blue' 'tomato'
;
s28: spv
	type = "watermelon"
	myplant = plant28
	adjective = 'watermelon'
; 

// Fruit seeds
s50: spf
	type = "blackberry"
	myplant = plant50
	adjective = 'blackberry'
;
s51: spf
	type = "blueberry"
	myplant = plant51
	adjective = 'blueberry'
;
s52: spf
	type = "boysenberry"
	myplant = plant52
	adjective = 'boysenberry'
;
s53: spf
	type = "elderberry"
	myplant = plant53
	adjective = 'elderberry'
;
s54: spf
	type = "Hoppian gooseberry"
	myplant = plant54
	adjective = 'gooseberry'
;
s55: spf
	type = "jostaberry"
	myplant = plant55
	adjective = 'jostaberry'
;
s56: spf
	type = "kiwi"
	myplant = plant56
	adjective = 'kiwi'
;
s66: spf
	type = "Floran gowperfruit"
	myplant = plant66
	adjective = 'florian' 'gowper' 'gowperfruit'
;
s57: spf
	type = "raspberry"
	myplant = plant57
	adjective = 'raspberry'
;
s59: spf
	type = "Grandpa Jones apple"
	myplant = plant59
	adjective = 'apple' 'grandpa' 'grampa' 'jones'
;
s60: spf
	type = "apricot"
	myplant = plant60
	adjective = 'apricot'
;
s61: spf
	type = "Tellian cherry"
	myplant = plant61
	adjective = 'cherry' 'tellian'
;
s62: spf
	type = "peach"
	myplant = plant62
	adjective = 'peach'
;
s63: spf
	type = "pear"
	myplant = plant63
	adjective = 'pear'
;
s64: spf
	type = "Todian plum"
	myplant = plant64
	adjective = 'plum' 'todian'
;
s65: spf
	type = "persimmon"
	myplant = plant65
	adjective = 'persimmon'
;
s67: spf
	type = "Akmi Dam Joosee Froot"
	myplant = plant67
	adjective = 'akmi' 'acme' 'dam'	'damn' 'joosee' 'juicy' 'froot'
;

/*
 * Each seed packet has an associated plant.
 */
class plant: Edible
	notraw = nil
	adesc = { self.sdesc; }
	theesc = { self.sdesc; }
	ldesc = "You see just what you'd expect."
	weight = 2
	bulk = 2
	verDoEat(actor) = {
		if (self.notraw)
			"Raw?  You've got to be kidding!";
	}
	doEat(actor) = {
		"Yum, yum!";
		self.movein(nil);
	}
;

/*
 * Vegetable plants
 */ 
plant1: plant
	sdesc = "some asparagus"
	noun = 'asparagus'
;
plant2: plant
	sdesc = "some Todian bush beans"
	noun = 'beans'
	adjective = 'todian' 'bush'
	notraw = true
;
plant3: plant
	sdesc = "some Tellian pole beans"
	adjective = 'tellian' 'pole'
	noun = 'beans'
	notraw = true
;
plant4: plant
	sdesc = "some soybeans"
	noun = 'soybeans'
	notraw = true
;
plant5: plant
	sdesc = "some broccoli"
	noun = 'broccoli'
;
plant6: plant
	sdesc = "some hawper sprouts"
	noun = 'sprouts'
	adjective = 'hawper'
	notraw = true
;
plant7: plant
	sdesc = "some cabbage"
	noun = 'cabbage'
;
plant8: plant
	sdesc = "some Ten Foo"
	noun = 'foo' 'tenfoo'
	adjective = 'ten'
;
plant9: plant
	sdesc = "cantaloupe"
	adesc = "a cantaloupe"
	thedesc = "the cantaloupe"
	noun = 'cantaloupe'
;
plant10: plant
	sdesc = "carrot"
	adesc = "a carrot"
	thedesc = "the carrot"
	noun = 'carrot'
;
plant11: plant
	sdesc = "some celery"
	noun = 'celery'
;
plant12: plant
	sdesc = "Tellian corn cob"
	adesc = "a Tellian corn cob"
	thedesc = "the Tellian corn cob"
	adjective = 'tellian' 'corn'
	noun = 'corn' 'cob'
;
plant13: plant
	sdesc = "Hoppian black corn cob"
	adesc = "a Hoppian black corn cob"
	thedesc = "the Hoppian black corn cob"
	adjective = 'hoppian' 'black' 'corn'
	noun = 'corn' 'cob'
;

plant0: plant
	sdesc = "Todian eggplant"
	adesc = "a Todian eggplant"
	thedesc = "the Todian eggplant"
	adjective = 'todian'
	noun = 'eggplant'
	notraw = true
;

plant14: plant
	sdesc = "tricolor corn cob"
	adesc = "a tricolor corn cob"
	thedesc = "the tricolor corn cob"
	adjective = 'tricolor' 'tri-color' 'tri' 'color' 'corn' 'colour'
	noun = 'corn' 'cob'
;
plant15: plant
	sdesc = "cucumber"
	adesc = "a cucumber"
	thedesc = "the cucumber"
	noun = 'cucumber'
;
plant16: plant
	sdesc = "some endive"
	noun = 'endive'
;
plant17: plant
	sdesc = "some Floran textured lettuce"
	adjective = 'floran' 'textured'
	noun = 'lettuce'
;
plant18: plant
	sdesc = "some Alduvian pink lettuce"
	adjective = 'alduvian' 'pink'
	noun = 'lettuce'
;
plant19: plant
	sdesc = "some Tellian lettuce"
	adjective = 'tellian'
	noun = 'lettuce'
;
plant20: plant
	sdesc = "onion"
	adesc = "an onion"
	thedesc = "the onion"
	noun = 'onion'
	notraw = true
;
plant21: plant
	sdesc = "some peas"
	noun = 'peas' 'pea'
;
plant22: plant
	sdesc = "some peanuts"
	noun = 'peanuts'
;
plant23: plant
	sdesc = "radish"
	adesc = "a radish"
	thedesc = "the radish"
	noun = 'radish'
;
plant24: plant
	sdesc = "some spinach"
	noun = 'spinach'
;
plant25: plant
	sdesc = "strawberry"
	adesc = "a strawberry"
	thedesc = "the strawberry"
	noun = 'strawberry'
;
plant26: plant
	sdesc = "yellow tomato"
	adesc = "a yellow tomato"
	thedesc = "the yellow tomato"
	adjective = 'yellow'
	noun = 'tomato'
;
plant27: plant
	sdesc = "blue tomato"
	adesc = "a blue tomato"
	thedesc = "the blue tomato"
	adjective = 'blue'
	noun = 'tomato'
;
plant28: plant
	sdesc = "watermelon"
	adesc = "a watermelon"
	thedesc = "the watermelon"
	noun = 'watermelon'
; 

/*
 * Fruit plants
 */
plant50: plant
	sdesc = "some blackberries"
	noun = 'blackberries'
;
plant51: plant
	sdesc = "some blueberries"
	noun = 'blueberries'
;
plant52: plant
	sdesc = "some boysenberries"
	noun = 'boysenberries'
;
plant53: plant
	sdesc = "some elderberries"
	noun = 'elderberries'
;
plant54: plant
	sdesc = "some Hoppian gooseberries"
	noun = 'gooseberries'
	adjective = 'Hoppian'
;
plant55: plant
	sdesc = "some jostaberries"
	noun = 'jostaberries'
;
plant56: plant
	sdesc = "kiwi"
	adesc = "a kiwi"
	thedesc = "the kiwi"
	noun = 'kiwi'
;
plant66: plant
	sdesc = "Floran gowperfruit"
	adesc = "a Floran gowperfruit"
	thedesc = "the Floran gowperfruit"
	adjective = 'florian' 'gowper'
	noun = 'gowperfruit' 'fruit'
;
plant57: plant
	sdesc = "raspberry"
	adesc = "a raspberry"
	thedesc = "the raspberry"
	noun = 'raspberry'
;
plant59: plant
	sdesc = "Grandpa Jones apple"
	adesc = "a Grandpa Jones apple"
	thedesc = "the Grandpa Jones apple"
	noun = 'apple'
	adjective = 'grandpa' 'grampa' 'jones'
;
plant60: plant
	sdesc = "apricot"
	adesc = "an apricot"
	thedesc = "the apricot"
	noun = 'apricot'
;
plant61: plant
	sdesc = "Tellian cherry"
	adesc = "a Tellian cherry"
	thedesc = "the Tellian cherry"
	noun = 'cherry'
	adjective = 'Tellian'
;
plant62: plant
	sdesc = "peach"
	adesc = "a peach"
	thedesc = "the peach"
	noun = 'peach'
;
plant63: plant
	sdesc = "pear"
	adesc = "a pear"
	thedesc = "the pear"
	noun = 'pear'
;
plant64: plant
	sdesc = "Todian plum"
	adesc = "a Todian plum"
	thedesc = "the Todian plum"
	noun = 'plum'
	adjective = 'Todian'
;
plant65: plant
	sdesc = "persimmon"
	adesc = "a persimmon"
	thedesc = "the persimmon"
	noun = 'persimmon'
;
theprune: plant
	sdesc = "prune"
	adesc = "a prune"
	thedesc = "the prune"
	noun = 'prune'
;
plant67: plant
	sdesc = "Akmi Dam Joosee Froot"
	adesc = "an Akmi Dam Joosee Froot"
	thedesc = "the Akmi Dam Joosee Froot"
	adjective = 'akmi' 'acme' 'dam' 'damn' 'joosee' 'juicy'
	noun = 'froot' 'fruit'

	verDoEat(actor) = {}
	doEat(actor) = {
		"Bleah!  The froot tastes like sugar-coated syntheplast!";
		self.movein(nil);
	}
;
