// Perdition's Flames - adv.t modifications
// copyright (c) 1993, 2002 by Michael J. Roberts

/* first include the normal definitions from adv.t */
#include <adv.t>

/*
   Define our own version of turncount
*/
replace turncount: function(parm)
{
    incturn();
    global.turnsofar++;
    if (global.turnsofar = 666)
        "\bYou hear a hollow voice in the distance laughing for a moment.
        You wonder what it could signify, until your eyes wander up to
        the status line and you notice the turn counter.";
    scoreStatus(global.score, global.turnsofar);
}


/*
   use a customized status line display function
*/
replace scoreStatus: function(pts, movs)
{
    setscore(cvtstr(pts) + ' points/' + cvtstr(movs) + ' moves');
}

/*
   define our own incscore
*/
replace incscore: function(amount)
{
    if (global.scoreNotify)
    {
        "\b[Your score just went up.";
        if (not global.scoreNotifyOnce)
        {
            " If you don't want to be notified of score changes
            like this in the future, just type NOTIFY.";
            global.scoreNotifyOnce := true;   // they've seen NOTIFY message
        }
        "]\n";
    }
    global.score := global.score + amount;
    scoreStatus(global.score, global.turnsofar);
}

/*
    Make some small changes to nestedroom defaults
*/
modify nestedroom
    statusPrep = "on"
    outOfPrep = "off of"
;

/*
    Add some behavior to thing
*/
modify thing
    verDoTakeWith(actor, iobj) = { self.verDoTake(actor); }
    doTakeWith(actor, iobj) =
    {
        "That doesn't seem to help.";
    }
    verDoPutOver(actor, iobj) = { self.verDoPutOn(actor, iobj); }
    verIoAskFor(actor) = {}
    ioAskFor(actor, dobj) = { dobj.doAskFor(actor, self); }
    verDoAskFor(actor, io) =
    {
        "I don't think << self.thedesc >> could give that to you.";
    }
    verDoThrowIn(actor, iobj) = { self.verDoThrowAt(actor, iobj); }
    verIoPourOn(actor) = {}
    ioPourOn(actor, dobj) = { dobj.doPourOn(actor, self); }
;

modify fixeditem
    verDoPutOver(actor, io) =
    {
        "%You% can't put "; self.thedesc; " anywhere. ";
    }
;

/* add some stuff to askVerb */
modify askVerb
    ioAction(forPrep) = 'AskFor'
    validIoList(actor, prep, dobj) =
    {
        // "ask for" requires object's presence; "ask about" doesn't
        if (prep = forPrep)
            pass validDoList;
        else
            return(nil);
    }
    ioDefault( actor, prep ) =
    {
        if (prep = aboutPrep)
            return([]);
        else
            return(actor.contents + actor.location.contents);
    }
;

modify pushVerb
    verb = 'nudge'
    ioAction(withPrep) = 'PushWith'
;

modify openVerb
    ioAction(withPrep) = 'OpenWith'
;

modify putVerb
    verb = 'insert'
    ioAction(overPrep) = 'PutOver'
;

modify takeVerb
    ioAction(withPrep) = 'TakeWith'
    ioAction( toPrep ) = 'GetTo'
;

modify getOutVerb
    doDefault( actor, prep, io ) =
    {
        if (actor.location)
        {
            /* handle the normal case of a nestedRoom */
            if (actor.location.location)
                return([actor.location]);

            /* handle a closedNestedRoom */
            if (actor.location.myRefItem)
                return([actor.location.myRefItem]);
        }

        /* nothing appropriate to get out of - return empty default list */
        return( [] );
    }
;

modify boardVerb
    verb = 'climb on' 'climb onto'
;

modify lookThruVerb
    verb = 'l out' 'look out'
;

modify pullVerb
    ioAction(withPrep) = 'PullWith'
;

modify throwVerb
    ioAction( inPrep ) = 'ThrowIn'
    ioAction( onPrep ) = 'ThrowOn'
;

/* we don't want "buckle" in this game, so replace adv.t's fastenVerb */
replace fastenVerb: deepverb
    verb = 'fasten'
    sdesc = "fasten"
    prepDefault = toPrep
    ioAction(toPrep) = 'FastenTo'
;

/* don't want "status" to be used for score - replace it */
replace scoreVerb: sysverb
    verb = 'score'
    action( actor ) =
    {
        scoreRank();
        abort;
    }
;

