/*
** Arr_npcs.t handles all the game's non-player-characters.
**
** Copyright (c) 1998, Stephen Granade. All rights reserved.
*/

#pragma C+

// The parents, mom and dad
mom: Actor
    actorOuthideStatus = 0
    alienCounter = 1
    isHer = true
    isRunning = nil                 // Am I running to the kitchen?
    isCleaning = nil                // Am I cleaning up broken dishes?
    isReturning = nil               // Am I returning/returned to the living room?
    noun = 'mom' 'parent' 'mother'
    plural = 'parents'
    adjective = 'my'
    location = living_room
    sdesc = "mom"
    ldesc = {
        if (self.isRunning)
            "She looks worried. That noise in the kitchen must have
                really startled her. ";
        else if (self.isCleaning)
            "She&rsquo;s throwing pieces of dishes away quietly and
                efficiently. ";
        else if (self.isReturning)
            "Mom is headed down the hall, looking upset. ";
        else "She&rsquo;s relaxing, quietly knitting to pass the time. ";
    }
    thedesc = "your mom"
    adesc = "your mom"
    actorDesc = {
        if (self.isRunning)
            "Mom is running down the hall towards the kitchen. ";
        else if (self.isCleaning)
            "Mom is on hands and knees, throwing away the broken
                dishes. ";
        else if (self.isReturning)
            "Mom is walking down the hall towards the living room. ";
        else "Mom is here, knitting away. ";
    }
    whodesc = "Mom&rsquo;s that woman who makes you dinner and makes you
        clean your room and wash dishes. "
    specifyMore = "<q>You need to be more specific.</q> "
    disavow = "<q>Not now, kid.</q> "
    askWord(word, lst) = {
        if (self.isRunning || self.isCleaning || self.isReturning) {
            self.disavow;
            return true;
        }
        if (find(['alien' 'aliens' 'silvery' 'ship' 'spaceship' 'saucer'],
            lst[1]) != nil) {
            switch (self.alienCounter++) {
                case 1:
                    "Your dad grunts as he rises from his chair. <q>Okay,
                        kid, let&rsquo;s take a look.</q> He gazes out the
                        window for
                        a moment, then sits heavily back down in his chair,
                        shaking his head at your mom.\b
                    <q>Oh, kid,</q> mom says laughingly. <q>I know you
                        don&rsquo;t want to wash dishes, but we all have to
                        do our
                        part. All three of us have familial responsibilities.
                        Now get back in there.</q> She gives you a playful
                        swat on the butt. ";
                    break;
                case 2:
                    "Mom grins at dad. Dad glances towards the window.
                        <q>So,</q>
                        dad says. <q>This ship you saw...kinda round, maybe
                        saucer-shaped?</q> You nod. <q>And is it...red? Does
                        it
                        have three legs and wheels?</q> Mom chuckles quietly
                        behind the back of her hand. <q>You need to get back
                        in there and finish those dishes, kid,</q> says dad,
                        going back to his paper. ";
                    break;
                case 3:
                    "Your mom and dad frown at you. <q>Enough,</q> dad says.
                        <q>Don&rsquo;t keep on about this.</q> ";
                    break;
                case 4:
                    "Mom glowers at dad, who stands up with a grunt. <q>Okay,
                        kid, c&rsquo;mon. You get to spend some time in your
                        room now.</q> Dad takes you by the hand and leads you
                        back to your room.\b
                    A few hours later, the world ends in a bright flash of
                        light. You never do get to see Captain Dangerous
                        again. ";
                    die();
            }
            return true;
        }
        return nil;
    }
    actorAction(v,d,p,i)={
        if (v==tellVerb && d==Me && p==aboutPrep) {
            self.actorOuthideStatus = outhide(true);
            self.verDoAskAbout(Me, i);
            // Oops, we can't ask us about this object
            if (outhide(self.actorOuthideStatus)) {
                self.verDoAskAbout(Me, i);
            }
            else self.doAskAbout(Me, i);
            exit;
        }
        if (v==giveVerb && i==Me && p==toPrep) {
        // Verify that we can give this to us
            self.actorOuthideStatus = outhide(true);
            self.verDoAskFor(Me, d);
            if (outhide(self.actorOuthideStatus)) {
                self.verDoAskFor(Me, d);
                exit;
            }
            self.doAskFor(Me, d);
            exit;
        }
        if (v == helloVerb) {
            "<q>Hi, kid,</q> mom sighs. ";
            exit;
        }
        "Your mom doesn&rsquo;t take orders from you. ";
        exit;
    }
    verDoClean(actor) = {
        "I don&rsquo;t think you understand how this works:\ mom tells you
            what to clean, and you do it. You don&rsquo;t clean things
            voluntarily, and you especially don&rsquo;t clean your
            parents. ";
    }
    verDoAskAbout(actor, io) = {
        if (self.isRunning || self.isCleaning || self.isReturning)
            self.disavow;
        else pass verDoAskAbout;
    }
    doAskAbout(actor, io) = {
        if (io.location == cabinets) {
            "<q>In the kitchen cabinets, like always,</q> mom tells you. ";
        }
        else switch (io) {
            case right_stack:
            case left_stack:
                if (dad.location != living_room)
                    "Mom frowns at you. <q>You need to finish washing those
                        dishes,</q> she says. ";
                else "Mom looks at dad; dad looks at mom. Dad clears his
                    throat. <q>Get to finishing those dishes,</q> he says. ";
                break;

            case azaleas:
                "<q>Don&rsquo;t worry, kid. I&rsquo;ll be taking care of my
                    azaleas next weekend.</q> ";
                break;

            case fake_hohos:
                "Mom sighs. <q>I wish we could afford Ho-hos. But you know how
                    expensive brand-name snack cakes are.</q> ";
                 break;

            case fake_captain:
            case fake_billy_bob:
            case teevee:
                "<q>Have you finished washing the dishes?</q>\ Mom asks. She
                    squints at you, and you squirm a little under a one-eyed
                    gaze that would do Odin proud. <q>Then the answer is still
                    no.</q> ";
                break;

            default:
                pass doAskAbout;
        }
    }
    verDoAskFor(actor, io) = {
        if (io.location != cabinets && io != fake_hohos)
            "Your mom doesn&rsquo;t have that. ";
        else if (self.isRunning || self.isCleaning || self.isReturning)
            self.disavow;
    }
    doAskFor(actor, io) = {
        if (io == fake_hohos)
            "Mom sighs. <q>I wish we could afford Ho-hos. But you know how
                expensive brand-name snack cakes are.</q> ";
        else "<q>In the kitchen cabinets, like always,</q> mom tells you. ";
    }
    verDoTellAbout(actor, io) = {
        self.verDoAskAbout(actor, io);
    }
    doTellAbout(actor, io) = {
        self.doAskAbout(actor, io);
    }
    verIoShowTo(actor) = {
        if (self.isRunning || self.isCleaning || self.isReturning)
            self.disavow;
    }
    ioShowTo(actor, dobj) = {
        switch (proptype(dobj, &momdesc)) {
            case 3:
                "Mom says, <q><<dobj.momdesc>></q> ";
                break;
            case 6:
            case 9:
                dobj.momdesc;
                break;
            default:
                "<q>Mmm-hmm,</q> she says. ";
                break;
        }
    }
    verDoSearch(actor)={"How rude!";}
    verDoPush(actor)={"How rude!";}
    verDoPull(actor)={"How rude!";}
    verDoMove(actor)={"How rude!";}
    verDoPoke(actor)={"How rude!";}
    verDoTouch(actor)={"How rude!";}
// Functions to handle mom going to the kitchen and cleaning up
    moveToKitchen = {
        if (self.location == living_room) {
            if (Me.location == living_room) {
                "\bMom jumps up, her knitting forgotten. <q>What was
                    that?</q> she asks on her way out the door. ";
                if (dad.location == living_room)
                    "\bDad calls after her. <q>Oh, probably a stack of dishes
                        falling to the floor and breaking.</q> ";
            }
            else if (Me.location == hallway)
                "\bMom comes running down the hall. <q>Did you hear that
                    noise in the kitchen?</q> she asks. ";
            self.isRunning = true;
            self.moveInto(hallway);
        }
        else {
            if (Me.location == hallway)
                "\bMom breezes past you and into the kitchen. ";
            else if (Me.location == startroom) {
                "\bMom runs into the kitchen, then stops short. She looks
                    at the broken dishes; she looks at you. She looks
                    very mad. <q>When I get done cleaning this up,
                    we&rsquo;re going to have a little talk. Don&rsquo;t you
                    go anywhere.</q> ";
            }
            unnotify(self, &moveToKitchen);
            notify(self, &almostDoneCleaningKitchen, 7);
            self.isRunning = nil;
            self.isCleaning = true;
            self.moveInto(startroom);
        }
    }
    almostDoneCleaningKitchen = {
        if (Me.location == startroom)
            "\bMom is almost done cleaning up the broken dishes. ";
        notify(self, &cleanKitchen, 0);
    }
    cleanKitchen = {
        unnotify(self, &cleanKitchen);
        broken_dishes.moveInto(nil);
        notify(self, &moveToLivingRoom, 0);
    }
    moveToLivingRoom = {
        if (self.location == startroom) {
            if (Me.location == startroom) {
                "\bMom finishes cleaning up the dishes and stands up, glaring
                    at you. ";
                self.groundKid;
            }
            else if (Me.location == hallway) {
                "\bMom comes out of the kitchen and down the hall. When
                    she sees you, she stops. She&rsquo;s obviously very,
                    very angry. ";
                self.groundKid;
            }
            self.isCleaning = nil;
            self.isReturning = true;
            self.moveInto(hallway);
        }
        else {
            if (Me.location == living_room) {
                "\bMom walks into the living room, stopping short when she
                    sees you. She looks mad enough to spit nails. ";
                self.groundKid;
            }
            unnotify(self, &moveToLivingRoom);
            self.moveInto(living_room);
        }
    }
    groundKid = {
        "<q>To your room, kid.</q> When she talks to you in that tone of
            voice, you know better than to disobey. Up the stairs you go, to
            await your eventual punishment.
        \bOf course, none of this matters much since the world ends some
            hours later. ";
        die();
    }
;

dad: Actor
    actorOuthideStatus = 0
    checkedLights = nil             // Have I seen the broken backyard light?
    isGoing = nil                   // Am I going to the backyard?
    isExamining = nil               // Am I examining the broken light?
    examineCounter = 0              // How long have I been examining?
    isReturning = nil               // Am I returning/returned to the living room?
    isHim = true
    noun = 'dad' 'parent' 'father'
    plural = 'parents'
    adjective = 'my'
    location = living_room
    sdesc = "dad"
    ldesc = {
        if (self.isGoing)
            "He is strolling out towards the backyard. ";
        else if (self.isExamining)
            "He keeps peering up at the lights, trying to figure out how (or
                why) the light was broken. ";
        else if (self.isReturning)
            "He is strolling back to the living room, lost in thought. ";
        else "Dad is poring over the paper, reading and re-reading every
            article, occasionally circling misspellings and misprints. ";
    }
    thedesc = "your dad"
    adesc = "your dad"
    actorDesc = {
        if (self.isGoing || self.isReturning)
            "Dad is strolling through the hallway. ";
        else if (self.isExamining)
            "Dad is slowly wandering around the backyard, looking up at the
                lights. ";
        else "Dad is slowly going through today&rsquo;s paper. ";
    }
    whodesc = "That guy who is always telling you <q>Do this</q> and
        <q>Don&rsquo;t do that</q>. "
    specifyMore = "<q>Come again? You&rsquo;re not being clear enough.</q> "
    disavow = {
        if (self.isGoing || self.isReturning || self.isExamining)
            "He shushes you absentmindedly. ";
        else "He lowers his paper, looks out at you from under beetle
            brows, and goes back to reading. ";
    }
    actorAction(v,d,p,i)={
        if (v==tellVerb && d==Me && p==aboutPrep) {
            self.actorOuthideStatus = outhide(true);
            self.verDoAskAbout(Me, i);
            // Oops, we can't ask us about this object
            if (outhide(self.actorOuthideStatus)) {
                self.verDoAskAbout(Me, i);
            }
            else self.doAskAbout(Me, i);
            exit;
        }
        if (v==giveVerb && i==Me && p==toPrep) {
        // Verify that we can give this to us
            self.actorOuthideStatus = outhide(true);
            self.verDoAskFor(Me, d);
            if (outhide(self.actorOuthideStatus)) {
                self.verDoAskFor(Me, d);
                exit;
            }
            self.doAskFor(Me, d);
            exit;
        }
        "Dad just snorts";
        if (!self.isGoing && !self.isExamining && !self.isReturning)
            " and continues reading his paper";
        ". ";
        exit;
    }
    verDoClean(actor) = { mom.verDoClean(actor); }
    verDoAskFor(actor, io) = {
        if (io == dad_paper)
            "<q>Be patient and wait your turn,</q> he says. ";
        else "Your dad doesn&rsquo;t have that. ";
    }
    verDoAskAbout(actor, io) = {
        if (self.isGoing || self.isExamining || self.isReturning)
            "<q>Not now, please.</q> ";
        else if (mom.location == self.location)
            "Mom says, <q>Don&rsquo;t pester your dad with questions while
                he&rsquo;s reading.</q> ";
        else pass verDoAskAbout;
    }
    doAskAbout(actor, io) = {
        if (mom.location == self.location)
            mom.doAskAbout(actor, io);
        else pass doAskAbout;
    }
    verDoTellAbout(actor, io) = {
        if (self.isGoing || self.isExamining || self.isReturning)
            "<q>Not now, please.</q> ";
        else if (mom.location == self.location)
            mom.verDoAskAbout(actor, io);
        else self.verDoAskAbout(actor, io);
    }
    doTellAbout(actor, io) = {
        if (io == bright_lights) {
            if (!bright_lights.oneBroken)
                "Dad says, <q>I know, the lights attract mosquitos. I&rsquo;m
                    thinking of buying a bug zapper.</q> ";
            else if (self.checkedLights)
                "Dad says, <q>I told you, kid, I&rsquo;ll get to it later. ";
            else if (self.isGoing || self.isExamining)
                "<q>I&rsquo;m looking into it.</q> ";
            else {
                "<q>One of the lights is out, huh? I&rsquo;d better go have
                    a look.</q> He slowly folds his paper and tucks it under
                    one arm. ";
                notify(self, &moveToBackyard, 0);
            }
        }
        else if (mom.location == self.location)
            mom.doAskAbout(actor, io);
        else self.doAskAbout(actor, io);
    }
    verIoShowTo(actor) = {
        if (self.isGoing || self.isComing || self.isInspecting)
            "<q>Not now, please.</q> ";
    }
    ioShowTo(actor, dobj) = {
        switch (proptype(dobj, &daddesc)) {
            case 3:
                "Dad says, <q><<dobj.daddesc>></q> ";
                break;
            case 6:
            case 9:
                dobj.daddesc;
                break;
            default:
                "Dad lowers his paper and looks at you sternly before going
                    back to his reading. ";
                break;
        }
    }
    doCloseEncountersRef = {
        if (Me.location != self.location || mom.location != living_room ||
            dad.location != living_room) {
            notify(self, &doCloseEncountersRef, 2 + _rand(2));
            return;
        }
        "\bYou hear your dad rustling his newspaper. When you
            look over at him, you see that he&rsquo;s crumpled part of it
            into a saucer-like shape. Mom sees it too; she says, <q>Dad?
            Whatcha got?</q>
        \b<q>I...I don&rsquo;t know,</q> he answers, <q>but...it <b>means</b>
            something.</q>
        \b<q>Oh, hush,</q> mom scolds him. <q>That doesn&rsquo;t mean
            anything.</q>
        \bDad thinks, then sends the paper saucer flying towards the trash.
            <q>I guess you&rsquo;re right,</q> he says before he starts
            reading again. ";
    }
    moveToBackyard = {
        if (self.location == living_room) {
            if (Me.location == living_room)
                "\bDad stands and stretches. After glancing briefly out the
                    window, he wanders out of the living room. ";
            else if (Me.location == hallway)
                "\bDad comes wandering into the hallway. ";
            self.isGoing = true;
            self.moveInto(hallway);
        }
        else {
            if (Me.location == hallway)
                "\bDad wanders out into the backyard. ";
            else if (Me.location == backyard) {
                "\bDad ambles into the backyard, then stops and peers up at
                    his lights. ";
            }
            unnotify(self, &moveToBackyard);
            notify(self, &examineLight, 0);
            self.isGoing = nil;
            self.isExamining = true;
            self.moveInto(backyard);
        }
    }
    examineLight = {
        self.examineCounter++;
        if (Me.location == backyard) {
            "\b";
            switch (self.examineCounter) {
                case 1:
                "Dad walks towards the light, but stumbles over the
                    ship&rsquo;s ramp. He looks back, rubbing his ankle.
                    <q>Stupid tree root,</q> he mutters. ";
                break;

                case 2:
                "Dad squints up at the light. He goes over to the current
                    control and twists the knob back and forth.
                \bBehind him, you see part of the spaceship turn translucent.
                    Zigurt and Floban appear at the new window, gesturing
                    excitedly at your dad. ";
                fake_zigurt_and_floban.moveInto(backyard);
                break;

                case 3:
                "<q>Hm. Looks like someone knocked out one of my lights.</q>
                    Dad sighs. <q>Probably some of those neighborhood kids,
                    driving by in their souped-up jalopies.</q> ";
                if (fake_zigurt_and_floban.location != nil)
                    "\bMeanwhile, Zigurt and Floban have begun making faces
                        at him, waving tentacles, sticking out thick blue
                        tongues. Eventually they tire of the sport, and the
                        window becomes opaque once more. ";
                fake_zigurt_and_floban.moveInto(nil);
                break;

                case 4:
                "Dad shrugs. <q>Nothing to do about this until tomorrow, when
                    Home Depot opens.</q> He ruffles your hair. <q>Thanks
                    for telling me about it, kid.</q> ";
                break;
            }
        }
        if (self.examineCounter == 4) {
            unnotify(self, &examineLight);
            notify(self, &moveToLivingRoom, 0);
        }
    }
    moveToLivingRoom = {
        if (self.location == backyard) {
            if (Me.location == backyard) {
                if (garden_hose.attachedToShip) {
                    "\bDad heads for the house, but stops short and stares
                        at the hose. He scratches his head, then gives the
                        hose a good yank, detaching it from the ship. ";
                    if (backyard_faucet.ison && garden_hose.attachedToFaucet) {
                        "Water squirts out the newly freed end. Dad glances
                            at you. <q>Don&rsquo;t play with the faucet,
                            kid,</q> he tells you as he turns off the
                            faucet and heads inside. ";
                        backyard_faucet.ison = nil;
                    }
                    garden_hose.detachFromShip;
                }
                else if (backyard_faucet.ison) {
                    "\bDad heads for the house, but stops short. He turns
                        off the faucet. <q>Don&rsquo;t play with the faucet,
                        kid,</q> he tells you on his way back inside. ";
                    backyard_faucet.ison = nil;
                }
                else "\bDad sighs and heads back into the house. ";
            }
            else if (Me.location == hallway)
                "\bDad comes back in from the backyard. He smiles at you. ";
            self.isExamining = nil;
            self.isReturning = true;
            self.examinedLights = true;
            self.moveInto(hallway);
        }
        else {
            if (Me.location == hallway)
                "\bDad walks back into the living room. ";
            else if (Me.location == living_room) {
                "\bDad walks in. He sighs as he sits back down and resumes
                    reading the paper. ";
            }
            unnotify(self, &moveToLivingRoom);
            self.moveInto(living_room);
        }
    }
    verDoSearch(actor)={"How rude!";}
    verDoPush(actor)={"How rude!";}
    verDoPull(actor)={"How rude!";}
    verDoMove(actor)={"How rude!";}
    verDoPoke(actor)={"How rude!";}
    verDoTouch(actor)={"How rude!";}
;

// The aliens, Zigurt and Floban
zigurt: Actor
    makingComments = nil    // The aliens are ready to crack wise
    mentionedFaucet = nil   // The aliens have seen the faucet turned on
    gottenSalt = nil        // The player's given the rock salt to the aliens
    gottenCupcakes = nil    // The player's given the cupcakes to the aliens
    gottenMemento = nil     // The player's given the memento to the aliens
    openingBottle = nil     // Are Zigurt & Floban opening the tylenol bottle?
    phraseNumbers = [ 1, 2, 3, 4, 5 ]
    currentPhrase = 0

    // Say some stuff when the player's in the rec room w/Zig & Flo
    makeConversation = {
        if ((Me.location == rec_room || Me.location == counter) &&
            zigurt.location == rec_room) {
            if (self.currentPhrase == 0) {
                "\b";
                if (Me.location == rec_room)
                    "Zigurt traces some routes on the atlas with one
                        tentacle. ";
                else "You hear Zigurt saying, ";

                if (VALLEYSPEAK)
                    zig('So, like, we&rsquo;ll take this
                        &lsquo;Interstate&rsquo; until, y&rsquo;know, we get
                        to Washington, D.C. Then we&rsquo;ll like meet with
                        the prez.');
                else zig('We shall follow this &lsquo;Interstate&rsquo; until
                    it reaches
                    Washington, D.C., at which point we will meet with the
                    leader of this country,');
                " he says to Floban.\b
                <<flo('Oh, capital!')>> Floban replies. ";
            }
            else switch(self.phraseNumbers[self.currentPhrase]) {
                case 1:
                "\bFloban exclaims, ";
                if (VALLEYSPEAK)
                    flo('Like, check this out! Here is a, y&rsquo;know, city
                        named &lsquo;Plain Dealing&rsquo;!');
                else flo('Ooh! Look! I have found a population
                    center named &lsquo;Plain Dealing&rsquo;!');
                "\bZigurt says smugly, ";
                if (VALLEYSPEAK)
                    zig('Sha! You wish! Here&rsquo;s a, like, better
                        one:\ &lsquo;Toad Suck&rsquo;.');
                else zig('I believe I have bested you. Here is one
                    named &lsquo;Toad Suck&rsquo;.');
                "\bFloban pauses. ";
                if (VALLEYSPEAK)
                    flo('So, like, is the city named because, they,
                        y&rsquo;know, suck toads?');
                else flo('Do you suppose the city is named that
                    due to their practice of sucking toads?');
                "\b";
                if (VALLEYSPEAK)
                    zig('Like, I dunno. But we gotta check this out!');
                else zig('Unknown. But if so, we certainly must visit!');
                " ";
                break;

                case 2:
                "\bZigurt says, ";
                if (VALLEYSPEAK)
                    zig('Y&rsquo;know, this planet is soooo split up. I mean,
                        have you looked at the sizes of &lsquo;China&rsquo;
                        and &lsquo;Luxembourg&rsquo;? They are, like, sooo
                        different!');
                else zig('The fractured nature of this planet
                    never ceases to amaze me. Compare the size of this
                    &lsquo;China&rsquo; nation to &lsquo;Luxembourg&rsquo;.
                    The disparity is overwhelming.');
                "\b";
                if (VALLEYSPEAK)
                    flo('Like, duh!');
                else flo('Indeed.');
                " ";
                break;

                case 3:
                "\bFloban hmms, then says, ";
                if (VALLEYSPEAK)
                    flo('Like, who else has visited this place? &rsquo;Cause,
                        y&rsquo;know, I&rsquo;ve seen on the news where people
                        have, like, found other aliens&mdash;');
                else flo('Who else has visited this
                    planet? I recall seeing news broadcasts of the discovery
                    of other non-Earth beings&mdash;');
                "\b";
                if (VALLEYSPEAK)
                    zig('Like, gag me with a spoon!');
                else zig('You are being foolish,');
                " Zigurt snaps. ";
                if (VALLEYSPEAK)
                    zig('That is so fake! Everyone knows those shows were,
                        like, made by a group of military dweebs.
                        I learned that from other shows.');
                else zig('Obviously those reports were faked by an
                    excessively powerful cabal within the military complex,
                    as I learned from a different sequence of broadcasts.');
                "\b";
                if (VALLEYSPEAK)
                    flo('Like, okay,');
                else flo('Ah,');
                " says Floban.";
                break;

                case 4:
                if (Me.location == rec_room)
                    "\bZigurt pauses, tapping one tentacle against his round
                        side. ";
                else "\bYou hear Zigurt clear his throat. ";
                if (VALLEYSPEAK)
                    zig('Oh, um, we&rsquo;re, like, s&rsquo;posed to go to
                        the, y&rsquo;know, Zeta Quadrant after this,');
                else zig('I have neglected to inform you that we are ordered
                    to the Zeta Quadrant at the completion of this mission,');
                " he says to Floban.\b
                <<flo('But we were going to Toshi Station to pick up some
                    power converters!')>>\ Floban whines in response.\b";
                if (VALLEYSPEAK)
                    zig('Sha! As if!');
                else zig('Hush. Do not make a spectacle of yourself with
                    your ceaseless complaining,');
                " Zigurt snaps. ";
                break;

                case 5:
                if (Me.location != rec_room) {
                    notify(self, &makeConversation, 2);
                    return;
                }
                "\bZigurt taps the atlas. Floban leans forward, and you jump
                    to get a glimpse of what they&rsquo;re looking at.
                    Zigurt is pointing to a picture of a large rock
                    formation, many stories tall, and shaded from white near
                    its base to red up top. A caption indicates that the
                    picture was taken in Arizona.\b";
                if (VALLEYSPEAK)
                    zig('Like, look at this mesa thingy. It&rsquo;s,
                        y&rsquo;know, pretty.');
                else zig('Notice this strange formation of rock, jutting up
                    from the ground by itself. I find it aesthetically
                    pleasing.');
                "\b";
                if (VALLEYSPEAK)
                    flo('Yeah, it&rsquo;s a real butte.');
                else flo('Yes. It is quite a butte.');
                break;
            }
            self.currentPhrase++;
        }
        if (self.currentPhrase <= length(self.phraseNumbers))
            notify(self, &makeConversation, 4 + _rand(3));
    }

    noun = 'zigurt' 'alien' 'blob' 'v\'lvxnlxian'
    plural = 'aliens' 'v\'lvxnlxians'
    adjective = 'green'
    sdesc = "Zigurt"
    thedesc = "Zigurt"
    adesc = "Zigurt"
    ldesc = {
        "Zigurt stands taller than you do, a bright green blob with tentacles. ";
        if (universal_translator.location == self)
            "One of his tentacles curves around a <<
                link('rod', 'x rod')>>. ";
        if (tylenol_bottle.location == self)
            "One tentacle is curled around a <<link('white bottle',
                'x bottle')>>. ";
    }
    actorDesc = {
        if (self.location == rec_room)
            "Zigurt is carefully poring over the atlas. ";
        else if (self.openingBottle != nil)
            "Zigurt is here, looking thoughtful. ";
        else "Standing here proudly is Zigurt. ";
    }
    whodesc = {
        "Zigurt is the bright green alien who landed in your backyard. ";
        if (!startroom.landed)
            "At least, he <b>will</b> land in your backyard. Why are you
                asking about him already? He&rsquo;ll be here soon enough. ";
        else if (!real_ship.rampDown && !Me.canThieve)
            "Of course, he hasn&rsquo;t come out yet. Are you playing this
                game to set some kind of record or something? ";
    }
    verDoWhatis(actor) = {}
    doWhatis(actor) = { "Zigurt is really more of a who. "; }
    disavow = {
        if (VALLEYSPEAK)
            zig('Why don&rsquo;t you, like, go play in traffic.');
        else zig('You are quite the nosy child.');
    }
    verGrab(item) = {
        "I doubt Zigurt would let go of <<item.thedesc>>. ";
    }
    actorAction(v, d, p, i) = {
        if (v == helloVerb) {
            if (self.makingComments)
                zig('Kindly hold your tongue until we have decided your fate.');
            else {
                if (VALLEYSPEAK)
                    zig('Like, hello,');
                else zig('Yes, yes, hello, Ambassador.');
                " Zigurt says. ";
            }
            exit;
        }
        else pass actorAction;
    }
    ioGiveTo(actor, dobj) = {
        if (dobj.alienItem) {
            "Zigurt snatches <<dobj.thedesc>> from you";
            if (counter.location == self.location) {
                " and places it on the counter";
                dobj.moveInto(counter);
            }
            else dobj.moveInto(self);
            if (VALLEYSPEAK)
                ". <<zig('Like, taking our stuff is most uncool.')>> ";
            else ". <<zig('Your theivery is quite unappreciated.')>> ";
            return;
        }
        if (dobj != rock_salt && dobj != generic_cupcakes &&
            dobj != memento) {
            "Zigurt brushes aside <<dobj.thedesc>>. ";
            if (VALLEYSPEAK)
                zig('As if! Like we need stuff from savages!');
            else zig('We have no need for gifts from savages.');
            " He stops short, clacking his teeth in embarassment. ";
            if (VALLEYSPEAK)
                zig('Um, I mean, like, except for you. Duh.');
            else zig('Yourself excepted, of course, Ambassador.');
            " ";
            return;
        }
        if (dobj == rock_salt) {
            self.gottenSalt = true;
            if (VALLEYSPEAK)
                flo('Like, is that salt?');
            else flo('Is it salt?');
            " Floban asks eagerly. When he spies the box, he claps several
                tentacles together happily while
                scooping up some crystals with another. ";
            if (VALLEYSPEAK)
                flo('Rad!');
            else flo('Wonn-ful,');
            " he says around a mouthful of salt. Zigurt upends the
                box and fills his maw. The contented sound of crunching
                fills the air.\b";
            if (self.gottenCupcakes && self.gottenMemento)
                self.timeToGo(true);
            else {
                if (!self.gottenCupcakes) {
                    if (VALLEYSPEAK)
                        zig('Like, aww we need now ahr, like, Ho-hos,');
                    else zig('Aww we need now ahr some Ho-Hos,');
                    " Zigurt announces, peppering you with bits of salt. ";
                    if (!self.gottenMemento) {
                        "\b";
                        if (VALLEYSPEAK)
                            flo('Ann, y&rsquo;know, the memento!');
                        else flo('Ann the memento!');
                        " Floban adds.\b";
                    }
                }
                else if (!self.gottenMemento) {
                    if (VALLEYSPEAK)
                        zig('Aww we, like, need now is that memento,');
                    else zig('Aww we need now is the memento,');
                    " Zigurt announces, peppering you with some bits of salt. ";
                }
                if (VALLEYSPEAK)
                    zig('Like, wun awong and fwetch them.');
                else zig('Wun awong and fwetch them.');
                " Zigurt and Floban turn back to the atlas, munching happily. ";
            }
        }
        else if (dobj == generic_cupcakes) {
            self.gottenCupcakes = true;
            "Floban takes the box from you, looking at it. ";
            if (global.isHTMLRuntime)
                "<<flo('Redi-Snak<SUP>TM</SUP> Chokolate Snak Kakes?')>> ";
            else "<<flo('Redi-Snak(TM) Chokolate Snak Kakes?')>> ";
            "He sighs. ";
            if (VALLEYSPEAK)
                flo('Like, what-EVER. I guess they&rsquo;re okay.');
            else flo('I suppose they will do.');
            "\b";
            if (self.gottenSalt && self.gottenMemento)
                self.timeToGo(nil);
            else {
                zigNQ('&ldquo;Now we need ');
                if (VALLEYSPEAK)
                    zigNQ('like ');
                if (self.gottenSalt)
                    zigNQ('a memento');
                else if (self.gottenMemento)
                    zigNQ('rock salt');
                else zigNQ('rock salt and a memento');
                if (VALLEYSPEAK)
                    zigNQ('. So, like, go fetch that stuff!&rdquo;');
                else zigNQ('. If you would, please, run along
                    now.&rdquo;');
                " Floban, meanwhile, has wolfed down
                    two or three cupcakes, leaving his face smeared with
                    chocolate
                    which he tries to lick off with a large blue tongue. ";
                if (VALLEYSPEAK)
                    zig('Like, you are such the dweeb,');
                else zig('You are such a mess,');
                " Zigurt tells him as they turn back to the atlas. ";
            }
        }
        else if (dobj == memento) {
            self.gottenMemento = true;
            "Floban snatches the doll from you. ";
            if (VALLEYSPEAK)
                flo('Like, cool! This is sooo pretty!');
            else flo('Ahh! Exquisite! Truly this piece has captured the
                essense of the human condition.');
            "\b";
            if (self.gottenSalt && self.gottenCupcakes)
                self.timeToGo(nil);
            else {
                "<<zigNQ('&ldquo;Now we need ')>>";
                if (VALLEYSPEAK)
                    zigNQ('like ');
                if (self.gottenSalt)
                    zigNQ('some Ho-Hos');
                else if (self.gottenCupcakes)
                    zigNQ('rock salt');
                else zigNQ('rock salt and Ho-Hos');
                if (VALLEYSPEAK)
                    zigNQ('. So, like, go get that stuff.&rdquo;');
                else zigNQ('. If you would, please, run
                    along and fetch some.&rdquo;');
                " With a happy sigh, Floban
                    puts away the memento and turns back to the task at
                    tentacle. ";
            }
        }
        dobj.moveInto(nil);
    }
    ioSynonym('GiveTo') = 'ShowTo'
    verDoAskFor(actor, io) = {
        if (self.makingComments) {
            "<<flo('Hsst! The child has a list of demands!')>> says Floban.\b
                <<zig('So I hear. I will ignore them for now,')>> Zigurt
                responds. ";
        }
    }
    doAskFor(actor, io) = { floban.doAskFor(actor, io); }
    doAskAbout(actor, io) = {
        switch (proptype(io, &zigdesc)) {
            case 3:
                "Zigurt says, <<zig(io.zigdesc)>> ";
                break;
            case 6:
            case 9:
                io.zigdesc;
                break;
            default:
                self.disavow;
                break;
        }
    }

    // When the aliens take the white bottle into the exam room, they have
    // to try a variety of measures to get it open.
    forceBottleOpen = {
        switch (self.openingBottle) {
            case 1:
                if (Me.location == exam_room) {
                    "\bFloban looks at Zigurt. ";
                    if (VALLEYSPEAK)
                        flo('Like, what now?');
                    else flo('You have a plan for opening the recalcitrant
                        bottle?');
                    "\b";
                    if (VALLEYSPEAK)
                        zig('Oh, yeah! You bet!');
                    else zig('Indeed. Wait but a moment and I shall put said
                        plan in motion.');
                }
                break;

            case 2:
                if (Me.location == exam_room) {
                    "\bZigurt places the bottle on the exam table. Both he and
                        Floban step back from the table just before Zigurt
                        stabs at a button on the control panel. A bright laser
                        beam strikes the top of the closed bottle. You
                        look away, blinking in pain. When the laser beam
                        shuts off, you look back. The bottle is still
                        closed, though little wisps of white smoke are rising
                        from it. Zigurt picks it up and looks at it. ";
                    if (VALLEYSPEAK)
                        zig('Whoa,');
                    else zig('Hmm,');
                    " he says. ";
                 }
                 break;

             case 3:
                if (Me.location == exam_room) {
                    "\bZigurt puts the white bottle on the exam table. ";
                    if (VALLEYSPEAK)
                        zig('Like, what d&rsquo;you think?');
                    else zig('Any suggestions?');
                    " he asks Floban.\b";
                    if (VALLEYSPEAK)
                        flo('I dunno. Maybe try the whirly blade thingy,');
                    else flo('I am uncertain, but perhaps the saw blade would
                        be more effective,');
                    " says Floban.\b
                    Zigurt nods and pulls a lever. A whirling circular saw
                        descends, hits the neck of the bottle, and rebounds
                        with a clang. Zigurt sighs, picking up the bottle
                        again. ";
                }
                break;

             case 4:
                if (Me.location == exam_room) {
                    "\bFloban&rsquo;s lower lip trembles. ";
                    if (VALLEYSPEAK)
                        flo('This, like, totally sucks, y&rsquo;know?');
                    else flo('Never again will I know the bittersweet taste
                        of acetaminophen!');
                    "\ wails Floban.\b";
                    if (VALLEYSPEAK)
                        zig('Sha! As if!');
                    else zig('Do not fear,');
                    "\ says Zigurt, who puts the bottle on the exam table.
                        He leans over the control panel and gently tweaks
                        several knobs, occasionally glancing over his
                        shoulder. A pair of gloved hands descends and
                        grabs the bottle. The hands turn slowly at first,
                        then begin twisting faster and faster, harder and
                        harder. Finally, with a loud <b>pop</b>, the cap
                        comes off. Floban grabs the bottle and lid from
                        the hands and happily downs a pill. ";
                    tylenol_bottle.moveInto(floban);
                }
                break;

             case 5:
                self.openingBottle = nil;
                floban.iShallReturn;
                return;
        }
        self.openingBottle++;
        notify(self, &forceBottleOpen, 1);
    }

    // If 'flag' is true, then the aliens have just gotten through eating
    // salt, and their speech should be muffled accordingly
    timeToGo(flag) = {
        Me.canThieve = true;        // The player can keep whatever he's got
        if (flag) {
            if (VALLEYSPEAK)
                zig('We awr, like, moth thankful fow youwr stuff,');
            else zig('We awr moth thankful fow youwr suppies,');
            " Zigurt says, swallowing the last of the rock salt. ";
        }
        else {
            if (VALLEYSPEAK)
                zig('Like, thanks for the stuff,');
            else zig('We are most thankful for your supplies,');
            " Zigurt says. ";
        }
        if (VALLEYSPEAK)
            zig('Like, this was really cool of you.');
        else zig('We will be sure to remember this act of kindness.');
        " Floban and Zigurt gently but firmly usher you off the ship. ";
        if (VALLEYSPEAK)
            zig('We&rsquo;ll, like, be right back after we talk to the
                prez.');
        else zig('We will return after we have spoken directly to your
            country&rsquo;s leader.');
        " They re-enter the ship, the ramp retracting after them.\b";
        outside_ship_ramp.moveInto(nil);
        real_ship.rampDown = nil;
        notify(real_ship, &blastOff, 2);
        Me.travelTo(backyard);
    }
;

floban: Actor
    givenPointsForLeaving = nil         // Player's awarded points for
                                        // making me leave
    noun = 'floban' 'alien' 'ghost' 'v\'lvxnlxian'
    plural = 'aliens' 'v\'lvxnlxians'
    adjective = 'purple' 'halloween'
    sdesc = "Floban"
    thedesc = "Floban"
    adesc = "Floban"
    ldesc = {
        "Floban is quite a bit taller than you and is a deep purple color.
            He resembles a halloween ghost with tentacles. Well, if ghosts
            were purple. ";
        if (translation_book.location == self)
            "He holds a <<link('large book', 'x book')>> loosely in three
                tentacles. ";
        if (tylenol_bottle.location == self)
            "A <<link('white bottle', 'x bottle')>> stands out noticeably
                from the purple tentacle in which it is held. ";
    }
    actorDesc = {
        if (self.location == rec_room)
            "Floban stands next to Zigurt, watching him and the maps. ";
        else if (self.location == exam_room && tylenol_bottle.location == Me)
            "Floban stands here, smiling happily. ";
        else "Floban stands here droopily. ";
    }
    whodesc = {
        "Floban is the purple ghost-looking alien who landed in your
            backyard. ";
        if (!startroom.landed)
            "Um, make that <b>will</b> land.\bSay, how do you know to ask
                about him already? ";
        else if (!real_ship.rampDown && !Me.canThieve)
            "Of course, you could always wait for him to come out of the
                ship and find out about him the way God and the game
                designer intended. ";
    }
    verDoWhatis(actor) = {}
    doWhatis(actor) = { "Floban is really more of a who. "; }
    disavow = {
        if (VALLEYSPEAK)
            flo('Like, don&rsquo;t be a pest.');
        else flo('Why these questions, Ambassador?');
    }
    verGrab(item) = {
        "Floban would never willingly let you have <<item.thedesc>>. ";
    }
    actorAction(v, d, p, i) = {
        if (v == helloVerb) {
            if (zigurt.makingComments)
                "<<flo('The child is speaking at me,')>> Floban says.\b
                    <<zig('Kindly hold your tongue until we have decided your
                        fate.')>> Zigurt snaps at you. ";
            else "Floban replies, <<flo('Oh, hello!')>> ";
            exit;
        }
        else pass actorAction;
    }
    ioGiveTo(actor, dobj) = {
        if (dobj == tylenol_bottle) {
            if (VALLEYSPEAK)
                flo('Like, what-EVER.');
            else flo('There is no need.');
            " Floban gestures towards the counter with two tentacles. ";
            if (VALLEYSPEAK)
                flo('I&rsquo;ve got one, y&rsquo;know, right...');
            " He pauses, looking confused. He then snatches the bottle out of
                your hand. ";
            if (VALLEYSPEAK)
                flo('Dork,');
            else flo('Philistine,');
            " he sniffs as he puts the bottle back on the counter. ";
            tylenol_bottle.moveInto(counter);
            return;
        }
        if (dobj.alienItem) {
            "Floban snatches <<dobj.thedesc>> from you";
            if (counter.location == self.location) {
                " and places it on the counter";
                dobj.moveInto(counter);
            }
            else dobj.moveInto(self);
            if (VALLEYSPEAK)
                ". <<flo('Dweeb,')>>";
            else ". <<flo('Malcontent,')>>";
            " he says. ";
            return;
        }
        if (dobj != rock_salt && dobj != generic_cupcakes &&
            dobj != memento) {
            "Floban waves away <<dobj.thedesc>>. ";
            if (VALLEYSPEAK)
                flo('Like I need your junk,');
            else flo('Your trinkets are of no concern right now,');
            " he tells you. ";
            return;
        }
        zigurt.ioGiveTo(actor, dobj);
    }
    ioSynonym('GiveTo') = 'ShowTo'
    verDoAskFor(actor, io) = {
        if (zigurt.makingComments) {
            "<<flo('Hsst! The child has a list of demands!')>> says Floban.\b
                <<zig('Ignore them for now,')>> Zigurt responds. ";
        }
    }
    doAskFor(actor, io) = {
        if (io.location == self || io.location == counter) {
            "Floban waves his tentacles. ";
            if (VALLEYSPEAK)
                flo('Like I&rsquo;ll give you my stuff,');
            else flo('You should not want what you cannot have,');
            " he says. ";
        }
        else {
            if (VALLEYSPEAK)
                flo('Sha! As if!');
            else flo('I do not have that.');
        }
    }
    doAskAbout(actor, io) = {
        switch (proptype(io, &flodesc)) {
            case 3:
                "Floban says, <<flo(io.flodesc)>> ";
                break;
            case 6:
            case 9:
                io.flodesc;
                break;
            default:
                self.disavow;
                break;
        }
    }

    // A function to handle Floban taking a pill
    popPill = {
        local leaveFlag = nil;

        if (!inside(Me, self.location)) {   // Do nothing if the player isn't
            if (!tylenol_bottle.isopen)     // in the room w/Floban, unless
                leaveFlag = true;           // the bottle is closed, in which
        }                                   // case we'll leave
        // Case 1: the bottle isn't on the counter
        else if (tylenol_bottle.location != counter) {
            // Subcase 1: The player is in the room with Floban
            if (Me.location == self.location) {
                "\bOne of Floban&rsquo;s tentacles moves towards the counter,
                    then begins feeling about it. ";
                // Does the player have it?
                if (tylenol_bottle.location == Me) {
                    "Surprised, he frowns, then looks at you. You flinch
                        guiltily. <<flo('Ah-hah!')>> he says. A tentacle
                        darts out and seizes the white bottle. ";
                    if (VALLEYSPEAK)
                        flo('Like, leave our stuff alone, okay?');
                    else flo('Do not be stealing our things,');
                    " he says, replacing the bottle on the counter. ";
                    if (VALLEYSPEAK)
                        flo('Like you could, y&rsquo;know, outwit us. I mean,
                            like, hellooo. Duh.');
                    else flo('Your petty theivery is no match for our superior
                        intellects.');
                    " ";
                    tylenol_bottle.moveInto(counter);
                }
                // Did the player put it in the small cubby?
                else if (tylenol_bottle.location == small_space) {
                    "He frowns, then leans a bit so that his tentacle can
                        reach behind the counter and into the space
                        beyond. ";
                    if (VALLEYSPEAK)
                        flo('Rad!');
                    else flo('Ah-hah!');
                    "\ he says, brandishing the recaptured bottle in his
                        tentacle before replacing it on the counter. ";
                    tylenol_bottle.moveInto(counter);
                }
                // Is the bottle in the room with Floban?
                else if (tylenol_bottle.location == self.location) {
                    "He frowns, then sees the bottle on the floor. ";
                    if (VALLEYSPEAK)
                        flo('Rad!');
                    else flo('Ah-hah!');
                    "\ he says, grabbing the bottle and replacing it on the
                        counter. ";
                    tylenol_bottle.moveInto(counter);
                }
                // Ah, well. It must be elsewhere.
                else {
                    "He frowns, concentrating. <<flo('Some evil player has
                        spirited away my bottle of pills.')>> He turns and
                        looks at you. <<flo('You&rsquo;ve certainly caught
                        mimesis with its pants down around its
                        ankles.')>> <i>{ERROR}</i> ";
                }
            }
            // Subcase 2: The player is in the cubby
            else {
                "\bYou see a purple tentacle drift along the top of the
                    counter, then ";
                // Does the player have the bottle?
                if (tylenol_bottle.location == Me) {
                    "slowly slide down towards you. It flails about, suddenly
                        landing on you. Floban peers over the counter. ";
                    if (VALLEYSPEAK)
                        flo('Like, what&rsquo;re you doing down there,
                            Ambassador? Lemme give you a boost.');
                    else flo('Why, Ambassador! I did not see you cowering
                        there! Let me assist your rising.');
                    " He lifts you to your feet, then says happily, ";
                    if (VALLEYSPEAK)
                        flo('Awesome! You, like, found my bottle! Rad.');
                    else flo('And you discovered the whereabouts of my errant
                        bottle! Many thanks.');
                    " He takes the bottle from
                        you and puts it back on the counter. ";
                    tylenol_bottle.moveInto(counter);
                    Me.moveInto(self.location);
                }
                // Is the bottle in the cubby with the player?
                else if (tylenol_bottle.location == small_space) {
                    "slowly slide down towards you. It somehow
                        misses you, landing instead on the white bottle. ";
                    if (VALLEYSPEAK)
                        flo('Rad!');
                    else flo('Ah-hah!');
                    "\ Floban says, grabbing the bottle and
                        putting it on the counter. ";
                    tylenol_bottle.moveInto(counter);
                }
                // The bottle must be somewhere else.
                else {
                    "withdraw. ";
                    // It's in the room with Floban
                    if (tylenol_bottle.location == self.location) {
                        "Floban then says, ";
                        if (VALLEYSPEAK)
                            flo('Rad!');
                        else flo('Ah-hah!');
                        " His tentacle reappears and places the white
                            bottle on the counter before vanishing again. ";
                        tylenol_bottle.moveInto(counter);
                    }
                    // It's well and truly lost
                    else "Floban leans over the counter and glares at you. <<
                        flo('You&rsquo;ve managed to lose my bottle. Well, that
                        buggers the fine illusion of reality that I&rsquo;ve
                        been
                        crafting, since you&rsquo;re not supposed to be able to
                        do that.')>> He withdraws. <i>{Error}</i> ";
                }
            }
        }
        // Case 2: The bottle is on the counter, and the player's in the room
        //         with Floban
        else if (Me.location == self.location) {
            "\bFloban massages his forehead with one tentacle, picking up the
                white bottle with another. ";
            if (tylenol_bottle.isopen)
                "He sticks a third tentacle into
                    the bottle. When he pulls it back out, a pill is stuck to
                    the end of it. He pops the pill in his mouth, then puts
                    the bottle back on the counter. ";
            else {
                if (VALLEYSPEAK)
                    flo('Bummer!');
                else flo('Cripes!');
                "\ Floban says, discovering that the bottle
                    is closed. He applies several tentacles to the bottle,
                    trying in vain to open it. ";
                if (VALLEYSPEAK)
                    flo('This child-proof cap sucks!');
                else flo('Curse you, child-proof cap!');
                "\bZigurt looks up from the atlas. ";
                if (VALLEYSPEAK)
                    zig('Why&rsquo;d you close it, dork?');
                else zig('You should know better than to close it.');
                "\b";
                if (VALLEYSPEAK)
                    flo('As if!');
                else flo('I never did!');
                "\ cries Floban.\b";
                if (VALLEYSPEAK)
                    zig('Like, stop whining, okay? We&rsquo;ll have to,
                        y&rsquo;know, go pry it open.');
                else zig('There is no use complaining now. Come; tools were
                    required to open it before.');
                " Zigurt picks up the translator and leads the distraught
                    Floban out of the room. ";
                leaveFlag = true;
            }
        }
        // Case 3: The bottle is on the counter, and the player's in the cubby
        else {
            "\bYou see a purple tentacle dart along the top of the counter
                and grab the white bottle before vanishing once more. ";
            if (tylenol_bottle.isopen)
                "A short time later the tentacle reappears, replaces the
                    bottle, and withdraws. ";
            else {
                "From the other side of the counter, you hear Floban
                    mutter, ";
                if (VALLEYSPEAK)
                    flo('Bummer! This child-proof cap sucks!');
                else flo('Cripes! Curse you, child-proof cap!');
                "\bThe conversation goes quickly thereafter:\b";
                if (VALLEYSPEAK)
                    zig('Why&rsquo;d you close it, dork?');
                else zig('You should know better than to close it.');
                "\b";
                if (VALLEYSPEAK)
                    flo('As if!');
                else flo('I never did!');
                "\b";
                if (VALLEYSPEAK)
                    zig('Like, stop whining, okay? We&rsquo;ll have to,
                        y&rsquo;know, go pry it open.');
                else zig('There is no use complaining now. Come; tools were
                    required to open it before.');
                " From your hidey-hole you
                    watch Zigurt escort a distraught Floban out of the room. ";
                leaveFlag = true;
            }
        }
        if (leaveFlag) {
            universal_translator.moveInto(zigurt);
            zigurt.moveInto(exam_room);
            floban.moveInto(exam_room);
            tylenol_bottle.moveInto(zigurt);
            if (!self.givenPointsForLeaving) {
                self.givenPointsForLeaving = true;
                incscore(4);
            }
            if (Me.location == ship_hallway)
                "\bZigurt and Floban enter the hallway from the rec room and
                    barely nod in your direction as they leave to the
                    southwest. ";
            else if (Me.location == exam_room)
                "\bZigurt and Floban stride into the room. Zigurt has the
                    white bottle firmly held in one tentacle, while Floban
                    looks distraught. ";
            zigurt.openingBottle = 1;
            notify(zigurt, &forceBottleOpen, 1);
        }
        else {
            notify(self, &popPill, 5 + _rand(2));    // Keep poppin' pills
        }
    }
    
    // The function for returning Floban and Zigurt to the rec room
    iShallReturn = {
        if (Me.location == exam_room)
            "\bZigurt and Floban head out into the hallway at a good clip. ";
        else if (Me.location == ship_hallway)
            "\bZigurt and Floban nod at you as they wander into the hallway
                and then into the rec room. ";
        else if (Me.location == rec_room) {
            "\bYou look up to see Zigurt and Floban returning. Floban puts the
                white bottle and its lid on the counter. ";
            if (VALLEYSPEAK)
                zig('Like, you okay now?');
            else zig('Satisfied?');
            "\ asks Zigurt.\b";
            if (VALLEYSPEAK)
                flo('Oh, yeah, totally,');
            else flo('Yes, quite,');
            "\ responds Floban. They turn back to the atlas. ";
        }
        else if (Me.location == counter) {
            "\bYou can just see Zigurt and Floban as they return. Above your
                head, the white bottle and its lid
                reappear on the counter. ";
            if (VALLEYSPEAK)
                zig('Like, you okay now?');
            else zig('Satisfied?');
            "\ you hear Zigurt ask.\b";
            if (VALLEYSPEAK)
                flo('Oh, yeah, totally,');
            else flo('Yes, quite,');
            "\ responds Floban. ";
        }
        zigurt.moveInto(rec_room);
        floban.moveInto(rec_room);
        universal_translator.moveInto(counter);
        tylenol_bottle.moveInto(counter);
        bottle_lid.moveInto(counter);
        tylenol_bottle.isopen = true;
        notify(self, &popPill, 5 + _rand(2));
    }
;

fake_zigurt_and_floban: distantItem
    noun = 'zigurt' 'floban' 'alien' 'aliens'
    sdesc = "the aliens"
    ldesc = "Zigurt and Floban are peering at you and dad through a
        translucent section of the ship. "
    dobjGen(a, v, i, p) =
    {
        if (v <> askVerb and v <> tellVerb and v <> inspectVerb)
        {
            "They are too far away.";
            exit;
        }
    }
    iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
    verDoWhois(actor) = { "Don't worry about the aliens. "; }
    verDoWhatis(actor) = { "Don't worry about the aliens. "; }
;

