/*
 * Decompiled with CFR 0.152.
 */
package jurt;

import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Vector;
import jurt.Refusal;
import jurt.TextAreaWriter;

public class IO
extends PrintWriter
implements ActionListener,
KeyListener {
    public static final String[] NUMBERS = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen", "twenty"};
    public static final NumberFormat NUMBERFORMAT = NumberFormat.getNumberInstance();
    TextField tf;
    Vector vector;
    boolean stopped;
    Vector history;
    int historyx;

    public static String intToString(int n) {
        if (0 <= n && n < NUMBERS.length) {
            return NUMBERS[n];
        }
        return NUMBERFORMAT.format(n);
    }

    public static int stringToInt(String string) throws Refusal {
        int n = 0;
        while (n < NUMBERS.length) {
            if (NUMBERS[n].equals(string)) {
                return n;
            }
            ++n;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = NUMBERFORMAT.parse(string, parsePosition);
        if (number != null && parsePosition.getIndex() == string.length()) {
            return number.intValue();
        }
        throw new Refusal();
    }

    public IO(TextArea textArea, TextField textField) {
        super((Writer)new BufferedWriter(new TextAreaWriter(textArea)), true);
        this.tf = textField;
        textField.addActionListener(this);
        textField.addKeyListener(this);
        this.history = new Vector();
        this.history.addElement("");
        this.historyx = 0;
        this.vector = new Vector();
        this.stopped = false;
    }

    public String readLine() {
        while (this.vector.isEmpty() && !this.stopped) {
            Thread.yield();
        }
        if (this.stopped) {
            return null;
        }
        String string = (String)this.vector.firstElement();
        this.vector.removeElementAt(0);
        this.println(string.toUpperCase());
        return string;
    }

    public void stop() {
        this.stopped = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.tf.getText();
        this.tf.setText("");
        this.vector.addElement(string);
        this.history.removeElementAt(0);
        if (string.length() > 0) {
            int n = this.history.indexOf(string);
            if (n >= 0) {
                this.history.removeElementAt(n);
            }
            this.history.insertElementAt(string, 0);
        }
        this.history.insertElementAt("", 0);
        this.historyx = 0;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 38) {
            if (this.historyx < this.history.size() - 1) {
                if (this.historyx == 0) {
                    this.history.setElementAt(this.tf.getText(), 0);
                }
                String string = (String)this.history.elementAt(++this.historyx);
                this.tf.setText(string);
                this.tf.setCaretPosition(string.length());
            }
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 40) {
            if (this.historyx > 0) {
                String string = (String)this.history.elementAt(--this.historyx);
                this.tf.setText(string);
                this.tf.setCaretPosition(string.length());
            }
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    static {
        NUMBERFORMAT.setParseIntegerOnly(true);
    }
}

