/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import jurt.Action;
import jurt.Concept;
import jurt.IO;
import jurt.Rebuff;
import jurt.Refusal;
import jurt.Vicinity;

public class LabTable
extends Concept {
    static final int MAXN = 15;
    int n;
    int k;
    int m;
    boolean success;
    Concept maze;
    Concept key;
    Concept socket;
    Random rnd;

    public LabTable(Concept concept) {
        super("lab table", concept);
        this.put("ID", new String[]{"laboratory", "lab", "table"});
        this.give("scenery");
        this.give("supporter");
        this.maze = new Concept("plastic maze", this){

            public void printItemDesc(IO iO) {
                String string = IO.intToString(15);
                iO.print("The numbers one through " + string + " are printed at " + "various points of the maze; the mouse squats by the " + IO.intToString(LabTable.this.n) + ".");
                if (LabTable.this.key.isIn(this)) {
                    iO.print(" A brass key also lies inside.");
                }
                iO.println();
                iO.println();
                iO.println("You notice a small electrical socket on one side of the maze.");
            }

            public void before(Action action) throws Refusal {
                if (action.isType("attack")) {
                    this.checkReachable(action);
                    throw new Rebuff("No! You might hurt hurt the mousey!");
                }
            }
        };
        this.maze.put("ID", new String[]{"clear", "plastic", "maze"});
        this.maze.give("static");
        this.maze.give("transparent");
        Concept concept2 = new Concept("white mouse", this.maze);
        concept2.put("ID", new String[]{"little", "white", "mouse", "mousey"});
        concept2.put("itemdesc", "The little white mouse meets your gaze momentarily.");
        this.rnd = new Random();
        this.n = 1;
        this.k = 1;
        this.m = 0;
        int n = 1;
        while (n <= 15) {
            String string = IO.intToString(n);
            String string2 = String.valueOf(n);
            concept = new Concept(string, this.maze);
            concept.put("ID", new String[]{"number", string, string2});
            concept.give("unlisted");
            ++n;
        }
        this.key = new Key("brass", "lock-2", this.maze);
        this.socket = new Concept("socket", this.maze){

            public void reactBefore(Action action) throws Refusal {
                if (action.isType("insert") && action.second == this && !action.noun.isSpecies("plugs")) {
                    action.noun.checkDropable(action);
                    this.checkReachable(action);
                    throw new Rebuff("That certainly doesn't belong in the socket!");
                }
            }

            public void printItemDesc(IO iO) {
                iO.print("The small electrical socket is part of the maze.");
                if (this.getNumChildren() == 0) {
                    iO.print(" You put electrical plugs into it.");
                }
                iO.println();
            }
        };
        this.socket.put("ID", new String[]{"electrical", "socket", "small"});
        this.socket.give("attachment");
        this.socket.give("static");
        this.socket.put("species", "sockets");
    }

    public void printInitial(IO iO) {
        iO.println();
        iO.println("On a laboratory table here is a clear plastic maze! A little mouse is scurrying around in it!");
    }

    public void eachTurn(Vicinity vicinity) {
        Scale scale;
        int n;
        Object object = this.get("lit");
        Object object2 = null;
        if (this.has("plug-source") && 1 <= (n = (scale = (Scale)this.get("plug-source")).getNumMarbles()) && n <= 15) {
            object2 = new Integer(n);
        }
        if (object != null && object2 != null) {
            if (object2.equals(object)) {
                return;
            }
            this.put("lit", object2);
            vicinity.io.println();
            vicinity.io.println("In the maze, the " + object + " goes out and the " + object2 + " comes on.");
            return;
        }
        if (object != null) {
            this.remove("lit");
            vicinity.io.println();
            vicinity.io.println("In the maze, the " + object + " goes out.");
        }
        if (object2 != null) {
            this.put("lit", object2);
            vicinity.io.println();
            vicinity.io.println("In the maze, the " + object2 + " comes on.");
            return;
        }
    }

    public void daemon(Vicinity vicinity) {
        if (vicinity.actor.has("loadslot1")) {
            if (this.isWithin(vicinity.ceiling)) {
                vicinity.io.println();
                vicinity.io.println("Suddenly the mouse turns and STARES at you, the fur on the back of its neck standing STRAIGHT UP.");
                vicinity.io.println();
            }
        } else if (this.k > this.m) {
            if (this.key.isIn(this.maze) && this.isWithin(vicinity.ceiling)) {
                vicinity.io.println();
                if (this.success) {
                    vicinity.io.println("The mouse lets out a merry CHEEP and goes over to the brass key! It pushes the key into a gap between the maze and the table, and after a minute manages to push the key OUT of the maze!");
                    this.key.setParent(this);
                } else {
                    vicinity.io.println("The mouse crawls up to the brass key, but doesn't touch it.");
                }
            }
            this.success = true;
            this.k = -1;
            this.m = 5 + (int)(this.rnd.nextDouble() * 6.0);
            this.n = 5 + (int)(this.rnd.nextDouble() * 6.0);
            if (this.isWithin(vicinity.ceiling)) {
                vicinity.io.println("It darts to the " + IO.intToString(this.n) + " and pauses, " + "as if catching its breath.");
            }
        } else if (this.k++ >= 1) {
            if (this.k > 2) {
                this.n = this.n == 1 ? ++this.n : (this.n == 15 ? --this.n : (this.rnd.nextDouble() >= 0.5 ? ++this.n : --this.n));
                if (this.isWithin(vicinity.ceiling)) {
                    vicinity.io.println();
                    vicinity.io.println("The mouse darts to the " + IO.intToString(this.n) + ".");
                }
            } else if (this.isWithin(vicinity.ceiling)) {
                vicinity.io.println();
                vicinity.io.println("The little mouse seems to be examing the " + IO.intToString(this.n) + " beneath it.");
            }
            if (this.success) {
                if (new Integer(this.n).equals(this.get("lit"))) {
                    if (this.isWithin(vicinity.ceiling)) {
                        vicinity.io.println("It emits a happy CHIT sound!");
                    }
                } else {
                    this.success = false;
                    if (this.isWithin(vicinity.ceiling)) {
                        vicinity.io.println("It emits a sad CHUT sound.");
                    }
                }
            }
        }
    }
}

