/*
 * Decompiled with CFR 0.152.
 */
import jurt.AClose;
import jurt.AInsert;
import jurt.AOpen;
import jurt.Action;
import jurt.Concept;
import jurt.IO;
import jurt.Nomen;
import jurt.Rebuff;
import jurt.Refusal;

public class Desk
extends Concept {
    public Concept drawer;

    public Desk(Concept concept) {
        super("steel desk", concept);
        this.put("ID", new String[]{"steel", "desk"});
        this.put("ID-rank", new Integer(1));
        this.put("species", "desks");
        this.give("supporter");
        this.give("scenery");
        this.drawer = new Concept("drawer", this);
        this.drawer.put("ID", new String[]{"desk", "drawer"});
        this.drawer.give("attachment");
        this.drawer.give("static");
        this.drawer.give("openable");
        this.drawer.give("container");
        this.drawer.give("lockable");
        this.drawer.give("locked");
        this.drawer.put("key", "lock-1");
    }

    public void printItemDesc(IO iO) {
        iO.print("A worn steel desk with a single drawer left. ");
        Nomen nomen = this.getChildList();
        if (nomen != null) {
            iO.print("On it " + nomen.pis());
        } else {
            iO.print("There's nothing on it");
        }
        iO.print("; the drawer is ");
        if (this.drawer.has("open")) {
            iO.print("open");
            nomen = this.drawer.getChildList();
            if (nomen != null) {
                iO.println(", containing " + nomen + ".");
            } else {
                iO.println(" but empty.");
            }
        } else {
            iO.println("closed.");
        }
    }

    public void reactBefore(Action action) throws Refusal {
        if (action.isType("insert") && action.second == this) {
            new AInsert(action.vic, action.noun, this.drawer).perform(true);
        } else {
            if (action.isType("move")) {
                Concept concept = action.vic.actor.findChild("crowbars");
                if (concept == null) {
                    throw new Rebuff("It won't budge!");
                }
                if (this.has("moved")) {
                    this.remove("moved");
                    throw new Rebuff("Happy desk! Happy desk! You shove it back and forth!!");
                }
                this.give("moved");
                throw new Rebuff("With the help of the crowbar, you manage to move the desk off of the hole!");
            }
            if (action.isType("go") && ("d".equals(action.string) || action.noun != null && action.noun.isSpecies("holes"))) {
                if (!this.has("moved")) {
                    throw new Rebuff("The desk is blocking the hole!");
                }
            } else if (action.isType("examine") && action.noun.isSpecies("holes")) {
                if (!this.has("moved")) {
                    throw new Rebuff("It's a hole in the floor. You might be able to get through it, except it's partially covered by the desk.");
                }
                throw new Rebuff("You should be able to go down it, but I don't know what the landing will be like.");
            }
        }
    }

    public void before(Action action) throws Refusal {
        if (action.isType("open")) {
            new AOpen(action.vic, this.drawer).perform(true);
        } else if (action.isType("close")) {
            new AClose(action.vic, this.drawer).perform(true);
        }
    }
}

