#include "dis48.h"
#include <fcntl.h>

#define NSIZE 524288
#define BSIZE (NSIZE / 2)

Bitmap	completed;
int	dopause = 0;

#ifdef ANSI
main(int argc, char **argv)
#else
main(argc, argv)
int	argc;
char	**argv;
#endif
{
	char	*p;
	int	n;
	int	s, e;
	char	buf[80];
	char	*mem, *malloc();
	
	if ((argc > 1) && !strcmp(argv[1], "-p"))
		dopause = 1;
		
	if ((mem = malloc(BSIZE)) == NULL) {
		fprintf(stderr, "malloc failed\n");
		exit(1);
	}
	
	if ((completed = malloc(BITS(NSIZE))) == NULL) {
		fprintf(stderr, "malloc failed\n");
		goto done;
	}
	
	memset(completed, 0, BITS(NSIZE));
	if ((n = open("rom", O_RDONLY)) < 0) {
		fprintf(stderr, "open failed\n");
		goto done2;
	}
	
	if (read(n, mem, BSIZE) != BSIZE) {
		fprintf(stderr, "read failed\n");
		close(n);
		goto done2;
	}
	
	(void) close(n);
	fprintf(stderr, "start?\n");
	if (fgets(buf, sizeof(buf), stdin) == NULL)
		goto done2;
		
	if (sscanf(buf, "%x", &s) != 1)
		goto done2;
		
	Disassemble(mem, s, NOADDR, stdout);
	for (s = 0; s < 0x80000;) {
		while (!BITTEST(completed, s))
			s++;
			
		e = s;
		while (BITTEST(completed, e) && (e < 0x80000))
			e++;
		
		e--;
		printf("\n");
		/*fprintf(stderr, "S: %05x E: %05x\n", s, e);*/
		Disassemble(mem, s, e, stdout);
		s = ++e;
	}
	
done2:
	free(completed);
done:	
	free(mem);
	exit(0);
}
