/*
 *
 *  source file:   ./filters/loclib/getpar_decode.c
 *
 * Joe Dellinger (SEP), June 11 1987
 *	Inserted this sample edit history entry.
 *	Please log any further modifications made to this file:
 */

/* Revised 3-8-86 stew  Added timestamp to recover older functionality
 *			when presented with multiple tags
 * Revised 9-18-86 joe  Added '1' type ... y or 1 for yes, n or 0 for no
 */
#include <stdio.h>
#include "fastpar.h"

/*
 * split off first tag "n1" from input tags "n1 nt ne"
 */
static int tag_split(tag,tlen,subtag,sublen)
register char *tag;
char **subtag;
register int tlen;
int *sublen;
{
 register int i,j;

 for(i=0; i<tlen; i++) if(tag[i] != ' ') break;
 if(i == tlen) return(0); /* all bytes consumed */
 *subtag = tag+i;
 for(j=i+1; j<tlen; j++) if(tag[j] == ' ') break;
 *sublen = (j-i);
 return(1);
}

/*
 * take string "n1 nt ne" and look up stored parameters with those
 * names, returning value with most recent timestamp
 */
int getpar_decode(q,qlen,tag,type,val)
hash_item **q;
int qlen;
char *tag, *type;
MIXED val;
{
 register char *next, *end;
 char *subtag;
 int sublen, count = 0 ;
 register hash_item *foundit, *saveit;
 extern hash_item *getpar_hash_lookup();
 register int bigtime = -1;

 next=tag; end = tag+strlen(tag);
 while(tag_split(next,end-next,&subtag,&sublen)) {
    foundit = getpar_hash_lookup(q,qlen,subtag,sublen);
    if(foundit != ((hash_item *) NULL))
	if(bigtime < foundit->timestamp) {
	    bigtime = foundit->timestamp;
	    saveit = foundit;
	    }
    next = subtag+sublen;
    }
 if(bigtime >= 0) count = getpar_getval(saveit,type,val);
 return(count);
 }

/*
 * return 1 if char c is not in string s; else return 0
 */
static int
getpar_neq(c,s)
register int c;
register char *s;
{
	do {
		if(*s == c) {
			return(0); 
		}
	} 
	while(*s++);
	return(1);
}

/*
 * take stored string value and convert it according to "type" format
 * result stored at "ptr"
 *
 * type formats:
 *               "i" or "d"  to convert to integer
 *               "r" or "f"  to convert to real
 *               "g"         to convert to double precision
 *               "s"         to keep as a string value
 *
 * stored string values may specify a vector of numerics:
 *
 *               3.0,5x3.5,-1.0,3*2.2
 * 
 * yields the result:
 *
 *               3.0,3.5,3.5,3.5,3.5,3.5,-1.0,2.2,2.2,2.2
 *
 * the function's return value will be the count (10) of items converted
 */
static int getpar_getval(foundit,type,ptr)
hash_item *foundit;
char *type;
MIXED ptr;
{
    register char *sptr, *str;
    register int ival, jval;
    register int index, endindex;
    extern double atof();
    extern int atoi();
    float flt;
    double dubble;
    int integer;
    index=0;
    str = foundit->val;
    ival = foundit->vlen;

    while(ival > 0) {
	endindex= index+1;
	if(*type != 's') {
		sptr = str;
		jval = ival;
		while(jval && getpar_neq((int) (*sptr),"*x,"))
			{ sptr++; jval--;}
		if(jval > 0)
		    if(*sptr=='*' || *sptr=='x') {
			endindex= index+atoi(str);
			str= sptr+1;
			ival = jval-1;
		}
	}
	switch(*type) {
	case 'd':
	case 'i':
		integer= atoi(str);
		while(index<endindex) ptr.i[index++]= integer;
		break;
	case '1':
		if (str[0] == 'y' || str[0] == '1' || str[0] == 'Y')
			integer = 1;
		else
			integer = 0;
		while(index<endindex) ptr.i[index++]= integer;
		break;
	case 'f':
	case 'r':
		flt= atof(str);
		while(index<endindex) ptr.f[index++]= flt;
		break;
	case 'g':
		dubble= atof(str);
		while(index<endindex) ptr.g[index++]= dubble;
		break;
	case 's':
		bcopy(str,ptr.s,ival);
		ptr.s[ival]='\0';
		return(1);
	default:
		err("getpar() unknown conversion type %c\n",*type);
	}
	while((--ival) && ((*(str++)) != ',')); /* skip past next comma */
    }
    return(endindex);
}
